[//]: # " Copyright (c) 2020 Oracle and/or its affiliates. All rights reserved. "
[//]: # "  "
[//]: # " This program and the accompanying materials are made available under the "
[//]: # " terms of the Eclipse Public License v. 2.0, which is available at "
[//]: # " http://www.eclipse.org/legal/epl-2.0. "
[//]: # "  "
[//]: # " This Source Code may also be made available under the following Secondary "
[//]: # " Licenses when the conditions for such availability set forth in the "
[//]: # " Eclipse Public License v. 2.0 are satisfied: GNU General Public License, "
[//]: # " version 2 with the GNU Classpath Exception, which is available at "
[//]: # " https://www.gnu.org/software/classpath/license.html. "
[//]: # "  "
[//]: # " SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 "

# Contributing to Eclipse Tyrus

Thanks for your interest in this project.

## Project description

Eclipse Tyrus is the open source
<a href="https://projects.eclipse.org/projects/ee4j.websocket">JSR 356 - Java API for WebSocket</a>
reference implementation for easy development of WebSocket applications. Eclipse Tyrus is also 
a Jakarta WebSocket 2.0 compatible implementation. 

WebSocket protocol defined by IETF
provides bi-directional communication between the server and the remote host. The
pros are mainly the ability to communicate both ways, low latency and small
communication overhead. Therefore Tyrus and WebSocket in general are suitable for web
applications that require sending a huge volume of relatively small messages like
online games or market ticker broadcasting.
 
Goals of Eclipse Tyrus project can be summarized in the following points:
* Track the Eclipse WebSocket API and provide regular releases of production quality implementations that ships with GlassFish;

* Provide APIs to extend Tyrus & Build a community of users and developers; and finally

* Make it easy to build websocket based web services utilising Java and the Java Virtual Machine.

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* https://projects.eclipse.org/projects/ee4j.tyrus/developer

The project maintains the following source code repositories

* https://github.com/eclipse-ee4j/tyrus
* https://github.com/eclipse-ee4j/tyrus-project.github.io

## Eclipse Development Process

This Eclipse Foundation open project is governed by the Eclipse Foundation
Development Process and operates under the terms of the Eclipse IP Policy.

## Specifications

This specification project operates under the terms of the Eclipse Foundation
Specification process.

* https://eclipse.org/projects/dev_process
* https://www.eclipse.org/org/documents/Eclipse_IP_Policy.pdf
* https://www.eclipse.org/projects/efsp/
* https://www.eclipse.org/legal/efsp_non_assert.php

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Contact the project developers via the project's "dev" list.

* https://dev.eclipse.org/mailman/listinfo/tyrus-dev
