/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2013 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.tyrus.tests.servlet.session;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;

import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

/**
 * @author Stepan Kopriva (stepan.kopriva at oracle.com)
 * @author Pavel Bucek (pavel.bucek at oracle.com)
 */
@ServerEndpoint(value = "/idletimeoutping", configurator = SingletonConfigurator.class)
public class IdleTimeoutSendingPingEndpoint {

    private volatile boolean onCloseCalled = false;

    public static final long TIMEOUT = 500;
    final byte[] data = new byte[]{1, 2, 3};

    @OnOpen
    public void onOpen(final Session session) {
        session.setMaxIdleTimeout(TIMEOUT);
        new Timer().schedule(new TimerTask() {
            @Override
            public void run() {
                try {
                    session.getBasicRemote().sendPing(ByteBuffer.wrap(data));
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, 0, 300);
    }

    @OnMessage
    public void onMessage(String message) {
        // do nothing.
    }

    @OnClose
    public void onClose(Session session) {
        onCloseCalled = true;
    }

    boolean isOnCloseCalled() {
        return onCloseCalled;
    }

    void setOnCloseCalled(boolean onCloseCalled) {
        this.onCloseCalled = onCloseCalled;
    }
}
