/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

class PositionRange
extends Expression {
    private int minPosition;
    private int maxPosition;

    public PositionRange(int n, int n2) {
        this.minPosition = n;
        this.maxPosition = n2;
    }

    public Expression simplify() throws XPathException {
        return this;
    }

    public Value evaluate(Context context) throws XPathException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    public boolean evaluateAsBoolean(Context context) throws XPathException {
        int n = context.getContextPosition();
        return n >= this.minPosition && n <= this.maxPosition;
    }

    public int getDataType() {
        return 1;
    }

    public int getDependencies() {
        return 16;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if ((0x10 & n) != 0) {
            return this.evaluate(context);
        }
        return this;
    }

    protected int getMinPosition() {
        return this.minPosition;
    }

    protected int getMaxPosition() {
        return this.maxPosition;
    }
}

