/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;

public class PDFPage
extends PDFObject {
    protected String parent;
    protected PDFResources resources;
    protected PDFStream contents;
    protected int pagewidth;
    protected int pageheight;
    protected PDFAnnotList annotList;

    public PDFPage(int number, PDFResources resources, PDFStream contents, int pagewidth, int pageheight) {
        super(number);
        this.resources = resources;
        this.contents = contents;
        this.pagewidth = pagewidth;
        this.pageheight = pageheight;
        this.annotList = null;
    }

    public void addShading(PDFShading shading) {
        this.resources.addShading(shading);
    }

    public PDFAnnotList getAnnotList() {
        return this.annotList;
    }

    public void setAnnotList(PDFAnnotList annotList) {
        this.annotList = annotList;
    }

    public void setParent(PDFPages parent) {
        this.parent = parent.referencePDF();
    }

    public byte[] toPDF() {
        StringBuffer sb = new StringBuffer();
        sb = sb.append(String.valueOf(this.number) + " " + this.generation + " obj\n" + "<< /Type /Page\n" + "/Parent " + this.parent + "\n" + "/MediaBox [ 0 0 " + this.pagewidth + " " + this.pageheight + " ]\n" + "/Resources " + this.resources.referencePDF() + "\n" + "/Contents " + this.contents.referencePDF() + "\n");
        if (this.annotList != null) {
            sb = sb.append("/Annots " + this.annotList.referencePDF() + "\n");
        }
        sb = sb.append(">>\nendobj\n");
        try {
            return sb.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return sb.toString().getBytes();
        }
    }
}

