/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.contrib.demo;

import com.sun.jna.Memory;
import com.sun.jna.platform.EnumUtils;
import com.sun.jna.platform.win32.Dxva2;
import com.sun.jna.platform.win32.HighLevelMonitorConfigurationAPI;
import com.sun.jna.platform.win32.LowLevelMonitorConfigurationAPI;
import com.sun.jna.platform.win32.PhysicalMonitorEnumerationAPI;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;

public class MonitorInfoDemo {
    public static void main(String[] args) {
        System.out.println("Installed Physical Monitors: " + User32.INSTANCE.GetSystemMetrics(80));
        User32.INSTANCE.EnumDisplayMonitors(null, null, new WinUser.MONITORENUMPROC(){

            public int apply(WinUser.HMONITOR hMonitor, WinDef.HDC hdc, WinDef.RECT rect, WinDef.LPARAM lparam) {
                MonitorInfoDemo.enumerate(hMonitor);
                return 1;
            }
        }, new WinDef.LPARAM(0L));
    }

    static void enumerate(WinUser.HMONITOR hMonitor) {
        System.out.println("Found HMONITOR: " + hMonitor.getPointer().toString());
        WinUser.MONITORINFOEX info = new WinUser.MONITORINFOEX();
        User32.INSTANCE.GetMonitorInfo(hMonitor, info);
        System.out.println("Screen " + info.rcMonitor);
        System.out.println("Work area " + info.rcWork);
        boolean isPrimary = (info.dwFlags & 1) != 0;
        System.out.println("Primary? " + (isPrimary ? "yes" : "no"));
        System.out.println("Device " + new String(info.szDevice));
        WinDef.DWORDByReference pdwNumberOfPhysicalMonitors = new WinDef.DWORDByReference();
        Dxva2.INSTANCE.GetNumberOfPhysicalMonitorsFromHMONITOR(hMonitor, pdwNumberOfPhysicalMonitors);
        int monitorCount = pdwNumberOfPhysicalMonitors.getValue().intValue();
        System.out.println("HMONITOR is linked to " + monitorCount + " physical monitors");
        PhysicalMonitorEnumerationAPI.PHYSICAL_MONITOR[] physMons = new PhysicalMonitorEnumerationAPI.PHYSICAL_MONITOR[monitorCount];
        Dxva2.INSTANCE.GetPhysicalMonitorsFromHMONITOR(hMonitor, monitorCount, physMons);
        for (int i = 0; i < monitorCount; ++i) {
            WinNT.HANDLE hPhysicalMonitor = physMons[0].hPhysicalMonitor;
            System.out.println("Monitor " + i + " - " + new String(physMons[i].szPhysicalMonitorDescription));
            MonitorInfoDemo.enumeratePhysicalMonitor(hPhysicalMonitor);
        }
        Dxva2.INSTANCE.DestroyPhysicalMonitors(monitorCount, physMons);
    }

    private static void enumeratePhysicalMonitor(WinNT.HANDLE hPhysicalMonitor) {
        HighLevelMonitorConfigurationAPI.MC_DISPLAY_TECHNOLOGY_TYPE.ByReference techType = new HighLevelMonitorConfigurationAPI.MC_DISPLAY_TECHNOLOGY_TYPE.ByReference();
        Dxva2.INSTANCE.GetMonitorTechnologyType(hPhysicalMonitor, techType);
        System.out.println("TECHTYPE: " + (Object)((Object)techType.getValue()));
        WinDef.DWORDByReference temps = new WinDef.DWORDByReference();
        WinDef.DWORDByReference caps = new WinDef.DWORDByReference();
        Dxva2.INSTANCE.GetMonitorCapabilities(hPhysicalMonitor, caps, temps);
        System.out.println("CAPS " + EnumUtils.setFromInteger(caps.getValue().intValue(), HighLevelMonitorConfigurationAPI.MC_CAPS.class));
        System.out.println("Temps " + temps.getValue());
        WinDef.DWORDByReference pdwMinimumBrightness = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwCurrentBrightness = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwMaximumBrightness = new WinDef.DWORDByReference();
        Dxva2.INSTANCE.GetMonitorBrightness(hPhysicalMonitor, pdwMinimumBrightness, pdwCurrentBrightness, pdwMaximumBrightness);
        System.out.println("Brightness Min: " + pdwMinimumBrightness.getValue());
        System.out.println("Brightness Current: " + pdwCurrentBrightness.getValue());
        System.out.println("Brightness Max: " + pdwMaximumBrightness.getValue());
        WinDef.DWORDByReference pdwMinimumContrast = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwCurrentContrast = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwMaximumContrast = new WinDef.DWORDByReference();
        Dxva2.INSTANCE.GetMonitorContrast(hPhysicalMonitor, pdwMinimumContrast, pdwCurrentContrast, pdwMaximumContrast);
        System.out.println("Contrast Min: " + pdwMinimumContrast.getValue());
        System.out.println("Contrast Current: " + pdwCurrentContrast.getValue());
        System.out.println("Contrast Max: " + pdwMaximumContrast.getValue());
        HighLevelMonitorConfigurationAPI.MC_COLOR_TEMPERATURE.ByReference pctCurrentColorTemperature = new HighLevelMonitorConfigurationAPI.MC_COLOR_TEMPERATURE.ByReference();
        Dxva2.INSTANCE.GetMonitorColorTemperature(hPhysicalMonitor, pctCurrentColorTemperature);
        System.out.println("Current Temp: " + (Object)((Object)pctCurrentColorTemperature.getValue()));
        WinDef.DWORDByReference pdwCapabilitiesStringLengthInCharacters = new WinDef.DWORDByReference();
        Dxva2.INSTANCE.GetCapabilitiesStringLength(hPhysicalMonitor, pdwCapabilitiesStringLengthInCharacters);
        WinDef.DWORD capStrLen = pdwCapabilitiesStringLengthInCharacters.getValue();
        WTypes.LPSTR pszASCIICapabilitiesString = new WTypes.LPSTR(new Memory(capStrLen.intValue()));
        Dxva2.INSTANCE.CapabilitiesRequestAndCapabilitiesReply(hPhysicalMonitor, pszASCIICapabilitiesString, capStrLen);
        System.out.println("Cap-String:" + new String(pszASCIICapabilitiesString.getPointer().getString(0L)));
        HighLevelMonitorConfigurationAPI.MC_POSITION_TYPE ptPositionType = HighLevelMonitorConfigurationAPI.MC_POSITION_TYPE.MC_HORIZONTAL_POSITION;
        WinDef.DWORDByReference pdwMinimumPosition = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwCurrentPosition = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwMaximumPosition = new WinDef.DWORDByReference();
        Dxva2.INSTANCE.GetMonitorDisplayAreaPosition(hPhysicalMonitor, ptPositionType, pdwMinimumPosition, pdwCurrentPosition, pdwMaximumPosition);
        System.out.println("Position (horz) Min: " + pdwMinimumPosition.getValue());
        System.out.println("Position (horz) Current: " + pdwCurrentPosition.getValue());
        System.out.println("Position (horz) Max: " + pdwMaximumPosition.getValue());
        HighLevelMonitorConfigurationAPI.MC_SIZE_TYPE ptSizeType = HighLevelMonitorConfigurationAPI.MC_SIZE_TYPE.MC_WIDTH;
        WinDef.DWORDByReference pdwMinimumSize = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwCurrentSize = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwMaximumSize = new WinDef.DWORDByReference();
        Dxva2.INSTANCE.GetMonitorDisplayAreaSize(hPhysicalMonitor, ptSizeType, pdwMinimumSize, pdwCurrentSize, pdwMaximumSize);
        System.out.println("Width Min: " + pdwMinimumSize.getValue());
        System.out.println("Width Current: " + pdwCurrentSize.getValue());
        System.out.println("Width Max: " + pdwMaximumSize.getValue());
        HighLevelMonitorConfigurationAPI.MC_GAIN_TYPE ptGainType = HighLevelMonitorConfigurationAPI.MC_GAIN_TYPE.MC_RED_GAIN;
        WinDef.DWORDByReference pdwMinimumGain = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwCurrentGain = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwMaximumGain = new WinDef.DWORDByReference();
        Dxva2.INSTANCE.GetMonitorRedGreenOrBlueGain(hPhysicalMonitor, ptGainType, pdwMinimumGain, pdwCurrentGain, pdwMaximumGain);
        System.out.println("Red Gain Min: " + pdwMinimumSize.getValue());
        System.out.println("Red Gain Current: " + pdwCurrentSize.getValue());
        System.out.println("Red Gain Max: " + pdwMaximumSize.getValue());
        HighLevelMonitorConfigurationAPI.MC_DRIVE_TYPE ptDriveType = HighLevelMonitorConfigurationAPI.MC_DRIVE_TYPE.MC_RED_DRIVE;
        WinDef.DWORDByReference pdwMinimumDrive = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwCurrentDrive = new WinDef.DWORDByReference();
        WinDef.DWORDByReference pdwMaximumDrive = new WinDef.DWORDByReference();
        Dxva2.INSTANCE.GetMonitorRedGreenOrBlueDrive(hPhysicalMonitor, ptDriveType, pdwMinimumDrive, pdwCurrentDrive, pdwMaximumDrive);
        System.out.println("Red Drive Min: " + pdwMinimumSize.getValue());
        System.out.println("Red Drive Current: " + pdwCurrentSize.getValue());
        System.out.println("Red Drive Max: " + pdwMaximumSize.getValue());
        LowLevelMonitorConfigurationAPI.MC_TIMING_REPORT pmtrMonitorTimingReport = new LowLevelMonitorConfigurationAPI.MC_TIMING_REPORT();
        Dxva2.INSTANCE.GetTimingReport(hPhysicalMonitor, pmtrMonitorTimingReport);
        System.out.println("HorizontalFrequencyInHZ " + pmtrMonitorTimingReport.dwHorizontalFrequencyInHZ);
        System.out.println("VerticalFrequencyInHZ " + pmtrMonitorTimingReport.dwVerticalFrequencyInHZ);
        System.out.println("--------------------------------------");
    }
}

