/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.test.optimization;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.math._BigDecimal;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.nio.charset._Charset;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.reporters.json.JSONArray;
import com.cenqua.clover.reporters.json.JSONException;
import com.cenqua.clover.reporters.json.JSONObject;
import com.cenqua.clover.test.optimization.Snapshot;
import com.cenqua.clover.test.optimization.TestMethodCall;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SnapshotPrinter {
    private static int indent;
    static /* synthetic */ Class class$com$cenqua$clover$test$optimization$SnapshotPrinter;

    public static void main(String[] args) throws IOException, JSONException {
        if (args.length == 0) {
            SnapshotPrinter.printUsage();
        } else {
            OutputStream out;
            Config config = SnapshotPrinter.parseCommandLineArgs(args);
            OutputStream outputStream = out = config.outputFile == null ? System.out : new FileOutputStream(config.outputFile);
            if (config.format.equalsIgnoreCase("json")) {
                SnapshotPrinter.jsonPrint(Snapshot.loadFrom(config.snapshotFile), out);
            } else {
                SnapshotPrinter.textPrint(Snapshot.loadFrom(config.snapshotFile), out);
            }
            out.flush();
            if (config.outputFile != null) {
                out.close();
            }
        }
    }

    private static Config parseCommandLineArgs(String[] args) {
        Config config = new Config();
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equals("-o")) {
                config.outputFile = new File(args[i + 1]);
                continue;
            }
            if (!args[i].equals("-f")) continue;
            config.format = args[i + 1];
        }
        config.snapshotFile = new File(args[args.length - 1]);
        return config;
    }

    private static void printUsage() {
        System.out.println("Usage:");
        StringBuffer stringBuffer = new StringBuffer().append("java ");
        Class<?> clazz = class$com$cenqua$clover$test$optimization$SnapshotPrinter;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$test$optimization$SnapshotPrinter = new SnapshotPrinter[0].getClass().getComponentType();
        }
        System.out.println(stringBuffer.append(clazz.getName()).append(" [-o output_file] [-f text|json] <snapshot path>").toString());
    }

    public static void jsonPrint(Snapshot snapshot, OutputStream out) throws JSONException {
        if (snapshot != null) {
            PrintWriter writer = new PrintWriter(out);
            JSONArray jsonFilesArray = new JSONArray();
            Iterator<Map.Entry<String, Collection<TestMethodCall>>> i$ = snapshot.getFile2TestsMap().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, Collection<TestMethodCall>> fileEntry = i$.next();
                JSONArray testArray = new JSONArray();
                Iterator<TestMethodCall> i$2 = fileEntry.getValue().iterator();
                while (i$2.hasNext()) {
                    TestMethodCall methodCall = i$2.next();
                    testArray.put(new JSONObject().put(methodCall.getRuntimeMethodName(), ""));
                }
                JSONObject jsonFileEntry = new JSONObject().put("path", fileEntry.getKey()).put("tests", testArray);
                jsonFilesArray.put(jsonFileEntry);
            }
            JSONObject jsonRoot = new JSONObject().put("project", new JSONObject().put("files", jsonFilesArray));
            writer.println(jsonRoot.toString());
            writer.flush();
        }
    }

    public static void textPrint(Snapshot snapshot, OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        if (snapshot != null) {
            Map.Entry entry;
            writer.println("Loaded snapshot at: " + snapshot.getLocation());
            writer.println("Loaded snapshot for clover.db: " + snapshot.getInitString());
            writer.println("Snapshot's Clover version: " + snapshot.getCloverVersionInfo());
            writer.println("CLI's Clover version: " + snapshot.getCloverVersionInfo());
            writer.println("Versions: ");
            Iterator<Object> iterator = snapshot.getDbVersions().iterator();
            while (iterator.hasNext()) {
                ++indent;
                writer.println("" + iterator.next());
                --indent;
            }
            writer.println("Known tests: ");
            iterator = snapshot.getTestLookup().entrySet().iterator();
            while (iterator.hasNext()) {
                ++indent;
                entry = (Map.Entry)iterator.next();
                String name = (String)entry.getKey();
                Set tests = (Set)entry.getValue();
                long duration = snapshot.calculateDurationOf(tests);
                writer.println(SnapshotPrinter.indent(name + " : duration " + SnapshotPrinter.durationAsString(duration)));
                Iterator iterator2 = tests.iterator();
                while (iterator2.hasNext()) {
                    ++indent;
                    TestMethodCall test = (TestMethodCall)iterator2.next();
                    long duration2 = snapshot.calculateDurationOf(Collections.singleton(test));
                    writer.println(SnapshotPrinter.indent(test.toString() + " : "));
                    --indent;
                }
                --indent;
            }
            writer.flush();
            writer.println("Failing tests: ");
            iterator = snapshot.getFailingTestPaths().iterator();
            while (iterator.hasNext()) {
                ++indent;
                writer.println(SnapshotPrinter.indent((String)iterator.next()));
                --indent;
            }
            writer.flush();
            writer.println("All files: ");
            iterator = snapshot.getFile2TestsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                ++indent;
                entry = (Map.Entry)iterator.next();
                writer.println(SnapshotPrinter.indent((String)entry.getKey()));
                writer.println(SnapshotPrinter.indent("Hitting tests:"));
                Iterator iterator1 = ((Set)entry.getValue()).iterator();
                while (iterator1.hasNext()) {
                    ++indent;
                    writer.println(SnapshotPrinter.indent(iterator1.next().toString()));
                    --indent;
                }
                --indent;
            }
            writer.flush();
        }
    }

    public static void textPrint(Snapshot snapshot, Logger logger, int logLevel) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SnapshotPrinter.textPrint(snapshot, buffer);
        try {
            logger.log(logLevel, buffer.toString(_Charset.defaultCharset().name()), null);
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(logLevel, "Unsupported encoding: " + _Charset.defaultCharset().name(), ex);
        }
    }

    private static String durationAsString(long duration) {
        return new Interval(_BigDecimal.valueOf(duration).divide(_BigDecimal.valueOf(1000L), 2, 4), 0).toSensibleString() + " (" + duration + " ms)";
    }

    private static String indent(String line) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            buffer.append("\t");
        }
        buffer.append(line);
        return buffer.toString();
    }

    private static class Config {
        File outputFile;
        String format = "text";
        File snapshotFile;

        private Config() {
        }
    }
}

