/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.atlassian.clover.api.CloverException;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CodeType;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.cfg.Percentage;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.CachingInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.PackageMetrics;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.ProjectMetrics;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.util.HistoricalSupport;
import com.cenqua.clover.reporters.util.MetricsDiffSummary;
import com.cenqua.clover.tasks.AbstractCloverTask;
import com.cenqua.clover.tasks.CloverReportTask;
import com.cenqua.clover.tasks.FilesetFileVisitor;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.StringUtils;

public class CloverPassTask
extends AbstractCloverTask {
    private File historydir;
    private File[] historyFiles;
    private double threshold;
    private HistoricalSupport.HasMetricsWrapper model;
    private Map models;
    private Percentage targetPC = null;
    private Percentage methodTarget;
    private Percentage statementTarget;
    private Percentage conditionalTarget;
    private boolean haltOnFailure = false;
    private String failureProperty;
    final Current currentConfig = new Current();
    private List testResults = new ArrayList();
    private List testSources = new ArrayList();
    private CodeType codeType = CodeType.APPLICATION;
    private List packageRequirements = new ArrayList();

    public void setCodeType(String codeTypeAsString) {
        try {
            this.codeType = CodeType.valueOf(codeTypeAsString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            this.codeType = null;
        }
    }

    public void init() throws BuildException {
        super.init();
        this.currentConfig.setFormat(Format.DEFAULT_XML);
    }

    public void addPackage(PackageRequirement requirement) {
        this.packageRequirements.add(requirement);
    }

    public void setHistorydir(File historydir) {
        this.historydir = historydir;
    }

    public File getHistorydir() {
        return this.historydir;
    }

    public void setThreshold(Percentage threshold) {
        this.threshold = (double)threshold.getAsFloatFraction() * 100.0;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setTarget(Percentage percentValue) {
        this.targetPC = percentValue;
    }

    public Percentage getMethodTarget() {
        return this.methodTarget;
    }

    public void setMethodTarget(Percentage methodTarget) {
        this.methodTarget = methodTarget;
    }

    public Percentage getStatementTarget() {
        return this.statementTarget;
    }

    public void setStatementTarget(Percentage statementTarget) {
        this.statementTarget = statementTarget;
    }

    public Percentage getConditionalTarget() {
        return this.conditionalTarget;
    }

    public void setConditionalTarget(Percentage conditionalTarget) {
        this.conditionalTarget = conditionalTarget;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public String getFailureProperty() {
        return this.failureProperty;
    }

    public void setFilter(String filterSpec) {
        this.currentConfig.getFormat().setFilter(filterSpec);
    }

    public void setSpan(Interval span) {
        this.currentConfig.setSpan(span);
    }

    public void addTestResults(FileSet fileset) {
        this.testResults.add(fileset);
    }

    public void setIncludeFailedTestCoverage(boolean include) {
        this.currentConfig.setIncludeFailedTestCoverage(include);
    }

    public void addTestSources(FileSet fileset) {
        this.testSources.add(fileset);
    }

    public List getTestSources() {
        return this.testSources;
    }

    private void initFileSets() {
        FilesetFileVisitor.Util.collectFiles(this.getProject(), this.testResults, new FilesetFileVisitor(){

            public void visit(File file) {
                CloverPassTask.this.currentConfig.addTestResultFile(file);
            }
        });
        FilesetFileVisitor.Util.collectFiles(this.getProject(), this.testSources, new FilesetFileVisitor(){

            public void visit(File file) {
                CloverPassTask.this.currentConfig.addTestSourceFile(file);
            }
        });
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }

    public void cloverExecute() {
        CloverDatabase db;
        boolean passed = true;
        StringBuffer targetFailures = new StringBuffer("");
        this.initFileSets();
        String initString = this.resolveInitString();
        this.currentConfig.setInitString(initString);
        if (this.targetPC == null && this.methodTarget == null && this.statementTarget == null && this.conditionalTarget == null && this.packageRequirements.size() == 0 && this.getHistorydir() == null) {
            throw new BuildException("You need to set either an overall target using one or more of the \"target\",\"methodTarget\",\"statementTarget\",\"conditionalTarget\" or \"historydir\" attribs, or specify atleast one nested <package> element.");
        }
        if (this.codeType == null) {
            throw new BuildException("You need to set a valid code type. Valid values are: \"" + CodeType.APPLICATION.name().toLowerCase(Locale.US) + "\",\"" + CodeType.TEST.name().toLowerCase(Locale.US) + "\",\"" + CodeType.ALL.name().toLowerCase() + "\"");
        }
        Iterator i = this.packageRequirements.iterator();
        while (i.hasNext()) {
            PackageRequirement requirement = (PackageRequirement)i.next();
            if (requirement.target == null && requirement.methodTarget == null && requirement.statementTarget == null && requirement.conditionalTarget == null && this.getHistorydir() == null || requirement.name == null && requirement.regex == null) {
                throw new BuildException("The <package> element requires a \"name\" or \"regex\" attribute and one or more of the \"target\", \"methodTarget\",\"statementTarget\",\"conditionalTarget\" or \"historydir\" attributes.");
            }
            if (requirement.name == null || requirement.regex == null) continue;
            throw new BuildException("The <package> element requires either the \"name\" or \"regex\" attribute set, not both.");
        }
        try {
            db = this.currentConfig.getCoverageDatabase();
        }
        catch (CloverException e) {
            throw new BuildException("Unable to read Clover coverage database", (Throwable)e);
        }
        ProjectInfo projectInfo = db.getModel(this.codeType);
        ProjectMetrics metrics = (ProjectMetrics)projectInfo.getMetrics();
        Logger.getInstance().debug("coverage = " + metrics.getPcCoveredElements());
        passed = this.checkCoverageFor(metrics.getPcCoveredElements(), this.targetPC, targetFailures, "Total", "target") && passed;
        passed = this.checkCoverageFor(metrics.getPcCoveredMethods(), this.methodTarget, targetFailures, "Method", "target") && passed;
        passed = this.checkCoverageFor(metrics.getPcCoveredStatements(), this.statementTarget, targetFailures, "Statement", "target") && passed;
        passed = this.checkCoverageFor(metrics.getPcCoveredBranches(), this.conditionalTarget, targetFailures, "Conditional", "target") && passed;
        try {
            passed = this.checkHistoryDirCoverage(metrics.getPcCoveredElements(), targetFailures, "Total", null) && passed;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (CloverException e) {
            throw new BuildException((Throwable)e);
        }
        Iterator i2 = this.packageRequirements.iterator();
        while (i2.hasNext()) {
            final PackageRequirement requirement = (PackageRequirement)i2.next();
            ArrayList<BasePackageInfo> matchedPackages = new ArrayList<BasePackageInfo>();
            if (requirement.name != null) {
                PackageInfo packageInfo = (PackageInfo)projectInfo.getNamedPackage(requirement.name);
                if (packageInfo == null) {
                    throw new BuildException("No coverage information for specified package: " + requirement.name);
                }
                matchedPackages.add(packageInfo);
            } else if (requirement.regex != null) {
                try {
                    matchedPackages.addAll(projectInfo.getPackages(new HasMetricsFilter(){

                        public boolean accept(HasMetrics node) {
                            return node.getName().matches(requirement.regex);
                        }
                    }));
                }
                catch (PatternSyntaxException e) {
                    throw new BuildException("Invalid package regular expression '" + requirement.regex + "': " + e.getMessage());
                }
            }
            Iterator pkgs = matchedPackages.iterator();
            while (pkgs.hasNext()) {
                PackageInfo packageInfo = (PackageInfo)pkgs.next();
                String packageName = packageInfo.getName();
                PackageMetrics pm = (PackageMetrics)packageInfo.getMetrics();
                String errorPrefix = "Package " + packageName;
                passed = this.checkCoverageFor(pm.getPcCoveredElements(), requirement.target, targetFailures, errorPrefix + " total", "target") && passed;
                passed = this.checkCoverageFor(pm.getPcCoveredMethods(), requirement.methodTarget, targetFailures, errorPrefix + " method", "target") && passed;
                passed = this.checkCoverageFor(pm.getPcCoveredStatements(), requirement.statementTarget, targetFailures, errorPrefix + " statement", "target") && passed;
                passed = this.checkCoverageFor(pm.getPcCoveredBranches(), requirement.conditionalTarget, targetFailures, errorPrefix + " conditional", "target") && passed;
                try {
                    passed = this.checkHistoryDirCoverage(pm.getPcCoveredElements(), targetFailures, errorPrefix + " total", packageName) && passed;
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
                catch (CloverException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
        if (!passed && targetFailures.lastIndexOf(StringUtils.LINE_SEP) == targetFailures.length() - StringUtils.LINE_SEP.length()) {
            targetFailures.delete(targetFailures.length() - StringUtils.LINE_SEP.length(), targetFailures.length());
        }
        if (!passed) {
            this.log("Coverage check FAILED");
            String failMessage = "The following coverage targets for " + this.getProject().getName() + " were not met: " + StringUtils.LINE_SEP + targetFailures;
            this.log(failMessage, 0);
            if (this.failureProperty != null) {
                this.getProject().setProperty(this.failureProperty, targetFailures.toString());
            }
            if (this.haltOnFailure) {
                throw new BuildException("Build failed to meet Clover coverage targets: " + failMessage);
            }
        } else {
            this.log("Coverage check PASSED");
        }
    }

    private boolean checkCoverageFor(float coverage, Percentage targetCoverage, StringBuffer failures, String level, String target) {
        DecimalFormat pcFormat = new DecimalFormat("###.#%");
        if (targetCoverage != null) {
            if (BlockMetrics.isUndefined(coverage)) {
                Logger.getInstance().debug("Recorded coverage = " + coverage + " means undefined value, so cannot compare against target coverage = " + targetCoverage + ". Returning PASS (true).");
                return true;
            }
            pcFormat.setMinimumFractionDigits(targetCoverage.getScale());
            if (targetCoverage.compare(coverage) > 0) {
                failures.append(level + " coverage of " + pcFormat.format(coverage) + " did not meet " + target + " of " + pcFormat.format(targetCoverage.getAsFloatFraction()));
                failures.append(StringUtils.LINE_SEP);
                return false;
            }
            Logger.getInstance().debug("recorded coverage = " + pcFormat.format(coverage) + "; target coverage = " + pcFormat.format(targetCoverage.getAsFloatFraction()));
        }
        return true;
    }

    private boolean checkHistoryDirCoverage(float coverage, StringBuffer failures, String level, String pkg) throws IOException, CloverException {
        if (this.getHistorydir() != null) {
            this.historyFiles = this.getHistoryFiles();
            this.model = this.getLastModel();
            if (this.model != null) {
                HasMetrics then = HistoricalSupport.getFullMetrics(this.model, pkg);
                if (then != null) {
                    Percentage targetCoverage = new Percentage("" + ((double)then.getMetrics().getPcCoveredElements() * 100.0 - this.threshold));
                    targetCoverage.setScale(2);
                    boolean passed = this.checkCoverageFor(coverage, targetCoverage, failures, level, "last history point target");
                    if (!passed) {
                        this.appendClassInfo(then, pkg, failures);
                    }
                    return passed;
                }
                Logger.getInstance().debug("Package " + pkg + " is new, the last history point target is met.");
            }
        }
        return true;
    }

    private void appendClassInfo(HasMetrics then, String pkg, StringBuffer failures) throws CloverException {
        CachingInfo now = pkg == null ? this.currentConfig.getCoverageDatabase().getModel(this.codeType) : this.currentConfig.getCoverageDatabase().getModel(this.codeType).getNamedPackage(pkg);
        List<MetricsDiffSummary> added = HistoricalSupport.getClassesMetricsDifference(then, now, new Percentage("0"), false);
        Iterator<MetricsDiffSummary> it = added.iterator();
        while (it.hasNext()) {
            MetricsDiffSummary diff = it.next();
            DecimalFormat diffFormat = new DecimalFormat("###.#");
            failures.append("  " + diffFormat.format(diff.getPc2()) + "% " + diff.getName() + " (Added)" + StringUtils.LINE_SEP);
        }
        List<MetricsDiffSummary> diffs = HistoricalSupport.getClassesMetricsDifference(then, now, new Percentage("0"), true);
        Iterator<MetricsDiffSummary> it2 = diffs.iterator();
        while (it2.hasNext()) {
            MetricsDiffSummary diff = it2.next();
            if (!(diff.getPcDiff() < 0.0f)) continue;
            DecimalFormat diffFormat = new DecimalFormat("###.#");
            failures.append("  " + diffFormat.format(diff.getPcDiff()) + " to " + diffFormat.format(diff.getPc2()) + "% " + diff.getName() + StringUtils.LINE_SEP);
        }
    }

    private HistoricalSupport.HasMetricsWrapper getLastModel() throws IOException, CloverException {
        if (this.models == null) {
            this.models = HistoricalSupport.getAllProjectMetrics(this.historyFiles);
            if (!this.models.isEmpty()) {
                Object[] modelArray = this.models.keySet().toArray();
                long currentVersion = this.currentConfig.getCoverageDatabase().getModel(this.codeType).getVersion();
                for (int i = modelArray.length - 1; i >= 0; --i) {
                    if ((Long)modelArray[i] >= currentVersion) continue;
                    Logger.getInstance().debug("Comparing current version " + new Date(currentVersion).toString() + " with history version " + new Date((Long)modelArray[i]).toString());
                    return (HistoricalSupport.HasMetricsWrapper)this.models.get(modelArray[i]);
                }
                Logger.getInstance().debug("History points exist but are newer than the database being checked.");
            } else {
                Logger.getInstance().debug("No history points exist.");
            }
        }
        return this.model;
    }

    private File[] getHistoryFiles() {
        if (this.historyFiles == null) {
            this.historyFiles = CloverReportTask.HistoricalEx.processHistoryIncludes(this.getProject(), null, this.getHistorydir());
        }
        return this.historyFiles;
    }

    public static class PackageRequirement {
        private String name;
        private String regex;
        private Percentage target;
        private Percentage methodTarget;
        private Percentage statementTarget;
        private Percentage conditionalTarget;

        public void setName(String name) {
            this.name = name;
        }

        public String getRegex() {
            return this.regex;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }

        public void setTarget(Percentage target) {
            this.target = target;
        }

        public Percentage getMethodTarget() {
            return this.methodTarget;
        }

        public void setMethodTarget(Percentage methodTarget) {
            this.methodTarget = methodTarget;
        }

        public Percentage getStatementTarget() {
            return this.statementTarget;
        }

        public void setStatementTarget(Percentage statementTarget) {
            this.statementTarget = statementTarget;
        }

        public Percentage getConditionalTarget() {
            return this.conditionalTarget;
        }

        public void setConditionalTarget(Percentage conditionalTarget) {
            this.conditionalTarget = conditionalTarget;
        }
    }
}

