/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html.source;

import com.atlassian.clover.services.ServiceLocator;
import com.atlassian.clover.services.ServiceNotAvailableException;
import com.atlassian.clover.spi.lang.Language;
import com.atlassian.clover.spi.reporters.html.source.SourceRenderer;
import com.cenqua.clover.Logger;
import com.cenqua.clover.reporters.html.source.PlaintextSourceRenderer;
import com.cenqua.clover.reporters.html.source.SourceRenderHelper;
import com.cenqua.clover.reporters.html.source.java.JavaSourceRenderer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SourceRendererManager {
    private static final PlaintextSourceRenderer PLAINTEXT_RENDERER = new PlaintextSourceRenderer();
    private static final Map<String, SourceRenderer> RENDERERS = Collections.unmodifiableMap(new HashMap<String, SourceRenderer>(){
        static /* synthetic */ Class class$com$cenqua$clover$reporters$html$source$SourceRenderHelper;
        static /* synthetic */ Class class$com$atlassian$clover$spi$reporters$html$source$SourceRenderer;
        {
            Class<?> clazz;
            Class<?> clazz2;
            this.registerRenderer(new JavaSourceRenderer());
            try {
                this.registerRenderer((SourceRenderer)Class.forName("com.atlassian.clover.reporters.html.source.groovy.GroovySourceRenderer").newInstance());
            }
            catch (Exception e) {
                Logger.getInstance().warn("Failed to register the Groovy source renderer - syntax highlighting will not be performed for Groovy code", e);
            }
            if ((clazz2 = class$com$atlassian$clover$spi$reporters$html$source$SourceRenderer) == null) {
                clazz2 = class$com$atlassian$clover$spi$reporters$html$source$SourceRenderer = new SourceRenderer[0].getClass().getComponentType();
            }
            if ((clazz = class$com$cenqua$clover$reporters$html$source$SourceRenderHelper) == null) {
                clazz = class$com$cenqua$clover$reporters$html$source$SourceRenderHelper = new SourceRenderHelper[0].getClass().getComponentType();
            }
            Iterator sourceRenderers = ServiceLocator.load(clazz2, clazz.getClassLoader()).iterator();
            while (sourceRenderers.hasNext()) {
                try {
                    this.registerRenderer((SourceRenderer)sourceRenderers.next());
                }
                catch (ServiceNotAvailableException e) {
                    Logger.getInstance().warn("Failed to register source renderer - syntax highlighting will not be performed for any of its supported languages", e);
                }
            }
        }

        private void registerRenderer(SourceRenderer sourceRenderer) {
            Language language = sourceRenderer.getSupportedLanguage();
            for (String extension : language.getFileExtensions()) {
                Logger.getInstance().debug(new StringBuffer().append("Registering renderer ").append(sourceRenderer.getClass().getName()).append(" for language ").append(language).append(" for file extension ").append(extension).toString());
                SourceRenderer existingRenderer = (SourceRenderer)this.get(extension);
                if (existingRenderer != null) {
                    throw new IllegalArgumentException(new StringBuffer().append("Render already registered for files with extension ").append(extension).append(": ").append(existingRenderer).toString());
                }
                this.put(extension, sourceRenderer);
            }
        }
    });

    public static PlaintextSourceRenderer getPlaintextRenderer() {
        return PLAINTEXT_RENDERER;
    }

    public static SourceRenderer getRendererForFileExtension(String fileExtension) {
        return RENDERERS.get(fileExtension);
    }
}

