/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.HasMetricsSupport;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.html.ClassInfoStatsCalculator;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.HtmlReporter;
import com.cenqua.clover.reporters.html.RenderCoverageCloudAction;
import com.cenqua.clover.reporters.html.TabInfo;
import com.cenqua.clover.reporters.html.TestClassFilter;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class RenderProjectCoverageCloudsAction
extends RenderCoverageCloudAction {
    protected ProjectInfo projectInfo;

    public RenderProjectCoverageCloudsAction(VelocityContext context, File basePath, HtmlReporter.TreeInfo tree, ProjectInfo projectInfo) {
        this(context, basePath, tree, projectInfo, RenderProjectCoverageCloudsAction.sortedAppClassesFor(projectInfo));
    }

    public RenderProjectCoverageCloudsAction(VelocityContext context, File basePath, HtmlReporter.TreeInfo tree, ProjectInfo projectInfo, List classes) {
        super(context, tree, classes, basePath);
        this.projectInfo = projectInfo;
    }

    protected File createOutputDir() {
        return this.basePath;
    }

    protected TabInfo createRisksTab() {
        return new TabInfo("Project Risks", "proj-risks.html", "help_pkg_risks");
    }

    private static List sortedAppClassesFor(ProjectInfo model) {
        List<? extends BaseClassInfo> classes = model.getClasses(new TestClassFilter());
        Collections.sort(classes, HasMetricsSupport.CMP_LEX);
        return classes;
    }

    protected void applySpecificProperties() {
        this.context.put("projectInfo", this.projectInfo);
        this.context.put("headerMetrics", this.projectInfo.getMetrics());
        this.context.put("headerMetricsRaw", this.projectInfo.getRawMetrics());
        this.context.put("siblingPresent", Boolean.TRUE);
        this.context.put("topLevel", Boolean.TRUE);
        HtmlReportUtil.addFilteredPercentageToContext(this.context, this.projectInfo);
    }

    protected void applyAxies(ClassInfoStatsCalculator axis1, ClassInfoStatsCalculator axis2) {
        this.applyAxis("deep", axis1, axis2, this.classes);
    }
}

