/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.console;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;
import com.atlassian.clover.util.Color;
import com.atlassian.clover.util.Formatting;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.LineInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectMetrics;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.reporters.console.ConsoleReporterConfig;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ConsoleReporter {
    private static final Logger LOG = Logger.getInstance();
    private final ConsoleReporterConfig cfg;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$console$ConsoleReporter;

    public ConsoleReporter(ConsoleReporterConfig cfg) {
        this.cfg = cfg;
    }

    public void report(PrintWriter out, CloverDatabase db) {
        out.print("Clover Coverage Report");
        if (this.cfg.title != null) {
            out.println(" - " + this.cfg.title);
        } else {
            out.println();
        }
        out.println("Coverage Timestamp: " + new Date(db.getRecordingTimestamp()));
        out.println("Report for code   : " + this.cfg.codetype);
        List<? extends BasePackageInfo> packages = db.getModel(this.cfg.codetype).getPackages();
        if (this.cfg.showPackages) {
            out.println();
            out.println("Package Summary - ");
        }
        Iterator<? extends BasePackageInfo> pkgs = packages.iterator();
        while (pkgs.hasNext()) {
            PackageInfo pkg = (PackageInfo)pkgs.next();
            if (this.cfg.packageSet != null && !this.cfg.packageSet.contains(pkg.getName())) continue;
            if (this.cfg.showPackages) {
                out.println(pkg.getName() + ": " + Formatting.getPercentStr(pkg.getMetrics().getPcCoveredElements()));
            }
            List fileInfos = pkg.getFiles();
            Iterator files = fileInfos.iterator();
            while (files.hasNext()) {
                FileInfo fInfo = (FileInfo)files.next();
                if (this.cfg.showClasses) {
                    out.println("---------------------------------------");
                    out.println("File: " + fInfo.getPackagePath());
                    List classes = fInfo.getClasses();
                    Iterator it = classes.iterator();
                    while (it.hasNext()) {
                        ClassInfo cInfo = (ClassInfo)it.next();
                        ClassMetrics metrics = (ClassMetrics)cInfo.getMetrics();
                        out.println("Package: " + cInfo.getPackage().getName());
                        this.printMetricsSummary(out, "Class: " + cInfo.getName(), metrics);
                    }
                }
                LineInfo[] lines = fInfo.getLineInfo();
                for (int linenum = 0; linenum < lines.length; ++linenum) {
                    BranchInfo[] branches;
                    int m;
                    MethodInfo[] starts;
                    LineInfo info = lines[linenum];
                    if (info == null) continue;
                    if (this.cfg.showMethods && (starts = info.getMethodStarts()) != null) {
                        for (m = 0; m < starts.length; ++m) {
                            if (starts[m].getHitCount() != 0) continue;
                            out.println(fInfo.getPhysicalFile().getAbsolutePath() + ":" + starts[m].getStartLine() + ":" + starts[m].getStartColumn() + ": method not entered.");
                        }
                    }
                    if (!this.cfg.showStatements) continue;
                    StatementInfo[] stmts = info.getStatements();
                    if (stmts != null) {
                        for (m = 0; m < stmts.length; ++m) {
                            if (stmts[m].getHitCount() != 0) continue;
                            out.println(fInfo.getPhysicalFile().getAbsolutePath() + ":" + stmts[m].getStartLine() + ":" + stmts[m].getStartColumn() + ": statement not executed.");
                        }
                    }
                    if ((branches = info.getBranches()) == null) continue;
                    for (int m2 = 0; m2 < branches.length; ++m2) {
                        String prefix = fInfo.getPhysicalFile().getAbsolutePath() + ":" + branches[m2].getStartLine() + ":" + branches[m2].getStartColumn() + ": ";
                        if (!branches[m2].isInstrumented()) {
                            out.println(prefix + "was not instumented, due to assignment in expression.");
                            continue;
                        }
                        if (branches[m2].getTrueHitCount() == 0 && branches[m2].getFalseHitCount() == 0) {
                            out.println(prefix + "branch not evaluated.");
                            continue;
                        }
                        if (branches[m2].getTrueHitCount() == 0) {
                            out.println(prefix + "true branch never taken.");
                            continue;
                        }
                        if (branches[m2].getFalseHitCount() != 0) continue;
                        out.println(prefix + "false branch never taken.");
                    }
                }
            }
        }
        out.println();
        out.println();
        ProjectMetrics overview = (ProjectMetrics)db.getModel(this.cfg.codetype).getMetrics();
        this.printMetricsSummary(out, "Coverage Overview -", overview);
        out.flush();
    }

    void printMetricsSummary(PrintWriter out, String title, ClassMetrics metrics) {
        out.println(title);
        out.println("Coverage:-");
        String methodSummary = ConsoleReporter.infoSummaryString(metrics.getNumCoveredMethods(), metrics.getNumMethods(), metrics.getPcCoveredMethods());
        String stmtSummary = ConsoleReporter.infoSummaryString(metrics.getNumCoveredStatements(), metrics.getNumStatements(), metrics.getPcCoveredStatements());
        String branchSummary = ConsoleReporter.infoSummaryString(metrics.getNumCoveredBranches(), metrics.getNumBranches(), metrics.getPcCoveredBranches());
        String totalSummary = Color.make(Formatting.getPercentStr(metrics.getPcCoveredElements())).b().toString();
        out.print("      Methods: " + methodSummary);
        this.printPcBar(out, methodSummary, metrics.getPcCoveredMethods());
        out.print("   Statements: " + stmtSummary);
        this.printPcBar(out, stmtSummary, metrics.getPcCoveredStatements());
        out.print("     Branches: " + branchSummary);
        this.printPcBar(out, branchSummary, metrics.getPcCoveredBranches());
        out.print("        Total: " + totalSummary);
        this.printPcBar(out, totalSummary, metrics.getPcCoveredElements());
        out.println("Complexity:-");
        out.println("   Avg Method: " + Formatting.format3d(metrics.getAvgMethodComplexity()));
        out.println("      Density: " + Formatting.format3d(metrics.getComplexityDensity()));
        out.println("        Total: " + metrics.getComplexity());
        if (this.cfg != null && this.cfg.showUnitTests) {
            out.println("Tests:-");
            out.println("    Available: " + metrics.getNumTests());
            out.println("     Executed: " + metrics.getNumTestsRun());
            out.println("       Passed: " + metrics.getNumTestPasses());
            out.println("       Failed: " + metrics.getNumTestFailures());
            out.println("       Errors: " + metrics.getNumTestErrors());
        }
    }

    private void printPcBar(PrintWriter out, String summary, float amt) {
        int padLen = 32 - summary.length();
        out.print(_String.format("%" + padLen + "s", new Object[]{" "}));
        int len = 80;
        int pc = (int)(amt * 80.0f);
        for (int i = 0; i <= 80; ++i) {
            if (i < pc) {
                out.print(Color.make(" ").bg().green());
                continue;
            }
            out.print(Color.make(" ").bg().red());
        }
        out.println();
    }

    private static String infoSummaryString(int covered, int total, float percent) {
        StringBuffer buf = new StringBuffer();
        buf.append(covered).append("/").append(total);
        buf.append(" (").append(Color.make(Formatting.getPercentStr(percent)).b()).append(")");
        return buf.toString();
    }

    private static void usage() {
        System.err.println();
        StringBuffer stringBuffer = new StringBuffer().append("  USAGE: ");
        Class<?> clazz = class$com$cenqua$clover$reporters$console$ConsoleReporter;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$reporters$console$ConsoleReporter = new ConsoleReporter[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" [OPTIONS] PARAMS").toString());
        System.err.println();
        System.err.println("  PARAMS:");
        System.err.println(ConsoleReporterConfig.Keys.INITSTRING.description() + "\n");
        System.err.println("  OPTIONS:\n" + ConsoleReporterConfig.Keys.LEVEL.description() + "\n" + ConsoleReporterConfig.Keys.CODETYPE.description() + "\n" + ConsoleReporterConfig.Keys.SOURCEPATH.description() + "\n" + ConsoleReporterConfig.Keys.SPAN.description() + "\n" + ConsoleReporterConfig.Keys.TITLE.description() + "\n" + ConsoleReporterConfig.Keys.UNITTESTS.description() + "\n");
    }

    public static void main(String[] args) {
        System.exit(ConsoleReporter.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        CloverStartup.loadLicense(LOG);
        ConsoleReporterConfig config = new ConsoleReporterConfig();
        if (!config.processArgs(args)) {
            ConsoleReporter.usage();
            return 1;
        }
        ConsoleReporter reporter = new ConsoleReporter(config);
        try {
            CloverDatabase db = new CloverDatabase(config.initstring);
            db.loadCoverageData(new CoverageDataSpec(config.getSpan().getValueInMillis()));
            if (config.getSourcepath() != null) {
                db.resolve(config.getSourcepath());
            }
            reporter.report(new PrintWriter(System.out), db);
            return 0;
        }
        catch (Exception e) {
            LOG.error("An error occurred while generating the report: " + e.getMessage(), e);
            return 1;
        }
    }
}

