/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.lang.Languages;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BasicElementInfo;
import com.cenqua.clover.registry.BasicStatementInfo;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.FixedSourceRegion;
import com.cenqua.clover.registry.MethodInfo;
import java.io.IOException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementInfo
extends ElementInfo<BasicElementInfo>
implements TaggedPersistent {
    private transient MethodInfo containingMethod;
    static /* synthetic */ Class class$com$cenqua$clover$context$ContextSet;

    public StatementInfo(MethodInfo containingMethod, int relativeDataIndex, ContextSet context, SourceInfo region, int complexity) {
        this(containingMethod, relativeDataIndex, context, region, complexity, LanguageConstruct.Builtin.STATEMENT);
    }

    public StatementInfo(MethodInfo containingMethod, int relativeDataIndex, ContextSet context, SourceInfo region, int complexity, LanguageConstruct construct) {
        this(containingMethod, context, new BasicStatementInfo(region, relativeDataIndex, complexity, construct));
    }

    private StatementInfo(MethodInfo containingMethod, ContextSet context, BasicElementInfo sharedInfo) {
        super(context, sharedInfo);
        this.containingMethod = containingMethod;
    }

    public StatementInfo copy(MethodInfo method) {
        return new StatementInfo(method, this.getContext(), this.sharedInfo);
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        throw new UnsupportedOperationException("setDataProvider not supported on StatementInfo");
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.containingMethod.getDataProvider();
    }

    @Override
    public int getDataLength() {
        return 1;
    }

    void setContainingMethod(MethodInfo methodInfo) {
        this.containingMethod = methodInfo;
    }

    @Override
    public BaseFileInfo getContainingFile() {
        return this.containingMethod.getContainingFile();
    }

    public String toString() {
        return new StringBuffer().append("StatementInfo{sharedInfo=").append(this.sharedInfo).append(", context=").append(this.context).append('}').toString();
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        Class<?> clazz = class$com$cenqua$clover$context$ContextSet;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$context$ContextSet = new ContextSet[0].getClass().getComponentType();
        }
        out.write(clazz, this.getContext());
        out.writeInt(this.sharedInfo.getRelativeDataIndex());
        out.writeInt(this.getComplexity());
        out.writeUTF(this.sharedInfo.getConstruct().getId());
        FixedSourceRegion.writeRaw(this, out);
    }

    public static StatementInfo read(TaggedDataInput in) throws IOException {
        Class<?> clazz = class$com$cenqua$clover$context$ContextSet;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$context$ContextSet = new ContextSet[0].getClass().getComponentType();
        }
        ContextSet context = (ContextSet)in.read(clazz);
        int relativeDataIndex = in.readInt();
        int complexity = in.readInt();
        LanguageConstruct construct = Languages.lookupConstruct(in.readUTF());
        FixedSourceRegion region = FixedSourceRegion.read(in);
        return new StatementInfo(null, relativeDataIndex, context, region, complexity, construct);
    }
}

