/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.HasMetricsNode;
import com.cenqua.clover.registry.PackageMetrics;
import com.cenqua.clover.registry.ProjectInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class PackageInfo
extends BasePackageInfo
implements HasMetricsNode,
CoverageDataReceptor,
com.atlassian.clover.api.registry.PackageInfo {
    private int dataIndex;
    private int dataLength;
    private Comparator orderby;
    private CoverageDataProvider data;

    public PackageInfo(ProjectInfo containingProject, String pkg, int dataIndex) {
        super(containingProject, pkg);
        this.dataIndex = dataIndex;
    }

    public static PackageInfo createEmptyFromTemplate(PackageInfo info) {
        return new PackageInfo(null, info.getName(), 0);
    }

    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        Iterator iterator = this.files.values().iterator();
        while (iterator.hasNext()) {
            FileInfo fileInfo = (FileInfo)iterator.next();
            fileInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    public int getDataIndex() {
        return this.dataIndex;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataIndex(int index) {
        this.dataIndex = index;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public String getChildType() {
        return "class";
    }

    public int getNumChildren() {
        if (this.classes == null) {
            this.gatherChildClasses();
        }
        return this.classes.size();
    }

    public HasMetricsNode getChild(int i) {
        if (this.classes == null) {
            this.gatherChildClasses();
        }
        return (HasMetricsNode)this.classes.get(i);
    }

    public int getIndexOfChild(HasMetricsNode child) {
        if (this.classes == null) {
            this.gatherChildClasses();
        }
        return this.classes.indexOf(child);
    }

    public boolean isLeaf() {
        return false;
    }

    public void setComparator(Comparator cmp) {
        this.orderby = cmp;
        this.classes = null;
        Iterator iterator = this.files.values().iterator();
        while (iterator.hasNext()) {
            FileInfo fileInfo = (FileInfo)iterator.next();
            fileInfo.setComparator(cmp);
        }
    }

    public BlockMetrics getMetrics() {
        if (this.metrics == null || this.getContainingProject().getContextFilter() != this.contextFilter) {
            this.contextFilter = this.getContainingProject().getContextFilter();
            this.metrics = this.calcMetrics(true);
        }
        return this.metrics;
    }

    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(false);
        }
        return this.rawMetrics;
    }

    protected void gatherChildClasses() {
        super.gatherChildClasses();
        if (this.orderby != null) {
            Collections.sort(this.classes, this.orderby);
        }
    }

    private PackageMetrics calcMetrics(boolean filter) {
        PackageMetrics packageMetrics = new PackageMetrics(this);
        int numFiles = 0;
        Iterator iterator = this.files.values().iterator();
        while (iterator.hasNext()) {
            FileInfo fileInfo = (FileInfo)iterator.next();
            if (!filter) {
                packageMetrics.add((FileMetrics)fileInfo.getRawMetrics());
            } else {
                packageMetrics.add((FileMetrics)fileInfo.getMetrics());
            }
            ++numFiles;
        }
        packageMetrics.setNumFiles(numFiles);
        return packageMetrics;
    }

    public PackageInfo copy(ProjectInfo proj, HasMetricsFilter filter) {
        PackageInfo pkg = new PackageInfo(proj, this.name, this.dataIndex);
        pkg.setDataProvider(this.getDataProvider());
        Iterator iterator = this.files.values().iterator();
        while (iterator.hasNext()) {
            FileInfo info;
            FileInfo fileInfo = (FileInfo)iterator.next();
            if (!filter.accept(fileInfo) || (info = fileInfo.copy(pkg, filter)).isEmpty()) continue;
            pkg.addFile(info);
        }
        pkg.setDataLength(this.getDataLength());
        return pkg;
    }

    public String toString() {
        return "PackageInfo{name='" + this.name + '\'' + ", defaultPkg=" + this.defaultPkg + ", path='" + this.path + '\'' + '}';
    }

    public com.atlassian.clover.api.registry.ProjectInfo getContainer() {
        return (com.atlassian.clover.api.registry.ProjectInfo)((Object)this.getContainingProject());
    }

    public boolean isDescendantOf(com.atlassian.clover.api.registry.PackageInfo other) {
        if (this.containingProject == other.getContainer()) {
            return this != other && (other.isDefault() || this.getName().indexOf(other.getName() + ".") == 0);
        }
        return false;
    }
}

