/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.spi.lang.Language;
import com.atlassian.clover.util.FileUtils;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileElementVisitor;
import com.cenqua.clover.registry.FileMetrics;
import com.cenqua.clover.registry.FixedSourceRegion;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.HasMetricsNode;
import com.cenqua.clover.registry.LineInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.StackTraceInfo;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.util.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfo
extends BaseFileInfo
implements HasMetricsNode,
CoverageDataReceptor,
TaggedPersistent,
com.atlassian.clover.api.registry.FileInfo {
    public static final long NO_VERSION = -1L;
    private File actualFile;
    protected int dataIndex;
    private int dataLength;
    private long minVersion;
    private long maxVersion;
    private transient List orderedClasses;
    private transient LineInfo[] lineInfo;
    private transient Comparator orderby;
    private transient CoverageDataProvider data;
    private transient Map failStackInfos;
    static /* synthetic */ Class class$com$cenqua$clover$registry$ClassInfo;

    public FileInfo(PackageInfo containingPackage, File actualFile, String encoding, int dataIndex, int lineCount, int ncLineCount, long timestamp, long filesize, long checksum, long minVersion) {
        super(containingPackage, actualFile.getName(), encoding, lineCount, ncLineCount, timestamp, filesize, checksum);
        this.actualFile = actualFile;
        this.dataIndex = dataIndex;
        this.lineCount = lineCount;
        this.minVersion = this.maxVersion = minVersion;
    }

    private FileInfo(File actualFile, String encoding, int dataIndex, int dataLength, int lineCount, int ncLineCount, long timestamp, long checksum, long filesize, long minVersion, long maxVersion, Map<String, ClassInfo> classes) {
        super(null, actualFile.getName(), encoding, lineCount, ncLineCount, timestamp, filesize, checksum);
        this.actualFile = actualFile;
        this.dataIndex = dataIndex;
        this.dataLength = dataLength;
        this.lineCount = lineCount;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.classes = classes;
    }

    public File getPhysicalFile() {
        return this.actualFile;
    }

    public boolean validatePhysicalFile() {
        if (this.actualFile.exists()) {
            try {
                return FileUtils.calcAdlerChecksum(this.getPhysicalFile(), this.getEncoding()) == this.getChecksum();
            }
            catch (IOException e) {
                Logger.getInstance().warn(new StringBuffer().append("IOException calculating file checksum for ").append(this.actualFile).toString(), e);
            }
        }
        return false;
    }

    public Set getSourceRegions() {
        TreeSet<SourceInfo> regions = new TreeSet<SourceInfo>(FixedSourceRegion.SOURCE_ORDER_COMP);
        for (ClassInfo classInfo : this.classes.values()) {
            classInfo.gatherSourceRegions(regions);
        }
        return regions;
    }

    public LineInfo[] getLineInfo() {
        return this.getLineInfo(this.getLineCount() + 1);
    }

    public LineInfo[] getLineInfo(int ensureLineCountAtLeast) {
        if (this.lineInfo == null) {
            final LineInfo[] tmpLineInfo = new LineInfo[Math.max(this.getLineCount() + 1, ensureLineCountAtLeast)];
            this.visitElements(new FileElementVisitor(){

                private LineInfo getOrCreateLineInfo(SourceInfo r) {
                    int startLine = r.getStartLine();
                    LineInfo lineInfo = null;
                    if (startLine >= 1 && startLine < tmpLineInfo.length && (lineInfo = tmpLineInfo[startLine]) == null) {
                        tmpLineInfo[startLine] = lineInfo = new LineInfo(startLine);
                    }
                    return lineInfo;
                }

                public void visitClass(ClassInfo info) {
                    LineInfo lineInfo = this.getOrCreateLineInfo(info);
                    if (lineInfo != null) {
                        lineInfo.addClassStart(info);
                    }
                }

                public void visitMethod(MethodInfo info) {
                    LineInfo lineInfo = this.getOrCreateLineInfo(info);
                    if (lineInfo != null) {
                        lineInfo.addMethodStart(info);
                    }
                }

                public void visitStatement(StatementInfo info) {
                    LineInfo lineInfo = this.getOrCreateLineInfo(info);
                    if (lineInfo != null) {
                        lineInfo.addStatement(info);
                    }
                }

                public void visitBranch(BranchInfo info) {
                    LineInfo lineInfo = this.getOrCreateLineInfo(info);
                    if (lineInfo != null) {
                        lineInfo.addBranch(info);
                    }
                }
            });
            if (this.failStackInfos != null) {
                for (Map.Entry entry : this.failStackInfos.entrySet()) {
                    int line = (Integer)entry.getKey();
                    List stackFrames = (List)entry.getValue();
                    if (line <= 0 || line >= tmpLineInfo.length) continue;
                    if (tmpLineInfo[line] == null) {
                        tmpLineInfo[line] = new LineInfo(line);
                    }
                    tmpLineInfo[line].setFailStackEntries(stackFrames.toArray(new StackTraceInfo.TraceEntry[stackFrames.size()]));
                }
            }
            this.lineInfo = tmpLineInfo;
        }
        return this.lineInfo;
    }

    public void visitElements(FileElementVisitor visitor) {
        for (ClassInfo classInfo : this.classes.values()) {
            classInfo.visitElements(visitor);
        }
    }

    @Override
    public BlockMetrics getMetrics() {
        if (this.metrics == null || this.getContainingPackage().getContextFilter() != this.contextFilter) {
            this.contextFilter = this.getContainingPackage().getContextFilter();
            this.metrics = this.calcMetrics(true);
        }
        return this.metrics;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(false);
        }
        return this.rawMetrics;
    }

    public void resolve(Path path) {
        File resolved = path.resolveFile(this.getPackagePath());
        if (resolved != null) {
            this.actualFile = resolved;
        }
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        for (ClassInfo classInfo : this.classes.values()) {
            classInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    public void setDataIndex(int dataIndex) {
        this.dataIndex = dataIndex;
    }

    @Override
    public int getDataIndex() {
        return this.dataIndex;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public void addVersion(long version) {
        if (this.minVersion == -1L) {
            this.minVersion = version;
        }
        this.maxVersion = Math.max(version, this.maxVersion);
    }

    public void addVersions(long minVersion, long maxVersion) {
        if (this.minVersion == -1L) {
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
        } else {
            this.minVersion = Math.min(this.minVersion, minVersion);
            this.maxVersion = Math.max(this.maxVersion, maxVersion);
        }
    }

    public boolean supportsVersion(long version) {
        return version <= this.maxVersion && version >= this.minVersion;
    }

    public long getMinVersion() {
        return this.minVersion;
    }

    public long getMaxVersion() {
        return this.maxVersion;
    }

    public void resetVersions(long version) {
        this.minVersion = this.maxVersion = version;
    }

    public boolean changedFrom(long checksum, long filesize) {
        return this.getChecksum() != checksum || this.getFilesize() != filesize;
    }

    @Override
    public String getChildType() {
        return "class";
    }

    @Override
    public int getNumChildren() {
        return this.classes.size();
    }

    @Override
    public HasMetricsNode getChild(int i) {
        if (this.orderedClasses == null) {
            this.buildOrderedClassList();
        }
        return (HasMetricsNode)this.orderedClasses.get(i);
    }

    @Override
    public int getIndexOfChild(HasMetricsNode child) {
        if (this.orderedClasses == null) {
            this.buildOrderedClassList();
        }
        return this.orderedClasses.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setComparator(Comparator cmp) {
        this.orderby = cmp;
        this.orderedClasses = null;
        for (ClassInfo classInfo : this.classes.values()) {
            classInfo.setComparator(cmp);
        }
    }

    private void buildOrderedClassList() {
        ArrayList tmpOrderedClasses = new ArrayList(this.classes.values());
        if (this.orderby != null) {
            Collections.sort(tmpOrderedClasses, this.orderby);
        } else {
            Collections.sort(tmpOrderedClasses, FixedSourceRegion.SOURCE_ORDER_COMP);
        }
        this.orderedClasses = tmpOrderedClasses;
    }

    private FileMetrics calcMetrics(boolean filtered) {
        FileMetrics fileMetrics = new FileMetrics(this);
        fileMetrics.setLineCount(this.lineCount);
        fileMetrics.setNcLineCount(this.ncLineCount);
        int numClasses = 0;
        for (ClassInfo classInfo : this.classes.values()) {
            if (!filtered) {
                fileMetrics.add((ClassMetrics)classInfo.getRawMetrics());
            } else {
                fileMetrics.add((ClassMetrics)classInfo.getMetrics());
            }
            ++numClasses;
        }
        fileMetrics.setNumClasses(numClasses);
        return fileMetrics;
    }

    public FileInfo copy(PackageInfo pkg, HasMetricsFilter filter) {
        FileInfo file = new FileInfo(pkg, this.actualFile, this.encoding, this.dataIndex, this.lineCount, this.ncLineCount, this.timestamp, this.filesize, this.checksum, this.minVersion);
        file.addVersion(this.maxVersion);
        file.setDataProvider(this.getDataProvider());
        for (ClassInfo classInfo : this.classes.values()) {
            if (!filter.accept(classInfo)) continue;
            file.addClass(classInfo.copy(file, filter));
        }
        file.setDataLength(this.getDataLength());
        if (this.failStackInfos != null) {
            file.setFailStackEntries(this.failStackInfos);
        }
        return file;
    }

    public Set getUniqueFailingTests() {
        HashSet<TestCaseInfo> tests = null;
        if (this.failStackInfos != null) {
            tests = new HashSet<TestCaseInfo>();
            for (Map.Entry entry : this.failStackInfos.entrySet()) {
                List entries = (List)entry.getValue();
                for (StackTraceInfo.TraceEntry traceEntry : entries) {
                    tests.add(traceEntry.getParentTrace().getOriginatingTest());
                }
            }
        }
        return tests;
    }

    public Map getFailStackEntries() {
        return this.failStackInfos;
    }

    public void setFailStackEntries(Map entries) {
        this.failStackInfos = new TreeMap(entries);
    }

    public void addFailStackEntry(int lineNum, StackTraceInfo.TraceEntry traceEntry) {
        Integer lineKey;
        ArrayList<StackTraceInfo.TraceEntry> tracesForLine;
        if (this.failStackInfos == null) {
            this.failStackInfos = new TreeMap();
        }
        if ((tracesForLine = (ArrayList<StackTraceInfo.TraceEntry>)this.failStackInfos.get(lineKey = new Integer(lineNum))) == null) {
            tracesForLine = new ArrayList<StackTraceInfo.TraceEntry>();
            this.failStackInfos.put(lineKey, tracesForLine);
        }
        tracesForLine.add(traceEntry);
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeUTF(this.actualFile.getPath());
        out.writeUTF(this.encoding);
        out.writeLong(this.timestamp);
        out.writeLong(this.filesize);
        out.writeLong(this.checksum);
        out.writeInt(this.dataIndex);
        out.writeInt(this.dataLength);
        out.writeLong(this.minVersion);
        out.writeLong(this.maxVersion);
        out.writeInt(this.lineCount);
        out.writeInt(this.ncLineCount);
        out.writeInt(this.classes.size());
        for (ClassInfo classInfo : this.classes.values()) {
            Class<?> clazz = class$com$cenqua$clover$registry$ClassInfo;
            if (clazz == null) {
                clazz = new ClassInfo[0].getClass().getComponentType();
            }
            out.write(clazz, classInfo);
        }
    }

    public static FileInfo read(TaggedDataInput in) throws IOException {
        String actualFileName = FileUtils.getPlatformSpecificPath(in.readUTF());
        File actualFile = new File(actualFileName);
        String encoding = in.readUTF();
        long timestamp = in.readLong();
        long filesize = in.readLong();
        long checksum = in.readLong();
        int dataIndex = in.readInt();
        int dataLength = in.readInt();
        long minVersion = in.readLong();
        long maxVersion = in.readLong();
        int lineCount = in.readInt();
        int ncLineCount = in.readInt();
        int numClasses = in.readInt();
        LinkedHashMap<String, ClassInfo> classes = new LinkedHashMap<String, ClassInfo>();
        for (int i = 0; i < numClasses; ++i) {
            Class<?> clazz = class$com$cenqua$clover$registry$ClassInfo;
            if (clazz == null) {
                clazz = new ClassInfo[0].getClass().getComponentType();
            }
            ClassInfo classInfo = (ClassInfo)in.read(clazz);
            classes.put(classInfo.getName(), classInfo);
        }
        FileInfo fileInfo = new FileInfo(actualFile, encoding, dataIndex, dataLength, lineCount, ncLineCount, timestamp, checksum, filesize, minVersion, maxVersion, classes);
        for (ClassInfo classInfo : classes.values()) {
            classInfo.setContainingFile(fileInfo);
        }
        return fileInfo;
    }

    public Reader getSourceReader() throws FileNotFoundException, UnsupportedEncodingException {
        if (this.getEncoding() == null) {
            return new FileReader(this.getPhysicalFile());
        }
        return new InputStreamReader((InputStream)new FileInputStream(this.getPhysicalFile()), this.getEncoding());
    }

    public Language getLanguage() {
        if (this.actualFile != null) {
            for (Language.Builtin language : Language.Builtin.values()) {
                for (String extension : language.getFileExtensions()) {
                    if (!this.actualFile.getPath().endsWith(extension)) continue;
                    return language;
                }
            }
        }
        return null;
    }

    @Override
    public com.atlassian.clover.api.registry.PackageInfo getContainer() {
        return (com.atlassian.clover.api.registry.PackageInfo)((Object)this.getContainingPackage());
    }
}

