/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.lang.Languages;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BasicBranchInfo;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.FixedSourceRegion;
import com.cenqua.clover.registry.MethodInfo;
import java.io.IOException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchInfo
extends ElementInfo<BasicBranchInfo>
implements TaggedPersistent {
    private transient MethodInfo containingMethod;
    static /* synthetic */ Class class$com$cenqua$clover$context$ContextSet;

    public BranchInfo(MethodInfo containingMethod, int relativeDataIndex, ContextSet context, SourceInfo region, int complexity, boolean instrumented) {
        this(containingMethod, relativeDataIndex, context, region, complexity, instrumented, LanguageConstruct.Builtin.BRANCH);
    }

    public BranchInfo(MethodInfo containingMethod, int relativeDataIndex, ContextSet context, SourceInfo region, int complexity, boolean instrumented, LanguageConstruct construct) {
        this(containingMethod, context, new BasicBranchInfo(region, relativeDataIndex, complexity, instrumented, construct));
    }

    private BranchInfo(MethodInfo containingMethod, ContextSet context, BasicBranchInfo sharedInfo) {
        super(context, sharedInfo);
        this.containingMethod = containingMethod;
    }

    public int getTrueHitCount() {
        return super.getHitCount();
    }

    public int getFalseHitCount() {
        CoverageDataProvider data = this.getDataProvider();
        if (data == null) {
            return 0;
        }
        return data.getHitCount(this.getDataIndex() + 1);
    }

    public boolean isInstrumented() {
        return ((BasicBranchInfo)this.sharedInfo).isInstrumented();
    }

    public BranchInfo copy(MethodInfo method) {
        return new BranchInfo(method, this.getContext(), (BasicBranchInfo)this.sharedInfo);
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        throw new UnsupportedOperationException("setDataProvider not supported on BranchInfo");
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.containingMethod.getDataProvider();
    }

    @Override
    public int getDataLength() {
        return 2;
    }

    void setContainingMethod(MethodInfo methodInfo) {
        this.containingMethod = methodInfo;
    }

    @Override
    public BaseFileInfo getContainingFile() {
        return this.containingMethod.getContainingFile();
    }

    public String toString() {
        return new StringBuffer().append("BranchInfo{sharedInfo=").append(this.sharedInfo).append(", context=").append(this.context).append('}').toString();
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        Class<?> clazz = class$com$cenqua$clover$context$ContextSet;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$context$ContextSet = new ContextSet[0].getClass().getComponentType();
        }
        out.write(clazz, this.getContext());
        out.writeInt(((BasicBranchInfo)this.sharedInfo).getRelativeDataIndex());
        out.writeInt(this.getComplexity());
        out.writeUTF(((BasicBranchInfo)this.sharedInfo).getConstruct().getId());
        out.writeBoolean(((BasicBranchInfo)this.sharedInfo).isInstrumented());
        FixedSourceRegion.writeRaw(this, out);
    }

    public static BranchInfo read(TaggedDataInput in) throws IOException {
        Class<?> clazz = class$com$cenqua$clover$context$ContextSet;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$context$ContextSet = new ContextSet[0].getClass().getComponentType();
        }
        ContextSet context = (ContextSet)in.read(clazz);
        int relativeDataIndex = in.readInt();
        int complexity = in.readInt();
        LanguageConstruct construct = Languages.lookupConstruct(in.readUTF());
        boolean isInstrumented = in.readBoolean();
        FixedSourceRegion region = FixedSourceRegion.read(in);
        return new BranchInfo(null, relativeDataIndex, context, region, complexity, isInstrumented, construct);
    }
}

