/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.CachingInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseProjectInfo
implements HasMetrics,
CachingInfo {
    protected String name;
    protected Map<String, BasePackageInfo> packages;
    protected long version;
    protected Map<String, BaseClassInfo> classLookup;
    protected Map<String, BaseFileInfo> fileLookup;
    protected BlockMetrics rawMetrics;
    protected BlockMetrics metrics;
    protected ContextSet contextFilter;

    public BaseProjectInfo(String name, long version) {
        this.name = name;
        this.version = version;
        this.packages = new LinkedHashMap<String, BasePackageInfo>();
    }

    public BaseProjectInfo(String name) {
        this(name, System.currentTimeMillis());
    }

    public List<? extends BasePackageInfo> getPackages() {
        return new ArrayList<BasePackageInfo>(this.packages.values());
    }

    public void addPackage(BasePackageInfo pkg) {
        this.packages.put(pkg.getName(), pkg);
    }

    public BasePackageInfo getDefaultPackage() {
        return this.packages.get("default-pkg");
    }

    public BasePackageInfo getNamedPackage(String name) {
        if (name == null || name.length() == 0 || "default-pkg".equals(name)) {
            return this.getDefaultPackage();
        }
        return this.packages.get(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEmpty() {
        return this.packages.isEmpty();
    }

    public BaseClassInfo findClass(String fqcn) {
        if (this.classLookup == null) {
            this.buildClassLookupMap();
        }
        return this.classLookup.get(fqcn);
    }

    public BaseFileInfo findFile(String pkgPath) {
        if (this.fileLookup == null) {
            this.buildFileLookupMap();
        }
        return this.fileLookup.get(pkgPath);
    }

    public List<? extends BaseClassInfo> getClasses(HasMetricsFilter filter) {
        if (this.classLookup == null) {
            this.buildClassLookupMap();
        }
        ArrayList<BaseClassInfo> result = new ArrayList<BaseClassInfo>();
        for (BaseClassInfo classInfo : this.classLookup.values()) {
            if (!filter.accept(classInfo)) continue;
            result.add(classInfo);
        }
        return result;
    }

    public List getFiles(HasMetricsFilter filter) {
        if (this.fileLookup == null) {
            this.buildFileLookupMap();
        }
        ArrayList<BaseFileInfo> result = new ArrayList<BaseFileInfo>();
        for (BaseFileInfo fileInfo : this.fileLookup.values()) {
            if (!filter.accept(fileInfo)) continue;
            result.add(fileInfo);
        }
        return result;
    }

    public List<BasePackageInfo> getPackages(HasMetricsFilter filter) {
        ArrayList<BasePackageInfo> result = new ArrayList<BasePackageInfo>();
        for (BasePackageInfo packageInfo : this.packages.values()) {
            if (!filter.accept(packageInfo)) continue;
            result.add(packageInfo);
        }
        return result;
    }

    private void buildClassLookupMap() {
        final LinkedHashMap<String, BaseClassInfo> tmpClassLookup = new LinkedHashMap<String, BaseClassInfo>();
        this.visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                List classes = file.getClasses();
                Iterator it = classes.iterator();
                while (it.hasNext()) {
                    BaseClassInfo info = (BaseClassInfo)it.next();
                    tmpClassLookup.put(info.getQualifiedName(), info);
                }
            }
        });
        this.classLookup = tmpClassLookup;
    }

    private void buildFileLookupMap() {
        final LinkedHashMap<String, BaseFileInfo> tmpFileLookup = new LinkedHashMap<String, BaseFileInfo>();
        this.visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                tmpFileLookup.put(file.getPackagePath(), file);
            }
        });
        this.fileLookup = tmpFileLookup;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        return this.rawMetrics;
    }

    @Override
    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    public ContextSet getContextFilter() {
        return this.contextFilter;
    }

    public void setContextFilter(ContextSet filter) {
        this.contextFilter = filter;
        this.metrics = null;
    }

    public void visitFiles(FileInfoVisitor visitor) {
        for (BasePackageInfo pkgInfo : this.packages.values()) {
            pkgInfo.visitFiles(visitor);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public void invalidateCaches() {
        this.classLookup = null;
        this.fileLookup = null;
        this.rawMetrics = null;
        this.metrics = null;
    }
}

