/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BaseProjectInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.CachingInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.util.CloverUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BasePackageInfo
implements HasMetrics,
CachingInfo {
    protected final String name;
    protected final boolean defaultPkg;
    protected final Map files = new LinkedHashMap();
    protected final String path;
    protected BaseProjectInfo containingProject;
    protected BlockMetrics rawMetrics;
    protected BlockMetrics metrics;
    protected ContextSet contextFilter;
    protected List classes;

    public BasePackageInfo(BaseProjectInfo containingProject, String name) {
        this.containingProject = containingProject;
        this.defaultPkg = BasePackageInfo.isDefaultName(name);
        this.name = this.defaultPkg ? "default-pkg" : name;
        this.path = CloverUtils.packageNameToPath(name, this.defaultPkg);
    }

    public static boolean isDefaultName(String name) {
        return name.length() == 0 || name.equals("default-pkg");
    }

    public BaseProjectInfo getContainingProject() {
        return this.containingProject;
    }

    public ContextSet getContextFilter() {
        return this.getContainingProject().getContextFilter();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isDefault() {
        return this.defaultPkg;
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    public List getFiles() {
        return new ArrayList(this.files.values());
    }

    public void addFile(BaseFileInfo file) {
        file.setContainingPackage(this);
        this.files.put(file.getPackagePath(), file);
    }

    public BaseFileInfo getFile(String packagePath) {
        return (BaseFileInfo)this.files.get(packagePath);
    }

    public BaseFileInfo getFileInPackage(String name) {
        return this.getFile(this.getPath() + name);
    }

    public List getClasses() {
        if (this.classes == null) {
            this.gatherChildClasses();
        }
        return new ArrayList(this.classes);
    }

    public List getClasses(HasMetricsFilter filter) {
        ArrayList<HasMetrics> filteredClasses = new ArrayList<HasMetrics>();
        List allClasses = this.getClasses();
        Iterator iterator = allClasses.iterator();
        while (iterator.hasNext()) {
            HasMetrics hasMetrics = (HasMetrics)iterator.next();
            if (!filter.accept(hasMetrics)) continue;
            filteredClasses.add(hasMetrics);
        }
        return filteredClasses;
    }

    public List getChildAndDescendantClasses() {
        List<? extends BasePackageInfo> packages = this.getContainingProject().getPackages();
        LinkedList classes = new LinkedList(this.getClasses());
        Iterator<? extends BasePackageInfo> pkgIter = packages.iterator();
        while (pkgIter.hasNext()) {
            BasePackageInfo otherPkg = pkgIter.next();
            if (!otherPkg.isChildOrDescendantOf(this)) continue;
            classes.addAll(otherPkg.getClasses());
        }
        return classes;
    }

    public BlockMetrics getRawMetrics() {
        return this.rawMetrics;
    }

    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    protected void gatherChildClasses() {
        ArrayList tmpClasses = new ArrayList();
        Iterator iterator = this.files.values().iterator();
        while (iterator.hasNext()) {
            BaseFileInfo fileInfo = (BaseFileInfo)iterator.next();
            tmpClasses.addAll(fileInfo.getClasses());
        }
        this.classes = tmpClasses;
    }

    public void visitFiles(FileInfoVisitor visitor) {
        Iterator iterator = this.files.values().iterator();
        while (iterator.hasNext()) {
            BaseFileInfo fileInfo = (BaseFileInfo)iterator.next();
            visitor.visitFileInfo(fileInfo);
        }
    }

    public boolean isChildOrDescendantOf(BasePackageInfo other) {
        if (this.containingProject == other.containingProject) {
            return this != other && (other.isDefault() || this.getName().indexOf(other.getName() + ".") == 0);
        }
        return false;
    }

    public boolean isNamed(String name) {
        return this.isDefault() && BasePackageInfo.isDefaultName(name) || this.name.equals(name);
    }

    public void invalidateCaches() {
        this.classes = null;
        this.rawMetrics = null;
        this.metrics = null;
    }
}

