/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverProperties {
    private final Map<String, String> instrTimeProperties;

    public CloverProperties(String[] instrTimeProperties) {
        this.instrTimeProperties = CloverProperties.toMap(instrTimeProperties);
    }

    public String getProperty(String name) {
        return CloverProperties.getSysProperty(name, this.instrTimeProperties.get(name));
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return Boolean.valueOf(CloverProperties.getSysProperty(name, Boolean.toString(defaultValue)));
    }

    public static String getSysProperty(final String name, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, defaultValue);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    public static boolean getBooleanSysProperty(String name, boolean defaultValue) {
        return Boolean.valueOf(CloverProperties.getSysProperty(name, Boolean.toString(defaultValue)));
    }

    private static Map<String, String> toMap(String[] nvpProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (nvpProperties != null) {
            if (nvpProperties.length % 2 != 0) {
                throw new IllegalArgumentException("The number of Clover properties strings supplied should be a multiple of 2");
            }
            for (int i = 0; i < nvpProperties.length; i += 2) {
                properties.put(nvpProperties[i], nvpProperties[i + 1]);
            }
        }
        return properties;
    }

    public static CloverProperties newEmptyProperties() {
        return new CloverProperties(new String[0]);
    }

    public String toString() {
        return new StringBuffer().append("[InstrumentationProperties=").append(this.instrTimeProperties).append(", cloverSystemProperties=").append(this.getCloverSystemProperties()).append("]").toString();
    }

    private String getCloverSystemProperties() {
        Properties systemProperties = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
        HashMap<String, String> cloverSystemProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
            if (!((String)entry.getKey()).startsWith("clover.")) continue;
            cloverSystemProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        return ((Object)cloverSystemProperties).toString();
    }
}

