/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.recorder.ActivePerTestRecorderAny;
import com.atlassian.clover.recorder.ActivePerTestRecorderOne;
import com.atlassian.clover.recorder.FileBasedPerTestRecording;
import com.atlassian.clover.recorder.LivePerTestRecording;
import com.atlassian.clover.recorder.RecordingResult;
import com.cenqua.clover.ErrorInfo;
import com.cenqua.clover.Logger;
import com.cenqua.clover.RuntimeType;
import com_cenqua_clover.CoverageRecorder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public final class ActivePerTestRecorderMany
extends ActivePerTestRecorderAny {
    private final ActivePerTestRecorderOne[] those;

    public ActivePerTestRecorderMany(CoverageRecorder coverageRecorder, ActivePerTestRecorderOne[] those) {
        super(coverageRecorder);
        this.those = those;
    }

    public void set(int index) {
        ActivePerTestRecorderOne[] arr$ = this.those;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ActivePerTestRecorderOne thisOne = arr$[i$];
            thisOne.set(index);
        }
    }

    public ActivePerTestRecorderAny testStarted(String type, long start, int slice, int testRunID) {
        ActivePerTestRecorderOne[] unaries = new ActivePerTestRecorderOne[this.those.length + 1];
        unaries[0] = new ActivePerTestRecorderOne(this.coverageRecorder, this.coverageRecorder.createEmptyHitsMask(), new RuntimeType(type), start, slice, testRunID);
        System.arraycopy(this.those, 0, unaries, 1, this.those.length);
        return new ActivePerTestRecorderMany(this.coverageRecorder, unaries);
    }

    public RecordingResult testFinished(String type, String method, long end, int slice, int testRunId, int exitStatus, ErrorInfo errorInfo) {
        RuntimeType runtimeType = new RuntimeType(type);
        if (this.those[0].matchesTest(type, slice, testRunId)) {
            if (this.those.length == 2) {
                return new RecordingResult(new FileBasedPerTestRecording(this.coverageRecorder, this.those[0].coverage, method, this.those[0].start, end, runtimeType, slice, testRunId, exitStatus, errorInfo), this.those[1]);
            }
            ActivePerTestRecorderOne[] unaries = new ActivePerTestRecorderOne[this.those.length - 1];
            System.arraycopy(this.those, 1, unaries, 0, this.those.length - 1);
            return new RecordingResult(new FileBasedPerTestRecording(this.coverageRecorder, this.those[0].coverage, method, this.those[0].start, end, runtimeType, slice, testRunId, exitStatus, errorInfo), new ActivePerTestRecorderMany(this.coverageRecorder, unaries));
        }
        Logger.getInstance().verbose("Test ending (" + ActivePerTestRecorderMany.asString(type, slice, testRunId) + ") " + "but test recorder in focus doesn't match: " + this.those[0]);
        ActivePerTestRecorderOne finished = null;
        ArrayList<ActivePerTestRecorderOne> singles = new ArrayList<ActivePerTestRecorderOne>(Arrays.asList(this.those));
        Iterator iterator = singles.iterator();
        while (iterator.hasNext()) {
            ActivePerTestRecorderOne one = (ActivePerTestRecorderOne)iterator.next();
            boolean matches = one.matchesTest(type, slice, testRunId);
            Logger.getInstance().verbose("Active recorder: " + one);
            if (!matches) continue;
            iterator.remove();
            finished = one;
        }
        if (finished == null) {
            Logger.getInstance().verbose("Test ending (" + ActivePerTestRecorderMany.asString(type, slice, testRunId) + ") " + "but no active per-test recorders match: " + this.toString());
            return new RecordingResult(LivePerTestRecording.NULL, this);
        }
        ActivePerTestRecorderOne[] singlesArray = singles.toArray(new ActivePerTestRecorderOne[singles.size()]);
        if (singles.size() == 1) {
            return new RecordingResult(new FileBasedPerTestRecording(this.coverageRecorder, finished.coverage, method, finished.start, end, runtimeType, slice, testRunId, exitStatus, errorInfo), singlesArray[0]);
        }
        return new RecordingResult(new FileBasedPerTestRecording(this.coverageRecorder, finished.coverage, method, finished.start, end, runtimeType, slice, testRunId, exitStatus, errorInfo), new ActivePerTestRecorderMany(this.coverageRecorder, singlesArray));
    }

    public String toString() {
        return "Many(" + this.those.length + "):PerTestRecorders[" + "those=" + Arrays.asList(this.those) + ']';
    }
}

