/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.api.optimization;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.optimization.Optimizable;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.atlassian.clover.api.optimization.StringOptimizable;
import com.cenqua.clover.Logger;
import com.cenqua.clover.test.optimization.ClassOptimizable;
import com.cenqua.clover.test.optimization.LocalSnapshotOptimizer;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOptimizer {
    private final OptimizationOptions options;

    public TestOptimizer(OptimizationOptions options) {
        this.options = options;
    }

    public TestOptimizer(String initString, File snapshotFile) {
        this.options = new OptimizationOptions.Builder().debug(true).initString(initString).snapshot(snapshotFile).build();
    }

    public Collection<Class> optimizeTestClasses(Collection<Class> testClasses) {
        List<Optimizable> optimizableClasses = this.convertClassesToOptimizables(testClasses);
        List<Optimizable> optimizedClasses = this.optimize(optimizableClasses);
        return this.convertClassList(optimizedClasses);
    }

    public <T extends Optimizable> List<T> optimize(List<T> optimizables) {
        try {
            return LocalSnapshotOptimizer.optimize(optimizables, this.options);
        }
        catch (CloverException e) {
            Logger.getInstance().error("Optimization failed. Running all specified tests.");
            Logger.getInstance().debug(e.getMessage(), e);
            return optimizables;
        }
    }

    public List<Optimizable> optimizeObjects(List objectList) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<StringOptimizable> list = new ArrayList<StringOptimizable>(objectList.size());
        for (Object obj : objectList) {
            String name = (String)obj.getClass().getMethod("getName", new Class[0]).invoke(obj, new Object[0]);
            list.add(new StringOptimizable(name));
        }
        return this.optimize(list);
    }

    private Collection<Class> convertClassList(List<? extends Optimizable> optimizables) {
        ArrayList<Class> optimizedClasses = new ArrayList<Class>(optimizables.size());
        for (Optimizable optimizable : optimizables) {
            ClassOptimizable optClass = (ClassOptimizable)optimizable;
            optimizedClasses.add(optClass.getMyClass());
        }
        return optimizedClasses;
    }

    private List<Optimizable> convertClassesToOptimizables(Collection<Class> testClasses) {
        ArrayList<Optimizable> optimizables = new ArrayList<Optimizable>(testClasses.size());
        for (Class aClass : testClasses) {
            optimizables.add(new ClassOptimizable(aClass));
        }
        return optimizables;
    }
}

