/*
 * Decompiled with CFR 0.152.
 */
package clover.org.apache.velocity.util.introspection;

import clover.org.apache.velocity.runtime.RuntimeLogger;
import clover.org.apache.velocity.runtime.log.Log;
import clover.org.apache.velocity.runtime.log.RuntimeLoggerLog;
import clover.org.apache.velocity.util.introspection.IntrospectorBase;
import clover.org.apache.velocity.util.introspection.MethodMap;
import java.lang.reflect.Method;

public class Introspector
extends IntrospectorBase {
    public static final String CACHEDUMP_MSG = "Introspector: detected classloader change. Dumping cache.";

    public Introspector(Log log) {
        super(log);
    }

    public Introspector(RuntimeLogger logger) {
        this(new RuntimeLoggerLog(logger));
    }

    public Method getMethod(Class c, String name, Object[] params) throws IllegalArgumentException {
        try {
            return super.getMethod(c, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            StringBuffer msg = new StringBuffer("Introspection Error : Ambiguous method invocation ").append(name).append("(");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                if (params[i] == null) {
                    msg.append("null");
                    continue;
                }
                msg.append(params[i].getClass().getName());
            }
            msg.append(") for class ").append(c);
            this.log.error(msg.toString());
            return null;
        }
    }

    public void triggerClear() {
        super.triggerClear();
        this.log.info(CACHEDUMP_MSG);
    }
}

