/*
 * Decompiled with CFR 0.152.
 */
package clover.org.apache.velocity.runtime.log;

import clover.org.apache.velocity.runtime.RuntimeServices;
import clover.org.apache.velocity.runtime.log.LogChute;

public class SystemLogChute
implements LogChute {
    public static final String RUNTIME_LOG_LEVEL_KEY = "runtime.log.logsystem.system.level";
    public static final String RUNTIME_LOG_SYSTEM_ERR_LEVEL_KEY = "runtime.log.logsystem.system.err.level";
    private int enabled = -1;
    private int errLevel = -1;

    public void init(RuntimeServices rs) throws Exception {
        String errLevel;
        String level = (String)rs.getProperty(RUNTIME_LOG_LEVEL_KEY);
        if (level != null) {
            this.setEnabledLevel(this.toLevel(level));
        }
        if ((errLevel = (String)rs.getProperty(RUNTIME_LOG_SYSTEM_ERR_LEVEL_KEY)) != null) {
            this.setSystemErrLevel(this.toLevel(errLevel));
        }
    }

    protected int toLevel(String level) {
        if (level.equalsIgnoreCase("debug")) {
            return 0;
        }
        if (level.equalsIgnoreCase("info")) {
            return 1;
        }
        if (level.equalsIgnoreCase("warn")) {
            return 2;
        }
        if (level.equalsIgnoreCase("error")) {
            return 3;
        }
        return -1;
    }

    protected String getPrefix(int level) {
        switch (level) {
            case 2: {
                return "  [warn] ";
            }
            case 1: {
                return "  [info] ";
            }
            case 0: {
                return " [debug] ";
            }
            case -1: {
                return " [trace] ";
            }
            case 3: {
                return " [error] ";
            }
        }
        return "  [info] ";
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable t) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        String prefix = this.getPrefix(level);
        if (level >= this.errLevel) {
            System.err.print(prefix);
            System.err.println(message);
            if (t != null) {
                System.err.println(t.getMessage());
                t.printStackTrace();
            }
        } else {
            System.out.print(prefix);
            System.out.println(message);
            if (t != null) {
                System.out.println(t.getMessage());
                t.printStackTrace(System.out);
            }
        }
    }

    public void setEnabledLevel(int level) {
        this.enabled = level;
    }

    public int getEnabledLevel() {
        return this.enabled;
    }

    public void setSystemErrLevel(int level) {
        this.errLevel = level;
    }

    public int getSystemErrLevel() {
        return this.errLevel;
    }

    public boolean isLevelEnabled(int level) {
        return level >= this.enabled;
    }
}

