/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.bytes;

import clover.it.unimi.dsi.fastutil.bytes.AbstractByteComparator;
import clover.it.unimi.dsi.fastutil.bytes.ByteComparator;

public class ByteComparators {
    public static final ByteComparator NATURAL_COMPARATOR = new AbstractByteComparator(){

        public final int compare(byte a, byte b) {
            return a < b ? -1 : (a == b ? 0 : 1);
        }
    };
    public static final ByteComparator OPPOSITE_COMPARATOR = new AbstractByteComparator(){

        public final int compare(byte a, byte b) {
            return b < a ? -1 : (b == a ? 0 : 1);
        }
    };

    private ByteComparators() {
    }

    public static ByteComparator oppositeComparator(final ByteComparator c) {
        return new AbstractByteComparator(){
            private final ByteComparator comparator;
            {
                this.comparator = c;
            }

            public final int compare(byte a, byte b) {
                return -this.comparator.compare(a, b);
            }
        };
    }
}

