/*
 * Decompiled with CFR 0.152.
 */
package clover.gnu.cajo.utils.extra;

import clover.gnu.cajo.invoke.Remote;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class Scheduler
implements Serializable {
    private static final String INDEX_INVALID = "task table index invalid";
    private transient Thread thread;
    private int syncFlags;
    private int soonFlags;
    private int wakeFlags;
    private Object[] list = new Object[32];
    private final Runnable kernel = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n = 0;
                while (!Scheduler.this.thread.isInterrupted()) {
                    int n2 = 0;
                    Scheduler scheduler = Scheduler.this;
                    synchronized (scheduler) {
                        int n3;
                        if (Scheduler.this.syncFlags != 0) {
                            n3 = 1;
                            while ((Scheduler.this.syncFlags & n3) == 0) {
                                ++n2;
                                n3 <<= 1;
                            }
                            Scheduler.this.syncFlags ^= n3;
                        } else if (Scheduler.this.soonFlags != 0) {
                            n3 = 1;
                            while ((Scheduler.this.soonFlags & n3) == 0) {
                                ++n2;
                                n3 <<= 1;
                            }
                            Scheduler.this.soonFlags ^= n3;
                        } else if (Scheduler.this.wakeFlags != 0) {
                            for (n3 = 0; n3 < 32; ++n3) {
                                if (++n == 32) {
                                    n = 0;
                                }
                                if ((1 << n & Scheduler.this.wakeFlags) == 0) continue;
                                n2 = n;
                                break;
                            }
                        } else {
                            Scheduler.this.wait();
                            continue;
                        }
                    }
                    try {
                        Remote.invoke(Scheduler.this.list[n2], "slice", null);
                    }
                    catch (Exception exception) {
                        Scheduler.this.drop(n2);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setEnabled(true);
    }

    public synchronized boolean setEnabled(boolean bl) {
        if (bl) {
            if (this.syncFlags != 0 | this.soonFlags != 0 | this.wakeFlags != 0) {
                if (this.thread == null) {
                    this.thread = new Thread(this.kernel);
                    this.thread.start();
                    return true;
                }
                this.notify();
            }
        } else if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
            return true;
        }
        return false;
    }

    public synchronized int load(Object object) {
        for (int i = 0; i < 32; ++i) {
            if (this.list[i] != null) continue;
            this.list[i] = object;
            return i;
        }
        throw new IllegalArgumentException("task table currently full");
    }

    public synchronized boolean sync(int n) {
        if (n >= 0 && n < 32) {
            int n2 = 1 << n;
            if ((this.syncFlags & n2) == 0) {
                this.syncFlags |= n2;
                this.setEnabled(true);
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException(INDEX_INVALID);
    }

    public synchronized boolean soon(int n) {
        if (n >= 0 && n < 32) {
            int n2 = 1 << n;
            if ((this.soonFlags & n2) == 0) {
                this.soonFlags |= n2;
                this.setEnabled(true);
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException(INDEX_INVALID);
    }

    public synchronized boolean wake(int n) {
        if (n >= 0 && n < 32) {
            int n2 = 1 << n;
            if ((this.wakeFlags & n2) == 0) {
                this.wakeFlags |= n2;
                this.setEnabled(true);
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException(INDEX_INVALID);
    }

    public synchronized void stop(int n) {
        if (n >= 0 && n < 32) {
            int n2 = ~(1 << n);
            this.syncFlags &= n2;
            this.soonFlags &= n2;
            this.wakeFlags &= n2;
        } else {
            throw new IllegalArgumentException(INDEX_INVALID);
        }
    }

    public synchronized void drop(int n) {
        if (n < 0 || n >= 32) {
            throw new IllegalArgumentException(INDEX_INVALID);
        }
        this.stop(n);
        this.list[n] = null;
    }

    public boolean pending() {
        return this.syncFlags != 0 | this.soonFlags != 0;
    }
}

