/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.rtf;

import clover.com.lowagie.text.DocumentException;
import clover.com.lowagie.text.Row;
import clover.com.lowagie.text.Table;
import clover.com.lowagie.text.rtf.RtfCell;
import clover.com.lowagie.text.rtf.RtfRow;
import clover.com.lowagie.text.rtf.RtfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfTable {
    private ArrayList rowsList = new ArrayList();
    private RtfWriter writer = null;
    private Table origTable = null;

    public RtfTable(RtfWriter writer) {
        this.writer = writer;
    }

    public boolean importTable(Table table, int pageWidth) {
        RtfRow rtfRow;
        this.origTable = table;
        Iterator rows = table.iterator();
        Row row = null;
        int tableWidth = (int)table.widthPercentage();
        int cellpadding = (int)((double)table.cellpadding() * 20.0);
        int cellspacing = (int)((double)table.cellspacing() * 20.0);
        float[] propWidths = table.getProportionalWidths();
        int borders = table.border();
        Color borderColor = table.borderColor();
        float borderWidth = table.borderWidth();
        int i = 0;
        while (i < table.size()) {
            rtfRow = new RtfRow(this.writer, this);
            rtfRow.pregenerateRows(table.columns());
            this.rowsList.add(rtfRow);
            ++i;
        }
        i = 0;
        while (rows.hasNext()) {
            row = (Row)rows.next();
            row.setHorizontalAlignment(table.alignment());
            rtfRow = (RtfRow)this.rowsList.get(i);
            rtfRow.importRow(row, propWidths, tableWidth, pageWidth, cellpadding, cellspacing, borders, borderColor, borderWidth, i);
            ++i;
        }
        return true;
    }

    public boolean writeTable(ByteArrayOutputStream os) throws DocumentException, IOException {
        if (!this.writer.writingHeaderFooter()) {
            os.write(92);
            os.write(RtfWriter.paragraph);
        }
        int size = this.rowsList.size();
        int i = 0;
        while (i < size) {
            RtfRow row = (RtfRow)this.rowsList.get(i);
            row.writeRow(os, i, this.origTable);
            os.write(10);
            ++i;
        }
        if (!this.writer.writingHeaderFooter()) {
            os.write(92);
            os.write(RtfWriter.paragraphDefaults);
            os.write(92);
            os.write(RtfWriter.paragraph);
            switch (this.origTable.alignment()) {
                case 0: {
                    os.write(92);
                    os.write(RtfWriter.alignLeft);
                    break;
                }
                case 2: {
                    os.write(92);
                    os.write(RtfWriter.alignRight);
                    break;
                }
                case 1: {
                    os.write(92);
                    os.write(RtfWriter.alignCenter);
                    break;
                }
                case 3: 
                case 8: {
                    os.write(92);
                    os.write(RtfWriter.alignJustify);
                }
            }
        }
        return true;
    }

    public void setMerge(int x, int y, int mergeType, RtfCell mergeCell) {
        RtfRow row = (RtfRow)this.rowsList.get(y);
        row.setMerge(x, mergeType, mergeCell);
    }

    protected Table getOriginalTable() {
        return this.origTable;
    }
}

