/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.AnonymousAndLocalClassExclusionStrategy;
import clover.com.google.gson.DefaultTypeAdapters;
import clover.com.google.gson.DisjunctionExclusionStrategy;
import clover.com.google.gson.ExclusionStrategy;
import clover.com.google.gson.FieldNamingStrategy;
import clover.com.google.gson.JavaFieldNamingPolicy;
import clover.com.google.gson.JsonCompactFormatter;
import clover.com.google.gson.JsonDeserializationContextDefault;
import clover.com.google.gson.JsonDeserializer;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonFormatter;
import clover.com.google.gson.JsonParseException;
import clover.com.google.gson.JsonParser;
import clover.com.google.gson.JsonSerializationContextDefault;
import clover.com.google.gson.JsonSerializer;
import clover.com.google.gson.MappedObjectConstructor;
import clover.com.google.gson.ModifierBasedExclusionStrategy;
import clover.com.google.gson.ObjectNavigatorFactory;
import clover.com.google.gson.ParameterizedTypeHandlerMap;
import clover.com.google.gson.SerializedNameAnnotationInterceptingNamingPolicy;
import clover.com.google.gson.VersionExclusionStrategy;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Appendable;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Class;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Gson {
    private static final String NULL_STRING = "null";
    static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    static final ModifierBasedExclusionStrategy DEFAULT_MODIFIER_BASED_EXCLUSION_STRATEGY = new ModifierBasedExclusionStrategy(true, new int[]{128, 8});
    static final JsonFormatter DEFAULT_JSON_FORMATTER = new JsonCompactFormatter();
    static final FieldNamingStrategy DEFAULT_NAMING_POLICY = new SerializedNameAnnotationInterceptingNamingPolicy(new JavaFieldNamingPolicy());
    private static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    private final ExclusionStrategy strategy;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final MappedObjectConstructor objectConstructor;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    private final JsonFormatter formatter;
    private final boolean serializeNulls;
    private final boolean generateNonExecutableJson;

    public Gson() {
        this(Gson.createExclusionStrategy(-1.0), DEFAULT_NAMING_POLICY);
    }

    Gson(ExclusionStrategy strategy, FieldNamingStrategy fieldNamingPolicy) {
        this(strategy, fieldNamingPolicy, new MappedObjectConstructor(DefaultTypeAdapters.getDefaultInstanceCreators()), DEFAULT_JSON_FORMATTER, false, DefaultTypeAdapters.getDefaultSerializers(), DefaultTypeAdapters.getDefaultDeserializers(), false);
    }

    Gson(ExclusionStrategy strategy, FieldNamingStrategy fieldNamingPolicy, MappedObjectConstructor objectConstructor, JsonFormatter formatter, boolean serializeNulls, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, boolean generateNonExecutableGson) {
        this.strategy = strategy;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.objectConstructor = objectConstructor;
        this.formatter = formatter;
        this.serializeNulls = serializeNulls;
        this.serializers = serializers;
        this.deserializers = deserializers;
        this.generateNonExecutableJson = generateNonExecutableGson;
    }

    private ObjectNavigatorFactory createDefaultObjectNavigatorFactory() {
        return new ObjectNavigatorFactory(this.strategy, this.fieldNamingPolicy);
    }

    private static ExclusionStrategy createExclusionStrategy(double version) {
        LinkedList<ExclusionStrategy> strategies = new LinkedList<ExclusionStrategy>();
        strategies.add(new AnonymousAndLocalClassExclusionStrategy());
        strategies.add(DEFAULT_MODIFIER_BASED_EXCLUSION_STRATEGY);
        if (version != -1.0) {
            strategies.add(new VersionExclusionStrategy(version));
        }
        return new DisjunctionExclusionStrategy(strategies);
    }

    public String toJson(Object src) {
        if (src == null) {
            return this.serializeNulls ? NULL_STRING : "";
        }
        return this.toJson(src, src.getClass());
    }

    public String toJson(Object src, Object typeOfSrc) {
        StringWriter writer = new StringWriter();
        this.toJson(src, typeOfSrc, writer);
        return writer.toString();
    }

    public void toJson(Object src, Object writer) {
        try {
            if (src != null) {
                this.toJson(src, src.getClass(), writer);
            } else if (this.serializeNulls) {
                this.writeOutNullString(writer);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void toJson(Object src, Object typeOfSrc, Object writer) {
        try {
            if (src != null) {
                JsonSerializationContextDefault context = new JsonSerializationContextDefault(this.createDefaultObjectNavigatorFactory(), this.serializeNulls, this.serializers);
                JsonElement jsonElement = context.serialize(src, typeOfSrc);
                if (this.generateNonExecutableJson) {
                    _Appendable.append(writer, JSON_NON_EXECUTABLE_PREFIX);
                }
                this.formatter.format(jsonElement, writer, this.serializeNulls);
            } else if (this.serializeNulls) {
                this.writeOutNullString(writer);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public <T> T fromJson(String json, Class<T> classOfT) throws JsonParseException {
        T target = this.fromJson(json, (Object)classOfT);
        return target;
    }

    public <T> T fromJson(String json, Object typeOfT) throws JsonParseException {
        StringReader reader = new StringReader(json);
        T target = this.fromJson((Reader)reader, typeOfT);
        return target;
    }

    public <T> T fromJson(Reader json, Class<T> classOfT) throws JsonParseException {
        Object target = _Class.cast(classOfT, this.fromJson(json, (Object)classOfT));
        return (T)target;
    }

    public <T> T fromJson(Reader json, Object typeOfT) throws JsonParseException {
        JsonElement root = new JsonParser().parse(json);
        JsonDeserializationContextDefault context = new JsonDeserializationContextDefault(this.createDefaultObjectNavigatorFactory(), this.deserializers, this.objectConstructor);
        Object target = context.deserialize(root, typeOfT);
        return target;
    }

    public <T> T fromJson(JsonElement json, Class<T> classOfT) throws JsonParseException {
        Object target = _Class.cast(classOfT, this.fromJson(json, (Object)classOfT));
        return (T)target;
    }

    public <T> T fromJson(JsonElement json, Object typeOfT) throws JsonParseException {
        JsonDeserializationContextDefault context = new JsonDeserializationContextDefault(this.createDefaultObjectNavigatorFactory(), this.deserializers, this.objectConstructor);
        Object target = context.deserialize(json, typeOfT);
        return target;
    }

    private void writeOutNullString(Object writer) throws IOException {
        _Appendable.append(writer, NULL_STRING);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{").append("serializeNulls:").append(this.serializeNulls).append(",serializers:").append(this.serializers).append(",deserializers:").append(this.deserializers).append(",instanceCreators:").append(this.objectConstructor).append("}");
        return sb.toString();
    }
}

