/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.contrib.demo;

import com.sun.jna.platform.WindowUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class BalloonTipManager {
    public static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(255, 255, 225);
    public static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    private static final Integer VPOS_ABOVE = 0;
    private static final Integer VPOS_BELOW = 1;
    private static final Integer HPOS_LEFT = 0;
    private static final Integer HPOS_RIGHT = 1;
    private static Integer vpos = null;
    private static Integer hpos = null;
    private static Timer hidePopupTimer = null;
    private static boolean isShowing = false;

    public static Popup getBalloonTip(Component owner, String content, int x, int y, int duration) {
        return BalloonTipManager.getBalloonTip(owner, content, x, y, duration, DEFAULT_BORDER_COLOR, DEFAULT_BACKGROUND_COLOR, DEFAULT_TEXT_COLOR);
    }

    public static boolean isShowing() {
        return isShowing;
    }

    public static void restartTimer() {
        hidePopupTimer.restart();
    }

    public static Popup getBalloonTip(final Component owner, String content, int x, int y, Integer duration, final Color bordercolor, final Color backgroundcolor, final Color textcolor) {
        final Point origin = owner == null ? new Point(0, 0) : owner.getLocationOnScreen();
        final Window parent = owner != null ? SwingUtilities.getWindowAncestor(owner) : null;
        final String text = content != null ? content : "";
        final Integer timerDuration = duration != null ? duration : 10000;
        origin.translate(x, y);
        vpos = VPOS_BELOW;
        hpos = HPOS_LEFT;
        return new Popup(){
            private BalloonTip bt = null;
            final ComponentEar componentEar = new ComponentEar();
            final MouseEar mouseEar = new MouseEar();
            final FocusEar focusEar = new FocusEar();

            public void show() {
                hidePopupTimer = new Timer(timerDuration, new TimerAction());
                this.bt = new BalloonTip(parent, text, origin, bordercolor, backgroundcolor, textcolor);
                this.bt.pack();
                Point pt = new Point(origin);
                pt.translate(10, owner.getHeight());
                this.bt.setLocation(this.getAdjustedOrigin(pt));
                this.bt.setWindowMask();
                this.bt.setVisible(true);
                owner.addFocusListener(this.focusEar);
                owner.addMouseListener(this.mouseEar);
                parent.addMouseListener(this.mouseEar);
                parent.addComponentListener(this.componentEar);
                hidePopupTimer.start();
                isShowing = true;
            }

            public void hide() {
                if (this.bt != null) {
                    isShowing = false;
                    hidePopupTimer.stop();
                    parent.removeComponentListener(this.componentEar);
                    parent.removeMouseListener(this.mouseEar);
                    owner.removeMouseListener(this.mouseEar);
                    owner.removeFocusListener(this.focusEar);
                    this.bt.setVisible(false);
                    this.bt.dispose();
                }
            }

            private Point getAdjustedOrigin(Point pt) {
                Point ret = new Point(pt.x, pt.y);
                GraphicsConfiguration gc = owner.getGraphicsConfiguration();
                Rectangle sBounds = gc.getBounds();
                Insets sInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                sBounds.x += sInsets.left;
                sBounds.y += sInsets.top;
                sBounds.width -= sInsets.left + sInsets.right;
                sBounds.height -= sInsets.top + sInsets.bottom;
                if (ret.x < sBounds.x) {
                    ret.x = sBounds.x;
                } else if (ret.x - sBounds.x + this.bt.getWidth() > sBounds.width) {
                    ret.x = owner.getLocationOnScreen().x - this.bt.getWidth() + 43;
                }
                if (ret.x >= pt.x) {
                    hpos = HPOS_LEFT;
                } else {
                    hpos = HPOS_RIGHT;
                }
                if (ret.y < sBounds.y) {
                    ret.y = sBounds.y;
                } else if (ret.y - sBounds.y + this.bt.getHeight() > sBounds.height) {
                    ret.y = owner.getLocationOnScreen().y - this.bt.getHeight();
                }
                if (ret.y >= pt.y) {
                    vpos = VPOS_BELOW;
                } else {
                    vpos = VPOS_ABOVE;
                }
                return ret;
            }

            final class FocusEar
            extends FocusAdapter {
                FocusEar() {
                }

                public void focusLost(FocusEvent e) {
                    this.hide();
                }
            }

            final class MouseEar
            extends MouseAdapter {
                MouseEar() {
                }

                public void mousePressed(MouseEvent e) {
                    this.hide();
                }
            }

            final class ComponentEar
            extends ComponentAdapter {
                ComponentEar() {
                }

                public void componentMoved(ComponentEvent e) {
                    this.hide();
                }
            }

            final class TimerAction
            extends AbstractAction {
                TimerAction() {
                }

                public void actionPerformed(ActionEvent e) {
                    this.hide();
                }
            }
        };
    }

    private static final class BalloonTip
    extends JWindow {
        private static final long serialVersionUID = 1L;
        private static final Integer HMARGIN = 10;
        private static final Integer VMARGIN = 6;
        private static final Integer VSPACER = 4;
        private static final int ARC_D = 16;
        private Area mask = null;
        private Dimension maskSize = null;
        private String[] textList = null;
        private Color backgroundColor = null;
        private Color borderColor = null;
        private Color textColor = null;

        public BalloonTip(Window owner, String content, Point origin, Color bordercolor, Color backgroundcolor, Color textcolor) {
            super(owner);
            this.textList = content.split("\n");
            this.borderColor = bordercolor;
            this.backgroundColor = backgroundcolor;
            this.textColor = textcolor;
            this.setFocusableWindowState(false);
            this.setName("###overrideRedirect###");
            this.setSize(this.getPreferredSize());
        }

        private void setWindowMask() {
            this.mask = new Area(this.getMask());
            this.maskSize = this.getSize();
            WindowUtils.setWindowMask((Window)this, this.mask);
        }

        public void paint(Graphics g) {
            int[] yPts;
            int[] xPts;
            super.paint(g);
            Dimension d = this.getMinimumWindowSize();
            int width = d.width + 2 * HMARGIN;
            int height = d.height + 2 * VMARGIN;
            int x = 0;
            int y = 0;
            if (vpos == VPOS_BELOW) {
                y += 15;
            }
            g.setColor(this.backgroundColor);
            g.fillRoundRect(x, y, width, height, 16, 16);
            g.drawLine(x + 6, y + height - 1, x + 6, y + height - 1);
            g.drawLine(x + width - 1, y + 6, x + width - 1, y + 6);
            g.drawLine(x + width - 1, y + height - 6, x + width - 1, y + height - 7);
            g.drawLine(x + width - 2, y + height - 4, x + width - 4, y + height - 2);
            g.drawLine(x + width - 6, y + height - 1, x + width - 7, y + height - 1);
            g.clearRect(x + 2, y + 2, 1, 1);
            g.setColor(this.borderColor);
            g.drawRoundRect(x, y, width, height, 16, 16);
            if (vpos == VPOS_BELOW) {
                if (hpos == HPOS_LEFT) {
                    g.setColor(this.backgroundColor);
                    xPts = new int[]{16, 16, 31};
                    yPts = new int[]{0, 16, 16};
                    g.fillPolygon(xPts, yPts, 3);
                    g.setColor(this.borderColor);
                    g.drawLine(16, 0, 16, 15);
                    g.drawLine(16, 0, 31, 15);
                    g.drawLine(16, 1, 30, 15);
                } else {
                    g.setColor(this.backgroundColor);
                    xPts = new int[]{width - 16, width - 16, width - 31};
                    yPts = new int[]{0, 16, 16};
                    g.fillPolygon(xPts, yPts, 3);
                    g.setColor(this.borderColor);
                    g.drawLine(width - 16, 0, width - 16, 15);
                    g.drawLine(width - 16, 0, width - 31, 15);
                    g.drawLine(width - 16, 1, width - 30, 15);
                }
            } else if (hpos == HPOS_LEFT) {
                g.setColor(this.backgroundColor);
                xPts = new int[]{16, 16, 31};
                yPts = new int[]{height, height + 16, height};
                g.fillPolygon(xPts, yPts, 3);
                g.setColor(this.borderColor);
                g.drawLine(16, height, 16, height + 15);
                g.drawLine(16, height + 15, 31, height);
                g.drawLine(16, height + 14, 30, height);
            } else {
                g.setColor(this.backgroundColor);
                xPts = new int[]{width - 16, width - 16, width - 31};
                yPts = new int[]{height, height + 16, height};
                g.fillPolygon(xPts, yPts, 3);
                g.setColor(this.borderColor);
                g.drawLine(width - 16, height, width - 16, height + 15);
                g.drawLine(width - 16, height + 15, width - 31, height);
                g.drawLine(width - 16, height + 14, width - 30, height);
            }
            g.setColor(this.textColor);
            g.setFont(new Font("Tahoma", 0, 11));
            int stringY = y + VMARGIN / 2;
            for (int i = 0; i < this.textList.length; ++i) {
                stringY += new JLabel((String)this.textList[i]).getPreferredSize().height;
                if (i > 0) {
                    stringY += VSPACER.intValue();
                }
                g.drawString(this.textList[i], (int)HMARGIN, stringY);
            }
        }

        private Shape getMask() {
            Dimension d = this.getMinimumWindowSize();
            int width = d.width + 2 * HMARGIN;
            int height = d.height + 2 * VMARGIN;
            boolean x = false;
            int y = 0;
            if (vpos == VPOS_BELOW) {
                y += 15;
            }
            Area area = new Area(new RoundRectangle2D.Float((float)x, y, width + 1, height + 1, 16.0f, 16.0f));
            area.add(new Area(new Rectangle(0, y + 6, 1, 2)));
            area.add(new Area(new Rectangle(0, y + height - 7, 1, 2)));
            area.add(new Area(new Rectangle(1, y + 4, 1, 1)));
            area.add(new Area(new Rectangle(1, y + height - 5, 1, 2)));
            area.add(new Area(new Rectangle(4, y + 1, 1, 1)));
            area.add(new Area(new Rectangle(6, y, 2, 1)));
            area.add(new Area(new Rectangle(width - 7, y, 2, 1)));
            area.subtract(new Area(new Rectangle(2, y + height - 2, 1, 1)));
            area.subtract(new Area(new Rectangle(3, y + height - 1, 1, 1)));
            area.subtract(new Area(new Rectangle(5, y + height, 1, 1)));
            area.subtract(new Area(new Rectangle(width - 5, y + height, 2, 1)));
            area.subtract(new Area(new Rectangle(width - 3, y + height - 1, 2, 1)));
            area.subtract(new Area(new Rectangle(width - 2, y + 2, 1, 1)));
            area.subtract(new Area(new Rectangle(width - 2, y + height - 2, 2, 1)));
            area.subtract(new Area(new Rectangle(width - 1, y + 3, 1, 1)));
            area.subtract(new Area(new Rectangle(width - 1, y + height - 3, 1, 1)));
            area.subtract(new Area(new Rectangle(width, y + 5, 1, 1)));
            area.subtract(new Area(new Rectangle(width, y + height - 5, 1, 2)));
            if (vpos == VPOS_BELOW) {
                if (hpos == HPOS_LEFT) {
                    int[] xPts = new int[]{16, 16, 32};
                    int[] yPts = new int[]{-1, 16, 16};
                    area.add(new Area(new Polygon(xPts, yPts, 3)));
                } else {
                    int[] xPts = new int[]{width - 15, width - 15, width - 32};
                    int[] yPts = new int[]{-1, 16, 16};
                    area.add(new Area(new Polygon(xPts, yPts, 3)));
                }
            } else if (hpos == HPOS_LEFT) {
                int[] xPts = new int[]{16, 16, 31};
                int[] yPts = new int[]{height, height + 16, height};
                area.add(new Area(new Polygon(xPts, yPts, 3)));
            } else {
                int[] xPts = new int[]{width - 15, width - 15, width - 32};
                int[] yPts = new int[]{height, height + 16, height};
                area.add(new Area(new Polygon(xPts, yPts, 3)));
            }
            return area;
        }

        private Dimension getMinimumWindowSize() {
            int maxWidth = 0;
            int textHeight = 0;
            JLabel tempLabel = null;
            for (int i = 0; i < this.textList.length; ++i) {
                tempLabel = new JLabel(this.textList[i]);
                maxWidth = Math.max(maxWidth, tempLabel.getPreferredSize().width);
                textHeight += tempLabel.getPreferredSize().height;
            }
            int w = Math.max(maxWidth, 32);
            int h = Math.max(textHeight + (this.textList.length - 1) * VSPACER, 8);
            return new Dimension(w, h);
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            Dimension size = new Dimension(w, h);
            if (this.mask != null && !size.equals(this.maskSize)) {
                this.mask.subtract(this.mask);
                this.mask.add(new Area(this.getMask()));
                this.maskSize = size;
            }
        }

        public Dimension getPreferredSize() {
            Dimension d = this.getMinimumWindowSize();
            int w = d.width + 2 * HMARGIN + 1;
            int h = d.height + 2 * VMARGIN + 16;
            return new Dimension(w, h);
        }
    }
}

