/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Functions;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class Collectors {
    public static <T> BinaryOperator<T> throwingMerger() {
        return (object, object2) -> {
            throw new IllegalStateException(String.format((String)"Duplicate key %s", (Object[])new Object[]{object}));
        };
    }

    static <T, R> Collector<T, R> leftCombining(Supplier<R> supplier, BiConsumer<R, T> biConsumer, BiConsumer<R, R> biConsumer2) {
        return new CollectorImpl(supplier, biConsumer, (object, object2) -> {
            biConsumer2.accept(object, object2);
            return object;
        });
    }

    public static <T, C extends Collection<T>> Collector<T, C> toCollection(Supplier<C> supplier) {
        return Collectors.leftCombining(supplier, Collection::add, Collection::addAll);
    }

    public static <T> Collector<T, List<T>> toList() {
        return Collectors.toCollection(ArrayList::new);
    }

    public static <T> Collector<T, Set<T>> toSet() {
        return Collectors.toCollection(HashSet::new);
    }

    public static Collector<String, StringBuilder> toStringBuilder() {
        return Collectors.leftCombining(StringBuilder::new, StringBuilder::append, (T stringBuilder, U stringBuilder2) -> stringBuilder.append((CharSequence)stringBuilder2));
    }

    public static Collector<CharSequence, StringJoiner> toStringJoiner(String string) {
        return Collectors.leftCombining(() -> new StringJoiner(string), StringJoiner::add, (T stringJoiner, U stringJoiner2) -> {
            if (stringJoiner2.length() > 0) {
                stringJoiner.add(stringJoiner2.toString());
            }
        });
    }

    static <K, V, M extends Map<K, V>> BinaryOperator<M> leftMapMerger(BinaryOperator<V> binaryOperator) {
        return (map, map2) -> {
            for (Map.Entry entry : map2.entrySet()) {
                map.merge(entry.getKey(), entry.getValue(), binaryOperator);
            }
            return map;
        };
    }

    public static <T, U, R> Collector<T, R> mapping(Function<? super T, ? extends U> function, Collector<U, R> collector) {
        BiConsumer biConsumer = collector.accumulator();
        return new CollectorImpl(collector.resultSupplier(), (object, object2) -> biConsumer.accept(object, function.apply((Object)object2)), collector.combiner(), collector.isConcurrent());
    }

    public static <T, R> Collector<T, R> mapping(ToIntFunction<? super T> toIntFunction, Collector.OfInt<R> ofInt) {
        ObjIntConsumer objIntConsumer = ofInt.intAccumulator();
        return new CollectorImpl(ofInt.resultSupplier(), (object, object2) -> objIntConsumer.accept(object, toIntFunction.applyAsInt((Object)object2)), ofInt.combiner(), ofInt.isConcurrent());
    }

    public static <T, R> Collector<T, R> mapping(ToDoubleFunction<? super T> toDoubleFunction, Collector.OfDouble<R> ofDouble) {
        ObjDoubleConsumer objDoubleConsumer = ofDouble.doubleAccumulator();
        return new CollectorImpl(ofDouble.resultSupplier(), (object, object2) -> objDoubleConsumer.accept(object, toDoubleFunction.applyAsDouble((Object)object2)), ofDouble.combiner(), ofDouble.isConcurrent());
    }

    public static <T, R> Collector<T, R> mapping(ToLongFunction<? super T> toLongFunction, Collector.OfLong<R> ofLong) {
        ObjLongConsumer objLongConsumer = ofLong.longAccumulator();
        return new CollectorImpl(ofLong.resultSupplier(), (object, object2) -> objLongConsumer.accept(object, toLongFunction.applyAsLong((Object)object2)), ofLong.combiner(), ofLong.isConcurrent());
    }

    public static <T, K> Collector<T, Map<K, Collection<T>>> groupingBy(Function<? super T, ? extends K> function) {
        return Collectors.groupingBy(function, HashMap::new, ArrayList::new);
    }

    public static <T, K, C extends Collection<T>, M extends Map<K, C>> Collector<T, M> groupingBy(Function<? super T, ? extends K> function, Supplier<M> supplier, Supplier<C> supplier2) {
        return Collectors.groupingBy(function, supplier, Collectors.toCollection(supplier2));
    }

    public static <T, K, D> Collector<T, Map<K, D>> groupingBy(Function<? super T, ? extends K> function, Collector<T, D> collector) {
        return Collectors.groupingBy(function, HashMap::new, collector);
    }

    public static <T, K, D, M extends Map<K, D>> Collector<T, M> groupingBy(Function<? super T, ? extends K> function, Supplier<M> supplier, Collector<T, D> collector) {
        Supplier supplier2 = collector.resultSupplier();
        BiConsumer biConsumer = collector.accumulator();
        BinaryOperator binaryOperator = collector.combiner();
        BiConsumer<Map, Object> biConsumer2 = (arg_0, arg_1) -> Collectors.lambda$184(function, biConsumer, (Supplier)supplier2, arg_0, arg_1);
        return new CollectorImpl(supplier, biConsumer2, Collectors.leftMapMerger(binaryOperator));
    }

    public static <T, K> Collector<T, Map<K, T>> groupingReduce(Function<? super T, ? extends K> function, BinaryOperator<T> binaryOperator) {
        return Collectors.groupingReduce(function, HashMap::new, (Function)Functions.identity(), binaryOperator);
    }

    public static <T, K, M extends Map<K, T>> Collector<T, M> groupingReduce(Function<? super T, ? extends K> function, Supplier<M> supplier, BinaryOperator<T> binaryOperator) {
        return Collectors.groupingReduce(function, supplier, (Function)Functions.identity(), binaryOperator);
    }

    public static <T, K, D> Collector<T, Map<K, D>> groupingReduce(Function<? super T, ? extends K> function, Function<? super T, ? extends D> function2, BinaryOperator<D> binaryOperator) {
        return Collectors.groupingReduce(function, HashMap::new, function2, binaryOperator);
    }

    public static <T, K, D, M extends Map<K, D>> Collector<T, M> groupingReduce(Function<? super T, ? extends K> function, Supplier<M> supplier, Function<? super T, ? extends D> function2, BinaryOperator<D> binaryOperator) {
        BiConsumer<Map, Object> biConsumer = (map, object) -> map.merge(Objects.requireNonNull(function.apply((Object)object), "element cannot be mapped to a null key"), function2.apply((Object)object), binaryOperator);
        return new CollectorImpl(supplier, biConsumer, Collectors.leftMapMerger(binaryOperator));
    }

    public static <T, U> Collector<T, Map<T, U>> joiningWith(Function<? super T, ? extends U> function) {
        return Collectors.joiningWith(function, (BinaryOperator)Collectors.throwingMerger());
    }

    public static <T, U> Collector<T, Map<T, U>> joiningWith(Function<? super T, ? extends U> function, BinaryOperator<U> binaryOperator) {
        return Collectors.joiningWith(function, binaryOperator, HashMap::new);
    }

    public static <T, U, M extends Map<T, U>> Collector<T, M> joiningWith(Function<? super T, ? extends U> function, Supplier<M> supplier) {
        return Collectors.joiningWith(function, (BinaryOperator)Collectors.throwingMerger(), supplier);
    }

    public static <T, U, M extends Map<T, U>> Collector<T, M> joiningWith(Function<? super T, ? extends U> function, BinaryOperator<U> binaryOperator, Supplier<M> supplier) {
        BiConsumer<Map, Object> biConsumer = (map, object) -> map.merge(object, function.apply((Object)object), binaryOperator);
        return new CollectorImpl(supplier, biConsumer, Collectors.leftMapMerger(binaryOperator));
    }

    public static <T> Collector<T, Map<Boolean, Collection<T>>> partitioningBy(Predicate<T> predicate) {
        return Collectors.partitioningBy(predicate, ArrayList::new);
    }

    public static <T, C extends Collection<T>> Collector<T, Map<Boolean, C>> partitioningBy(Predicate<T> predicate, Supplier<C> supplier) {
        return Collectors.partitioningBy(predicate, Collectors.toCollection(supplier));
    }

    static <D> BinaryOperator<Map<Boolean, D>> leftPartitionMerger(BinaryOperator<D> binaryOperator) {
        return (map, map2) -> {
            Partition partition = (Partition)map;
            Partition partition2 = (Partition)map2;
            partition.forFalse = binaryOperator.apply(partition.forFalse, partition2.forFalse);
            partition.forTrue = binaryOperator.apply(partition.forTrue, partition2.forTrue);
            return partition;
        };
    }

    public static <T, D> Collector<T, Map<Boolean, D>> partitioningBy(Predicate<T> predicate, Collector<T, D> collector) {
        BiConsumer biConsumer = collector.accumulator();
        BiConsumer<Map, Object> biConsumer2 = (map, object) -> {
            Partition partition = (Partition)map;
            biConsumer.accept(predicate.test(object) ? partition.forTrue : partition.forFalse, object);
        };
        return new CollectorImpl(() -> new Partition(collector.resultSupplier().get(), collector.resultSupplier().get()), biConsumer2, Collectors.leftPartitionMerger(collector.combiner()));
    }

    public static <T> Collector<T, Map<Boolean, T>> partitioningReduce(Predicate<T> predicate, T t, BinaryOperator<T> binaryOperator) {
        return Collectors.partitioningReduce(predicate, t, (Function)Functions.identity(), binaryOperator);
    }

    public static <T, U> Collector<T, Map<Boolean, U>> partitioningReduce(Predicate<T> predicate, U u, Function<T, U> function, BinaryOperator<U> binaryOperator) {
        BiConsumer<Map, Object> biConsumer = (map, object) -> {
            Partition partition = (Partition)map;
            if (predicate.test(object)) {
                partition.forTrue = binaryOperator.apply(partition.forTrue, function.apply(object));
            } else {
                partition.forFalse = binaryOperator.apply(partition.forFalse, function.apply(object));
            }
        };
        return new CollectorImpl(() -> new Partition<Object>(u, u), biConsumer, Collectors.leftPartitionMerger(binaryOperator));
    }

    public static Collector.OfLong<LongStatistics> toLongStatistics() {
        return new LongCollectorImpl(LongStatistics::new, LongStatistics::accept, (longStatistics, longStatistics2) -> {
            LongStatistics.access$100((LongStatistics)longStatistics, (LongStatistics)longStatistics2);
            return longStatistics;
        });
    }

    public static Collector.OfDouble<DoubleStatistics> toDoubleStatistics() {
        return new DoubleCollectorImpl(DoubleStatistics::new, DoubleStatistics::accept, (doubleStatistics, doubleStatistics2) -> {
            DoubleStatistics.access$000((DoubleStatistics)doubleStatistics, (DoubleStatistics)doubleStatistics2);
            return doubleStatistics;
        });
    }

    private static /* synthetic */ void lambda$184(Function function, BiConsumer biConsumer, Supplier supplier, Map map, Object object) {
        Object r = Objects.requireNonNull(function.apply(object), "element cannot be mapped to a null key");
        biConsumer.accept(map.computeIfAbsent(r, arg_0 -> Collectors.lambda$185((Supplier)supplier, arg_0)), object);
    }

    private static /* synthetic */ Object lambda$185(Supplier supplier, Object object) {
        return supplier.get();
    }

    private static final class Partition<T>
    extends AbstractMap<Boolean, T>
    implements Map<Boolean, T> {
        final T forTrue;
        final T forFalse;

        Partition(T forTrue, T forFalse) {
            this.forTrue = forTrue;
            this.forFalse = forFalse;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public T get(Object key) {
            if (key instanceof Boolean) {
                Boolean b = (Boolean)key;
                return b != false ? this.forTrue : this.forFalse;
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof Boolean;
        }

        @Override
        public boolean containsValue(Object value) {
            return Objects.equals(value, this.forTrue) || Objects.equals(value, this.forFalse);
        }

        @Override
        public Set<Map.Entry<Boolean, T>> entrySet() {
            return new AbstractSet<Map.Entry<Boolean, T>>(){

                @Override
                public Iterator<Map.Entry<Boolean, T>> iterator() {
                    AbstractMap.SimpleImmutableEntry falseEntry = new AbstractMap.SimpleImmutableEntry(false, forFalse);
                    AbstractMap.SimpleImmutableEntry trueEntry = new AbstractMap.SimpleImmutableEntry(true, forTrue);
                    return List.of(falseEntry, trueEntry).iterator();
                }

                @Override
                public int size() {
                    return 2;
                }
            };
        }
    }

    record CollectorImpl<T, A, R>(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) implements Collector<T, A, R>
    {
        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, Collectors.castingIdentity(), characteristics);
        }
    }
}

