/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private static final long serialVersionUID = 1421746759512286392L;
    private volatile transient Set<K> keySet = null;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;
    private volatile transient Collection<V> values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static Enumeration emptyEnumerator = new EmptyEnumerator();
    private static Iterator emptyIterator = new EmptyIterator();

    public Hashtable(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuffer().append("Illegal Capacity: ").append(n).toString());
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException(new StringBuffer().append("Illegal Load: ").append(f).toString());
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return this.getEnumeration(0);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return this.getEnumeration(1);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public synchronized V get(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    @Override
    public synchronized V put(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                Object v2 = entry.value;
                entry.value = v;
                return v2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entry = entryArray[n2];
        entryArray[n2] = new Entry<K, V>(n, k, v, entry);
        ++this.count;
        return null;
    }

    @Override
    public synchronized V remove(Object object) {
        Entry[] entryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(object)) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                Object v = entry.value;
                entry.value = null;
                return v;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put((K)entry.getKey(), (V)entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            hashtable.table = new Entry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                hashtable.table[n] = this.table[n] != null ? (Entry)this.table[n].clone() : null;
            }
            hashtable.keySet = null;
            hashtable.entrySet = null;
            hashtable.values = null;
            hashtable.modCount = 0;
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            Map.Entry<K, V> entry = iterator.next();
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            stringBuffer.append(new StringBuffer().append(object == this ? "(this Map)" : new StringBuffer().append("").append(object).toString()).append("=").append(object2 == this ? "(this Map)" : new StringBuffer().append("").append(object2).toString()).toString());
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private <T> Enumeration<T> getEnumeration(int n) {
        if (this.count == 0) {
            return emptyEnumerator;
        }
        return new Enumerator(n, false);
    }

    private <T> Iterator<T> getIterator(int n) {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new Enumerator(n, true);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.synchronizedSet(new KeySet(this, null), this);
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = Collections.synchronizedSet(new EntrySet(this, null), this);
        }
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = Collections.synchronizedCollection(new ValueCollection(this, null), this);
        }
        return this.values;
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                Object object2 = entry.getKey();
                Object object3 = entry.getValue();
                if (!(object3 == null ? map.get(object2) != null || !map.containsKey(object2) : !object3.equals(map.get(object2)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized int hashCode() {
        int n = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return n;
        }
        this.loadFactor = -this.loadFactor;
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                n += entry.key.hashCode() ^ entry.value.hashCode();
                entry = entry.next;
            }
        }
        this.loadFactor = -this.loadFactor;
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            Entry entry = this.table[i];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new Entry[n3];
        this.count = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.reconstitutionPut(object, object2);
            --n2;
        }
    }

    private void reconstitutionPut(K k, V v) throws StreamCorruptedException {
        if (v == null) {
            throw new StreamCorruptedException();
        }
        Entry[] entryArray = this.table;
        int n = k.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(k)) {
                throw new StreamCorruptedException();
            }
            entry = entry.next;
        }
        entry = entryArray[n2];
        entryArray[n2] = new Entry<K, V>(n, k, v, entry);
        ++this.count;
    }

    static /* synthetic */ Iterator access$100(Hashtable hashtable, int n) {
        return hashtable.getIterator(n);
    }

    static /* synthetic */ int access$200(Hashtable hashtable) {
        return hashtable.count;
    }

    static /* synthetic */ Entry[] access$400(Hashtable hashtable) {
        return hashtable.table;
    }

    static /* synthetic */ int access$508(Hashtable hashtable) {
        return hashtable.modCount++;
    }

    static /* synthetic */ int access$210(Hashtable hashtable) {
        return hashtable.count--;
    }

    static /* synthetic */ int access$500(Hashtable hashtable) {
        return hashtable.modCount;
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Entry<K, V> next;

        protected Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry<K, V>(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Hashtable.this.getIterator(2);
        }

        @Override
        public boolean add(Map.Entry<K, V> o) {
            return super.add(o);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry[] tab = Hashtable.this.table;
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    return true;
                }
                e = e.next;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry[] tab = Hashtable.this.table;
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    e.value = null;
                    ++Hashtable.this.modCount;
                    --Hashtable.this.count;
                    return true;
                }
                prev = e;
                e = e.next;
            }
            return false;
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class Enumerator<T>
    implements Enumeration<T>,
    Iterator<T> {
        final Entry<?, ?>[] table;
        int index;
        Entry<?, ?> entry;
        Entry<?, ?> lastReturned;
        final int type;
        final boolean iterator;
        protected int expectedModCount;

        Enumerator(int type, boolean iterator) {
            this.table = Hashtable.this.table;
            this.index = this.table.length;
            this.expectedModCount = Hashtable.this.modCount;
            this.type = type;
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            Entry<?, ?> e = this.entry;
            int i = this.index;
            Entry<?, ?>[] t = this.table;
            while (e == null && i > 0) {
                e = t[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        @Override
        public T nextElement() {
            Entry<?, ?> et = this.entry;
            int i = this.index;
            Entry<?, ?>[] t = this.table;
            while (et == null && i > 0) {
                et = t[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                this.lastReturned = this.entry;
                Entry<?, ?> e = this.lastReturned;
                this.entry = e.next;
                return (T)(this.type == 0 ? e.key : (this.type == 1 ? e.value : e));
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public T next() {
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                Entry[] tab = Hashtable.this.table;
                int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
                Entry e = tab[index];
                Entry prev = null;
                while (e != null) {
                    if (e == this.lastReturned) {
                        if (prev == null) {
                            tab[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        ++this.expectedModCount;
                        this.lastReturned = null;
                        ++Hashtable.this.modCount;
                        --Hashtable.this.count;
                        return;
                    }
                    prev = e;
                    e = e.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return Hashtable.this.getIterator(0);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return Hashtable.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return Hashtable.this.remove(o) != null;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return Hashtable.this.getIterator(1);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return Hashtable.this.containsValue(o);
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }
}

