/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.security;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;

public class ClientCertAuthenticator
implements Authenticator {
    private int _maxHandShakeSeconds = 60;

    public ClientCertAuthenticator() {
        Log.warn("Client Cert Authentication is EXPERIMENTAL");
    }

    public int getMaxHandShakeSeconds() {
        return this._maxHandShakeSeconds;
    }

    public void setMaxHandShakeSeconds(int maxHandShakeSeconds) {
        this._maxHandShakeSeconds = maxHandShakeSeconds;
    }

    public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) throws IOException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (response != null && (certs == null || certs.length == 0 || certs[0] == null)) {
            HttpConnection connection = HttpConnection.getCurrentConnection();
            if (!connection.getConnector().isConfidential(request)) {
                return null;
            }
            Object s = connection.getEndPoint().getConnection();
            if (!(s instanceof SSLSocket)) {
                return null;
            }
            SSLSocket socket = (SSLSocket)s;
            if (!socket.getNeedClientAuth()) {
                socket.setNeedClientAuth(true);
                socket.startHandshake();
                int i = this._maxHandShakeSeconds * 4;
                while (i-- > 0 && ((certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate")) == null || certs.length <= 0 || certs[0] == null)) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        if (certs == null || certs.length == 0 || certs[0] == null) {
            return null;
        }
        Principal principal = certs[0].getSubjectDN();
        if (principal == null) {
            principal = certs[0].getIssuerDN();
        }
        String username = principal == null ? "clientcert" : principal.getName();
        Principal user = realm.authenticate(username, certs, request);
        request.setAuthType("CLIENT_CERT");
        request.setUserPrincipal(user);
        return user;
    }

    public String getAuthMethod() {
        return "CLIENT_CERT";
    }
}

