/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.WrappedHandler;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.resource.Resource;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.URIUtil;

public class ContextHandler
extends WrappedHandler
implements Attributes {
    private static ThreadLocal __context = new ThreadLocal();
    private Attributes _attributes;
    private Attributes _contextAttributes;
    private ClassLoader _classLoader;
    private Context _context = new Context();
    private String _contextPath;
    private HashMap _initParams;
    private String _displayName;
    private String _docRoot;
    private Resource _baseResource;
    private MimeTypes _mimeTypes;
    private Map _localeEncodingMap;
    private String[] _welcomeFiles;
    private ErrorHandler _errorHandler;
    private String[] _hosts;
    private String[] _vhosts;
    private EventListener[] _eventListeners;
    Logger logger;
    private Object _contextListeners;
    private Object _contextAttributeListeners;
    private Object _requestListeners;
    private Object _requestAttributeListeners;

    public static Context getCurrentContext() {
        Context context = (Context)__context.get();
        if (context == null) {
            throw new IllegalStateException("Only valid during call to doStart()");
        }
        return context;
    }

    public ContextHandler() {
        this._attributes = new AttributesMap();
        this._initParams = new HashMap();
    }

    public void setServer(Server server) {
        if (this.getServer() != null && this.getServer() != server) {
            this.getServer().getContainer().update((Object)this, this._errorHandler, null, "error");
        }
        if (server != null && this.getServer() != server) {
            server.getContainer().update((Object)this, null, this._errorHandler, "error");
        }
        super.setServer(server);
        if (this._errorHandler != null) {
            this._errorHandler.setServer(server);
        }
    }

    public void setVirtualHosts(String[] vhosts) {
        this._vhosts = vhosts;
    }

    public String[] getVirtualHosts() {
        return this._vhosts;
    }

    public void setHosts(String[] hosts) {
        this._hosts = hosts;
    }

    public String[] getHosts() {
        return this._hosts;
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.getAttributeNames();
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getInitParameter(String name) {
        return (String)this._initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public HashMap getInitParams() {
        return this._initParams;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public EventListener[] getEventListeners() {
        return this._eventListeners;
    }

    public void setEventListeners(EventListener[] eventListeners) {
        this._contextListeners = null;
        this._contextAttributeListeners = null;
        this._requestListeners = null;
        this._requestAttributeListeners = null;
        this._eventListeners = eventListeners;
        for (int i = 0; eventListeners != null && i < eventListeners.length; ++i) {
            EventListener listener = this._eventListeners[i];
            if (listener instanceof ServletContextListener) {
                this._contextListeners = LazyList.add(this._contextListeners, listener);
            }
            if (listener instanceof ServletContextAttributeListener) {
                this._contextAttributeListeners = LazyList.add(this._contextAttributeListeners, listener);
            }
            if (listener instanceof ServletRequestListener) {
                this._requestListeners = LazyList.add(this._requestListeners, listener);
            }
            if (!(listener instanceof ServletRequestAttributeListener)) continue;
            this._requestAttributeListeners = LazyList.add(this._requestAttributeListeners, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        this.logger = Log.getLogger(this.getDisplayName() == null ? this.getContextPath() : this.getDisplayName());
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        Object old_context = null;
        this._contextAttributes = new AttributesMap();
        try {
            if (this._classLoader != null) {
                current_thread = Thread.currentThread();
                old_classloader = current_thread.getContextClassLoader();
                current_thread.setContextClassLoader(this._classLoader);
            }
            if (this._mimeTypes == null) {
                this._mimeTypes = new MimeTypes();
            }
            old_context = __context.get();
            __context.set(this._context);
            if (this._errorHandler == null) {
                this._errorHandler = new ErrorHandler();
            }
            this.startContext();
            Object var5_4 = null;
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            throw throwable;
        }
    }

    protected void startContext() throws Exception {
        super.doStart();
        if (this._contextListeners != null) {
            ServletContextEvent event = new ServletContextEvent((ServletContext)this._context);
            for (int i = 0; i < LazyList.size(this._contextListeners); ++i) {
                ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextInitialized(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        Object old_context = __context.get();
        __context.set(this._context);
        try {
            if (this._classLoader != null) {
                current_thread = Thread.currentThread();
                old_classloader = current_thread.getContextClassLoader();
                current_thread.setContextClassLoader(this._classLoader);
            }
            super.doStop();
            if (this._contextListeners != null) {
                ServletContextEvent event = new ServletContextEvent((ServletContext)this._context);
                for (int i = 0; i < LazyList.size(this._contextListeners); ++i) {
                    ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextDestroyed(event);
                }
            }
            Object var7_6 = null;
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            __context.set(old_context);
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            throw throwable;
        }
        this._contextAttributes.clearAttributes();
        this._contextAttributes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        boolean handled = false;
        boolean new_context = false;
        Request base_request = null;
        Context old_context = null;
        String old_context_path = null;
        String old_servlet_path = null;
        String old_path_info = null;
        ClassLoader old_classloader = null;
        Thread current_thread = null;
        base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        old_context = base_request.getContext();
        if (old_context != this._context) {
            int i;
            boolean match;
            new_context = true;
            if (dispatch == 1) {
                if (target.equals(this._contextPath)) {
                    target = this._contextPath;
                    if (!target.endsWith("/")) {
                        response.sendRedirect(target + "/");
                        return true;
                    }
                } else {
                    if (!target.startsWith(this._contextPath)) return false;
                    if (this._contextPath.length() != 1) {
                        if (target.charAt(this._contextPath.length()) != '/') return false;
                    }
                    if (this._contextPath.length() > 1) {
                        target = target.substring(this._contextPath.length());
                    }
                }
            }
            if (this._vhosts != null && this._vhosts.length > 0) {
                String vhost = request.getServerName();
                match = false;
                for (i = 0; !match && i < this._vhosts.length; ++i) {
                    match = this._vhosts[i] != null && this._vhosts[i].equalsIgnoreCase(vhost);
                }
                if (!match) {
                    return false;
                }
            }
            if (this._hosts != null && this._hosts.length > 0) {
                String host = request.getLocalName();
                match = false;
                for (i = 0; !match && i < this._hosts.length; ++i) {
                    match = this._hosts[i] != null && this._hosts[i].equalsIgnoreCase(host);
                }
                if (!match) {
                    return false;
                }
            }
        }
        try {
            block31: {
                int i3;
                old_context_path = base_request.getContextPath();
                old_servlet_path = base_request.getServletPath();
                old_path_info = base_request.getPathInfo();
                base_request.setContext(this._context);
                if (dispatch != 4 && target.startsWith("/")) {
                    if (this._contextPath.length() == 1) {
                        base_request.setContextPath("");
                    } else {
                        base_request.setContextPath(this._contextPath);
                    }
                    base_request.setServletPath(null);
                    base_request.setPathInfo(target);
                }
                if (this._classLoader != null) {
                    current_thread = Thread.currentThread();
                    old_classloader = current_thread.getContextClassLoader();
                    current_thread.setContextClassLoader(this._classLoader);
                }
                ServletRequestEvent event = null;
                if (new_context) {
                    int i2;
                    if (this._requestListeners != null) {
                        event = new ServletRequestEvent((ServletContext)this._context, (ServletRequest)request);
                        for (i2 = 0; i2 < LazyList.size(this._requestListeners); ++i2) {
                            ((ServletRequestListener)LazyList.get(this._requestListeners, i2)).requestInitialized(event);
                        }
                    }
                    for (i2 = 0; i2 < LazyList.size(this._requestAttributeListeners); ++i2) {
                        base_request.addEventListener((EventListener)((ServletRequestListener)LazyList.get(this._requestAttributeListeners, i2)));
                    }
                }
                try {
                    handled = this.getHandler().handle(target, request, response, dispatch);
                    Object var18_17 = null;
                    if (!new_context) break block31;
                }
                catch (Throwable throwable) {
                    int i3;
                    Object var18_18 = null;
                    if (!new_context) throw throwable;
                    for (i3 = 0; i3 < LazyList.size(this._requestListeners); ++i3) {
                        ((ServletRequestListener)LazyList.get(this._requestListeners, i3)).requestDestroyed(event);
                    }
                    i3 = 0;
                    while (i3 < LazyList.size(this._requestAttributeListeners)) {
                        base_request.removeEventListener((EventListener)((ServletRequestListener)LazyList.get(this._requestAttributeListeners, i3)));
                        ++i3;
                    }
                    throw throwable;
                }
                for (i3 = 0; i3 < LazyList.size(this._requestListeners); ++i3) {
                    ((ServletRequestListener)LazyList.get(this._requestListeners, i3)).requestDestroyed(event);
                }
                for (i3 = 0; i3 < LazyList.size(this._requestAttributeListeners); ++i3) {
                    base_request.removeEventListener((EventListener)((ServletRequestListener)LazyList.get(this._requestAttributeListeners, i3)));
                }
            }
            Object var21_22 = null;
            if (old_context == this._context) return handled;
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            base_request.setContext(old_context);
            base_request.setContextPath(old_context_path);
            base_request.setServletPath(old_servlet_path);
            base_request.setPathInfo(old_path_info);
            return handled;
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            if (old_context == this._context) throw throwable;
            if (this._classLoader != null) {
                current_thread.setContextClassLoader(old_classloader);
            }
            base_request.setContext(old_context);
            base_request.setContextPath(old_context_path);
            base_request.setServletPath(old_servlet_path);
            base_request.setPathInfo(old_path_info);
            throw throwable;
        }
    }

    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    public void setAttributes(Attributes attributes) {
        this._attributes = attributes;
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setInitParams(HashMap initParams) {
        this._initParams = initParams;
    }

    public void setDisplayName(String servletContextName) {
        this._displayName = servletContextName;
    }

    public Resource getBaseResource() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource;
    }

    public String getResourceBase() {
        if (this._baseResource == null) {
            return null;
        }
        return this._baseResource.toString();
    }

    public void setBaseResource(Resource base) {
        this._baseResource = base;
        this._docRoot = null;
        try {
            File file = this._baseResource.getFile();
            if (file != null) {
                this._docRoot = file.getCanonicalPath();
                if (this._docRoot.endsWith(File.pathSeparator)) {
                    this._docRoot = this._docRoot.substring(0, this._docRoot.length() - 1);
                }
            }
        }
        catch (Exception e) {
            Log.warn(e);
            throw new IllegalArgumentException(base.toString());
        }
    }

    public void setResourceBase(String resourceBase) {
        try {
            this.setBaseResource(Resource.newResource(resourceBase));
        }
        catch (Exception e) {
            Log.warn(e);
            throw new IllegalArgumentException(resourceBase);
        }
    }

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setWelcomeFiles(String[] files) {
        this._welcomeFiles = files;
    }

    public String[] getWelcomeFiles() {
        return this._welcomeFiles;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (this._errorHandler != null) {
            this._errorHandler.setServer(null);
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._errorHandler, errorHandler, "errorHandler");
        }
        this._errorHandler = errorHandler;
        if (this._errorHandler != null) {
            this._errorHandler.setServer(this.getServer());
        }
    }

    public String toString() {
        return "ContextHandler@" + Integer.toHexString(this.hashCode()) + "{" + this.getContextPath() + "," + this.getBaseResource() + "}";
    }

    public synchronized Class loadClass(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (this._classLoader == null) {
            return Loader.loadClass(this.getClass(), className);
        }
        return this._classLoader.loadClass(className);
    }

    public void addLocaleEncoding(String locale, String encoding) {
        if (this._localeEncodingMap == null) {
            this._localeEncodingMap = new HashMap();
        }
        this._localeEncodingMap.put(locale, encoding);
    }

    public String getLocaleEncoding(Locale locale) {
        if (this._localeEncodingMap == null) {
            return null;
        }
        String encoding = (String)this._localeEncodingMap.get(locale.toString());
        if (encoding == null) {
            encoding = (String)this._localeEncodingMap.get(locale.getLanguage());
        }
        return encoding;
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        if (this._baseResource == null) {
            return null;
        }
        try {
            path = URIUtil.canonicalPath(path);
            Resource resource = this._baseResource.addPath(path);
            return resource;
        }
        catch (Exception e) {
            Log.ignore(e);
            return null;
        }
    }

    public Set getResourcePaths(String path) {
        try {
            String[] l;
            path = URIUtil.canonicalPath(path);
            Resource resource = this.getResource(path);
            if (resource != null && resource.exists() && (l = resource.list()) != null) {
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < l.length; ++i) {
                    set.add(path + "/" + l[i]);
                }
                return set;
            }
        }
        catch (Exception e) {
            Log.ignore(e);
        }
        return Collections.EMPTY_SET;
    }

    public class Context
    implements ServletContext {
        private Context() {
        }

        public ContextHandler getContextHandler() {
            return ContextHandler.this;
        }

        public ServletContext getContext(String uripath) {
            ContextHandler context = null;
            Handler[] handlers = ContextHandler.this.getServer().getAllHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                ContextHandler ch;
                String context_path;
                if (handlers[i] == null || !handlers[i].isStarted() || !(handlers[i] instanceof ContextHandler) || !uripath.equals(context_path = (ch = (ContextHandler)handlers[i]).getContextPath()) && (!uripath.startsWith(context_path) || uripath.charAt(context_path.length()) != '/') || context != null && context_path.length() <= context.getContextPath().length()) continue;
                context = ch;
            }
            if (context != null) {
                return context._context;
            }
            return null;
        }

        public int getMajorVersion() {
            return 2;
        }

        public String getMimeType(String file) {
            if (ContextHandler.this._mimeTypes == null) {
                return null;
            }
            Buffer mime = ContextHandler.this._mimeTypes.getMimeByExtension(file);
            if (mime != null) {
                return mime.toString();
            }
            return null;
        }

        public int getMinorVersion() {
            return 5;
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return new Dispatcher(ContextHandler.this, name);
        }

        public String getRealPath(String path) {
            if (ContextHandler.this._docRoot == null) {
                return null;
            }
            if (path == null) {
                return null;
            }
            if (!(path = URIUtil.canonicalPath(path)).startsWith("/")) {
                path = "/" + path;
            }
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
            }
            return ContextHandler.this._docRoot + path;
        }

        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            if (uriInContext == null) {
                return null;
            }
            if (!uriInContext.startsWith("/")) {
                return null;
            }
            try {
                String query = null;
                int q = 0;
                q = uriInContext.indexOf(63);
                if (q > 0) {
                    query = uriInContext.substring(q + 1);
                    uriInContext = uriInContext.substring(0, q);
                }
                if ((q = uriInContext.indexOf(59)) > 0) {
                    uriInContext = uriInContext.substring(0, q);
                }
                String pathInContext = URIUtil.canonicalPath(URIUtil.decodePath(uriInContext));
                String uri = URIUtil.addPaths(this.getContextPath(), uriInContext);
                return new Dispatcher(ContextHandler.this, uri, pathInContext, query);
            }
            catch (Exception e) {
                Log.ignore(e);
                return null;
            }
        }

        public URL getResource(String path) throws MalformedURLException {
            Resource resource = ContextHandler.this.getResource(path);
            if (resource != null && resource.exists()) {
                return resource.getURL();
            }
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            try {
                URL url = this.getResource(path);
                if (url == null) {
                    return null;
                }
                return url.openStream();
            }
            catch (Exception e) {
                Log.ignore(e);
                return null;
            }
        }

        public Set getResourcePaths(String path) {
            return ContextHandler.this.getResourcePaths(path);
        }

        public String getServerInfo() {
            return "Jetty-6.0";
        }

        public Servlet getServlet(String name) throws ServletException {
            return null;
        }

        public Enumeration getServletNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public Enumeration getServlets() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void log(Exception exception, String msg) {
            ContextHandler.this.logger.warn(msg, exception);
        }

        public void log(String msg) {
            ContextHandler.this.logger.info(msg, null, null);
        }

        public void log(String message, Throwable throwable) {
            ContextHandler.this.logger.warn(message, throwable);
        }

        public String getInitParameter(String name) {
            return ContextHandler.this.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return ContextHandler.this.getInitParameterNames();
        }

        public synchronized Object getAttribute(String name) {
            Object o = ContextHandler.this.getAttribute(name);
            if (o == null) {
                o = ContextHandler.this._contextAttributes.getAttribute(name);
            }
            return o;
        }

        public synchronized Enumeration getAttributeNames() {
            HashSet set = new HashSet();
            Enumeration e = ContextHandler.this._contextAttributes.getAttributeNames();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            e = ContextHandler.this.getAttributeNames();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            return Collections.enumeration(set);
        }

        public synchronized void setAttribute(String name, Object value) {
            Object old_value;
            Object object = old_value = ContextHandler.this._contextAttributes == null ? null : ContextHandler.this._contextAttributes.getAttribute(name);
            if (value == null) {
                ContextHandler.this._contextAttributes.removeAttribute(name);
            } else {
                ContextHandler.this._contextAttributes.setAttribute(name, value);
            }
            if (ContextHandler.this._contextAttributeListeners != null) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)ContextHandler.this._context, name, old_value == null ? value : old_value);
                for (int i = 0; i < LazyList.size(ContextHandler.this._contextAttributeListeners); ++i) {
                    ServletContextAttributeListener l = (ServletContextAttributeListener)LazyList.get(ContextHandler.this._contextAttributeListeners, i);
                    if (old_value == null) {
                        l.attributeAdded(event);
                        continue;
                    }
                    if (value == null) {
                        l.attributeRemoved(event);
                        continue;
                    }
                    l.attributeReplaced(event);
                }
            }
        }

        public synchronized void removeAttribute(String name) {
            Object old_value = ContextHandler.this._contextAttributes.getAttribute(name);
            ContextHandler.this._contextAttributes.removeAttribute(name);
            if (old_value != null && ContextHandler.this._contextAttributeListeners != null) {
                ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)ContextHandler.this._context, name, old_value);
                for (int i = 0; i < LazyList.size(ContextHandler.this._contextAttributeListeners); ++i) {
                    ((ServletContextAttributeListener)LazyList.get(ContextHandler.this._contextAttributeListeners, i)).attributeRemoved(event);
                }
            }
        }

        public String getServletContextName() {
            String name = ContextHandler.this.getDisplayName();
            if (name == null) {
                name = ContextHandler.this.getContextPath();
            }
            return name;
        }

        public String getContextPath() {
            return ContextHandler.this._contextPath;
        }

        public String toString() {
            return "ServletContext@" + Integer.toHexString(this.hashCode()) + "{" + this.getContextPath() + "," + ContextHandler.this.getBaseResource() + "}";
        }
    }
}

