/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.component.Container;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.NotFoundHandler;
import org.mortbay.jetty.handler.WrappedHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.log.Log;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;

public class Server
extends HandlerCollection {
    private static ShutdownHookThread hookThread = new ShutdownHookThread();
    private ThreadPool _threadPool;
    private Connector[] _connectors;
    private UserRealm[] _realms;
    private Handler _notFoundHandler;
    private Container _container = new Container();
    private RequestLog _requestLog;
    private PathMap _contextMap;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public Server() {
        this.setServer(this);
    }

    public Container getContainer() {
        return this._container;
    }

    public boolean getStopAtShutdown() {
        return hookThread.contains(this);
    }

    public void setStopAtShutdown(boolean stop) {
        if (stop) {
            hookThread.add(this);
        } else {
            hookThread.remove(this);
        }
    }

    public Connector[] getConnectors() {
        return this._connectors;
    }

    public void setConnectors(Connector[] connectors) {
        int i;
        this._container.update((Object)this, this._connectors, connectors, "connector");
        if (this._connectors != null) {
            for (i = 0; i < this._connectors.length; ++i) {
                if (this._connectors[i] == null) continue;
                this._connectors[i].setServer(null);
            }
        }
        this._connectors = connectors;
        if (connectors != null) {
            for (i = 0; i < connectors.length; ++i) {
                connectors[i].setServer(this);
            }
        }
    }

    public void setHandlers(Handler[] handlers) {
        this._contextMap = null;
        super.setHandlers(handlers);
        if (handlers != null && handlers.length > 0) {
            PathMap contextMap = new PathMap();
            ArrayList list = new ArrayList();
            for (int i = 0; i < handlers.length; ++i) {
                list.clear();
                this.expandHandler(handlers[i], list);
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    Handler handler = (Handler)iter.next();
                    if (!(handler instanceof ContextHandler)) continue;
                    String contextPath = ((ContextHandler)handler).getContextPath();
                    if (contextPath == null || contextPath.indexOf(44) >= 0 || contextPath.startsWith("*")) {
                        throw new IllegalArgumentException("Illegal context spec:" + contextPath);
                    }
                    if (!contextPath.startsWith("/")) {
                        contextPath = '/' + contextPath;
                    }
                    if (contextPath.length() > 1) {
                        if (contextPath.endsWith("/")) {
                            contextPath = contextPath + "*";
                        } else if (!contextPath.endsWith("/*")) {
                            contextPath = contextPath + "/*";
                        }
                    }
                    Object contexts = contextMap.get(contextPath);
                    contexts = LazyList.add(contexts, handlers[i]);
                    contextMap.put(contextPath, contexts);
                }
            }
            this._contextMap = contextMap;
        }
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._container.update((Object)this, this._threadPool, threadPool, "threadpool");
        this._threadPool = threadPool;
    }

    public void setRequestLog(RequestLog requestLog) {
        this._container.update((Object)this, this._requestLog, requestLog, "requestLog");
        this._requestLog = requestLog;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    protected void doStart() throws Exception {
        MultiException mex = new MultiException();
        if (this._threadPool == null) {
            BoundedThreadPool btp = new BoundedThreadPool();
            this.setThreadPool(btp);
        }
        try {
            if (this._requestLog != null) {
                this._requestLog.start();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            this._threadPool.start();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            super.doStart();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                try {
                    this._connectors[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        if (this._connectors != null) {
            int i = this._connectors.length;
            while (i-- > 0) {
                try {
                    this._connectors[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            this._threadPool.stop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            if (this._requestLog != null) {
                this._requestLog.stop();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        mex.ifExceptionThrow();
    }

    public void handle(HttpConnection connection) throws IOException, ServletException {
        String target = connection.getRequest().getPathInfo();
        if (Log.isDebugEnabled()) {
            Log.debug("REQUEST " + target + " on " + connection);
            this.handle(target, connection.getRequest(), connection.getResponse(), 1);
            Log.debug("RESPONSE " + target + "  " + connection.getResponse().getStatus());
        } else {
            this.handle(target, connection.getRequest(), connection.getResponse(), 1);
        }
        if (this._requestLog != null) {
            this._requestLog.log(connection.getRequest(), connection.getResponse());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        Handler[] handlers = this.getHandlers();
        if (handlers == null || handlers.length == 0) {
            response.sendError(500);
            return true;
        }
        if (this._contextMap != null && target != null && target.startsWith("/")) {
            Object contexts = this._contextMap.getLazyMatches(target);
            for (int i = 0; i < LazyList.size(contexts); ++i) {
                if (!((Handler)((Map.Entry)LazyList.get(contexts, i)).getValue()).handle(target, request, response, dispatch)) continue;
                return true;
            }
        }
        for (int i = 0; i < handlers.length; ++i) {
            if (!handlers[i].handle(target, request, response, dispatch)) continue;
            return true;
        }
        Server server = this;
        synchronized (server) {
            if (this._notFoundHandler == null) {
                try {
                    NotFoundHandler nfh = new NotFoundHandler();
                    nfh.setServer(this);
                    nfh.start();
                    this.setNotFoundHandler(nfh);
                }
                catch (Exception e) {
                    Log.warn(e);
                }
            }
            this._notFoundHandler.handle(target, request, response, dispatch);
        }
        return false;
    }

    public Handler[] getAllHandlers() {
        Handler[] handlers = this.getHandlers();
        ArrayList list = new ArrayList();
        for (int i = 0; i < handlers.length; ++i) {
            this.expandHandler(handlers[i], list);
        }
        return list.toArray(new Handler[list.size()]);
    }

    private void expandHandler(Handler handler, List list) {
        if (handler == null) {
            return;
        }
        list.add(handler);
        if (handler instanceof WrappedHandler) {
            this.expandHandler(((WrappedHandler)handler).getHandler(), list);
        }
        if (handler instanceof HandlerCollection) {
            Handler[] ha = ((HandlerCollection)handler).getHandlers();
            for (int i = 0; ha != null && i < ha.length; ++i) {
                this.expandHandler(ha[i], list);
            }
        }
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public UserRealm[] getUserRealms() {
        return this._realms;
    }

    public void setUserRealms(UserRealm[] realms) {
        this._container.update((Object)this, this._realms, realms, "realm");
        this._realms = realms;
    }

    public Handler getNotFoundHandler() {
        return this._notFoundHandler;
    }

    public void setNotFoundHandler(Handler notFoundHandler) {
        this._container.update((Object)this, this._notFoundHandler, notFoundHandler, "notFoundHandler");
        this._notFoundHandler = notFoundHandler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ShutdownHookThread
    extends Thread {
        private boolean hooked = false;
        private ArrayList servers = new ArrayList();

        private ShutdownHookThread() {
        }

        private void createShutdownHook() {
            block3: {
                if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK") && !this.hooked) {
                    try {
                        Method shutdownHook = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Server.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = Server.class$("java.lang.Thread")) : class$java$lang$Thread);
                        shutdownHook.invoke((Object)Runtime.getRuntime(), this);
                        this.hooked = true;
                    }
                    catch (Exception e) {
                        if (!Log.isDebugEnabled()) break block3;
                        Log.debug("No shutdown hook in JVM ", e);
                    }
                }
            }
        }

        public boolean add(Server server) {
            this.createShutdownHook();
            return this.servers.add(server);
        }

        public boolean contains(Server server) {
            return this.servers.contains(server);
        }

        public boolean addAll(Collection c) {
            this.createShutdownHook();
            return this.servers.addAll(c);
        }

        public void clear() {
            this.createShutdownHook();
            this.servers.clear();
        }

        public boolean remove(Server server) {
            this.createShutdownHook();
            return ((AbstractCollection)this.servers).remove(server);
        }

        public boolean removeAll(Collection c) {
            this.createShutdownHook();
            return ((AbstractCollection)this.servers).removeAll(c);
        }

        public void run() {
            this.setName("Shutdown");
            Log.info("Shutdown hook executing");
            Iterator it = ((AbstractList)this.servers).iterator();
            while (it.hasNext()) {
                Server svr = (Server)it.next();
                if (svr == null) continue;
                try {
                    svr.stop();
                }
                catch (Exception e) {
                    Log.warn(e);
                }
                Log.info("Shutdown hook complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    Log.warn(e);
                }
            }
        }
    }
}

