/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Buffer;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.WaitingContinuation;

public abstract class AbstractConnector
extends AbstractLifeCycle
implements Connector {
    private int _headerBufferSize = 4096;
    private int _requestBufferSize = 8192;
    private int _responseBufferSize = 32768;
    private Server _server;
    private ThreadPool _threadPool;
    private String _host;
    private int _port = 8080;
    private String _integralScheme = "https";
    private int _integralPort = 0;
    private String _confidentialScheme = "https";
    private int _confidentialPort = 0;
    private int _acceptQueueSize = 0;
    private int _acceptors = 1;
    protected long _maxIdleTime = 30000L;
    protected long _soLingerTime = 1000L;
    private transient SocketAddress _address;
    private transient ArrayList _headerBuffers;
    private transient ArrayList _requestBuffers;
    private transient ArrayList _responseBuffers;
    private transient Thread[] _acceptorThread;

    public abstract void open() throws IOException;

    public Server getServer() {
        return this._server;
    }

    public void setServer(Server server) {
        this._server = server;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool pool) {
        this._threadPool = pool;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public SocketAddress getAddress() {
        if (this._address == null) {
            this._address = this._host == null ? new InetSocketAddress(this._port) : new InetSocketAddress(this._host, this._port);
        }
        return this._address;
    }

    public int getHeaderBufferSize() {
        return this._headerBufferSize;
    }

    public void setHeaderBufferSize(int headerBufferSize) {
        this._headerBufferSize = headerBufferSize;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getRequestBufferSize() {
        return this._requestBufferSize;
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this._requestBufferSize = requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this._responseBufferSize;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this._responseBufferSize = responseBufferSize;
    }

    public long getSoLingerTime() {
        return this._soLingerTime;
    }

    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this._acceptQueueSize = acceptQueueSize;
    }

    public int getAcceptors() {
        return this._acceptors;
    }

    public void setAcceptors(int acceptors) {
        this._acceptors = acceptors;
    }

    public void setSoLingerTime(long soLingerTime) {
        this._soLingerTime = soLingerTime;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.open();
        if (this._headerBuffers != null) {
            this._headerBuffers.clear();
        } else {
            this._headerBuffers = new ArrayList();
        }
        if (this._requestBuffers != null) {
            this._requestBuffers.clear();
        } else {
            this._requestBuffers = new ArrayList();
        }
        if (this._responseBuffers != null) {
            this._responseBuffers.clear();
        } else {
            this._responseBuffers = new ArrayList();
        }
        if (this._threadPool == null) {
            this._threadPool = this._server.getThreadPool();
        }
        if (this._threadPool != this._server.getThreadPool()) {
            this._threadPool.start();
        }
        this._acceptorThread = new Thread[this.getAcceptors()];
        for (int i = 0; i < this._acceptorThread.length; ++i) {
            if (this._threadPool.dispatch(new Acceptor(i))) continue;
            Log.warn("insufficient maxThreads configured for {}", this);
            break;
        }
        Log.info("Started {}", this);
    }

    protected void doStop() throws Exception {
        if (this._threadPool != this._server.getThreadPool()) {
            this._threadPool.stop();
        }
        if (this._acceptorThread != null) {
            for (int i = 0; i < this._acceptorThread.length; ++i) {
                if (this._acceptorThread[i] == null) continue;
                this._acceptorThread[i].interrupt();
            }
        }
        this._acceptorThread = null;
        this._address = null;
        try {
            this.close();
        }
        catch (IOException e) {
            Log.warn(e);
        }
        super.doStop();
    }

    public void join() throws InterruptedException {
        Thread[] threads = this._acceptorThread;
        if (threads != null) {
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                threads[i].join();
            }
        }
    }

    protected void configure(Socket socket) throws IOException {
        try {
            socket.setTcpNoDelay(true);
            if (this._maxIdleTime >= 0L) {
                socket.setSoTimeout((int)this._maxIdleTime);
            }
            if (this._soLingerTime >= 0L) {
                socket.setSoLinger(true, (int)this._soLingerTime / 1000);
            } else {
                socket.setSoLinger(false, 0);
            }
        }
        catch (Exception e) {
            Log.ignore(e);
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
    }

    protected abstract Buffer newBuffer(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getBuffer(int size) {
        if (size == this._headerBufferSize) {
            ArrayList arrayList = this._headerBuffers;
            synchronized (arrayList) {
                if (this._headerBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                return (Buffer)this._headerBuffers.remove(this._headerBuffers.size() - 1);
            }
        }
        if (size == this._responseBufferSize) {
            ArrayList arrayList = this._responseBuffers;
            synchronized (arrayList) {
                if (this._responseBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                return (Buffer)this._responseBuffers.remove(this._responseBuffers.size() - 1);
            }
        }
        if (size == this._requestBufferSize) {
            ArrayList arrayList = this._requestBuffers;
            synchronized (arrayList) {
                if (this._requestBuffers.size() == 0) {
                    return this.newBuffer(size);
                }
                return (Buffer)this._requestBuffers.remove(this._requestBuffers.size() - 1);
            }
        }
        return this.newBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        if (!buffer.isVolatile() && !buffer.isImmutable()) {
            int c = buffer.capacity();
            if (c == this._headerBufferSize) {
                ArrayList arrayList = this._headerBuffers;
                synchronized (arrayList) {
                    this._headerBuffers.add(buffer);
                }
            }
            if (c == this._responseBufferSize) {
                ArrayList arrayList = this._responseBuffers;
                synchronized (arrayList) {
                    this._responseBuffers.add(buffer);
                }
            }
            if (c == this._requestBufferSize) {
                ArrayList arrayList = this._requestBuffers;
                synchronized (arrayList) {
                    this._requestBuffers.add(buffer);
                }
            }
        }
    }

    public int getConfidentialPort() {
        return this._confidentialPort;
    }

    public String getConfidentialScheme() {
        return this._confidentialScheme;
    }

    public boolean isIntegral(Request request) {
        return false;
    }

    public int getIntegralPort() {
        return this._integralPort;
    }

    public String getIntegralScheme() {
        return this._integralScheme;
    }

    public boolean isConfidential(Request request) {
        return false;
    }

    public void setConfidentialPort(int confidentialPort) {
        this._confidentialPort = confidentialPort;
    }

    public void setConfidentialScheme(String confidentialScheme) {
        this._confidentialScheme = confidentialScheme;
    }

    public void setIntegralPort(int integralPort) {
        this._integralPort = integralPort;
    }

    public void setIntegralScheme(String integralScheme) {
        this._integralScheme = integralScheme;
    }

    public Continuation newContinuation() {
        return new WaitingContinuation();
    }

    protected abstract void accept(int var1) throws IOException, InterruptedException;

    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            name = name.substring(dot + 1);
        }
        return name + " @ " + (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + this.getPort();
    }

    public abstract /* synthetic */ void close() throws IOException;

    private class Acceptor
    implements Runnable {
        int _acceptor = 0;

        Acceptor(int id) {
            this._acceptor = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread current;
            ((AbstractConnector)AbstractConnector.this)._acceptorThread[this._acceptor] = current = Thread.currentThread();
            String name = AbstractConnector.this._acceptorThread[this._acceptor].getName();
            current.setName(name + " - Acceptor" + this._acceptor + " " + AbstractConnector.this);
            Log.debug("Starting " + this);
            try {
                current.setPriority(current.getPriority() - 1);
                while (AbstractConnector.this.isRunning() && AbstractConnector.this.getThreadPool().isRunning()) {
                    try {
                        AbstractConnector.this.accept(this._acceptor);
                    }
                    catch (IOException e) {
                        Log.ignore(e);
                    }
                    catch (Exception e) {
                        Log.warn(e);
                    }
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                Log.debug("Stopping " + this);
                current.setPriority(current.getPriority() + 1);
                current.setName(name);
                try {
                    if (this._acceptor == 0) {
                        AbstractConnector.this.close();
                    }
                }
                catch (IOException e) {
                    Log.warn(e);
                }
                throw throwable;
            }
            Log.debug("Stopping " + this);
            current.setPriority(current.getPriority() + 1);
            current.setName(name);
            try {
                if (this._acceptor == 0) {
                    AbstractConnector.this.close();
                }
            }
            catch (IOException e) {
                Log.warn(e);
            }
        }
    }
}

