/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public final class ArrayBinding
extends TypeBinding {
    public static final FieldBinding ArrayLength = new FieldBinding(TypeConstants.LENGTH, BaseTypes.IntBinding, 17, null, Constant.NotAConstant);
    public TypeBinding leafComponentType;
    public int dimensions;
    LookupEnvironment environment;
    char[] constantPoolName;
    char[] genericTypeSignature;

    public ArrayBinding(TypeBinding type, int dimensions, LookupEnvironment environment) {
        this.tagBits |= 1L;
        this.leafComponentType = type;
        this.dimensions = dimensions;
        this.environment = environment;
        if (type instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)type).addWrapper(this);
        } else {
            this.tagBits |= type.tagBits & 0x60000000L;
        }
    }

    public int kind() {
        return 68;
    }

    public void collectSubstitutes(TypeBinding otherType, Map substitutes) {
        if (otherType.isArrayType()) {
            int otherDim = otherType.dimensions();
            if (otherDim == this.dimensions) {
                this.leafComponentType.collectSubstitutes(otherType.leafComponentType(), substitutes);
            } else if (otherDim > this.dimensions) {
                ArrayBinding otherReducedType = this.environment.createArrayType(otherType.leafComponentType(), otherDim - this.dimensions);
                this.leafComponentType.collectSubstitutes(otherReducedType, substitutes);
            }
        }
    }

    public char[] computeUniqueKey() {
        char[] brackets = new char[this.dimensions];
        int i = this.dimensions - 1;
        while (i >= 0) {
            brackets[i] = 91;
            --i;
        }
        return CharOperation.concat(brackets, this.leafComponentType.computeUniqueKey());
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        char[] brackets = new char[this.dimensions];
        int i = this.dimensions - 1;
        while (i >= 0) {
            brackets[i] = 91;
            --i;
        }
        this.constantPoolName = CharOperation.concat(brackets, this.leafComponentType.signature());
        return this.constantPoolName;
    }

    public String debugName() {
        StringBuffer brackets = new StringBuffer(this.dimensions * 2);
        int i = this.dimensions;
        while (--i >= 0) {
            brackets.append("[]");
        }
        return String.valueOf(this.leafComponentType.debugName()) + brackets.toString();
    }

    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding elementsType() {
        if (this.dimensions == 1) {
            return this.leafComponentType;
        }
        return this.environment.createArrayType(this.leafComponentType, this.dimensions - 1);
    }

    public TypeBinding erasure() {
        TypeBinding erasedType = this.leafComponentType.erasure();
        if (this.leafComponentType != erasedType) {
            return this.environment.createArrayType(erasedType, this.dimensions);
        }
        return this;
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            char[] brackets = new char[this.dimensions];
            int i = this.dimensions - 1;
            while (i >= 0) {
                brackets[i] = 91;
                --i;
            }
            this.genericTypeSignature = CharOperation.concat(brackets, this.leafComponentType.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    public PackageBinding getPackage() {
        return this.leafComponentType.getPackage();
    }

    public int hashCode() {
        return this.leafComponentType == null ? super.hashCode() : this.leafComponentType.hashCode();
    }

    public boolean isCompatibleWith(TypeBinding right) {
        if (this == right) {
            return true;
        }
        if (right.isArrayType()) {
            ArrayBinding rightArray = (ArrayBinding)right;
            if (rightArray.leafComponentType.isBaseType()) {
                return false;
            }
            if (this.dimensions == rightArray.dimensions) {
                return this.leafComponentType.isCompatibleWith(rightArray.leafComponentType);
            }
            if (this.dimensions < rightArray.dimensions) {
                return false;
            }
        } else {
            if (right.isBaseType()) {
                return false;
            }
            if (right.isWildcard()) {
                return ((WildcardBinding)right).boundCheck(this);
            }
        }
        switch (right.leafComponentType().id) {
            case 1: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public TypeBinding leafComponentType() {
        return this.leafComponentType;
    }

    public int problemId() {
        return this.leafComponentType.problemId();
    }

    public char[] qualifiedSourceName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.qualifiedSourceName(), brackets);
    }

    public char[] readableName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.readableName(), brackets);
    }

    public char[] shortReadableName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.shortReadableName(), brackets);
    }

    public char[] sourceName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.sourceName(), brackets);
    }

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType, LookupEnvironment env) {
        if (this.leafComponentType == unresolvedType) {
            this.leafComponentType = resolvedType.isGenericType() ? env.createRawType(resolvedType, resolvedType.enclosingType()) : resolvedType;
            this.tagBits |= this.leafComponentType.tagBits & 0x60000000L;
        }
    }

    public String toString() {
        return this.leafComponentType != null ? this.debugName() : "NULL TYPE ARRAY";
    }
}

