/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.core.dom.AST;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.ASTSyntaxErrorPropagator;
import org.aspectj.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.Annotation;
import org.aspectj.org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayAccess;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayCreation;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.core.dom.ArrayType;
import org.aspectj.org.eclipse.jdt.core.dom.AssertStatement;
import org.aspectj.org.eclipse.jdt.core.dom.Assignment;
import org.aspectj.org.eclipse.jdt.core.dom.Block;
import org.aspectj.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.BooleanLiteral;
import org.aspectj.org.eclipse.jdt.core.dom.BreakStatement;
import org.aspectj.org.eclipse.jdt.core.dom.CastExpression;
import org.aspectj.org.eclipse.jdt.core.dom.CatchClause;
import org.aspectj.org.eclipse.jdt.core.dom.CharacterLiteral;
import org.aspectj.org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.aspectj.org.eclipse.jdt.core.dom.Comment;
import org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit;
import org.aspectj.org.eclipse.jdt.core.dom.ConditionalExpression;
import org.aspectj.org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.ContinueStatement;
import org.aspectj.org.eclipse.jdt.core.dom.DefaultCommentMapper;
import org.aspectj.org.eclipse.jdt.core.dom.DoStatement;
import org.aspectj.org.eclipse.jdt.core.dom.DocCommentParser;
import org.aspectj.org.eclipse.jdt.core.dom.EmptyStatement;
import org.aspectj.org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.aspectj.org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.EnumDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.Expression;
import org.aspectj.org.eclipse.jdt.core.dom.ExpressionStatement;
import org.aspectj.org.eclipse.jdt.core.dom.FieldAccess;
import org.aspectj.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ForStatement;
import org.aspectj.org.eclipse.jdt.core.dom.IfStatement;
import org.aspectj.org.eclipse.jdt.core.dom.ImportDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.InfixExpression;
import org.aspectj.org.eclipse.jdt.core.dom.Initializer;
import org.aspectj.org.eclipse.jdt.core.dom.InstanceofExpression;
import org.aspectj.org.eclipse.jdt.core.dom.Javadoc;
import org.aspectj.org.eclipse.jdt.core.dom.LabeledStatement;
import org.aspectj.org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.aspectj.org.eclipse.jdt.core.dom.MemberRef;
import org.aspectj.org.eclipse.jdt.core.dom.MemberValuePair;
import org.aspectj.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.MethodInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.MethodRef;
import org.aspectj.org.eclipse.jdt.core.dom.MethodRefParameter;
import org.aspectj.org.eclipse.jdt.core.dom.Modifier;
import org.aspectj.org.eclipse.jdt.core.dom.Name;
import org.aspectj.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.core.dom.NullLiteral;
import org.aspectj.org.eclipse.jdt.core.dom.NumberLiteral;
import org.aspectj.org.eclipse.jdt.core.dom.PackageDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.ParameterizedType;
import org.aspectj.org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.aspectj.org.eclipse.jdt.core.dom.PostfixExpression;
import org.aspectj.org.eclipse.jdt.core.dom.PrefixExpression;
import org.aspectj.org.eclipse.jdt.core.dom.PrimitiveType;
import org.aspectj.org.eclipse.jdt.core.dom.QualifiedName;
import org.aspectj.org.eclipse.jdt.core.dom.QualifiedType;
import org.aspectj.org.eclipse.jdt.core.dom.ReturnStatement;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleType;
import org.aspectj.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.Statement;
import org.aspectj.org.eclipse.jdt.core.dom.StringLiteral;
import org.aspectj.org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.aspectj.org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.aspectj.org.eclipse.jdt.core.dom.SwitchCase;
import org.aspectj.org.eclipse.jdt.core.dom.SwitchStatement;
import org.aspectj.org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.aspectj.org.eclipse.jdt.core.dom.TagElement;
import org.aspectj.org.eclipse.jdt.core.dom.ThisExpression;
import org.aspectj.org.eclipse.jdt.core.dom.ThrowStatement;
import org.aspectj.org.eclipse.jdt.core.dom.TryStatement;
import org.aspectj.org.eclipse.jdt.core.dom.Type;
import org.aspectj.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.aspectj.org.eclipse.jdt.core.dom.TypeLiteral;
import org.aspectj.org.eclipse.jdt.core.dom.TypeParameter;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.aspectj.org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.aspectj.org.eclipse.jdt.core.dom.WhileStatement;
import org.aspectj.org.eclipse.jdt.core.dom.WildcardType;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.IntLiteralMinValue;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocArgumentExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LongLiteralMinValue;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Reference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

class ASTConverter {
    protected AST ast;
    protected Comment[] commentsTable;
    char[] compilationUnitSource;
    protected DocCommentParser docParser;
    protected boolean insideComments;
    protected IProgressMonitor monitor;
    protected Set pendingNameScopeResolution;
    protected Set pendingThisExpressionScopeResolution;
    protected boolean resolveBindings;
    Scanner scanner;
    private DefaultCommentMapper commentMapper;

    public ASTConverter(Map options, boolean resolveBindings, IProgressMonitor monitor) {
        this.resolveBindings = resolveBindings;
        Object sourceModeSetting = options.get("org.aspectj.org.eclipse.jdt.core.compiler.source");
        long sourceLevel = 0x2F0000L;
        if ("1.4".equals(sourceModeSetting)) {
            sourceLevel = 0x300000L;
        } else if ("1.5".equals(sourceModeSetting)) {
            sourceLevel = 0x310000L;
        }
        this.scanner = new Scanner(true, false, false, sourceLevel, null, null, true);
        this.monitor = monitor;
        this.insideComments = "enabled".equals(options.get("org.aspectj.org.eclipse.jdt.core.compiler.doc.comment.support"));
    }

    protected void adjustSourcePositionsForParent(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        int start = expression.sourceStart;
        int end = expression.sourceEnd;
        int leftParentCount = 1;
        int rightParentCount = 0;
        this.scanner.resetTo(start, end);
        try {
            int token = this.scanner.getNextToken();
            expression.sourceStart = this.scanner.currentPosition;
            boolean stop = false;
            while (!stop && (token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 21: {
                        ++leftParentCount;
                        break;
                    }
                    case 30: {
                        if (++rightParentCount != leftParentCount) break;
                        stop = true;
                    }
                }
            }
            expression.sourceEnd = this.scanner.startPosition - 1;
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    protected void buildBodyDeclarations(org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration, AbstractTypeDeclaration typeDecl) {
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] members = typeDeclaration.memberTypes;
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields = typeDeclaration.fields;
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        int fieldsLength = fields == null ? 0 : fields.length;
        int methodsLength = methods == null ? 0 : methods.length;
        int membersLength = members == null ? 0 : members.length;
        int fieldsIndex = 0;
        int methodsIndex = 0;
        int membersIndex = 0;
        block5: while (fieldsIndex < fieldsLength || membersIndex < membersLength || methodsIndex < methodsLength) {
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldsIndex < fieldsLength) {
                nextFieldDeclaration = fields[fieldsIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodsIndex < methodsLength) {
                nextMethodDeclaration = methods[methodsIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (membersIndex < membersLength) {
                nextMemberDeclaration = members[membersIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    if (nextFieldDeclaration.getKind() == 3) {
                        typeDecl.bodyDeclarations().add(this.convert(nextFieldDeclaration));
                    } else {
                        this.checkAndAddMultipleFieldDeclaration(fields, fieldsIndex, typeDecl.bodyDeclarations());
                    }
                    ++fieldsIndex;
                    break;
                }
                case 1: {
                    ++methodsIndex;
                    if (nextMethodDeclaration.isDefaultConstructor() || nextMethodDeclaration.isClinit()) continue block5;
                    typeDecl.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                    break;
                }
                case 2: {
                    ++membersIndex;
                    ASTNode node = this.convert(nextMemberDeclaration);
                    if (node == null) {
                        typeDecl.setFlags(typeDecl.getFlags() | 1);
                        break;
                    }
                    typeDecl.bodyDeclarations().add(node);
                }
            }
        }
        this.convert(typeDeclaration.javadoc, typeDecl);
    }

    protected void buildBodyDeclarations(org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration enumDeclaration2, EnumDeclaration enumDeclaration) {
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] members = enumDeclaration2.memberTypes;
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields = enumDeclaration2.fields;
        AbstractMethodDeclaration[] methods = enumDeclaration2.methods;
        int fieldsLength = fields == null ? 0 : fields.length;
        int methodsLength = methods == null ? 0 : methods.length;
        int membersLength = members == null ? 0 : members.length;
        int fieldsIndex = 0;
        int methodsIndex = 0;
        int membersIndex = 0;
        block5: while (fieldsIndex < fieldsLength || membersIndex < membersLength || methodsIndex < methodsLength) {
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldsIndex < fieldsLength) {
                nextFieldDeclaration = fields[fieldsIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodsIndex < methodsLength) {
                nextMethodDeclaration = methods[methodsIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (membersIndex < membersLength) {
                nextMemberDeclaration = members[membersIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    if (nextFieldDeclaration.getKind() == 3) {
                        enumDeclaration.enumConstants().add(this.convert(nextFieldDeclaration));
                    } else {
                        this.checkAndAddMultipleFieldDeclaration(fields, fieldsIndex, enumDeclaration.bodyDeclarations());
                    }
                    ++fieldsIndex;
                    break;
                }
                case 1: {
                    ++methodsIndex;
                    if (nextMethodDeclaration.isDefaultConstructor() || nextMethodDeclaration.isClinit()) continue block5;
                    enumDeclaration.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                    break;
                }
                case 2: {
                    ++membersIndex;
                    enumDeclaration.bodyDeclarations().add(this.convert(nextMemberDeclaration));
                }
            }
        }
        this.convert(enumDeclaration2.javadoc, enumDeclaration);
    }

    protected void buildBodyDeclarations(org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration expression, AnonymousClassDeclaration anonymousClassDeclaration) {
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] members = expression.memberTypes;
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields = expression.fields;
        AbstractMethodDeclaration[] methods = expression.methods;
        int fieldsLength = fields == null ? 0 : fields.length;
        int methodsLength = methods == null ? 0 : methods.length;
        int membersLength = members == null ? 0 : members.length;
        int fieldsIndex = 0;
        int methodsIndex = 0;
        int membersIndex = 0;
        block5: while (fieldsIndex < fieldsLength || membersIndex < membersLength || methodsIndex < methodsLength) {
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldsIndex < fieldsLength) {
                nextFieldDeclaration = fields[fieldsIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodsIndex < methodsLength) {
                nextMethodDeclaration = methods[methodsIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (membersIndex < membersLength) {
                nextMemberDeclaration = members[membersIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    if (nextFieldDeclaration.getKind() == 3) {
                        anonymousClassDeclaration.bodyDeclarations().add(this.convert(nextFieldDeclaration));
                    } else {
                        this.checkAndAddMultipleFieldDeclaration(fields, fieldsIndex, anonymousClassDeclaration.bodyDeclarations());
                    }
                    ++fieldsIndex;
                    break;
                }
                case 1: {
                    ++methodsIndex;
                    if (nextMethodDeclaration.isDefaultConstructor() || nextMethodDeclaration.isClinit()) continue block5;
                    anonymousClassDeclaration.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                    break;
                }
                case 2: {
                    ++membersIndex;
                    ASTNode node = this.convert(nextMemberDeclaration);
                    if (node == null) {
                        anonymousClassDeclaration.setFlags(anonymousClassDeclaration.getFlags() | 1);
                        break;
                    }
                    anonymousClassDeclaration.bodyDeclarations().add(node);
                }
            }
        }
    }

    void buildCommentsTable(CompilationUnit compilationUnit, int[][] comments) {
        this.commentsTable = new Comment[comments.length];
        int nbr = 0;
        int i = 0;
        while (i < comments.length) {
            Comment comment = this.createComment(comments[i]);
            if (comment != null) {
                comment.setAlternateRoot(compilationUnit);
                this.commentsTable[nbr++] = comment;
            }
            ++i;
        }
        if (nbr < comments.length) {
            Comment[] newCommentsTable = new Comment[nbr];
            System.arraycopy(this.commentsTable, 0, newCommentsTable, 0, nbr);
            this.commentsTable = newCommentsTable;
        }
        compilationUnit.setCommentTable(this.commentsTable);
    }

    protected void checkAndAddMultipleFieldDeclaration(org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration[] fields, int index, List bodyDeclarations) {
        if (fields[index] instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer) {
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer oldInitializer = (org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer)fields[index];
            Initializer initializer = this.ast.newInitializer();
            initializer.setBody(this.convert(oldInitializer.block));
            this.setModifiers(initializer, oldInitializer);
            initializer.setSourceRange(oldInitializer.declarationSourceStart, oldInitializer.sourceEnd - oldInitializer.declarationSourceStart + 1);
            this.convert(oldInitializer.javadoc, initializer);
            bodyDeclarations.add(initializer);
            return;
        }
        if (index > 0 && fields[index - 1].declarationSourceStart == fields[index].declarationSourceStart) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclarations.get(bodyDeclarations.size() - 1);
            fieldDeclaration.fragments().add(this.convertToVariableDeclarationFragment(fields[index]));
        } else {
            bodyDeclarations.add(this.convertToFieldDeclaration(fields[index]));
        }
    }

    protected void checkAndAddMultipleLocalDeclaration(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement[] stmts, int index, List blockStatements) {
        if (index > 0 && stmts[index - 1] instanceof LocalDeclaration) {
            LocalDeclaration local1 = (LocalDeclaration)stmts[index - 1];
            LocalDeclaration local2 = (LocalDeclaration)stmts[index];
            if (local1.declarationSourceStart == local2.declarationSourceStart) {
                VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)blockStatements.get(blockStatements.size() - 1);
                variableDeclarationStatement.fragments().add(this.convertToVariableDeclarationFragment((LocalDeclaration)stmts[index]));
            } else {
                blockStatements.add(this.convertToVariableDeclarationStatement((LocalDeclaration)stmts[index]));
            }
        } else {
            blockStatements.add(this.convertToVariableDeclarationStatement((LocalDeclaration)stmts[index]));
        }
    }

    protected void checkCanceled() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void completeRecord(ArrayType arrayType, org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode astNode) {
        ArrayType array = arrayType;
        int dimensions = array.getDimensions();
        int i = 0;
        while (i < dimensions) {
            Type componentType = array.getComponentType();
            this.recordNodes(componentType, astNode);
            if (componentType.isArrayType()) {
                array = (ArrayType)componentType;
            }
            ++i;
        }
    }

    public ASTNode convert(AbstractMethodDeclaration methodDeclaration) {
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter[] typeParameters;
        Argument[] parameters;
        this.checkCanceled();
        if (methodDeclaration instanceof AnnotationMethodDeclaration) {
            return this.convert((AnnotationMethodDeclaration)methodDeclaration);
        }
        MethodDeclaration methodDecl = this.ast.newMethodDeclaration();
        this.setModifiers(methodDecl, methodDeclaration);
        boolean isConstructor = methodDeclaration.isConstructor();
        methodDecl.setConstructor(isConstructor);
        SimpleName methodName = this.ast.newSimpleName(new String(methodDeclaration.selector));
        int start = methodDeclaration.sourceStart;
        int end = this.retrieveIdentifierEndPosition(start, methodDeclaration.sourceEnd);
        methodName.setSourceRange(start, end - start + 1);
        methodDecl.setName(methodName);
        TypeReference[] thrownExceptions = methodDeclaration.thrownExceptions;
        if (thrownExceptions != null) {
            int thrownExceptionsLength = thrownExceptions.length;
            int i = 0;
            while (i < thrownExceptionsLength) {
                methodDecl.thrownExceptions().add(this.convert(thrownExceptions[i]));
                ++i;
            }
        }
        if ((parameters = methodDeclaration.arguments) != null) {
            int parametersLength = parameters.length;
            int i = 0;
            while (i < parametersLength) {
                methodDecl.parameters().add(this.convert(parameters[i]));
                ++i;
            }
        }
        ExplicitConstructorCall explicitConstructorCall = null;
        if (isConstructor) {
            ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)methodDeclaration;
            explicitConstructorCall = constructorDeclaration.constructorCall;
            switch (this.ast.apiLevel) {
                case 2: {
                    PrimitiveType returnType = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    returnType.setSourceRange(methodDeclaration.sourceStart, 0);
                    methodDecl.setReturnType(returnType);
                    break;
                }
                case 3: {
                    methodDecl.setReturnType2(null);
                }
            }
        } else if (methodDeclaration instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration) {
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration method = (org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration)methodDeclaration;
            TypeReference typeReference = method.returnType;
            if (typeReference != null) {
                Type returnType = this.convertType(typeReference);
                int rightParenthesisPosition = this.retrieveEndOfRightParenthesisPosition(end, method.bodyEnd);
                int extraDimensions = this.retrieveExtraDimension(rightParenthesisPosition, method.bodyEnd);
                methodDecl.setExtraDimensions(extraDimensions);
                this.setTypeForMethodDeclaration(methodDecl, returnType, extraDimensions);
            }
        }
        int declarationSourceStart = methodDeclaration.declarationSourceStart;
        int declarationSourceEnd = methodDeclaration.bodyEnd;
        methodDecl.setSourceRange(declarationSourceStart, declarationSourceEnd - declarationSourceStart + 1);
        int closingPosition = this.retrieveRightBraceOrSemiColonPosition(methodDeclaration.bodyEnd + 1, methodDeclaration.declarationSourceEnd);
        if (closingPosition != -1) {
            int startPosition = methodDecl.getStartPosition();
            methodDecl.setSourceRange(startPosition, closingPosition - startPosition + 1);
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement[] statements = methodDeclaration.statements;
            start = this.retrieveStartBlockPosition(methodDeclaration.sourceStart, declarationSourceEnd);
            end = this.retrieveEndBlockPosition(methodDeclaration.sourceStart, methodDeclaration.declarationSourceEnd);
            Block block = null;
            if (start != -1 && end != -1) {
                block = this.ast.newBlock();
                block.setSourceRange(start, end - start + 1);
                methodDecl.setBody(block);
            }
            if (block != null && (statements != null || explicitConstructorCall != null)) {
                if (explicitConstructorCall != null && explicitConstructorCall.accessMode != 1) {
                    block.statements().add(this.convert(explicitConstructorCall));
                }
                int statementsLength = statements == null ? 0 : statements.length;
                int i = 0;
                while (i < statementsLength) {
                    if (statements[i] instanceof LocalDeclaration) {
                        this.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                    } else {
                        block.statements().add(this.convert(statements[i]));
                    }
                    ++i;
                }
            }
            if (block != null && (Modifier.isAbstract(methodDecl.getModifiers()) || Modifier.isNative(methodDecl.getModifiers()))) {
                methodDecl.setFlags(methodDecl.getFlags() | 1);
            }
        } else if (!methodDeclaration.isNative() && !methodDeclaration.isAbstract()) {
            start = this.retrieveStartBlockPosition(methodDeclaration.sourceStart, declarationSourceEnd);
            end = methodDeclaration.bodyEnd;
            IProblem[] problems = methodDeclaration.compilationResult().problems;
            if (problems != null) {
                int i = 0;
                int max = methodDeclaration.compilationResult().problemCount;
                while (i < max) {
                    IProblem currentProblem = problems[i];
                    if (currentProblem.getSourceStart() == start && currentProblem.getID() == 0x600000F0) {
                        end = currentProblem.getSourceEnd();
                        break;
                    }
                    ++i;
                }
            }
            int startPosition = methodDecl.getStartPosition();
            methodDecl.setSourceRange(startPosition, end - startPosition + 1);
            if (start != -1 && end != -1) {
                Block block = this.ast.newBlock();
                block.setSourceRange(start, end - start + 1);
                methodDecl.setBody(block);
            }
        }
        if ((typeParameters = methodDeclaration.typeParameters()) != null) {
            switch (this.ast.apiLevel) {
                case 2: {
                    methodDecl.setFlags(methodDecl.getFlags() | 1);
                    break;
                }
                case 3: {
                    int i = 0;
                    int max = typeParameters.length;
                    while (i < max) {
                        methodDecl.typeParameters().add(this.convert(typeParameters[i]));
                        ++i;
                    }
                    break;
                }
            }
        }
        this.convert(methodDeclaration.javadoc, methodDecl);
        if (this.resolveBindings) {
            this.recordNodes(methodDecl, methodDeclaration);
            this.recordNodes(methodName, methodDeclaration);
            methodDecl.resolveBinding();
        }
        return methodDecl;
    }

    public ClassInstanceCreation convert(AllocationExpression expression) {
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        if (this.resolveBindings) {
            this.recordNodes(classInstanceCreation, expression);
        }
        if (expression.typeArguments != null) {
            switch (this.ast.apiLevel) {
                case 2: {
                    classInstanceCreation.setFlags(classInstanceCreation.getFlags() | 1);
                    break;
                }
                case 3: {
                    int i = 0;
                    int max = expression.typeArguments.length;
                    while (i < max) {
                        classInstanceCreation.typeArguments().add(this.convertType(expression.typeArguments[i]));
                        ++i;
                    }
                    break;
                }
            }
        }
        switch (this.ast.apiLevel) {
            case 2: {
                classInstanceCreation.setName(this.convert(expression.type));
                break;
            }
            case 3: {
                classInstanceCreation.setType(this.convertType(expression.type));
            }
        }
        classInstanceCreation.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = expression.arguments;
        if (arguments != null) {
            int length = arguments.length;
            int i = 0;
            while (i < length) {
                classInstanceCreation.arguments().add(this.convert(arguments[i]));
                ++i;
            }
        }
        this.removeTrailingCommentFromExpressionEndingWithAParen(classInstanceCreation);
        return classInstanceCreation;
    }

    public Expression convert(AND_AND_Expression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return infixExpression;
    }

    public AnnotationTypeDeclaration convertToAnnotationDeclaration(org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration) {
        this.checkCanceled();
        AnnotationTypeDeclaration typeDecl = this.ast.newAnnotationTypeDeclaration();
        this.setModifiers(typeDecl, typeDeclaration);
        SimpleName typeName = this.ast.newSimpleName(new String(typeDeclaration.name));
        typeName.setSourceRange(typeDeclaration.sourceStart, typeDeclaration.sourceEnd - typeDeclaration.sourceStart + 1);
        typeDecl.setName(typeName);
        typeDecl.setSourceRange(typeDeclaration.declarationSourceStart, typeDeclaration.bodyEnd - typeDeclaration.declarationSourceStart + 1);
        this.buildBodyDeclarations(typeDeclaration, typeDecl);
        if (this.resolveBindings) {
            this.recordNodes(typeDecl, typeDeclaration);
            this.recordNodes(typeName, typeDeclaration);
            typeDecl.resolveBinding();
        }
        return typeDecl;
    }

    public ASTNode convert(AnnotationMethodDeclaration annotationTypeMemberDeclaration) {
        this.checkCanceled();
        if (this.ast.apiLevel == 2) {
            return null;
        }
        AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration2 = this.ast.newAnnotationTypeMemberDeclaration();
        this.setModifiers(annotationTypeMemberDeclaration2, annotationTypeMemberDeclaration);
        SimpleName methodName = this.ast.newSimpleName(new String(annotationTypeMemberDeclaration.selector));
        int start = annotationTypeMemberDeclaration.sourceStart;
        int end = this.retrieveIdentifierEndPosition(start, annotationTypeMemberDeclaration.sourceEnd);
        methodName.setSourceRange(start, end - start + 1);
        annotationTypeMemberDeclaration2.setName(methodName);
        TypeReference typeReference = annotationTypeMemberDeclaration.returnType;
        if (typeReference != null) {
            Type returnType = this.convertType(typeReference);
            this.setTypeForMethodDeclaration(annotationTypeMemberDeclaration2, returnType, 0);
        }
        int declarationSourceStart = annotationTypeMemberDeclaration.declarationSourceStart;
        int declarationSourceEnd = annotationTypeMemberDeclaration.bodyEnd;
        annotationTypeMemberDeclaration2.setSourceRange(declarationSourceStart, declarationSourceEnd - declarationSourceStart + 1);
        this.convert(annotationTypeMemberDeclaration.javadoc, annotationTypeMemberDeclaration2);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression memberValue = annotationTypeMemberDeclaration.defaultValue;
        if (memberValue != null) {
            annotationTypeMemberDeclaration2.setDefault(this.convert(memberValue));
        }
        if (this.resolveBindings) {
            this.recordNodes(annotationTypeMemberDeclaration2, annotationTypeMemberDeclaration);
            this.recordNodes(methodName, annotationTypeMemberDeclaration);
            annotationTypeMemberDeclaration2.resolveBinding();
        }
        return annotationTypeMemberDeclaration2;
    }

    public SingleVariableDeclaration convert(Argument argument) {
        SingleVariableDeclaration variableDecl = this.ast.newSingleVariableDeclaration();
        this.setModifiers(variableDecl, argument);
        SimpleName name = this.ast.newSimpleName(new String(argument.name));
        int start = argument.sourceStart;
        int nameEnd = argument.sourceEnd;
        name.setSourceRange(start, nameEnd - start + 1);
        variableDecl.setName(name);
        int typeSourceEnd = argument.type.sourceEnd;
        int extraDimensions = this.retrieveExtraDimension(nameEnd + 1, typeSourceEnd);
        variableDecl.setExtraDimensions(extraDimensions);
        boolean isVarArgs = argument.isVarArgs();
        if (isVarArgs && extraDimensions == 0) {
            argument.type.sourceEnd = this.retrieveEllipsisStartPosition(argument.type.sourceStart, typeSourceEnd);
        }
        Type type = this.convertType(argument.type);
        int typeEnd = type.getStartPosition() + type.getLength() - 1;
        int rightEnd = Math.max(typeEnd, argument.declarationSourceEnd);
        if (isVarArgs) {
            this.setTypeForSingleVariableDeclaration(variableDecl, type, extraDimensions + 1);
        } else {
            this.setTypeForSingleVariableDeclaration(variableDecl, type, extraDimensions);
        }
        variableDecl.setSourceRange(argument.declarationSourceStart, rightEnd - argument.declarationSourceStart + 1);
        if (isVarArgs) {
            switch (this.ast.apiLevel) {
                case 2: {
                    variableDecl.setFlags(variableDecl.getFlags() | 1);
                    break;
                }
                case 3: {
                    variableDecl.setVarargs(true);
                }
            }
        }
        if (this.resolveBindings) {
            this.recordNodes(name, argument);
            this.recordNodes(variableDecl, argument);
            variableDecl.resolveBinding();
        }
        return variableDecl;
    }

    public Annotation convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation annotation) {
        if (annotation instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation)annotation);
        }
        if (annotation instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation)annotation);
        }
        return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.NormalAnnotation)annotation);
    }

    public ArrayCreation convert(ArrayAllocationExpression expression) {
        ArrayCreation arrayCreation = this.ast.newArrayCreation();
        if (this.resolveBindings) {
            this.recordNodes(arrayCreation, expression);
        }
        arrayCreation.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] dimensions = expression.dimensions;
        int dimensionsLength = dimensions.length;
        int i = 0;
        while (i < dimensionsLength) {
            if (dimensions[i] != null) {
                Expression dimension = this.convert(dimensions[i]);
                if (this.resolveBindings) {
                    this.recordNodes(dimension, dimensions[i]);
                }
                arrayCreation.dimensions().add(dimension);
            }
            ++i;
        }
        Type type = this.convertType(expression.type);
        if (this.resolveBindings) {
            this.recordNodes(type, expression.type);
        }
        ArrayType arrayType = null;
        if (type.isArrayType()) {
            arrayType = (ArrayType)type;
        } else {
            int end;
            arrayType = this.ast.newArrayType(type, dimensionsLength);
            if (this.resolveBindings) {
                this.completeRecord(arrayType, expression);
            }
            int start = type.getStartPosition();
            int previousSearchStart = end = type.getStartPosition() + type.getLength();
            ArrayType componentType = (ArrayType)type.getParent();
            int i2 = 0;
            while (i2 < dimensionsLength) {
                previousSearchStart = this.retrieveRightBracketPosition(previousSearchStart + 1, this.compilationUnitSource.length);
                componentType.setSourceRange(start, previousSearchStart - start + 1);
                componentType = (ArrayType)componentType.getParent();
                ++i2;
            }
        }
        arrayCreation.setType(arrayType);
        if (this.resolveBindings) {
            this.recordNodes(arrayType, expression);
        }
        if (expression.initializer != null) {
            arrayCreation.setInitializer(this.convert(expression.initializer));
        }
        return arrayCreation;
    }

    public ArrayInitializer convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer expression) {
        ArrayInitializer arrayInitializer = this.ast.newArrayInitializer();
        if (this.resolveBindings) {
            this.recordNodes(arrayInitializer, expression);
        }
        arrayInitializer.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] expressions = expression.expressions;
        if (expressions != null) {
            int length = expressions.length;
            int i = 0;
            while (i < length) {
                Expression expr = this.convert(expressions[i]);
                if (this.resolveBindings) {
                    this.recordNodes(expr, expressions[i]);
                }
                arrayInitializer.expressions().add(expr);
                ++i;
            }
        }
        return arrayInitializer;
    }

    public ArrayAccess convert(ArrayReference reference) {
        ArrayAccess arrayAccess = this.ast.newArrayAccess();
        if (this.resolveBindings) {
            this.recordNodes(arrayAccess, reference);
        }
        arrayAccess.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        arrayAccess.setArray(this.convert(reference.receiver));
        arrayAccess.setIndex(this.convert(reference.position));
        return arrayAccess;
    }

    public AssertStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.AssertStatement statement) {
        AssertStatement assertStatement = this.ast.newAssertStatement();
        int end = statement.assertExpression.sourceEnd + 1;
        assertStatement.setExpression(this.convert(statement.assertExpression));
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression exceptionArgument = statement.exceptionArgument;
        if (exceptionArgument != null) {
            assertStatement.setMessage(this.convert(exceptionArgument));
            end = exceptionArgument.sourceEnd + 1;
        }
        int start = statement.sourceStart;
        int sourceEnd = this.retrieveEndingSemiColonPosition(end, this.compilationUnitSource.length);
        assertStatement.setSourceRange(start, sourceEnd - start + 1);
        return assertStatement;
    }

    public Assignment convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Assignment expression) {
        Assignment assignment = this.ast.newAssignment();
        if (this.resolveBindings) {
            this.recordNodes(assignment, expression);
        }
        Expression lhs = this.convert(expression.lhs);
        assignment.setLeftHandSide(lhs);
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setRightHandSide(this.convert(expression.expression));
        int start = lhs.getStartPosition();
        assignment.setSourceRange(start, expression.sourceEnd - start + 1);
        return assignment;
    }

    public TypeDeclaration convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode[] nodes) {
        TypeDeclaration typeDecl = this.ast.newTypeDeclaration();
        int nodesLength = nodes.length;
        int i = 0;
        while (i < nodesLength) {
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode node = nodes[i];
            if (node instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer) {
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer oldInitializer = (org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer)node;
                Initializer initializer = this.ast.newInitializer();
                initializer.setBody(this.convert(oldInitializer.block));
                this.setModifiers(initializer, oldInitializer);
                initializer.setSourceRange(oldInitializer.declarationSourceStart, oldInitializer.sourceEnd - oldInitializer.declarationSourceStart + 1);
                this.convert(oldInitializer.javadoc, initializer);
                typeDecl.bodyDeclarations().add(initializer);
            } else if (node instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration) {
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fieldDeclaration = (org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration)node;
                if (i > 0 && nodes[i - 1] instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration && ((org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration)nodes[i - 1]).declarationSourceStart == fieldDeclaration.declarationSourceStart) {
                    FieldDeclaration currentFieldDeclaration = (FieldDeclaration)typeDecl.bodyDeclarations().get(typeDecl.bodyDeclarations().size() - 1);
                    currentFieldDeclaration.fragments().add(this.convertToVariableDeclarationFragment(fieldDeclaration));
                } else {
                    typeDecl.bodyDeclarations().add(this.convertToFieldDeclaration(fieldDeclaration));
                }
            } else if (node instanceof AbstractMethodDeclaration) {
                AbstractMethodDeclaration nextMethodDeclaration = (AbstractMethodDeclaration)node;
                if (!nextMethodDeclaration.isDefaultConstructor() && !nextMethodDeclaration.isClinit()) {
                    typeDecl.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                }
            } else if (node instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration) {
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration nextMemberDeclaration = (org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)node;
                ASTNode nextMemberDeclarationNode = this.convert(nextMemberDeclaration);
                if (nextMemberDeclarationNode == null) {
                    typeDecl.setFlags(typeDecl.getFlags() | 1);
                } else {
                    typeDecl.bodyDeclarations().add(nextMemberDeclarationNode);
                }
            }
            ++i;
        }
        return typeDecl;
    }

    public Expression convert(BinaryExpression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        int expressionOperatorID = (expression.bits & 0xFC0) >> 6;
        switch (expressionOperatorID) {
            case 18: {
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                break;
            }
            case 5: {
                infixExpression.setOperator(InfixExpression.Operator.LESS_EQUALS);
                break;
            }
            case 7: {
                infixExpression.setOperator(InfixExpression.Operator.GREATER_EQUALS);
                break;
            }
            case 29: {
                infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
                break;
            }
            case 10: {
                infixExpression.setOperator(InfixExpression.Operator.LEFT_SHIFT);
                break;
            }
            case 17: {
                infixExpression.setOperator(InfixExpression.Operator.RIGHT_SHIFT_SIGNED);
                break;
            }
            case 19: {
                infixExpression.setOperator(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED);
                break;
            }
            case 1: {
                infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
                break;
            }
            case 0: {
                infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
                break;
            }
            case 14: {
                infixExpression.setOperator(InfixExpression.Operator.PLUS);
                break;
            }
            case 13: {
                infixExpression.setOperator(InfixExpression.Operator.MINUS);
                break;
            }
            case 16: {
                infixExpression.setOperator(InfixExpression.Operator.REMAINDER);
                break;
            }
            case 8: {
                infixExpression.setOperator(InfixExpression.Operator.XOR);
                break;
            }
            case 2: {
                infixExpression.setOperator(InfixExpression.Operator.AND);
                break;
            }
            case 15: {
                infixExpression.setOperator(InfixExpression.Operator.TIMES);
                break;
            }
            case 3: {
                infixExpression.setOperator(InfixExpression.Operator.OR);
                break;
            }
            case 9: {
                infixExpression.setOperator(InfixExpression.Operator.DIVIDE);
                break;
            }
            case 6: {
                infixExpression.setOperator(InfixExpression.Operator.GREATER);
                break;
            }
            case 4: {
                infixExpression.setOperator(InfixExpression.Operator.LESS);
            }
        }
        if (expression.left instanceof BinaryExpression && (expression.left.bits & 0x1FE00000) == 0) {
            infixExpression.extendedOperands().add(this.convert(expression.right));
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression leftOperand = expression.left;
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression rightOperand = null;
            do {
                rightOperand = ((BinaryExpression)leftOperand).right;
                if ((leftOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (leftOperand.bits & 0x1FE00000) == 0 || rightOperand instanceof BinaryExpression && (rightOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (rightOperand.bits & 0x1FE00000) == 0) {
                    List extendedOperands = infixExpression.extendedOperands();
                    InfixExpression temp = this.ast.newInfixExpression();
                    if (this.resolveBindings) {
                        this.recordNodes(temp, expression);
                    }
                    temp.setOperator(this.getOperatorFor(expressionOperatorID));
                    Expression leftSide = this.convert(leftOperand);
                    temp.setLeftOperand(leftSide);
                    temp.setSourceRange(leftSide.getStartPosition(), leftSide.getLength());
                    int size = extendedOperands.size();
                    int i = 0;
                    while (i < size - 1) {
                        InfixExpression expr = temp;
                        temp = this.ast.newInfixExpression();
                        if (this.resolveBindings) {
                            this.recordNodes(temp, expression);
                        }
                        temp.setLeftOperand(expr);
                        temp.setOperator(this.getOperatorFor(expressionOperatorID));
                        temp.setSourceRange(expr.getStartPosition(), expr.getLength());
                        ++i;
                    }
                    infixExpression = temp;
                    i = 0;
                    while (i < size) {
                        Expression extendedOperand = (Expression)extendedOperands.remove(size - 1 - i);
                        temp.setRightOperand(extendedOperand);
                        int startPosition = temp.getLeftOperand().getStartPosition();
                        temp.setSourceRange(startPosition, extendedOperand.getStartPosition() + extendedOperand.getLength() - startPosition);
                        if (temp.getLeftOperand().getNodeType() == 27) {
                            temp = (InfixExpression)temp.getLeftOperand();
                        }
                        ++i;
                    }
                    int startPosition = infixExpression.getLeftOperand().getStartPosition();
                    infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
                    if (this.resolveBindings) {
                        this.recordNodes(infixExpression, expression);
                    }
                    return infixExpression;
                }
                infixExpression.extendedOperands().add(0, this.convert(rightOperand));
            } while ((leftOperand = ((BinaryExpression)leftOperand).left) instanceof BinaryExpression && (leftOperand.bits & 0x1FE00000) == 0);
            Expression leftExpression = this.convert(leftOperand);
            infixExpression.setLeftOperand(leftExpression);
            infixExpression.setRightOperand((Expression)infixExpression.extendedOperands().remove(0));
            int startPosition = leftExpression.getStartPosition();
            infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
            return infixExpression;
        }
        if (expression.left instanceof StringLiteralConcatenation && (expression.left.bits & 0x1FE00000) == 0) {
            StringLiteralConcatenation literal = (StringLiteralConcatenation)expression.left;
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] stringLiterals = literal.literals;
            infixExpression.setLeftOperand(this.convert(stringLiterals[0]));
            infixExpression.setRightOperand(this.convert(stringLiterals[1]));
            int i = 2;
            while (i < literal.counter) {
                infixExpression.extendedOperands().add(this.convert(stringLiterals[i]));
                ++i;
            }
            infixExpression.extendedOperands().add(this.convert(expression.right));
            int startPosition = literal.sourceStart;
            infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
            return infixExpression;
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return infixExpression;
    }

    public Block convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Block statement) {
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement[] statements;
        Block block = this.ast.newBlock();
        if (statement.sourceEnd > 0) {
            block.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        }
        if ((statements = statement.statements) != null) {
            int statementsLength = statements.length;
            int i = 0;
            while (i < statementsLength) {
                if (statements[i] instanceof LocalDeclaration) {
                    this.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                } else {
                    block.statements().add(this.convert(statements[i]));
                }
                ++i;
            }
        }
        return block;
    }

    public BreakStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.BreakStatement statement) {
        BreakStatement breakStatement = this.ast.newBreakStatement();
        breakStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.label != null) {
            SimpleName name = this.ast.newSimpleName(new String(statement.label));
            this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
            breakStatement.setLabel(name);
        }
        this.retrieveSemiColonPosition(breakStatement);
        return breakStatement;
    }

    public SwitchCase convert(CaseStatement statement) {
        SwitchCase switchCase = this.ast.newSwitchCase();
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression constantExpression = statement.constantExpression;
        if (constantExpression == null) {
            switchCase.setExpression(null);
        } else {
            switchCase.setExpression(this.convert(constantExpression));
        }
        switchCase.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        this.retrieveColonPosition(switchCase);
        return switchCase;
    }

    public CastExpression convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.CastExpression expression) {
        CastExpression castExpression = this.ast.newCastExpression();
        castExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression type = expression.type;
        this.trimWhiteSpacesAndComments(type);
        if (type instanceof TypeReference) {
            castExpression.setType(this.convertType((TypeReference)type));
        } else if (type instanceof NameReference) {
            castExpression.setType(this.convertToType((NameReference)type));
        }
        castExpression.setExpression(this.convert(expression.expression));
        if (this.resolveBindings) {
            this.recordNodes(castExpression, expression);
        }
        return castExpression;
    }

    public CharacterLiteral convert(CharLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        CharacterLiteral literal = this.ast.newCharacterLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setEscapedValue(new String(tokens));
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public Expression convert(ClassLiteralAccess expression) {
        TypeLiteral typeLiteral = this.ast.newTypeLiteral();
        if (this.resolveBindings) {
            this.recordNodes(typeLiteral, expression);
        }
        typeLiteral.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        typeLiteral.setType(this.convertType(expression.type));
        return typeLiteral;
    }

    public CompilationUnit convert(CompilationUnitDeclaration unit, char[] source) {
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] types;
        int[][] comments;
        ImportReference[] imports;
        this.compilationUnitSource = source;
        this.scanner.setSource(unit.compilationResult);
        CompilationUnit compilationUnit = this.ast.newCompilationUnit();
        if (this.resolveBindings) {
            this.recordNodes(compilationUnit, unit);
        }
        if (unit.currentPackage != null) {
            PackageDeclaration packageDeclaration = this.convertPackage(unit);
            compilationUnit.setPackage(packageDeclaration);
        }
        if ((imports = unit.imports) != null) {
            int importLength = imports.length;
            int i = 0;
            while (i < importLength) {
                compilationUnit.imports().add(this.convertImport(imports[i]));
                ++i;
            }
        }
        if ((comments = unit.comments) != null) {
            this.buildCommentsTable(compilationUnit, comments);
        }
        if ((types = unit.types) != null) {
            int typesLength = types.length;
            int i = 0;
            while (i < typesLength) {
                ASTNode type = this.convert(types[i]);
                if (type == null) {
                    compilationUnit.setFlags(compilationUnit.getFlags() | 1);
                } else {
                    compilationUnit.types().add(type);
                }
                ++i;
            }
        }
        compilationUnit.setSourceRange(unit.sourceStart, unit.sourceEnd - unit.sourceStart + 1);
        int problemLength = unit.compilationResult.problemCount;
        if (problemLength != 0) {
            IProblem[] resizedProblems = null;
            IProblem[] problems = unit.compilationResult.problems;
            if (problems.length == problemLength) {
                resizedProblems = problems;
            } else {
                resizedProblems = new IProblem[problemLength];
                System.arraycopy(problems, 0, resizedProblems, 0, problemLength);
            }
            ASTSyntaxErrorPropagator syntaxErrorPropagator = new ASTSyntaxErrorPropagator(resizedProblems);
            compilationUnit.accept(syntaxErrorPropagator);
            compilationUnit.setProblems(resizedProblems);
        }
        if (this.resolveBindings) {
            this.lookupForScopes();
        }
        compilationUnit.initCommentMapper(this.scanner);
        return compilationUnit;
    }

    public Assignment convert(CompoundAssignment expression) {
        Assignment assignment = this.ast.newAssignment();
        Expression lhs = this.convert(expression.lhs);
        assignment.setLeftHandSide(lhs);
        int start = lhs.getStartPosition();
        assignment.setSourceRange(start, expression.sourceEnd - start + 1);
        switch (expression.operator) {
            case 14: {
                assignment.setOperator(Assignment.Operator.PLUS_ASSIGN);
                break;
            }
            case 13: {
                assignment.setOperator(Assignment.Operator.MINUS_ASSIGN);
                break;
            }
            case 15: {
                assignment.setOperator(Assignment.Operator.TIMES_ASSIGN);
                break;
            }
            case 9: {
                assignment.setOperator(Assignment.Operator.DIVIDE_ASSIGN);
                break;
            }
            case 2: {
                assignment.setOperator(Assignment.Operator.BIT_AND_ASSIGN);
                break;
            }
            case 3: {
                assignment.setOperator(Assignment.Operator.BIT_OR_ASSIGN);
                break;
            }
            case 8: {
                assignment.setOperator(Assignment.Operator.BIT_XOR_ASSIGN);
                break;
            }
            case 16: {
                assignment.setOperator(Assignment.Operator.REMAINDER_ASSIGN);
                break;
            }
            case 10: {
                assignment.setOperator(Assignment.Operator.LEFT_SHIFT_ASSIGN);
                break;
            }
            case 17: {
                assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN);
                break;
            }
            case 19: {
                assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN);
            }
        }
        assignment.setRightHandSide(this.convert(expression.expression));
        return assignment;
    }

    public ConditionalExpression convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConditionalExpression expression) {
        ConditionalExpression conditionalExpression = this.ast.newConditionalExpression();
        if (this.resolveBindings) {
            this.recordNodes(conditionalExpression, expression);
        }
        conditionalExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        conditionalExpression.setExpression(this.convert(expression.condition));
        conditionalExpression.setThenExpression(this.convert(expression.valueIfTrue));
        conditionalExpression.setElseExpression(this.convert(expression.valueIfFalse));
        return conditionalExpression;
    }

    public ContinueStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.ContinueStatement statement) {
        ContinueStatement continueStatement = this.ast.newContinueStatement();
        continueStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.label != null) {
            SimpleName name = this.ast.newSimpleName(new String(statement.label));
            this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
            continueStatement.setLabel(name);
        }
        this.retrieveSemiColonPosition(continueStatement);
        return continueStatement;
    }

    public DoStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.DoStatement statement) {
        DoStatement doStatement = this.ast.newDoStatement();
        doStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        doStatement.setExpression(this.convert(statement.condition));
        doStatement.setBody(this.convert(statement.action));
        this.retrieveSemiColonPosition(doStatement);
        return doStatement;
    }

    public NumberLiteral convert(DoubleLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public EmptyStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.EmptyStatement statement) {
        EmptyStatement emptyStatement = this.ast.newEmptyStatement();
        emptyStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        return emptyStatement;
    }

    public EnumConstantDeclaration convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration enumConstant) {
        this.checkCanceled();
        EnumConstantDeclaration enumConstantDeclaration = this.ast.newEnumConstantDeclaration();
        SimpleName typeName = this.ast.newSimpleName(new String(enumConstant.name));
        typeName.setSourceRange(enumConstant.sourceStart, enumConstant.sourceEnd - enumConstant.sourceStart + 1);
        enumConstantDeclaration.setName(typeName);
        int declarationSourceStart = enumConstant.declarationSourceStart;
        int declarationSourceEnd = enumConstant.declarationSourceEnd;
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression initialization = enumConstant.initialization;
        if (initialization != null) {
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] arguments;
            if (initialization instanceof QualifiedAllocationExpression) {
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration anonymousType = ((QualifiedAllocationExpression)initialization).anonymousType;
                if (anonymousType != null) {
                    AnonymousClassDeclaration anonymousClassDeclaration = this.ast.newAnonymousClassDeclaration();
                    int start = this.retrieveStartBlockPosition(anonymousType.sourceEnd, anonymousType.bodyEnd);
                    int end = this.retrieveRightBrace(anonymousType.bodyEnd, declarationSourceEnd);
                    anonymousClassDeclaration.setSourceRange(start, end - start + 1);
                    enumConstantDeclaration.setAnonymousClassDeclaration(anonymousClassDeclaration);
                    this.buildBodyDeclarations(anonymousType, anonymousClassDeclaration);
                    if (this.resolveBindings) {
                        this.recordNodes(anonymousClassDeclaration, anonymousType);
                        anonymousClassDeclaration.resolveBinding();
                    }
                    enumConstantDeclaration.setSourceRange(declarationSourceStart, end - declarationSourceStart + 1);
                }
            } else {
                enumConstantDeclaration.setSourceRange(declarationSourceStart, declarationSourceEnd - declarationSourceStart + 1);
            }
            if ((arguments = ((AllocationExpression)initialization).arguments) != null) {
                int i = 0;
                int max = arguments.length;
                while (i < max) {
                    enumConstantDeclaration.arguments().add(this.convert(arguments[i]));
                    ++i;
                }
            }
        } else {
            enumConstantDeclaration.setSourceRange(declarationSourceStart, declarationSourceEnd - declarationSourceStart + 1);
        }
        if (this.resolveBindings) {
            this.recordNodes(enumConstantDeclaration, enumConstant);
            this.recordNodes(typeName, enumConstant);
            enumConstantDeclaration.resolveVariable();
        }
        return enumConstantDeclaration;
    }

    public Expression convert(EqualExpression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        switch ((expression.bits & 0xFC0) >> 6) {
            case 18: {
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                break;
            }
            case 29: {
                infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
            }
        }
        return infixExpression;
    }

    public Statement convert(ExplicitConstructorCall statement) {
        Statement newStatement;
        int sourceStart = statement.sourceStart;
        if (statement.isSuperAccess() || statement.isSuper()) {
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] arguments;
            SuperConstructorInvocation superConstructorInvocation = this.ast.newSuperConstructorInvocation();
            if (statement.qualification != null) {
                superConstructorInvocation.setExpression(this.convert(statement.qualification));
            }
            if ((arguments = statement.arguments) != null) {
                int length = arguments.length;
                int i = 0;
                while (i < length) {
                    superConstructorInvocation.arguments().add(this.convert(arguments[i]));
                    ++i;
                }
            }
            if (statement.typeArguments != null) {
                sourceStart = statement.typeArgumentsSourceStart;
                switch (this.ast.apiLevel) {
                    case 2: {
                        superConstructorInvocation.setFlags(superConstructorInvocation.getFlags() | 1);
                        break;
                    }
                    case 3: {
                        int i = 0;
                        int max = statement.typeArguments.length;
                        while (i < max) {
                            superConstructorInvocation.typeArguments().add(this.convertType(statement.typeArguments[i]));
                            ++i;
                        }
                        break;
                    }
                }
            }
            newStatement = superConstructorInvocation;
        } else {
            ConstructorInvocation constructorInvocation = this.ast.newConstructorInvocation();
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = statement.arguments;
            if (arguments != null) {
                int length = arguments.length;
                int i = 0;
                while (i < length) {
                    constructorInvocation.arguments().add(this.convert(arguments[i]));
                    ++i;
                }
            }
            if (statement.typeArguments != null) {
                sourceStart = statement.typeArgumentsSourceStart;
                switch (this.ast.apiLevel) {
                    case 2: {
                        constructorInvocation.setFlags(constructorInvocation.getFlags() | 1);
                        break;
                    }
                    case 3: {
                        int i = 0;
                        int max = statement.typeArguments.length;
                        while (i < max) {
                            constructorInvocation.typeArguments().add(this.convertType(statement.typeArguments[i]));
                            ++i;
                        }
                        break;
                    }
                }
            }
            newStatement = constructorInvocation;
        }
        newStatement.setSourceRange(sourceStart, statement.sourceEnd - sourceStart + 1);
        this.retrieveSemiColonPosition(newStatement);
        if (this.resolveBindings) {
            this.recordNodes(newStatement, statement);
        }
        return newStatement;
    }

    public Expression convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        if ((expression.bits & 0x1FE00000) != 0) {
            return this.convertToParenthesizedExpression(expression);
        }
        if (expression instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation)expression);
        }
        if (expression instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.CastExpression) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.CastExpression)expression);
        }
        if (expression instanceof ArrayAllocationExpression) {
            return this.convert((ArrayAllocationExpression)expression);
        }
        if (expression instanceof QualifiedAllocationExpression) {
            return this.convert((QualifiedAllocationExpression)expression);
        }
        if (expression instanceof AllocationExpression) {
            return this.convert((AllocationExpression)expression);
        }
        if (expression instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer)expression);
        }
        if (expression instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.PrefixExpression) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.PrefixExpression)expression);
        }
        if (expression instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.PostfixExpression) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.PostfixExpression)expression);
        }
        if (expression instanceof CompoundAssignment) {
            return this.convert((CompoundAssignment)expression);
        }
        if (expression instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.Assignment) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.Assignment)expression);
        }
        if (expression instanceof ClassLiteralAccess) {
            return this.convert((ClassLiteralAccess)expression);
        }
        if (expression instanceof FalseLiteral) {
            return this.convert((FalseLiteral)expression);
        }
        if (expression instanceof TrueLiteral) {
            return this.convert((TrueLiteral)expression);
        }
        if (expression instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.NullLiteral) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.NullLiteral)expression);
        }
        if (expression instanceof CharLiteral) {
            return this.convert((CharLiteral)expression);
        }
        if (expression instanceof DoubleLiteral) {
            return this.convert((DoubleLiteral)expression);
        }
        if (expression instanceof FloatLiteral) {
            return this.convert((FloatLiteral)expression);
        }
        if (expression instanceof IntLiteralMinValue) {
            return this.convert((IntLiteralMinValue)expression);
        }
        if (expression instanceof IntLiteral) {
            return this.convert((IntLiteral)expression);
        }
        if (expression instanceof LongLiteralMinValue) {
            return this.convert((LongLiteralMinValue)expression);
        }
        if (expression instanceof LongLiteral) {
            return this.convert((LongLiteral)expression);
        }
        if (expression instanceof StringLiteralConcatenation) {
            return this.convert((StringLiteralConcatenation)expression);
        }
        if (expression instanceof ExtendedStringLiteral) {
            return this.convert((ExtendedStringLiteral)expression);
        }
        if (expression instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteral) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteral)expression);
        }
        if (expression instanceof AND_AND_Expression) {
            return this.convert((AND_AND_Expression)expression);
        }
        if (expression instanceof OR_OR_Expression) {
            return this.convert((OR_OR_Expression)expression);
        }
        if (expression instanceof EqualExpression) {
            return this.convert((EqualExpression)expression);
        }
        if (expression instanceof BinaryExpression) {
            return this.convert((BinaryExpression)expression);
        }
        if (expression instanceof InstanceOfExpression) {
            return this.convert((InstanceOfExpression)expression);
        }
        if (expression instanceof UnaryExpression) {
            return this.convert((UnaryExpression)expression);
        }
        if (expression instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConditionalExpression) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConditionalExpression)expression);
        }
        if (expression instanceof MessageSend) {
            return this.convert((MessageSend)expression);
        }
        if (expression instanceof Reference) {
            return this.convert((Reference)expression);
        }
        if (expression instanceof TypeReference) {
            return this.convert((TypeReference)expression);
        }
        return null;
    }

    public StringLiteral convert(ExtendedStringLiteral expression) {
        expression.computeConstant();
        StringLiteral literal = this.ast.newStringLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setLiteralValue(expression.constant.stringValue());
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public BooleanLiteral convert(FalseLiteral expression) {
        BooleanLiteral literal = this.ast.newBooleanLiteral(false);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public Expression convert(FieldReference reference) {
        if (reference.receiver.isSuper()) {
            SuperFieldAccess superFieldAccess = this.ast.newSuperFieldAccess();
            if (this.resolveBindings) {
                this.recordNodes(superFieldAccess, reference);
            }
            if (reference.receiver instanceof QualifiedSuperReference) {
                Name qualifier = this.convert((QualifiedSuperReference)reference.receiver);
                superFieldAccess.setQualifier(qualifier);
                if (this.resolveBindings) {
                    this.recordNodes(qualifier, reference.receiver);
                }
            }
            SimpleName simpleName = this.ast.newSimpleName(new String(reference.token));
            int sourceStart = (int)(reference.nameSourcePosition >>> 32);
            int length = (int)(reference.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
            simpleName.setSourceRange(sourceStart, length);
            superFieldAccess.setName(simpleName);
            if (this.resolveBindings) {
                this.recordNodes(simpleName, reference);
            }
            superFieldAccess.setSourceRange(reference.receiver.sourceStart, reference.sourceEnd - reference.receiver.sourceStart + 1);
            return superFieldAccess;
        }
        FieldAccess fieldAccess = this.ast.newFieldAccess();
        if (this.resolveBindings) {
            this.recordNodes(fieldAccess, reference);
        }
        Expression receiver = this.convert(reference.receiver);
        fieldAccess.setExpression(receiver);
        SimpleName simpleName = this.ast.newSimpleName(new String(reference.token));
        int sourceStart = (int)(reference.nameSourcePosition >>> 32);
        int length = (int)(reference.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
        simpleName.setSourceRange(sourceStart, length);
        fieldAccess.setName(simpleName);
        if (this.resolveBindings) {
            this.recordNodes(simpleName, reference);
        }
        fieldAccess.setSourceRange(receiver.getStartPosition(), reference.sourceEnd - receiver.getStartPosition() + 1);
        return fieldAccess;
    }

    public NumberLiteral convert(FloatLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public Statement convert(ForeachStatement statement) {
        switch (this.ast.apiLevel) {
            case 2: {
                return this.createFakeEmptyStatement(statement);
            }
            case 3: {
                EnhancedForStatement enhancedForStatement = this.ast.newEnhancedForStatement();
                enhancedForStatement.setParameter(this.convertToSingleVariableDeclaration(statement.elementVariable));
                enhancedForStatement.setExpression(this.convert(statement.collection));
                enhancedForStatement.setBody(this.convert(statement.action));
                int start = statement.sourceStart;
                int end = statement.sourceEnd;
                enhancedForStatement.setSourceRange(start, end - start + 1);
                return enhancedForStatement;
            }
        }
        return this.createFakeEmptyStatement(statement);
    }

    public ForStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.ForStatement statement) {
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement[] increments;
        ForStatement forStatement = this.ast.newForStatement();
        forStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement[] initializations = statement.initializations;
        if (initializations != null) {
            if (initializations[0] instanceof LocalDeclaration) {
                VariableDeclarationExpression variableDeclarationExpression = this.convertToVariableDeclarationExpression((LocalDeclaration)initializations[0]);
                int initializationsLength = initializations.length;
                int i = 1;
                while (i < initializationsLength) {
                    variableDeclarationExpression.fragments().add(this.convertToVariableDeclarationFragment((LocalDeclaration)initializations[i]));
                    ++i;
                }
                if (initializationsLength != 1) {
                    int start = variableDeclarationExpression.getStartPosition();
                    int end = ((LocalDeclaration)initializations[initializationsLength - 1]).declarationSourceEnd;
                    variableDeclarationExpression.setSourceRange(start, end - start + 1);
                }
                forStatement.initializers().add(variableDeclarationExpression);
            } else {
                int initializationsLength = initializations.length;
                int i = 0;
                while (i < initializationsLength) {
                    Expression initializer = this.convertToExpression(initializations[i]);
                    if (initializer != null) {
                        forStatement.initializers().add(initializer);
                    } else {
                        forStatement.setFlags(forStatement.getFlags() | 1);
                    }
                    ++i;
                }
            }
        }
        if (statement.condition != null) {
            forStatement.setExpression(this.convert(statement.condition));
        }
        if ((increments = statement.increments) != null) {
            int incrementsLength = increments.length;
            int i = 0;
            while (i < incrementsLength) {
                forStatement.updaters().add(this.convertToExpression(increments[i]));
                ++i;
            }
        }
        forStatement.setBody(this.convert(statement.action));
        return forStatement;
    }

    public IfStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.IfStatement statement) {
        IfStatement ifStatement = this.ast.newIfStatement();
        ifStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        ifStatement.setExpression(this.convert(statement.condition));
        ifStatement.setThenStatement(this.convert(statement.thenStatement));
        if (statement.elseStatement != null) {
            ifStatement.setElseStatement(this.convert(statement.elseStatement));
        }
        return ifStatement;
    }

    public InstanceofExpression convert(InstanceOfExpression expression) {
        InstanceofExpression instanceOfExpression = this.ast.newInstanceofExpression();
        if (this.resolveBindings) {
            this.recordNodes(instanceOfExpression, expression);
        }
        Expression leftExpression = this.convert(expression.expression);
        instanceOfExpression.setLeftOperand(leftExpression);
        instanceOfExpression.setRightOperand(this.convertType(expression.type));
        int startPosition = leftExpression.getStartPosition();
        instanceOfExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return instanceOfExpression;
    }

    public NumberLiteral convert(IntLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(IntLiteralMinValue expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public void convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Javadoc javadoc, BodyDeclaration bodyDeclaration) {
        if (bodyDeclaration.getJavadoc() == null && javadoc != null) {
            Comment comment;
            if (this.commentMapper == null || !this.commentMapper.hasSameTable(this.commentsTable)) {
                this.commentMapper = new DefaultCommentMapper(this.commentsTable);
            }
            if ((comment = this.commentMapper.getComment(javadoc.sourceStart)) != null && comment.isDocComment() && comment.getParent() == null) {
                Javadoc docComment = (Javadoc)comment;
                if (this.resolveBindings) {
                    this.recordNodes(docComment, javadoc);
                    ListIterator tags = docComment.tags().listIterator();
                    while (tags.hasNext()) {
                        this.recordNodes(javadoc, (TagElement)tags.next());
                    }
                }
                bodyDeclaration.setJavadoc(docComment);
            }
        }
    }

    public LabeledStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.LabeledStatement statement) {
        LabeledStatement labeledStatement = this.ast.newLabeledStatement();
        labeledStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement body = statement.statement;
        labeledStatement.setBody(this.convert(body));
        SimpleName name = this.ast.newSimpleName(new String(statement.label));
        this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
        labeledStatement.setLabel(name);
        return labeledStatement;
    }

    public NumberLiteral convert(LongLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(LongLiteralMinValue expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        NumberLiteral literal = this.ast.newNumberLiteral(new String(tokens));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public Expression convert(MessageSend expression) {
        Expression expr;
        int sourceStart = expression.sourceStart;
        if (expression.isSuperAccess()) {
            TypeReference[] typeArguments;
            int i;
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] arguments;
            SuperMethodInvocation superMethodInvocation = this.ast.newSuperMethodInvocation();
            if (this.resolveBindings) {
                this.recordNodes(superMethodInvocation, expression);
            }
            SimpleName name = this.ast.newSimpleName(new String(expression.selector));
            int nameSourceStart = (int)(expression.nameSourcePosition >>> 32);
            int nameSourceLength = (int)(expression.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - nameSourceStart + 1;
            name.setSourceRange(nameSourceStart, nameSourceLength);
            if (this.resolveBindings) {
                this.recordNodes(name, expression);
            }
            superMethodInvocation.setName(name);
            if (expression.receiver instanceof QualifiedSuperReference) {
                Name qualifier = this.convert((QualifiedSuperReference)expression.receiver);
                superMethodInvocation.setQualifier(qualifier);
                if (this.resolveBindings) {
                    this.recordNodes(qualifier, expression.receiver);
                }
                if (qualifier != null) {
                    sourceStart = qualifier.getStartPosition();
                }
            }
            if ((arguments = expression.arguments) != null) {
                int argumentsLength = arguments.length;
                i = 0;
                while (i < argumentsLength) {
                    Expression expri = this.convert(arguments[i]);
                    if (this.resolveBindings) {
                        this.recordNodes(expri, arguments[i]);
                    }
                    superMethodInvocation.arguments().add(expri);
                    ++i;
                }
            }
            if ((typeArguments = expression.typeArguments) != null) {
                switch (this.ast.apiLevel) {
                    case 2: {
                        superMethodInvocation.setFlags(superMethodInvocation.getFlags() | 1);
                        break;
                    }
                    case 3: {
                        i = 0;
                        int max = typeArguments.length;
                        while (i < max) {
                            superMethodInvocation.typeArguments().add(this.convertType(typeArguments[i]));
                            ++i;
                        }
                        break;
                    }
                }
            }
            expr = superMethodInvocation;
        } else {
            TypeReference[] typeArguments;
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] arguments;
            MethodInvocation methodInvocation = this.ast.newMethodInvocation();
            if (this.resolveBindings) {
                this.recordNodes(methodInvocation, expression);
            }
            SimpleName name = this.ast.newSimpleName(new String(expression.selector));
            int nameSourceStart = (int)(expression.nameSourcePosition >>> 32);
            int nameSourceLength = (int)(expression.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - nameSourceStart + 1;
            name.setSourceRange(nameSourceStart, nameSourceLength);
            methodInvocation.setName(name);
            if (this.resolveBindings) {
                this.recordNodes(name, expression);
            }
            if ((arguments = expression.arguments) != null) {
                int argumentsLength = arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    Expression expri = this.convert(arguments[i]);
                    if (this.resolveBindings) {
                        this.recordNodes(expri, arguments[i]);
                    }
                    methodInvocation.arguments().add(expri);
                    ++i;
                }
            }
            Expression qualifier = null;
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression receiver = expression.receiver;
            qualifier = receiver instanceof MessageSend ? ((receiver.bits & 0x1FE00000) != 0 ? this.convertToParenthesizedExpression(receiver) : this.convert((MessageSend)receiver)) : this.convert(receiver);
            if (qualifier instanceof Name && this.resolveBindings) {
                this.recordNodes(qualifier, receiver);
            }
            methodInvocation.setExpression(qualifier);
            if (qualifier != null) {
                sourceStart = qualifier.getStartPosition();
            }
            if ((typeArguments = expression.typeArguments) != null) {
                switch (this.ast.apiLevel) {
                    case 2: {
                        methodInvocation.setFlags(methodInvocation.getFlags() | 1);
                        break;
                    }
                    case 3: {
                        int i = 0;
                        int max = typeArguments.length;
                        while (i < max) {
                            methodInvocation.typeArguments().add(this.convertType(typeArguments[i]));
                            ++i;
                        }
                        break;
                    }
                }
            }
            expr = methodInvocation;
        }
        expr.setSourceRange(sourceStart, expression.sourceEnd - sourceStart + 1);
        this.removeTrailingCommentFromExpressionEndingWithAParen(expr);
        return expr;
    }

    public MarkerAnnotation convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation annotation) {
        MarkerAnnotation markerAnnotation = this.ast.newMarkerAnnotation();
        this.setTypeNameForAnnotation(annotation, markerAnnotation);
        int start = annotation.sourceStart;
        int end = annotation.declarationSourceEnd;
        markerAnnotation.setSourceRange(start, end - start + 1);
        if (this.resolveBindings) {
            this.recordNodes(markerAnnotation, annotation);
        }
        return markerAnnotation;
    }

    public MemberValuePair convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair memberValuePair) {
        MemberValuePair pair = this.ast.newMemberValuePair();
        SimpleName simpleName = this.ast.newSimpleName(new String(memberValuePair.name));
        int start = memberValuePair.sourceStart;
        int end = memberValuePair.sourceEnd;
        simpleName.setSourceRange(start, end - start + 1);
        pair.setName(simpleName);
        pair.setValue(this.convert(memberValuePair.value));
        start = memberValuePair.sourceStart;
        end = memberValuePair.value.sourceEnd;
        pair.setSourceRange(start, end - start + 1);
        if (this.resolveBindings) {
            this.recordNodes(simpleName, memberValuePair);
        }
        return pair;
    }

    public Name convert(NameReference reference) {
        if (reference instanceof QualifiedNameReference) {
            return this.convert((QualifiedNameReference)reference);
        }
        return this.convert((SingleNameReference)reference);
    }

    public InfixExpression convert(StringLiteralConcatenation expression) {
        expression.computeConstant();
        InfixExpression infixExpression = this.ast.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] stringLiterals = expression.literals;
        infixExpression.setLeftOperand(this.convert(stringLiterals[0]));
        infixExpression.setRightOperand(this.convert(stringLiterals[1]));
        int i = 2;
        while (i < expression.counter) {
            infixExpression.extendedOperands().add(this.convert(stringLiterals[i]));
            ++i;
        }
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        infixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return infixExpression;
    }

    public NormalAnnotation convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.NormalAnnotation annotation) {
        NormalAnnotation normalAnnotation = this.ast.newNormalAnnotation();
        this.setTypeNameForAnnotation(annotation, normalAnnotation);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair[] memberValuePairs = annotation.memberValuePairs;
        if (memberValuePairs != null) {
            int i = 0;
            int max = memberValuePairs.length;
            while (i < max) {
                normalAnnotation.values().add(this.convert(memberValuePairs[i]));
                ++i;
            }
        }
        int start = annotation.sourceStart;
        int end = annotation.declarationSourceEnd;
        normalAnnotation.setSourceRange(start, end - start + 1);
        if (this.resolveBindings) {
            this.recordNodes(normalAnnotation, annotation);
        }
        return normalAnnotation;
    }

    public NullLiteral convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.NullLiteral expression) {
        NullLiteral literal = this.ast.newNullLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public Expression convert(OR_OR_Expression expression) {
        InfixExpression infixExpression = this.ast.newInfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
        int sourceStart = leftExpression.getStartPosition();
        infixExpression.setSourceRange(sourceStart, expression.sourceEnd - sourceStart + 1);
        return infixExpression;
    }

    public PostfixExpression convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.PostfixExpression expression) {
        PostfixExpression postfixExpression = this.ast.newPostfixExpression();
        if (this.resolveBindings) {
            this.recordNodes(postfixExpression, expression);
        }
        postfixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        postfixExpression.setOperand(this.convert(expression.lhs));
        switch (expression.operator) {
            case 14: {
                postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
                break;
            }
            case 13: {
                postfixExpression.setOperator(PostfixExpression.Operator.DECREMENT);
            }
        }
        return postfixExpression;
    }

    public PrefixExpression convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.PrefixExpression expression) {
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        if (this.resolveBindings) {
            this.recordNodes(prefixExpression, expression);
        }
        prefixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        prefixExpression.setOperand(this.convert(expression.lhs));
        switch (expression.operator) {
            case 14: {
                prefixExpression.setOperator(PrefixExpression.Operator.INCREMENT);
                break;
            }
            case 13: {
                prefixExpression.setOperator(PrefixExpression.Operator.DECREMENT);
            }
        }
        return prefixExpression;
    }

    public Expression convert(QualifiedAllocationExpression allocation) {
        ClassInstanceCreation classInstanceCreation = this.ast.newClassInstanceCreation();
        if (allocation.enclosingInstance != null) {
            classInstanceCreation.setExpression(this.convert(allocation.enclosingInstance));
        }
        switch (this.ast.apiLevel) {
            case 2: {
                classInstanceCreation.setName(this.convert(allocation.type));
                break;
            }
            case 3: {
                classInstanceCreation.setType(this.convertType(allocation.type));
            }
        }
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression[] arguments = allocation.arguments;
        if (arguments != null) {
            int length = arguments.length;
            int i = 0;
            while (i < length) {
                Expression argument = this.convert(arguments[i]);
                if (this.resolveBindings) {
                    this.recordNodes(argument, arguments[i]);
                }
                classInstanceCreation.arguments().add(argument);
                ++i;
            }
        }
        if (allocation.typeArguments != null) {
            switch (this.ast.apiLevel) {
                case 2: {
                    classInstanceCreation.setFlags(classInstanceCreation.getFlags() | 1);
                    break;
                }
                case 3: {
                    int i = 0;
                    int max = allocation.typeArguments.length;
                    while (i < max) {
                        classInstanceCreation.typeArguments().add(this.convertType(allocation.typeArguments[i]));
                        ++i;
                    }
                    break;
                }
            }
        }
        if (allocation.anonymousType != null) {
            int declarationSourceStart = allocation.sourceStart;
            classInstanceCreation.setSourceRange(declarationSourceStart, allocation.anonymousType.bodyEnd - declarationSourceStart + 1);
            AnonymousClassDeclaration anonymousClassDeclaration = this.ast.newAnonymousClassDeclaration();
            int start = this.retrieveStartBlockPosition(allocation.anonymousType.sourceEnd, allocation.anonymousType.bodyEnd);
            anonymousClassDeclaration.setSourceRange(start, allocation.anonymousType.bodyEnd - start + 1);
            classInstanceCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
            this.buildBodyDeclarations(allocation.anonymousType, anonymousClassDeclaration);
            if (this.resolveBindings) {
                this.recordNodes(classInstanceCreation, allocation.anonymousType);
                this.recordNodes(anonymousClassDeclaration, allocation.anonymousType);
                anonymousClassDeclaration.resolveBinding();
            }
            return classInstanceCreation;
        }
        int start = allocation.sourceStart;
        classInstanceCreation.setSourceRange(start, allocation.sourceEnd - start + 1);
        if (this.resolveBindings) {
            this.recordNodes(classInstanceCreation, allocation);
        }
        this.removeTrailingCommentFromExpressionEndingWithAParen(classInstanceCreation);
        return classInstanceCreation;
    }

    public Name convert(QualifiedNameReference nameReference) {
        return this.setQualifiedNameNameAndSourceRanges(nameReference.tokens, nameReference.sourcePositions, nameReference);
    }

    public Name convert(QualifiedSuperReference reference) {
        return this.convert(reference.qualification);
    }

    public ThisExpression convert(QualifiedThisReference reference) {
        ThisExpression thisExpression = this.ast.newThisExpression();
        thisExpression.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        thisExpression.setQualifier(this.convert(reference.qualification));
        if (this.resolveBindings) {
            this.recordNodes(thisExpression, reference);
            this.recordPendingThisExpressionScopeResolution(thisExpression);
        }
        return thisExpression;
    }

    public Expression convert(Reference reference) {
        if (reference instanceof NameReference) {
            return this.convert((NameReference)reference);
        }
        if (reference instanceof ThisReference) {
            return this.convert((ThisReference)reference);
        }
        if (reference instanceof ArrayReference) {
            return this.convert((ArrayReference)reference);
        }
        if (reference instanceof FieldReference) {
            return this.convert((FieldReference)reference);
        }
        return null;
    }

    public ReturnStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement statement) {
        ReturnStatement returnStatement = this.ast.newReturnStatement();
        returnStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.expression != null) {
            returnStatement.setExpression(this.convert(statement.expression));
        }
        this.retrieveSemiColonPosition(returnStatement);
        return returnStatement;
    }

    public SingleMemberAnnotation convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation annotation) {
        SingleMemberAnnotation singleMemberAnnotation = this.ast.newSingleMemberAnnotation();
        this.setTypeNameForAnnotation(annotation, singleMemberAnnotation);
        singleMemberAnnotation.setValue(this.convert(annotation.memberValue));
        int start = annotation.sourceStart;
        int end = annotation.declarationSourceEnd;
        singleMemberAnnotation.setSourceRange(start, end - start + 1);
        if (this.resolveBindings) {
            this.recordNodes(singleMemberAnnotation, annotation);
        }
        return singleMemberAnnotation;
    }

    public SimpleName convert(SingleNameReference nameReference) {
        SimpleName name = this.ast.newSimpleName(new String(nameReference.token));
        if (this.resolveBindings) {
            this.recordNodes(name, nameReference);
        }
        name.setSourceRange(nameReference.sourceStart, nameReference.sourceEnd - nameReference.sourceStart + 1);
        return name;
    }

    public Statement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement statement) {
        if (statement instanceof ForeachStatement) {
            return this.convert((ForeachStatement)statement);
        }
        if (statement instanceof LocalDeclaration) {
            return this.convertToVariableDeclarationStatement((LocalDeclaration)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.AssertStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.AssertStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.Block) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.Block)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.BreakStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.BreakStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.ContinueStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.ContinueStatement)statement);
        }
        if (statement instanceof CaseStatement) {
            return this.convert((CaseStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.DoStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.DoStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.EmptyStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.EmptyStatement)statement);
        }
        if (statement instanceof ExplicitConstructorCall) {
            return this.convert((ExplicitConstructorCall)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.ForStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.ForStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.IfStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.IfStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.LabeledStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.LabeledStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.SwitchStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.SwitchStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThrowStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThrowStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.TryStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.TryStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration) {
            ASTNode result = this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)statement);
            switch (result.getNodeType()) {
                case 71: {
                    switch (this.ast.apiLevel) {
                        case 2: {
                            return this.createFakeEmptyStatement(statement);
                        }
                        case 3: {
                            TypeDeclarationStatement typeDeclarationStatement = this.ast.newTypeDeclarationStatement((EnumDeclaration)result);
                            TypeDeclaration typeDecl = typeDeclarationStatement.getTypeDeclaration();
                            typeDeclarationStatement.setSourceRange(typeDecl.getStartPosition(), typeDecl.getLength());
                            return typeDeclarationStatement;
                        }
                    }
                    break;
                }
                case 81: {
                    switch (this.ast.apiLevel) {
                        case 2: {
                            return this.createFakeEmptyStatement(statement);
                        }
                        case 3: {
                            TypeDeclarationStatement typeDeclarationStatement = this.ast.newTypeDeclarationStatement((AnnotationTypeDeclaration)result);
                            TypeDeclaration typeDecl = typeDeclarationStatement.getTypeDeclaration();
                            typeDeclarationStatement.setSourceRange(typeDecl.getStartPosition(), typeDecl.getLength());
                            return typeDeclarationStatement;
                        }
                    }
                    break;
                }
                default: {
                    TypeDeclaration typeDeclaration = (TypeDeclaration)result;
                    if (typeDeclaration == null) {
                        return this.createFakeEmptyStatement(statement);
                    }
                    TypeDeclarationStatement typeDeclarationStatement = this.ast.newTypeDeclarationStatement(typeDeclaration);
                    switch (this.ast.apiLevel) {
                        case 2: {
                            TypeDeclaration typeDecl = typeDeclarationStatement.getTypeDeclaration();
                            typeDeclarationStatement.setSourceRange(typeDecl.getStartPosition(), typeDecl.getLength());
                            break;
                        }
                        case 3: {
                            AbstractTypeDeclaration typeDeclAST3 = typeDeclarationStatement.getDeclaration();
                            typeDeclarationStatement.setSourceRange(typeDeclAST3.getStartPosition(), typeDeclAST3.getLength());
                        }
                    }
                    return typeDeclarationStatement;
                }
            }
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.WhileStatement) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.WhileStatement)statement);
        }
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression) {
            Expression expr = this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression)statement);
            ExpressionStatement stmt = this.ast.newExpressionStatement(expr);
            stmt.setSourceRange(expr.getStartPosition(), expr.getLength());
            this.retrieveSemiColonPosition(stmt);
            return stmt;
        }
        return this.createFakeEmptyStatement(statement);
    }

    public Expression convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.StringLiteral expression) {
        if (expression instanceof StringLiteralConcatenation) {
            return this.convert((StringLiteralConcatenation)expression);
        }
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        char[] tokens = new char[length];
        System.arraycopy(this.compilationUnitSource, sourceStart, tokens, 0, length);
        StringLiteral literal = this.ast.newStringLiteral();
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setEscapedValue(new String(tokens));
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public SwitchStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.SwitchStatement statement) {
        SwitchStatement switchStatement = this.ast.newSwitchStatement();
        switchStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        switchStatement.setExpression(this.convert(statement.expression));
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement[] statements = statement.statements;
        if (statements != null) {
            int statementsLength = statements.length;
            int i = 0;
            while (i < statementsLength) {
                switchStatement.statements().add(this.convert(statements[i]));
                ++i;
            }
        }
        return switchStatement;
    }

    public SynchronizedStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement statement) {
        SynchronizedStatement synchronizedStatement = this.ast.newSynchronizedStatement();
        synchronizedStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        synchronizedStatement.setBody(this.convert(statement.block));
        synchronizedStatement.setExpression(this.convert(statement.expression));
        return synchronizedStatement;
    }

    public Expression convert(ThisReference reference) {
        if (reference.isImplicitThis()) {
            return null;
        }
        if (reference instanceof QualifiedSuperReference) {
            return this.convert((QualifiedSuperReference)reference);
        }
        if (reference instanceof QualifiedThisReference) {
            return this.convert((QualifiedThisReference)reference);
        }
        ThisExpression thisExpression = this.ast.newThisExpression();
        thisExpression.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(thisExpression, reference);
            this.recordPendingThisExpressionScopeResolution(thisExpression);
        }
        return thisExpression;
    }

    public ThrowStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThrowStatement statement) {
        ThrowStatement throwStatement = this.ast.newThrowStatement();
        throwStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        throwStatement.setExpression(this.convert(statement.exception));
        this.retrieveSemiColonPosition(throwStatement);
        return throwStatement;
    }

    public BooleanLiteral convert(TrueLiteral expression) {
        BooleanLiteral literal = this.ast.newBooleanLiteral(true);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public TryStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.TryStatement statement) {
        TryStatement tryStatement = this.ast.newTryStatement();
        tryStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        tryStatement.setBody(this.convert(statement.tryBlock));
        Argument[] catchArguments = statement.catchArguments;
        if (catchArguments != null) {
            int catchArgumentsLength = catchArguments.length;
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Block[] catchBlocks = statement.catchBlocks;
            int start = statement.tryBlock.sourceEnd;
            int i = 0;
            while (i < catchArgumentsLength) {
                CatchClause catchClause = this.ast.newCatchClause();
                int catchClauseSourceStart = this.retrieveStartingCatchPosition(start, catchArguments[i].sourceStart);
                catchClause.setSourceRange(catchClauseSourceStart, catchBlocks[i].sourceEnd - catchClauseSourceStart + 1);
                catchClause.setBody(this.convert(catchBlocks[i]));
                catchClause.setException(this.convert(catchArguments[i]));
                tryStatement.catchClauses().add(catchClause);
                start = catchBlocks[i].sourceEnd;
                ++i;
            }
        }
        if (statement.finallyBlock != null) {
            tryStatement.setFinally(this.convert(statement.finallyBlock));
        }
        return tryStatement;
    }

    public ASTNode convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration) {
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter[] typeParameters;
        TypeReference[] superInterfaces;
        switch (typeDeclaration.kind()) {
            case 3: {
                if (this.ast.apiLevel == 2) {
                    return null;
                }
                return this.convertToEnumDeclaration(typeDeclaration);
            }
            case 4: {
                if (this.ast.apiLevel == 2) {
                    return null;
                }
                return this.convertToAnnotationDeclaration(typeDeclaration);
            }
        }
        this.checkCanceled();
        TypeDeclaration typeDecl = this.ast.newTypeDeclaration();
        if (typeDeclaration.modifiersSourceStart != -1) {
            this.setModifiers(typeDecl, typeDeclaration);
        }
        typeDecl.setInterface(typeDeclaration.kind() == 2);
        SimpleName typeName = this.ast.newSimpleName(new String(typeDeclaration.name));
        typeName.setSourceRange(typeDeclaration.sourceStart, typeDeclaration.sourceEnd - typeDeclaration.sourceStart + 1);
        typeDecl.setName(typeName);
        typeDecl.setSourceRange(typeDeclaration.declarationSourceStart, typeDeclaration.bodyEnd - typeDeclaration.declarationSourceStart + 1);
        if (typeDeclaration.superclass != null) {
            switch (this.ast.apiLevel) {
                case 2: {
                    typeDecl.setSuperclass(this.convert(typeDeclaration.superclass));
                    break;
                }
                case 3: {
                    typeDecl.setSuperclassType(this.convertType(typeDeclaration.superclass));
                }
            }
        }
        if ((superInterfaces = typeDeclaration.superInterfaces) != null) {
            switch (this.ast.apiLevel) {
                case 2: {
                    int index = 0;
                    int length = superInterfaces.length;
                    while (index < length) {
                        typeDecl.superInterfaces().add(this.convert(superInterfaces[index]));
                        ++index;
                    }
                    break;
                }
                case 3: {
                    int index = 0;
                    int length = superInterfaces.length;
                    while (index < length) {
                        typeDecl.superInterfaceTypes().add(this.convertType(superInterfaces[index]));
                        ++index;
                    }
                    break;
                }
            }
        }
        if ((typeParameters = typeDeclaration.typeParameters) != null) {
            switch (this.ast.apiLevel) {
                case 2: {
                    typeDecl.setFlags(typeDecl.getFlags() | 1);
                    break;
                }
                case 3: {
                    int index = 0;
                    int length = typeParameters.length;
                    while (index < length) {
                        typeDecl.typeParameters().add(this.convert(typeParameters[index]));
                        ++index;
                    }
                    break;
                }
            }
        }
        this.buildBodyDeclarations(typeDeclaration, typeDecl);
        if (this.resolveBindings) {
            this.recordNodes(typeDecl, typeDeclaration);
            this.recordNodes(typeName, typeDeclaration);
            typeDecl.resolveBinding();
        }
        return typeDecl;
    }

    public TypeParameter convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter typeParameter) {
        TypeReference[] bounds;
        TypeParameter typeParameter2 = this.ast.newTypeParameter();
        SimpleName simpleName = this.ast.newSimpleName(new String(typeParameter.name));
        int start = typeParameter.sourceStart;
        int end = typeParameter.sourceEnd;
        simpleName.setSourceRange(start, end - start + 1);
        typeParameter2.setName(simpleName);
        TypeReference superType = typeParameter.type;
        end = typeParameter.declarationSourceEnd;
        if (superType != null) {
            Type type = this.convertType(superType);
            typeParameter2.typeBounds().add(type);
            end = type.getStartPosition() + type.getLength() - 1;
        }
        if ((bounds = typeParameter.bounds) != null) {
            Type type = null;
            int index = 0;
            int length = bounds.length;
            while (index < length) {
                type = this.convertType(bounds[index]);
                typeParameter2.typeBounds().add(type);
                end = type.getStartPosition() + type.getLength() - 1;
                ++index;
            }
        }
        start = typeParameter.declarationSourceStart;
        end = this.retrieveClosingAngleBracketPosition(end);
        typeParameter2.setSourceRange(start, end - start + 1);
        if (this.resolveBindings) {
            this.recordName(simpleName, typeParameter);
            this.recordNodes(typeParameter2, typeParameter);
            typeParameter2.resolveBinding();
        }
        return typeParameter2;
    }

    public Name convert(TypeReference typeReference) {
        char[][] typeName = typeReference.getTypeName();
        int length = typeName.length;
        Name name = null;
        if (length > 1) {
            QualifiedTypeReference qualifiedTypeReference = (QualifiedTypeReference)typeReference;
            long[] positions = qualifiedTypeReference.sourcePositions;
            name = this.setQualifiedNameNameAndSourceRanges(typeName, positions, typeReference);
        } else {
            name = this.ast.newSimpleName(new String(typeName[0]));
            name.setSourceRange(typeReference.sourceStart, typeReference.sourceEnd - typeReference.sourceStart + 1);
        }
        if (this.resolveBindings) {
            this.recordNodes(name, typeReference);
        }
        return name;
    }

    public PrefixExpression convert(UnaryExpression expression) {
        PrefixExpression prefixExpression = this.ast.newPrefixExpression();
        if (this.resolveBindings) {
            this.recordNodes(prefixExpression, expression);
        }
        prefixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        prefixExpression.setOperand(this.convert(expression.expression));
        switch ((expression.bits & 0xFC0) >> 6) {
            case 14: {
                prefixExpression.setOperator(PrefixExpression.Operator.PLUS);
                break;
            }
            case 13: {
                prefixExpression.setOperator(PrefixExpression.Operator.MINUS);
                break;
            }
            case 11: {
                prefixExpression.setOperator(PrefixExpression.Operator.NOT);
                break;
            }
            case 12: {
                prefixExpression.setOperator(PrefixExpression.Operator.COMPLEMENT);
            }
        }
        return prefixExpression;
    }

    public WhileStatement convert(org.aspectj.org.eclipse.jdt.internal.compiler.ast.WhileStatement statement) {
        WhileStatement whileStatement = this.ast.newWhileStatement();
        whileStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        whileStatement.setExpression(this.convert(statement.condition));
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement action = statement.action;
        whileStatement.setBody(this.convert(action));
        return whileStatement;
    }

    public ImportDeclaration convertImport(ImportReference importReference) {
        ImportDeclaration importDeclaration = this.ast.newImportDeclaration();
        boolean onDemand = importReference.onDemand;
        char[][] tokens = importReference.tokens;
        int length = importReference.tokens.length;
        long[] positions = importReference.sourcePositions;
        Name name = null;
        if (length > 1) {
            name = this.setQualifiedNameNameAndSourceRanges(tokens, positions, importReference);
        } else {
            name = this.ast.newSimpleName(new String(tokens[0]));
            int start = (int)(positions[0] >>> 32);
            int end = (int)(positions[0] & 0xFFFFFFFFFFFFFFFFL);
            name.setSourceRange(start, end - start + 1);
        }
        importDeclaration.setSourceRange(importReference.declarationSourceStart, importReference.declarationEnd - importReference.declarationSourceStart + 1);
        importDeclaration.setName(name);
        importDeclaration.setOnDemand(onDemand);
        int modifiers = importReference.modifiers;
        if (modifiers != 0) {
            switch (this.ast.apiLevel) {
                case 2: {
                    importDeclaration.setFlags(importDeclaration.getFlags() | 1);
                    break;
                }
                case 3: {
                    if (modifiers == 8) {
                        importDeclaration.setStatic(true);
                        break;
                    }
                    importDeclaration.setFlags(importDeclaration.getFlags() | 1);
                }
            }
        }
        if (this.resolveBindings) {
            this.recordNodes(importDeclaration, importReference);
        }
        return importDeclaration;
    }

    public PackageDeclaration convertPackage(CompilationUnitDeclaration compilationUnitDeclaration) {
        ImportReference importReference = compilationUnitDeclaration.currentPackage;
        PackageDeclaration packageDeclaration = this.ast.newPackageDeclaration();
        char[][] tokens = importReference.tokens;
        int length = importReference.tokens.length;
        long[] positions = importReference.sourcePositions;
        int start = (int)(positions[0] >>> 32);
        int end = (int)(positions[length - 1] & 0xFFFFFFFFFFFFFFFFL);
        Name name = null;
        if (length > 1) {
            name = this.setQualifiedNameNameAndSourceRanges(tokens, positions, importReference);
        } else {
            name = this.ast.newSimpleName(new String(tokens[0]));
            name.setSourceRange(start, end - start + 1);
        }
        packageDeclaration.setSourceRange(importReference.declarationSourceStart, importReference.declarationEnd - importReference.declarationSourceStart + 1);
        packageDeclaration.setName(name);
        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation[] annotations = importReference.annotations;
        if (annotations != null) {
            switch (this.ast.apiLevel) {
                case 2: {
                    packageDeclaration.setFlags(packageDeclaration.getFlags() & 1);
                    break;
                }
                case 3: {
                    int i = 0;
                    int max = annotations.length;
                    while (i < max) {
                        packageDeclaration.annotations().add(this.convert(annotations[i]));
                        ++i;
                    }
                    break;
                }
            }
        }
        if (this.resolveBindings) {
            this.recordNodes(packageDeclaration, importReference);
            this.recordNodes(name, compilationUnitDeclaration);
        }
        return packageDeclaration;
    }

    private EnumDeclaration convertToEnumDeclaration(org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration) {
        this.checkCanceled();
        EnumDeclaration enumDeclaration2 = this.ast.newEnumDeclaration();
        this.setModifiers(enumDeclaration2, typeDeclaration);
        SimpleName typeName = this.ast.newSimpleName(new String(typeDeclaration.name));
        typeName.setSourceRange(typeDeclaration.sourceStart, typeDeclaration.sourceEnd - typeDeclaration.sourceStart + 1);
        enumDeclaration2.setName(typeName);
        enumDeclaration2.setSourceRange(typeDeclaration.declarationSourceStart, typeDeclaration.bodyEnd - typeDeclaration.declarationSourceStart + 1);
        TypeReference[] superInterfaces = typeDeclaration.superInterfaces;
        if (superInterfaces != null) {
            int index = 0;
            int length = superInterfaces.length;
            while (index < length) {
                enumDeclaration2.superInterfaceTypes().add(this.convertType(superInterfaces[index]));
                ++index;
            }
        }
        this.buildBodyDeclarations(typeDeclaration, enumDeclaration2);
        if (this.resolveBindings) {
            this.recordNodes(enumDeclaration2, typeDeclaration);
            this.recordNodes(typeName, typeDeclaration);
            enumDeclaration2.resolveBinding();
        }
        return enumDeclaration2;
    }

    public Expression convertToExpression(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement statement) {
        if (statement instanceof org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression) {
            return this.convert((org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression)statement);
        }
        return null;
    }

    protected FieldDeclaration convertToFieldDeclaration(org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fieldDecl) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(fieldDecl);
        FieldDeclaration fieldDeclaration = this.ast.newFieldDeclaration(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, fieldDecl);
            variableDeclarationFragment.resolveBinding();
        }
        fieldDeclaration.setSourceRange(fieldDecl.declarationSourceStart, fieldDecl.declarationEnd - fieldDecl.declarationSourceStart + 1);
        Type type = this.convertType(fieldDecl.type);
        this.setTypeForField(fieldDeclaration, type, variableDeclarationFragment.getExtraDimensions());
        this.setModifiers(fieldDeclaration, fieldDecl);
        this.convert(fieldDecl.javadoc, fieldDeclaration);
        return fieldDeclaration;
    }

    public ParenthesizedExpression convertToParenthesizedExpression(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        ParenthesizedExpression parenthesizedExpression = this.ast.newParenthesizedExpression();
        if (this.resolveBindings) {
            this.recordNodes(parenthesizedExpression, expression);
        }
        parenthesizedExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        this.adjustSourcePositionsForParent(expression);
        this.trimWhiteSpacesAndComments(expression);
        int numberOfParenthesis = (expression.bits & 0x1FE00000) >> 21;
        expression.bits &= 0xE01FFFFF;
        expression.bits |= numberOfParenthesis - 1 << 21;
        parenthesizedExpression.setExpression(this.convert(expression));
        return parenthesizedExpression;
    }

    public Type convertToType(NameReference reference) {
        Name name = this.convert(reference);
        SimpleType type = this.ast.newSimpleType(name);
        type.setSourceRange(name.getStartPosition(), name.getLength());
        if (this.resolveBindings) {
            this.recordNodes(type, reference);
        }
        return type;
    }

    protected VariableDeclarationExpression convertToVariableDeclarationExpression(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(localDeclaration);
        VariableDeclarationExpression variableDeclarationExpression = this.ast.newVariableDeclarationExpression(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
        }
        variableDeclarationExpression.setSourceRange(localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd - localDeclaration.declarationSourceStart + 1);
        Type type = this.convertType(localDeclaration.type);
        this.setTypeForVariableDeclarationExpression(variableDeclarationExpression, type, variableDeclarationFragment.getExtraDimensions());
        if (localDeclaration.modifiersSourceStart != -1) {
            this.setModifiers(variableDeclarationExpression, localDeclaration);
        }
        return variableDeclarationExpression;
    }

    protected SingleVariableDeclaration convertToSingleVariableDeclaration(LocalDeclaration localDeclaration) {
        SingleVariableDeclaration variableDecl = this.ast.newSingleVariableDeclaration();
        this.setModifiers(variableDecl, localDeclaration);
        SimpleName name = this.ast.newSimpleName(new String(localDeclaration.name));
        int start = localDeclaration.sourceStart;
        int nameEnd = localDeclaration.sourceEnd;
        name.setSourceRange(start, nameEnd - start + 1);
        variableDecl.setName(name);
        int extraDimensions = this.retrieveExtraDimension(nameEnd + 1, localDeclaration.type.sourceEnd);
        variableDecl.setExtraDimensions(extraDimensions);
        Type type = this.convertType(localDeclaration.type);
        int typeEnd = type.getStartPosition() + type.getLength() - 1;
        int rightEnd = Math.max(typeEnd, localDeclaration.declarationSourceEnd);
        this.setTypeForSingleVariableDeclaration(variableDecl, type, extraDimensions);
        variableDecl.setSourceRange(localDeclaration.declarationSourceStart, rightEnd - localDeclaration.declarationSourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(name, localDeclaration);
            this.recordNodes(variableDecl, localDeclaration);
            variableDecl.resolveBinding();
        }
        return variableDecl;
    }

    protected VariableDeclarationFragment convertToVariableDeclarationFragment(org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fieldDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        SimpleName name = this.ast.newSimpleName(new String(fieldDeclaration.name));
        name.setSourceRange(fieldDeclaration.sourceStart, fieldDeclaration.sourceEnd - fieldDeclaration.sourceStart + 1);
        variableDeclarationFragment.setName(name);
        int end = this.retrievePositionBeforeNextCommaOrSemiColon(fieldDeclaration.sourceEnd, fieldDeclaration.declarationSourceEnd);
        if (end == -1) {
            variableDeclarationFragment.setSourceRange(fieldDeclaration.sourceStart, fieldDeclaration.declarationSourceEnd - fieldDeclaration.sourceStart + 1);
            variableDeclarationFragment.setFlags(variableDeclarationFragment.getFlags() | 1);
        } else {
            variableDeclarationFragment.setSourceRange(fieldDeclaration.sourceStart, end - fieldDeclaration.sourceStart + 1);
        }
        if (fieldDeclaration.initialization != null) {
            variableDeclarationFragment.setInitializer(this.convert(fieldDeclaration.initialization));
        }
        variableDeclarationFragment.setExtraDimensions(this.retrieveExtraDimension(fieldDeclaration.sourceEnd + 1, fieldDeclaration.declarationSourceEnd));
        if (this.resolveBindings) {
            this.recordNodes(name, fieldDeclaration);
            this.recordNodes(variableDeclarationFragment, fieldDeclaration);
            variableDeclarationFragment.resolveBinding();
        }
        return variableDeclarationFragment;
    }

    protected VariableDeclarationFragment convertToVariableDeclarationFragment(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.ast.newVariableDeclarationFragment();
        SimpleName name = this.ast.newSimpleName(new String(localDeclaration.name));
        name.setSourceRange(localDeclaration.sourceStart, localDeclaration.sourceEnd - localDeclaration.sourceStart + 1);
        variableDeclarationFragment.setName(name);
        int end = this.retrievePositionBeforeNextCommaOrSemiColon(localDeclaration.sourceEnd, this.compilationUnitSource.length);
        if (end == -1) {
            if (localDeclaration.initialization != null) {
                variableDeclarationFragment.setSourceRange(localDeclaration.sourceStart, localDeclaration.initialization.sourceEnd - localDeclaration.sourceStart + 1);
            } else {
                variableDeclarationFragment.setSourceRange(localDeclaration.sourceStart, localDeclaration.sourceEnd - localDeclaration.sourceStart + 1);
            }
        } else {
            variableDeclarationFragment.setSourceRange(localDeclaration.sourceStart, end - localDeclaration.sourceStart + 1);
        }
        if (localDeclaration.initialization != null) {
            variableDeclarationFragment.setInitializer(this.convert(localDeclaration.initialization));
        }
        variableDeclarationFragment.setExtraDimensions(this.retrieveExtraDimension(localDeclaration.sourceEnd + 1, this.compilationUnitSource.length));
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
            this.recordNodes(name, localDeclaration);
            variableDeclarationFragment.resolveBinding();
        }
        return variableDeclarationFragment;
    }

    protected VariableDeclarationStatement convertToVariableDeclarationStatement(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(localDeclaration);
        VariableDeclarationStatement variableDeclarationStatement = this.ast.newVariableDeclarationStatement(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
        }
        variableDeclarationStatement.setSourceRange(localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd - localDeclaration.declarationSourceStart + 1);
        Type type = this.convertType(localDeclaration.type);
        this.setTypeForVariableDeclarationStatement(variableDeclarationStatement, type, variableDeclarationFragment.getExtraDimensions());
        if (localDeclaration.modifiersSourceStart != -1) {
            this.setModifiers(variableDeclarationStatement, localDeclaration);
        }
        return variableDeclarationStatement;
    }

    public Type convertType(TypeReference typeReference) {
        Type type;
        block45: {
            int dimensions;
            int length;
            int sourceStart;
            block41: {
                block43: {
                    char[] name;
                    block44: {
                        block42: {
                            if (typeReference instanceof Wildcard) {
                                Wildcard wildcard = (Wildcard)typeReference;
                                WildcardType wildcardType = this.ast.newWildcardType();
                                if (wildcard.bound != null) {
                                    wildcardType.setBound(this.convertType(wildcard.bound), wildcard.kind == 1);
                                }
                                int start = wildcard.sourceStart;
                                int end = wildcard.sourceEnd;
                                wildcardType.setSourceRange(start, end - start + 1);
                                if (this.resolveBindings) {
                                    this.recordNodes(wildcardType, typeReference);
                                }
                                return wildcardType;
                            }
                            type = null;
                            sourceStart = -1;
                            length = 0;
                            dimensions = typeReference.dimensions();
                            if (!(typeReference instanceof SingleTypeReference)) break block41;
                            name = ((SingleTypeReference)typeReference).getTypeName()[0];
                            sourceStart = typeReference.sourceStart;
                            length = typeReference.sourceEnd - typeReference.sourceStart + 1;
                            if (!this.isPrimitiveType(name)) break block42;
                            int end = this.retrieveEndOfElementTypeNamePosition(sourceStart, sourceStart + length);
                            if (end == -1) {
                                end = sourceStart + length - 1;
                            }
                            type = this.ast.newPrimitiveType(this.getPrimitiveTypeCode(name));
                            type.setSourceRange(sourceStart, end - sourceStart + 1);
                            break block43;
                        }
                        if (!(typeReference instanceof ParameterizedSingleTypeReference)) break block44;
                        ParameterizedSingleTypeReference parameterizedSingleTypeReference = (ParameterizedSingleTypeReference)typeReference;
                        SimpleName simpleName = this.ast.newSimpleName(new String(name));
                        int end = this.retrieveEndOfElementTypeNamePosition(sourceStart, sourceStart + length);
                        if (end == -1) {
                            end = sourceStart + length - 1;
                        }
                        simpleName.setSourceRange(sourceStart, end - sourceStart + 1);
                        switch (this.ast.apiLevel) {
                            case 2: {
                                type = this.ast.newSimpleType(simpleName);
                                type.setFlags(type.getFlags() | 1);
                                type.setSourceRange(sourceStart, end - sourceStart + 1);
                                if (this.resolveBindings) {
                                    this.recordNodes(simpleName, typeReference);
                                    break;
                                }
                                break block43;
                            }
                            case 3: {
                                SimpleType simpleType = this.ast.newSimpleType(simpleName);
                                simpleType.setSourceRange(simpleName.getStartPosition(), simpleName.getLength());
                                type = this.ast.newParameterizedType(simpleType);
                                TypeReference[] typeArguments = parameterizedSingleTypeReference.typeArguments;
                                if (typeArguments != null) {
                                    Type type2 = null;
                                    int i = 0;
                                    int max = typeArguments.length;
                                    while (i < max) {
                                        type2 = this.convertType(typeArguments[i]);
                                        ((ParameterizedType)type).typeArguments().add(type2);
                                        end = type2.getStartPosition() + type2.getLength() - 1;
                                        ++i;
                                    }
                                    end = this.retrieveClosingAngleBracketPosition(end + 1);
                                    type.setSourceRange(sourceStart, end - sourceStart + 1);
                                } else {
                                    type.setSourceRange(sourceStart, end - sourceStart + 1);
                                }
                                if (this.resolveBindings) {
                                    this.recordNodes(simpleName, typeReference);
                                    this.recordNodes(simpleType, typeReference);
                                } else {
                                    break;
                                }
                            }
                        }
                        break block43;
                    }
                    SimpleName simpleName = this.ast.newSimpleName(new String(name));
                    int end = this.retrieveEndOfElementTypeNamePosition(sourceStart, sourceStart + length);
                    if (end == -1) {
                        end = sourceStart + length - 1;
                    }
                    simpleName.setSourceRange(sourceStart, end - sourceStart + 1);
                    type = this.ast.newSimpleType(simpleName);
                    type.setSourceRange(sourceStart, end - sourceStart + 1);
                    if (this.resolveBindings) {
                        this.recordNodes(simpleName, typeReference);
                    }
                }
                if (dimensions != 0) {
                    type = this.ast.newArrayType(type, dimensions);
                    type.setSourceRange(sourceStart, length);
                    if (this.resolveBindings) {
                        this.completeRecord((ArrayType)type, typeReference);
                    }
                }
                break block45;
            }
            if (typeReference instanceof ParameterizedQualifiedTypeReference) {
                ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference = (ParameterizedQualifiedTypeReference)typeReference;
                char[][] tokens = parameterizedQualifiedTypeReference.tokens;
                TypeReference[][] typeArguments = parameterizedQualifiedTypeReference.typeArguments;
                long[] positions = parameterizedQualifiedTypeReference.sourcePositions;
                sourceStart = (int)(positions[0] >>> 32);
                switch (this.ast.apiLevel) {
                    case 2: {
                        char[][] name = ((QualifiedTypeReference)typeReference).getTypeName();
                        int nameLength = name.length;
                        sourceStart = (int)(positions[0] >>> 32);
                        length = (int)(positions[nameLength - 1] & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
                        QualifiedName qualifiedName = this.setQualifiedNameNameAndSourceRanges(name, positions, typeReference);
                        type = this.ast.newSimpleType(qualifiedName);
                        type.setSourceRange(sourceStart, length);
                        break;
                    }
                    case 3: {
                        if (typeArguments != null) {
                            int numberOfEnclosingType = 0;
                            int i = 0;
                            int max = typeArguments.length;
                            while (i < max) {
                                if (typeArguments[i] != null) {
                                    ++numberOfEnclosingType;
                                }
                                ++i;
                            }
                            int startingIndex = 0;
                            int endingIndex = 0;
                            while (typeArguments[endingIndex] == null) {
                                ++endingIndex;
                            }
                            Name name = null;
                            if (endingIndex - startingIndex == 0) {
                                name = this.ast.newSimpleName(new String(tokens[startingIndex]));
                                this.recordPendingNameScopeResolution(name);
                                int start = (int)(positions[startingIndex] >>> 32);
                                int end = (int)positions[startingIndex];
                                name.setSourceRange(start, end - start + 1);
                            } else {
                                name = this.setQualifiedNameNameAndSourceRanges(tokens, positions, startingIndex, endingIndex, typeReference);
                            }
                            SimpleType simpleType = this.ast.newSimpleType(name);
                            int start = (int)(positions[startingIndex] >>> 32);
                            int end = (int)positions[endingIndex];
                            simpleType.setSourceRange(start, end - start + 1);
                            ParameterizedType parameterizedType = this.ast.newParameterizedType(simpleType);
                            start = simpleType.getStartPosition();
                            end = start + simpleType.getLength() - 1;
                            int i2 = 0;
                            int max2 = typeArguments[endingIndex].length;
                            while (i2 < max2) {
                                Type type2 = this.convertType(typeArguments[endingIndex][i2]);
                                parameterizedType.typeArguments().add(type2);
                                end = type2.getStartPosition() + type2.getLength() - 1;
                                ++i2;
                            }
                            end = this.retrieveClosingAngleBracketPosition(end + 1);
                            length = end + 1;
                            parameterizedType.setSourceRange(start, end - start + 1);
                            startingIndex = endingIndex + 1;
                            Type currentType = parameterizedType;
                            while (startingIndex < typeArguments.length) {
                                SimpleName simpleName = this.ast.newSimpleName(new String(tokens[startingIndex]));
                                start = (int)(positions[startingIndex] >>> 32);
                                end = (int)positions[startingIndex];
                                simpleName.setSourceRange(start, end - start + 1);
                                this.recordPendingNameScopeResolution(simpleName);
                                QualifiedType qualifiedType = this.ast.newQualifiedType(currentType, simpleName);
                                start = currentType.getStartPosition();
                                end = simpleName.getStartPosition() + simpleName.getLength() - 1;
                                qualifiedType.setSourceRange(start, end - start + 1);
                                if (typeArguments[startingIndex] != null) {
                                    ParameterizedType parameterizedType2 = this.ast.newParameterizedType(qualifiedType);
                                    int i3 = 0;
                                    int max3 = typeArguments[startingIndex].length;
                                    while (i3 < max3) {
                                        Type type2 = this.convertType(typeArguments[startingIndex][i3]);
                                        parameterizedType2.typeArguments().add(type2);
                                        end = type2.getStartPosition() + type2.getLength() - 1;
                                        ++i3;
                                    }
                                    end = this.retrieveClosingAngleBracketPosition(end + 1);
                                    length = end + 1;
                                    parameterizedType2.setSourceRange(start, end - start + 1);
                                    currentType = parameterizedType2;
                                } else {
                                    currentType = qualifiedType;
                                }
                                ++startingIndex;
                            }
                            if (this.resolveBindings) {
                                this.recordNodes(currentType, typeReference);
                            }
                            type = currentType;
                            length -= sourceStart;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                char[][] name = ((QualifiedTypeReference)typeReference).getTypeName();
                int nameLength = name.length;
                long[] positions = ((QualifiedTypeReference)typeReference).sourcePositions;
                sourceStart = (int)(positions[0] >>> 32);
                length = (int)(positions[nameLength - 1] & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
                QualifiedName qualifiedName = this.setQualifiedNameNameAndSourceRanges(name, positions, typeReference);
                type = this.ast.newSimpleType(qualifiedName);
                type.setSourceRange(sourceStart, length);
            }
            if (dimensions != 0) {
                int end;
                type = this.ast.newArrayType(type, dimensions);
                if (this.resolveBindings) {
                    this.completeRecord((ArrayType)type, typeReference);
                }
                if ((end = this.retrieveEndOfDimensionsPosition(sourceStart + length, this.compilationUnitSource.length)) != -1) {
                    type.setSourceRange(sourceStart, end - sourceStart + 1);
                } else {
                    type.setSourceRange(sourceStart, length);
                }
            }
        }
        if (this.resolveBindings) {
            this.recordNodes(type, typeReference);
        }
        return type;
    }

    protected Comment createComment(int[] positions) {
        Comment comment = null;
        int start = positions[0];
        int end = positions[1];
        if (positions[1] > 0) {
            this.ast.newJavadoc();
            Javadoc docComment = this.docParser.parse(positions);
            if (docComment == null) {
                return null;
            }
            comment = docComment;
        } else {
            end = -end;
            if (positions[0] > 0) {
                comment = this.ast.newBlockComment();
            } else {
                start = -start;
                comment = this.ast.newLineComment();
            }
            comment.setSourceRange(start, end - start);
        }
        return comment;
    }

    protected Statement createFakeEmptyStatement(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement statement) {
        EmptyStatement emptyStatement = this.ast.newEmptyStatement();
        emptyStatement.setFlags(emptyStatement.getFlags() | 1);
        int start = statement.sourceStart;
        int end = statement.sourceEnd;
        emptyStatement.setSourceRange(start, end - start + 1);
        return emptyStatement;
    }

    private Modifier createModifier(Modifier.ModifierKeyword keyword) {
        Modifier modifier = this.ast.newModifier(keyword);
        int start = this.scanner.getCurrentTokenStartPosition();
        int end = this.scanner.getCurrentTokenEndPosition();
        modifier.setSourceRange(start, end - start + 1);
        return modifier;
    }

    protected InfixExpression.Operator getOperatorFor(int operatorID) {
        switch (operatorID) {
            case 18: {
                return InfixExpression.Operator.EQUALS;
            }
            case 5: {
                return InfixExpression.Operator.LESS_EQUALS;
            }
            case 7: {
                return InfixExpression.Operator.GREATER_EQUALS;
            }
            case 29: {
                return InfixExpression.Operator.NOT_EQUALS;
            }
            case 10: {
                return InfixExpression.Operator.LEFT_SHIFT;
            }
            case 17: {
                return InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
            }
            case 19: {
                return InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
            }
            case 1: {
                return InfixExpression.Operator.CONDITIONAL_OR;
            }
            case 0: {
                return InfixExpression.Operator.CONDITIONAL_AND;
            }
            case 14: {
                return InfixExpression.Operator.PLUS;
            }
            case 13: {
                return InfixExpression.Operator.MINUS;
            }
            case 16: {
                return InfixExpression.Operator.REMAINDER;
            }
            case 8: {
                return InfixExpression.Operator.XOR;
            }
            case 2: {
                return InfixExpression.Operator.AND;
            }
            case 15: {
                return InfixExpression.Operator.TIMES;
            }
            case 3: {
                return InfixExpression.Operator.OR;
            }
            case 9: {
                return InfixExpression.Operator.DIVIDE;
            }
            case 6: {
                return InfixExpression.Operator.GREATER;
            }
            case 4: {
                return InfixExpression.Operator.LESS;
            }
        }
        return null;
    }

    protected PrimitiveType.Code getPrimitiveTypeCode(char[] name) {
        switch (name[0]) {
            case 'i': {
                if (name.length != 3 || name[1] != 'n' || name[2] != 't') break;
                return PrimitiveType.INT;
            }
            case 'l': {
                if (name.length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                return PrimitiveType.LONG;
            }
            case 'd': {
                if (name.length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                return PrimitiveType.DOUBLE;
            }
            case 'f': {
                if (name.length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                return PrimitiveType.FLOAT;
            }
            case 'b': {
                if (name.length == 4 && name[1] == 'y' && name[2] == 't' && name[3] == 'e') {
                    return PrimitiveType.BYTE;
                }
                if (name.length != 7 || name[1] != 'o' || name[2] != 'o' || name[3] != 'l' || name[4] != 'e' || name[5] != 'a' || name[6] != 'n') break;
                return PrimitiveType.BOOLEAN;
            }
            case 'c': {
                if (name.length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                return PrimitiveType.CHAR;
            }
            case 's': {
                if (name.length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                return PrimitiveType.SHORT;
            }
            case 'v': {
                if (name.length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                return PrimitiveType.VOID;
            }
        }
        return null;
    }

    protected boolean isPrimitiveType(char[] name) {
        switch (name[0]) {
            case 'i': {
                return name.length == 3 && name[1] == 'n' && name[2] == 't';
            }
            case 'l': {
                return name.length == 4 && name[1] == 'o' && name[2] == 'n' && name[3] == 'g';
            }
            case 'd': {
                return name.length == 6 && name[1] == 'o' && name[2] == 'u' && name[3] == 'b' && name[4] == 'l' && name[5] == 'e';
            }
            case 'f': {
                return name.length == 5 && name[1] == 'l' && name[2] == 'o' && name[3] == 'a' && name[4] == 't';
            }
            case 'b': {
                if (name.length == 4 && name[1] == 'y' && name[2] == 't' && name[3] == 'e') {
                    return true;
                }
                return name.length == 7 && name[1] == 'o' && name[2] == 'o' && name[3] == 'l' && name[4] == 'e' && name[5] == 'a' && name[6] == 'n';
            }
            case 'c': {
                return name.length == 4 && name[1] == 'h' && name[2] == 'a' && name[3] == 'r';
            }
            case 's': {
                return name.length == 5 && name[1] == 'h' && name[2] == 'o' && name[3] == 'r' && name[4] == 't';
            }
            case 'v': {
                return name.length == 4 && name[1] == 'o' && name[2] == 'i' && name[3] == 'd';
            }
        }
        return false;
    }

    private void lookupForScopes() {
        Iterator iterator;
        if (this.pendingNameScopeResolution != null) {
            iterator = this.pendingNameScopeResolution.iterator();
            while (iterator.hasNext()) {
                Name name = (Name)iterator.next();
                this.ast.getBindingResolver().recordScope(name, this.lookupScope(name));
            }
        }
        if (this.pendingThisExpressionScopeResolution != null) {
            iterator = this.pendingThisExpressionScopeResolution.iterator();
            while (iterator.hasNext()) {
                ThisExpression thisExpression = (ThisExpression)iterator.next();
                this.ast.getBindingResolver().recordScope(thisExpression, this.lookupScope(thisExpression));
            }
        }
    }

    private BlockScope lookupScope(ASTNode node) {
        ASTNode currentNode = node;
        while (!(currentNode == null || currentNode instanceof MethodDeclaration || currentNode instanceof Initializer || currentNode instanceof FieldDeclaration)) {
            currentNode = currentNode.getParent();
        }
        if (currentNode == null) {
            return null;
        }
        if (currentNode instanceof Initializer) {
            Initializer initializer = (Initializer)currentNode;
            while (!(currentNode instanceof AbstractTypeDeclaration)) {
                currentNode = currentNode.getParent();
            }
            if (currentNode instanceof TypeDeclaration || currentNode instanceof EnumDeclaration || currentNode instanceof AnnotationTypeDeclaration) {
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDecl = (org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)this.ast.getBindingResolver().getCorrespondingNode(currentNode);
                if ((initializer.getModifiers() & 8) != 0) {
                    return typeDecl.staticInitializerScope;
                }
                return typeDecl.initializerScope;
            }
        } else if (currentNode instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)currentNode;
            while (!(currentNode instanceof AbstractTypeDeclaration)) {
                currentNode = currentNode.getParent();
            }
            if (currentNode instanceof TypeDeclaration || currentNode instanceof EnumDeclaration || currentNode instanceof AnnotationTypeDeclaration) {
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDecl = (org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration)this.ast.getBindingResolver().getCorrespondingNode(currentNode);
                if ((fieldDeclaration.getModifiers() & 8) != 0) {
                    return typeDecl.staticInitializerScope;
                }
                return typeDecl.initializerScope;
            }
        }
        AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)this.ast.getBindingResolver().getCorrespondingNode(currentNode);
        return abstractMethodDeclaration.scope;
    }

    protected void recordName(Name name, org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode compilerNode) {
        if (compilerNode != null) {
            this.recordNodes(name, compilerNode);
            if (compilerNode instanceof TypeReference) {
                TypeReference typeRef = (TypeReference)compilerNode;
                if (name.isQualifiedName()) {
                    int count = 0;
                    SimpleName simpleName = null;
                    while (name.isQualifiedName()) {
                        simpleName = ((QualifiedName)name).getName();
                        this.recordNodes(simpleName, typeRef);
                        simpleName.index = count++;
                        name = ((QualifiedName)name).getQualifier();
                        name.index = count;
                        this.recordNodes(name, typeRef);
                    }
                }
            }
        }
    }

    protected void recordNodes(ASTNode node, org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode oldASTNode) {
        this.ast.getBindingResolver().store(node, oldASTNode);
    }

    protected void recordNodes(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Javadoc javadoc, TagElement tagElement) {
        ListIterator fragments = tagElement.fragments().listIterator();
        while (fragments.hasNext()) {
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression expression;
            TypeReference typeRef;
            org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode compilerNode;
            int start;
            SimpleName name;
            ASTNode node = (ASTNode)fragments.next();
            if (node.getNodeType() == 67) {
                MemberRef memberRef = (MemberRef)node;
                name = memberRef.getName();
                start = name.getStartPosition();
                compilerNode = javadoc.getNodeStartingAt(start);
                if (compilerNode != null) {
                    this.recordNodes(name, compilerNode);
                    this.recordNodes(node, compilerNode);
                }
                if (memberRef.getQualifier() == null) continue;
                typeRef = null;
                if (compilerNode instanceof JavadocFieldReference) {
                    expression = ((JavadocFieldReference)compilerNode).receiver;
                    if (expression instanceof TypeReference) {
                        typeRef = (TypeReference)expression;
                    }
                } else if (compilerNode instanceof JavadocMessageSend && (expression = ((JavadocMessageSend)compilerNode).receiver) instanceof TypeReference) {
                    typeRef = (TypeReference)expression;
                }
                if (typeRef == null) continue;
                this.recordName(memberRef.getQualifier(), typeRef);
                continue;
            }
            if (node.getNodeType() == 68) {
                MethodRef methodRef = (MethodRef)node;
                name = methodRef.getName();
                start = name.getStartPosition();
                compilerNode = javadoc.getNodeStartingAt(start);
                if (compilerNode != null) {
                    this.recordNodes(methodRef, compilerNode);
                    typeRef = null;
                    if (compilerNode instanceof JavadocAllocationExpression) {
                        typeRef = ((JavadocAllocationExpression)compilerNode).type;
                        if (typeRef != null) {
                            this.recordNodes(name, typeRef);
                        }
                    } else if (compilerNode instanceof JavadocMessageSend) {
                        expression = ((JavadocMessageSend)compilerNode).receiver;
                        if (expression instanceof TypeReference) {
                            typeRef = (TypeReference)expression;
                        }
                        this.recordNodes(name, compilerNode);
                    }
                    if (typeRef != null && methodRef.getQualifier() != null) {
                        this.recordName(methodRef.getQualifier(), typeRef);
                    }
                }
                ListIterator parameters = methodRef.parameters().listIterator();
                while (parameters.hasNext()) {
                    Type type;
                    MethodRefParameter param = (MethodRefParameter)parameters.next();
                    org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression expression2 = (org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression)javadoc.getNodeStartingAt(param.getStartPosition());
                    if (expression2 == null) continue;
                    this.recordNodes(param, expression2);
                    if (!(expression2 instanceof JavadocArgumentExpression)) continue;
                    JavadocArgumentExpression argExpr = (JavadocArgumentExpression)expression2;
                    TypeReference typeRef2 = argExpr.argument.type;
                    this.recordNodes(param.getType(), typeRef2);
                    if (param.getType().isSimpleType()) {
                        type = (SimpleType)param.getType();
                        this.recordName(((SimpleType)type).getName(), typeRef2);
                        continue;
                    }
                    if (!param.getType().isArrayType() || !(type = ((ArrayType)param.getType()).getElementType()).isSimpleType()) continue;
                    this.recordName(((SimpleType)type).getName(), typeRef2);
                }
                continue;
            }
            if (node.getNodeType() == 42 || node.getNodeType() == 40) {
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode compilerNode2 = javadoc.getNodeStartingAt(node.getStartPosition());
                this.recordName((Name)node, compilerNode2);
                continue;
            }
            if (node.getNodeType() != 65) continue;
            this.recordNodes(javadoc, (TagElement)node);
        }
    }

    protected void recordPendingNameScopeResolution(Name name) {
        if (this.pendingNameScopeResolution == null) {
            this.pendingNameScopeResolution = new HashSet();
        }
        this.pendingNameScopeResolution.add(name);
    }

    protected void recordPendingThisExpressionScopeResolution(ThisExpression thisExpression) {
        if (this.pendingThisExpressionScopeResolution == null) {
            this.pendingThisExpressionScopeResolution = new HashSet();
        }
        this.pendingThisExpressionScopeResolution.add(thisExpression);
    }

    private void trimWhiteSpacesAndComments(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression expression) {
        int start = expression.sourceStart;
        int end = expression.sourceEnd;
        int trimLeftPosition = expression.sourceStart;
        int trimRightPosition = expression.sourceEnd;
        boolean first = true;
        Scanner removeBlankScanner = this.ast.scanner;
        try {
            removeBlankScanner.setSource(this.compilationUnitSource);
            removeBlankScanner.resetTo(start, end);
            block7: while (true) {
                int token = removeBlankScanner.getNextToken();
                switch (token) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        if (!first) continue block7;
                        trimLeftPosition = removeBlankScanner.currentPosition;
                        continue block7;
                    }
                    case 1000: {
                        if (!first) continue block7;
                        trimLeftPosition = removeBlankScanner.currentPosition;
                        continue block7;
                    }
                    case 75: {
                        expression.sourceStart = trimLeftPosition;
                        expression.sourceEnd = trimRightPosition;
                        return;
                    }
                }
                trimRightPosition = removeBlankScanner.currentPosition - 1;
                first = false;
            }
        }
        catch (InvalidInputException invalidInputException) {
            return;
        }
    }

    protected void removeLeadingAndTrailingCommentsFromLiteral(ASTNode node) {
        int start = node.getStartPosition();
        this.scanner.resetTo(start, start + node.getLength());
        int startPosition = -1;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: {
                        if (startPosition == -1) {
                            startPosition = this.scanner.startPosition;
                        }
                        int end = this.scanner.currentPosition;
                        node.setSourceRange(startPosition, end - startPosition);
                        return;
                    }
                    case 3: {
                        startPosition = this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    protected void removeTrailingCommentFromExpressionEndingWithAParen(ASTNode node) {
        int start = node.getStartPosition();
        this.scanner.resetTo(start, start + node.getLength());
        int parenCounter = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 21: {
                        ++parenCounter;
                        break;
                    }
                    case 30: {
                        if (--parenCounter != 0) break;
                        int end = this.scanner.currentPosition - 1;
                        node.setSourceRange(start, end - start + 1);
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    protected int retrieveClosingAngleBracketPosition(int start) {
        this.scanner.resetTo(start, this.scanner.eofPosition);
        this.scanner.returnOnlyGreater = true;
        try {
            int token = this.scanner.getNextToken();
            if (token != 75) {
                switch (token) {
                    case 14: {
                        return this.scanner.currentPosition - 1;
                    }
                }
                return start;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        this.scanner.returnOnlyGreater = false;
        return start;
    }

    protected void retrieveColonPosition(ASTNode node) {
        int start = node.getStartPosition();
        int length = node.getLength();
        int end = start + length;
        this.scanner.resetTo(end, this.compilationUnitSource.length);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 72: {
                        node.setSourceRange(start, this.scanner.currentPosition - start);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    protected int retrieveEllipsisStartPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 112: {
                        return this.scanner.startPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrieveEndBlockPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        int count = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 74: {
                        ++count;
                        break;
                    }
                    case 38: {
                        if (--count != 0) break;
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrieveEndingSemiColonPosition(int start, int end) {
        int count = 0;
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 28: {
                        if (count != 0) break;
                        return this.scanner.currentPosition - 1;
                    }
                    case 74: {
                        ++count;
                        break;
                    }
                    case 38: {
                        --count;
                        break;
                    }
                    case 21: {
                        ++count;
                        break;
                    }
                    case 30: {
                        --count;
                        break;
                    }
                    case 12: {
                        ++count;
                        break;
                    }
                    case 77: {
                        --count;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrieveEndOfDimensionsPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        int foundPosition = -1;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 12: 
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        break;
                    }
                    case 77: {
                        foundPosition = this.scanner.currentPosition - 1;
                        break;
                    }
                    default: {
                        return foundPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return foundPosition;
    }

    protected int retrieveEndOfElementTypeNamePosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 22: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrieveEndOfRightParenthesisPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 30: {
                        return this.scanner.currentPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrieveExtraDimension(int start, int end) {
        this.scanner.resetTo(start, end);
        int dimensions = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 77: {
                        ++dimensions;
                        break;
                    }
                    case 28: 
                    case 30: 
                    case 37: 
                    case 74: 
                    case 92: {
                        return dimensions;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return dimensions;
    }

    protected void retrieveIdentifierAndSetPositions(int start, int end, Name name) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                if (token != 22) continue;
                int startName = this.scanner.startPosition;
                int endName = this.scanner.currentPosition - 1;
                name.setSourceRange(startName, endName - startName + 1);
                return;
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    protected int retrieveIdentifierEndPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 22: {
                        return this.scanner.getCurrentTokenEndPosition();
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrievePositionBeforeNextCommaOrSemiColon(int start, int end) {
        this.scanner.resetTo(start, end);
        int braceCounter = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 74: {
                        ++braceCounter;
                        break;
                    }
                    case 38: {
                        --braceCounter;
                        break;
                    }
                    case 21: {
                        ++braceCounter;
                        break;
                    }
                    case 30: {
                        --braceCounter;
                        break;
                    }
                    case 12: {
                        ++braceCounter;
                        break;
                    }
                    case 77: {
                        --braceCounter;
                        break;
                    }
                    case 28: 
                    case 37: {
                        if (braceCounter != 0) break;
                        return this.scanner.startPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrieveProperRightBracketPosition(int bracketNumber, int start) {
        this.scanner.resetTo(start, this.compilationUnitSource.length);
        try {
            int token;
            int count = 0;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 77: {
                        if (++count != bracketNumber) break;
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrieveRightBraceOrSemiColonPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 38: {
                        return this.scanner.currentPosition - 1;
                    }
                    case 28: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrieveRightBrace(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 38: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrieveRightBracketPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 77: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected void retrieveSemiColonPosition(ASTNode node) {
        int start = node.getStartPosition();
        int length = node.getLength();
        int end = start + length;
        int count = 0;
        this.scanner.resetTo(end, this.compilationUnitSource.length);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 28: {
                        if (count != 0) break;
                        node.setSourceRange(start, this.scanner.currentPosition - start);
                        return;
                    }
                    case 74: {
                        ++count;
                        break;
                    }
                    case 38: {
                        --count;
                        break;
                    }
                    case 21: {
                        ++count;
                        break;
                    }
                    case 30: {
                        --count;
                        break;
                    }
                    case 12: {
                        ++count;
                        break;
                    }
                    case 77: {
                        --count;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    protected int retrieveStartBlockPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 74: {
                        return this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    protected int retrieveStartingCatchPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 75) {
                switch (token) {
                    case 95: {
                        return this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return -1;
    }

    public void setAST(AST ast) {
        this.ast = ast;
        this.docParser = new DocCommentParser(this.ast, this.scanner, this.insideComments);
    }

    protected void setModifiers(AnnotationTypeDeclaration typeDecl, org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration) {
        this.scanner.resetTo(typeDeclaration.declarationSourceStart, typeDeclaration.sourceStart);
        this.setModifiers((BodyDeclaration)typeDecl, typeDeclaration.annotations);
    }

    protected void setModifiers(AnnotationTypeMemberDeclaration annotationTypeMemberDecl, AnnotationMethodDeclaration annotationTypeMemberDeclaration) {
        this.scanner.resetTo(annotationTypeMemberDeclaration.declarationSourceStart, annotationTypeMemberDeclaration.sourceStart);
        this.setModifiers((BodyDeclaration)annotationTypeMemberDecl, annotationTypeMemberDeclaration.annotations);
    }

    protected void setModifiers(BodyDeclaration bodyDeclaration, org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation[] annotations) {
        try {
            int token;
            int indexInAnnotations = 0;
            int eofPosition = this.scanner.eofPosition;
            while ((token = this.scanner.getNextToken()) != 75) {
                ASTNode modifier = null;
                switch (token) {
                    case 63: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                        break;
                    }
                    case 68: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                        break;
                    }
                    case 52: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                        break;
                    }
                    case 67: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
                        break;
                    }
                    case 66: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                        break;
                    }
                    case 64: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                        break;
                    }
                    case 65: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD);
                        break;
                    }
                    case 53: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
                        break;
                    }
                    case 70: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
                        break;
                    }
                    case 71: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD);
                        break;
                    }
                    case 69: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD);
                        break;
                    }
                    case 50: {
                        if (annotations == null || indexInAnnotations >= annotations.length) break;
                        org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation annotation = annotations[indexInAnnotations++];
                        modifier = this.convert(annotation);
                        this.scanner.resetTo(annotation.declarationSourceEnd + 1, eofPosition);
                        break;
                    }
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (modifier == null) continue;
                bodyDeclaration.modifiers().add(modifier);
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    protected void setModifiers(EnumDeclaration enumDeclaration, org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration enumDeclaration2) {
        this.scanner.resetTo(enumDeclaration2.declarationSourceStart, enumDeclaration2.sourceStart);
        this.setModifiers((BodyDeclaration)enumDeclaration, enumDeclaration2.annotations);
    }

    protected void setModifiers(FieldDeclaration fieldDeclaration, org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration fieldDecl) {
        switch (this.ast.apiLevel) {
            case 2: {
                fieldDeclaration.setModifiers(fieldDecl.modifiers & 0xFFFF);
                if (fieldDecl.annotations == null) break;
                fieldDeclaration.setFlags(fieldDeclaration.getFlags() | 1);
                break;
            }
            case 3: {
                this.scanner.resetTo(fieldDecl.declarationSourceStart, fieldDecl.sourceStart);
                this.setModifiers((BodyDeclaration)fieldDeclaration, fieldDecl.annotations);
            }
        }
    }

    protected void setModifiers(Initializer initializer, org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer oldInitializer) {
        switch (this.ast.apiLevel) {
            case 2: {
                initializer.setModifiers(oldInitializer.modifiers & 0xFFFF);
                if (oldInitializer.annotations == null) break;
                initializer.setFlags(initializer.getFlags() | 1);
                break;
            }
            case 3: {
                this.scanner.resetTo(oldInitializer.declarationSourceStart, oldInitializer.bodyStart);
                this.setModifiers((BodyDeclaration)initializer, oldInitializer.annotations);
            }
        }
    }

    protected void setModifiers(MethodDeclaration methodDecl, AbstractMethodDeclaration methodDeclaration) {
        switch (this.ast.apiLevel) {
            case 2: {
                methodDecl.setModifiers(methodDeclaration.modifiers & 0xFFFF);
                if (methodDeclaration.annotations == null) break;
                methodDecl.setFlags(methodDecl.getFlags() | 1);
                break;
            }
            case 3: {
                this.scanner.resetTo(methodDeclaration.declarationSourceStart, methodDeclaration.sourceStart);
                this.setModifiers((BodyDeclaration)methodDecl, methodDeclaration.annotations);
            }
        }
    }

    protected void setModifiers(SingleVariableDeclaration variableDecl, Argument argument) {
        switch (this.ast.apiLevel) {
            case 2: {
                variableDecl.setModifiers(argument.modifiers & 0xFFFF);
                if (argument.annotations == null) break;
                variableDecl.setFlags(variableDecl.getFlags() | 1);
                break;
            }
            case 3: {
                this.scanner.resetTo(argument.declarationSourceStart, argument.sourceStart);
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation[] annotations = argument.annotations;
                int indexInAnnotations = 0;
                try {
                    int token;
                    while ((token = this.scanner.getNextToken()) != 75) {
                        ASTNode modifier = null;
                        switch (token) {
                            case 63: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                                break;
                            }
                            case 68: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                                break;
                            }
                            case 52: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                                break;
                            }
                            case 67: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
                                break;
                            }
                            case 66: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                                break;
                            }
                            case 64: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                                break;
                            }
                            case 65: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD);
                                break;
                            }
                            case 53: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
                                break;
                            }
                            case 70: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
                                break;
                            }
                            case 71: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD);
                                break;
                            }
                            case 69: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD);
                                break;
                            }
                            case 50: {
                                if (annotations == null || indexInAnnotations >= annotations.length) break;
                                org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation annotation = annotations[indexInAnnotations++];
                                modifier = this.convert(annotation);
                                this.scanner.resetTo(annotation.declarationSourceEnd + 1, this.scanner.eofPosition);
                            }
                        }
                        if (modifier == null) continue;
                        variableDecl.modifiers().add(modifier);
                    }
                    break;
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
        }
    }

    protected void setModifiers(SingleVariableDeclaration variableDecl, LocalDeclaration localDeclaration) {
        switch (this.ast.apiLevel) {
            case 2: {
                variableDecl.setModifiers(localDeclaration.modifiers & 0xFFFF);
                if (localDeclaration.annotations == null) break;
                variableDecl.setFlags(variableDecl.getFlags() | 1);
                break;
            }
            case 3: {
                this.scanner.resetTo(localDeclaration.declarationSourceStart, localDeclaration.sourceStart);
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation[] annotations = localDeclaration.annotations;
                int indexInAnnotations = 0;
                try {
                    int token;
                    while ((token = this.scanner.getNextToken()) != 75) {
                        ASTNode modifier = null;
                        switch (token) {
                            case 63: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                                break;
                            }
                            case 68: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                                break;
                            }
                            case 52: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                                break;
                            }
                            case 67: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
                                break;
                            }
                            case 66: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                                break;
                            }
                            case 64: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                                break;
                            }
                            case 65: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD);
                                break;
                            }
                            case 53: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
                                break;
                            }
                            case 70: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
                                break;
                            }
                            case 71: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD);
                                break;
                            }
                            case 69: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD);
                                break;
                            }
                            case 50: {
                                if (annotations == null || indexInAnnotations >= annotations.length) break;
                                org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation annotation = annotations[indexInAnnotations++];
                                modifier = this.convert(annotation);
                                this.scanner.resetTo(annotation.declarationSourceEnd + 1, this.scanner.eofPosition);
                            }
                        }
                        if (modifier == null) continue;
                        variableDecl.modifiers().add(modifier);
                    }
                    break;
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
        }
    }

    protected void setModifiers(TypeDeclaration typeDecl, org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration typeDeclaration) {
        switch (this.ast.apiLevel) {
            case 2: {
                int modifiers = typeDeclaration.modifiers;
                modifiers &= 0xFFFFFDFF;
                typeDecl.setModifiers(modifiers &= 0xFFFF);
                if (typeDeclaration.annotations == null) break;
                typeDecl.setFlags(typeDecl.getFlags() | 1);
                break;
            }
            case 3: {
                this.scanner.resetTo(typeDeclaration.declarationSourceStart, typeDeclaration.sourceStart);
                this.setModifiers((BodyDeclaration)typeDecl, typeDeclaration.annotations);
            }
        }
    }

    protected void setModifiers(VariableDeclarationExpression variableDeclarationExpression, LocalDeclaration localDeclaration) {
        switch (this.ast.apiLevel) {
            case 2: {
                int modifiers = localDeclaration.modifiers & 0xFFFF;
                variableDeclarationExpression.setModifiers(modifiers &= 0xFBFFFFFF);
                if (localDeclaration.annotations == null) break;
                variableDeclarationExpression.setFlags(variableDeclarationExpression.getFlags() | 1);
                break;
            }
            case 3: {
                this.scanner.resetTo(localDeclaration.declarationSourceStart, localDeclaration.sourceStart);
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation[] annotations = localDeclaration.annotations;
                int indexInAnnotations = 0;
                try {
                    int token;
                    while ((token = this.scanner.getNextToken()) != 75) {
                        ASTNode modifier = null;
                        switch (token) {
                            case 63: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                                break;
                            }
                            case 68: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                                break;
                            }
                            case 52: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                                break;
                            }
                            case 67: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
                                break;
                            }
                            case 66: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                                break;
                            }
                            case 64: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                                break;
                            }
                            case 65: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD);
                                break;
                            }
                            case 53: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
                                break;
                            }
                            case 70: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
                                break;
                            }
                            case 71: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD);
                                break;
                            }
                            case 69: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD);
                                break;
                            }
                            case 50: {
                                if (annotations == null || indexInAnnotations >= annotations.length) break;
                                org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation annotation = annotations[indexInAnnotations++];
                                modifier = this.convert(annotation);
                                this.scanner.resetTo(annotation.declarationSourceEnd + 1, this.scanner.eofPosition);
                            }
                        }
                        if (modifier == null) continue;
                        variableDeclarationExpression.modifiers().add(modifier);
                    }
                    break;
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
        }
    }

    protected void setModifiers(VariableDeclarationStatement variableDeclarationStatement, LocalDeclaration localDeclaration) {
        switch (this.ast.apiLevel) {
            case 2: {
                int modifiers = localDeclaration.modifiers & 0xFFFF;
                variableDeclarationStatement.setModifiers(modifiers &= 0xFBFFFFFF);
                if (localDeclaration.annotations == null) break;
                variableDeclarationStatement.setFlags(variableDeclarationStatement.getFlags() | 1);
                break;
            }
            case 3: {
                this.scanner.resetTo(localDeclaration.declarationSourceStart, localDeclaration.sourceStart);
                org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation[] annotations = localDeclaration.annotations;
                int indexInAnnotations = 0;
                try {
                    int token;
                    while ((token = this.scanner.getNextToken()) != 75) {
                        ASTNode modifier = null;
                        switch (token) {
                            case 63: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                                break;
                            }
                            case 68: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                                break;
                            }
                            case 52: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                                break;
                            }
                            case 67: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
                                break;
                            }
                            case 66: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                                break;
                            }
                            case 64: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                                break;
                            }
                            case 65: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD);
                                break;
                            }
                            case 53: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
                                break;
                            }
                            case 70: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
                                break;
                            }
                            case 71: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD);
                                break;
                            }
                            case 69: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD);
                                break;
                            }
                            case 50: {
                                if (annotations == null || indexInAnnotations >= annotations.length) break;
                                org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation annotation = annotations[indexInAnnotations++];
                                modifier = this.convert(annotation);
                                this.scanner.resetTo(annotation.declarationSourceEnd + 1, this.scanner.eofPosition);
                            }
                        }
                        if (modifier == null) continue;
                        variableDeclarationStatement.modifiers().add(modifier);
                    }
                    break;
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
        }
    }

    protected QualifiedName setQualifiedNameNameAndSourceRanges(char[][] typeName, long[] positions, org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode node) {
        int start0;
        int length = typeName.length;
        SimpleName firstToken = this.ast.newSimpleName(new String(typeName[0]));
        firstToken.index = length - 1;
        int start = start0 = (int)(positions[0] >>> 32);
        int end = (int)(positions[0] & 0xFFFFFFFFFFFFFFFFL);
        firstToken.setSourceRange(start, end - start + 1);
        SimpleName secondToken = this.ast.newSimpleName(new String(typeName[1]));
        secondToken.index = length - 2;
        start = (int)(positions[1] >>> 32);
        end = (int)(positions[1] & 0xFFFFFFFFFFFFFFFFL);
        secondToken.setSourceRange(start, end - start + 1);
        QualifiedName qualifiedName = this.ast.newQualifiedName(firstToken, secondToken);
        if (this.resolveBindings) {
            this.recordNodes(qualifiedName, node);
            this.recordPendingNameScopeResolution(qualifiedName);
            this.recordNodes(firstToken, node);
            this.recordNodes(secondToken, node);
            this.recordPendingNameScopeResolution(firstToken);
            this.recordPendingNameScopeResolution(secondToken);
        }
        qualifiedName.index = length - 2;
        qualifiedName.setSourceRange(start0, end - start0 + 1);
        SimpleName newPart = null;
        int i = 2;
        while (i < length) {
            newPart = this.ast.newSimpleName(new String(typeName[i]));
            newPart.index = length - i - 1;
            start = (int)(positions[i] >>> 32);
            end = (int)(positions[i] & 0xFFFFFFFFFFFFFFFFL);
            newPart.setSourceRange(start, end - start + 1);
            qualifiedName = this.ast.newQualifiedName(qualifiedName, newPart);
            qualifiedName.index = newPart.index;
            qualifiedName.setSourceRange(start0, end - start0 + 1);
            if (this.resolveBindings) {
                this.recordNodes(qualifiedName, node);
                this.recordNodes(newPart, node);
                this.recordPendingNameScopeResolution(qualifiedName);
                this.recordPendingNameScopeResolution(newPart);
            }
            ++i;
        }
        QualifiedName name = qualifiedName;
        if (this.resolveBindings) {
            this.recordNodes(name, node);
            this.recordPendingNameScopeResolution(name);
        }
        return name;
    }

    protected QualifiedName setQualifiedNameNameAndSourceRanges(char[][] typeName, long[] positions, int startingIndex, int endingIndex, org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode node) {
        int start0;
        int length = endingIndex - startingIndex + 1;
        SimpleName firstToken = this.ast.newSimpleName(new String(typeName[startingIndex]));
        firstToken.index = startingIndex;
        int start = start0 = (int)(positions[startingIndex] >>> 32);
        int end = (int)positions[startingIndex];
        firstToken.setSourceRange(start, end - start + 1);
        SimpleName secondToken = this.ast.newSimpleName(new String(typeName[startingIndex + 1]));
        secondToken.index = startingIndex + 1;
        start = (int)(positions[startingIndex + 1] >>> 32);
        end = (int)positions[startingIndex + 1];
        secondToken.setSourceRange(start, end - start + 1);
        QualifiedName qualifiedName = this.ast.newQualifiedName(firstToken, secondToken);
        if (this.resolveBindings) {
            this.recordNodes(qualifiedName, node);
            this.recordPendingNameScopeResolution(qualifiedName);
            this.recordNodes(firstToken, node);
            this.recordNodes(secondToken, node);
            this.recordPendingNameScopeResolution(firstToken);
            this.recordPendingNameScopeResolution(secondToken);
        }
        qualifiedName.index = startingIndex + 1;
        qualifiedName.setSourceRange(start0, end - start0 + 1);
        SimpleName newPart = null;
        int i = 2;
        while (i < length) {
            newPart = this.ast.newSimpleName(new String(typeName[i]));
            newPart.index = startingIndex + i;
            start = (int)(positions[i] >>> 32);
            end = (int)positions[i];
            newPart.setSourceRange(start, end - start + 1);
            qualifiedName = this.ast.newQualifiedName(qualifiedName, newPart);
            qualifiedName.index = newPart.index;
            qualifiedName.setSourceRange(start0, end - start0 + 1);
            if (this.resolveBindings) {
                this.recordNodes(qualifiedName, node);
                this.recordNodes(newPart, node);
                this.recordPendingNameScopeResolution(qualifiedName);
                this.recordPendingNameScopeResolution(newPart);
            }
            ++i;
        }
        QualifiedName name = qualifiedName;
        if (this.resolveBindings) {
            this.recordNodes(name, node);
            this.recordPendingNameScopeResolution(name);
        }
        return name;
    }

    protected void setTypeNameForAnnotation(org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation compilerAnnotation, Annotation annotation) {
        Name name;
        TypeReference typeReference = compilerAnnotation.type;
        if (typeReference instanceof QualifiedTypeReference) {
            QualifiedTypeReference qualifiedTypeReference = (QualifiedTypeReference)typeReference;
            char[][] tokens = qualifiedTypeReference.tokens;
            long[] positions = qualifiedTypeReference.sourcePositions;
            name = this.setQualifiedNameNameAndSourceRanges(tokens, positions, compilerAnnotation);
        } else {
            SingleTypeReference singleTypeReference = (SingleTypeReference)typeReference;
            name = this.ast.newSimpleName(new String(singleTypeReference.token));
            int start = singleTypeReference.sourceStart;
            int end = singleTypeReference.sourceEnd;
            name.setSourceRange(start, end - start + 1);
        }
        if (this.resolveBindings) {
            this.recordNodes(name, compilerAnnotation);
        }
        annotation.setTypeName(name);
    }

    protected void setTypeForField(FieldDeclaration fieldDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    fieldDeclaration.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    fieldDeclaration.setType(subarrayType);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                fieldDeclaration.setType(type);
            }
        } else {
            if (type.isArrayType()) {
                int dimensions = ((ArrayType)type).getDimensions();
                this.updateInnerPositions(type, dimensions);
            }
            fieldDeclaration.setType(type);
        }
    }

    protected void setTypeForMethodDeclaration(MethodDeclaration methodDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    switch (this.ast.apiLevel) {
                        case 2: {
                            methodDeclaration.setReturnType(elementType);
                            break;
                        }
                        case 3: {
                            methodDeclaration.setReturnType2(elementType);
                        }
                    }
                } else {
                    int start = type.getStartPosition();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    switch (this.ast.apiLevel) {
                        case 2: {
                            methodDeclaration.setReturnType(subarrayType);
                            break;
                        }
                        case 3: {
                            methodDeclaration.setReturnType2(subarrayType);
                        }
                    }
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                switch (this.ast.apiLevel) {
                    case 2: {
                        methodDeclaration.setReturnType(type);
                        break;
                    }
                    case 3: {
                        methodDeclaration.setReturnType2(type);
                    }
                }
            }
        } else {
            switch (this.ast.apiLevel) {
                case 2: {
                    methodDeclaration.setReturnType(type);
                    break;
                }
                case 3: {
                    methodDeclaration.setReturnType2(type);
                }
            }
        }
    }

    protected void setTypeForMethodDeclaration(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration, Type type, int extraDimension) {
        annotationTypeMemberDeclaration.setType(type);
    }

    protected void setTypeForSingleVariableDeclaration(SingleVariableDeclaration singleVariableDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    singleVariableDeclaration.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    singleVariableDeclaration.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                singleVariableDeclaration.setType(type);
            }
        } else {
            singleVariableDeclaration.setType(type);
        }
    }

    protected void setTypeForVariableDeclarationExpression(VariableDeclarationExpression variableDeclarationExpression, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    variableDeclarationExpression.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    variableDeclarationExpression.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                variableDeclarationExpression.setType(type);
            }
        } else {
            variableDeclarationExpression.setType(type);
        }
    }

    protected void setTypeForVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    variableDeclarationStatement.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    variableDeclarationStatement.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                variableDeclarationStatement.setType(type);
            }
        } else {
            variableDeclarationStatement.setType(type);
        }
    }

    protected void updateInnerPositions(Type type, int dimensions) {
        if (dimensions > 1) {
            int start = type.getStartPosition();
            Type currentComponentType = ((ArrayType)type).getComponentType();
            int searchedDimension = dimensions - 1;
            int rightBracketEndPosition = start;
            while (currentComponentType.isArrayType()) {
                rightBracketEndPosition = this.retrieveProperRightBracketPosition(searchedDimension, start);
                currentComponentType.setSourceRange(start, rightBracketEndPosition - start + 1);
                currentComponentType = ((ArrayType)currentComponentType).getComponentType();
                --searchedDimension;
            }
        }
    }
}

