/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.fop.image.analyser.AbstractImageReader;

public class TIFFReader
extends AbstractImageReader {
    protected static final int TIFF_SIG_LENGTH = 8;
    protected byte[] header;

    public String getMimeType() {
        return "image/tiff";
    }

    protected void setDefaultHeader() throws IOException {
        this.header = new byte[8];
        try {
            this.imageStream.mark(9);
            this.imageStream.read(this.header);
            this.imageStream.reset();
        }
        catch (IOException ex) {
            try {
                this.imageStream.reset();
            }
            catch (IOException iOException) {}
            throw ex;
        }
    }

    protected void setDimension() {
    }

    public boolean verifySignature(String uri, BufferedInputStream fis) throws IOException {
        this.imageStream = fis;
        this.setDefaultHeader();
        boolean supported = false;
        if (this.header[0] == 73 && this.header[1] == 73 && this.header[2] == 42 && this.header[3] == 0) {
            supported = true;
        }
        if (this.header[0] == 77 && this.header[1] == 77 && this.header[2] == 0 && this.header[3] == 42) {
            supported = true;
        }
        if (supported) {
            this.setDimension();
            return true;
        }
        return false;
    }
}

