/*
 * Decompiled with CFR 0.152.
 */
package com.foo;

import com.foobar.Utils;
import java.text.DateFormatSymbols;
import java.text.spi.DateFormatSymbolsProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DateFormatSymbolsProviderImpl
extends DateFormatSymbolsProvider {
    static Locale[] avail = new Locale[]{new Locale("ja", "JP", "osaka"), new Locale("ja", "JP", "kyoto"), Locale.JAPAN, new Locale("yy", "ZZ")};
    static List<Locale> availList = Arrays.asList(avail);
    static String[] dialect = new String[]{"\u3084\u3002", "\u3069\u3059\u3002", "\u3067\u3059\u3002", "-yy-ZZ"};
    static Map<Locale, FooDateFormatSymbols> symbols = new HashMap<Locale, FooDateFormatSymbols>(4);

    @Override
    public Locale[] getAvailableLocales() {
        return avail;
    }

    @Override
    public DateFormatSymbols getInstance(Locale locale) {
        if (!Utils.supportsLocale(availList, locale)) {
            throw new IllegalArgumentException("locale is not supported: " + locale);
        }
        FooDateFormatSymbols fooDateFormatSymbols = symbols.get(locale);
        if (fooDateFormatSymbols == null) {
            for (int i = 0; i < avail.length; ++i) {
                if (!Utils.supportsLocale(avail[i], locale)) continue;
                fooDateFormatSymbols = new FooDateFormatSymbols(i);
                symbols.put(locale, fooDateFormatSymbols);
                break;
            }
        }
        return fooDateFormatSymbols;
    }

    class FooDateFormatSymbols
    extends DateFormatSymbols {
        String dialect;
        String[] eras;
        String[] months;
        String[] shortMonths;
        String[] weekdays;
        String[] shortWeekdays;
        String[] ampms;

        public FooDateFormatSymbols(int n) {
            super(avail[n]);
            this.dialect = "";
            this.eras = null;
            this.months = null;
            this.shortMonths = null;
            this.weekdays = null;
            this.shortWeekdays = null;
            this.ampms = null;
            this.dialect = dialect[n];
        }

        @Override
        public String[] getEras() {
            if (this.eras == null) {
                this.eras = super.getEras();
                for (int i = 0; i < this.eras.length; ++i) {
                    this.eras[i] = this.eras[i] + this.dialect;
                }
            }
            return this.eras;
        }

        @Override
        public void setEras(String[] stringArray) {
            this.eras = stringArray;
        }

        @Override
        public String[] getMonths() {
            if (this.months == null) {
                this.months = super.getMonths();
                for (int i = 0; i < this.months.length; ++i) {
                    this.months[i] = this.months[i] + this.dialect;
                }
            }
            return this.months;
        }

        @Override
        public void setMonths(String[] stringArray) {
            this.months = stringArray;
        }

        @Override
        public String[] getShortMonths() {
            if (this.shortMonths == null) {
                this.shortMonths = super.getShortMonths();
                for (int i = 0; i < this.shortMonths.length; ++i) {
                    this.shortMonths[i] = this.shortMonths[i] + this.dialect;
                }
            }
            return this.shortMonths;
        }

        @Override
        public void setShortMonths(String[] stringArray) {
            this.shortMonths = stringArray;
        }

        @Override
        public String[] getWeekdays() {
            if (this.weekdays == null) {
                this.weekdays = super.getWeekdays();
                for (int i = 0; i < this.weekdays.length; ++i) {
                    this.weekdays[i] = this.weekdays[i] + this.dialect;
                }
            }
            return this.weekdays;
        }

        @Override
        public void setWeekdays(String[] stringArray) {
            this.weekdays = stringArray;
        }

        @Override
        public String[] getShortWeekdays() {
            if (this.shortWeekdays == null) {
                this.shortWeekdays = super.getShortWeekdays();
                for (int i = 0; i < this.shortWeekdays.length; ++i) {
                    this.shortWeekdays[i] = this.shortWeekdays[i] + this.dialect;
                }
            }
            return this.shortWeekdays;
        }

        @Override
        public void setShortWeekdays(String[] stringArray) {
            this.shortWeekdays = stringArray;
        }

        @Override
        public String[] getAmPmStrings() {
            if (this.ampms == null) {
                this.ampms = super.getAmPmStrings();
                for (int i = 0; i < this.ampms.length; ++i) {
                    this.ampms[i] = this.ampms[i] + this.dialect;
                }
            }
            return this.ampms;
        }

        @Override
        public void setAmPmStrings(String[] stringArray) {
            this.ampms = stringArray;
        }

        @Override
        public String[][] getZoneStrings() {
            return new String[0][0];
        }
    }
}

