/*
 * Copyright (c) 1997, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources.ext;

import sun.util.resources.TimeZoneNamesBundle;

public final class TimeZoneNames_zh_CN extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
        String ACT[] = new String[] {"Acre \u65f6\u95f4", "ACT",
                                     "Acre \u590f\u4ee4\u65f6", "ACST",
                                     "Acre \u65f6\u95f4", "ACT"};
        String ADELAIDE[] = new String[] {"\u4E2D\u592E\u6807\u51C6\u65F6\u95F4 (\u5357\u6FB3\u5927\u5229\u4E9A)", "ACST",
                                          "\u4E2D\u592E\u590F\u4EE4\u65F6 (\u5357\u6FB3\u5927\u5229\u4E9A)", "ACDT",
                                          "\u4E2D\u90E8\u65F6\u95F4 (\u5357\u6FB3\u5927\u5229\u4E9A)", "ACT"};
        String AGT[] = new String[] {"\u963f\u6839\u5ef7\u65f6\u95f4", "ART",
                                     "\u963f\u6839\u5ef7\u590f\u4ee4\u65f6", "ARST",
                                     "\u963F\u6839\u5EF7\u65F6\u95F4", "ART"};
        String AKST[] = new String[] {"\u963f\u62c9\u65af\u52a0\u6807\u51c6\u65f6\u95f4", "AKST",
                                      "\u963f\u62c9\u65af\u52a0\u590f\u4ee4\u65f6", "AKDT",
                                      "\u963F\u62C9\u65AF\u52A0\u65F6\u95F4", "AKT"};
        String AMT[] = new String[] {"\u4e9a\u9a6c\u900a\u65f6\u95f4", "AMT",
                                     "\u4e9a\u9a6c\u900a\u590f\u4ee4\u65f6", "AMST",
                                     "\u4E9A\u9A6C\u900A\u65F6\u95F4", "AMT"};
        String ARAST[] = new String[] {"\u963f\u62c9\u4f2f\u6807\u51c6\u65f6\u95f4", "AST",
                                       "\u963f\u62c9\u4f2f\u590f\u4ee4\u65f6", "ADT",
                                       "\u963F\u62C9\u4F2F\u534A\u5C9B\u65F6\u95F4", "AT"};
        String ARMT[] = new String[] {"\u4e9a\u7f8e\u5c3c\u4e9a\u65f6\u95f4", "AMT",
                                      "\u4e9a\u7f8e\u5c3c\u4e9a\u590f\u4ee4\u65f6", "AMST",
                                      "\u4E9A\u7F8E\u5C3C\u4E9A\u65F6\u95F4", "AMT"};
        String AST[] = new String[] {"\u5927\u897f\u6d0b\u6807\u51c6\u65f6\u95f4", "AST",
                                     "\u5927\u897f\u6d0b\u590f\u4ee4\u65f6", "ADT",
                                     "\u5927\u897F\u6D0B\u65F6\u95F4", "AT"};
        String BDT[] = new String[] {"\u5b5f\u52a0\u62c9\u65f6\u95f4", "BDT",
                                     "\u5b5f\u52a0\u62c9\u590f\u4ee4\u65f6", "BDST",
                                     "\u5B5F\u52A0\u62C9\u65F6\u95F4", "BDT"};
        String BRISBANE[] = new String[] {"\u4E1C\u90E8\u6807\u51C6\u65F6\u95F4 (\u6606\u58EB\u5170)", "AEST",
                                          "\u4E1C\u90E8\u590F\u4EE4\u65F6 (\u6606\u58EB\u5170)", "AEDT",
                                          "\u4E1C\u90E8\u65F6\u95F4 (\u6606\u58EB\u5170)", "AET"};
        String BROKEN_HILL[] = new String[] {"\u4E2D\u592E\u6807\u51C6\u65F6\u95F4 (\u5357\u6FB3\u5927\u5229\u4E9A/\u65B0\u5357\u5A01\u5C14\u65AF)", "ACST",
                                             "\u4E2D\u592E\u590F\u4EE4\u65F6 (\u5357\u6FB3\u5927\u5229\u4E9A/\u65B0\u5357\u5A01\u5C14\u65AF)", "ACDT",
                                             "\u4E2D\u90E8\u65F6\u95F4 (\u5357\u6FB3\u5927\u5229\u4E9A/\u65B0\u5357\u5A01\u5C14\u65AF)", "ACT"};
        String BRT[] = new String[] {"\u5df4\u897f\u5229\u4e9a\u65f6\u95f4", "BRT",
                                     "\u5df4\u897f\u5229\u4e9a\u590f\u4ee4\u65f6", "BRST",
                                     "\u5DF4\u897F\u5229\u4E9A\u65F6\u95F4", "BRT"};
        String BTT[] = new String[] {"\u4e0d\u4e39\u65f6\u95f4", "BTT",
                                     "\u4e0d\u4e39\u590f\u4ee4\u65f6", "BTST",
                                     "\u4E0D\u4E39\u65F6\u95F4", "BTT"};
        String CAT[] = new String[] {"\u4e2d\u975e\u65f6\u95f4", "CAT",
                                     "\u4e2d\u975e\u590f\u4ee4\u65f6", "CAST",
                                     "\u4E2D\u975E\u65F6\u95F4", "CAT"};
        String CET[] = new String[] {"\u4e2d\u6b27\u65f6\u95f4", "CET",
                                     "\u4e2d\u6b27\u590f\u4ee4\u65f6", "CEST",
                                     "\u4E2D\u6B27\u65F6\u95F4", "CET"};
        String CHAST[] = new String[] {"\u67e5\u8428\u59c6\u6807\u51c6\u65f6\u95f4", "CHAST",
                                       "\u67e5\u8428\u59c6\u590f\u4ee4\u65f6", "CHADT",
                                       "\u67E5\u5854\u59C6\u65F6\u95F4", "CHAT"};
        String CHUT[] = new String[] {"\u4E18\u514B\u65F6\u95F4", "CHUT",
                                      "\u4E18\u514B\u590F\u4EE4\u65F6", "CHUST",
                                      "\u4E18\u514B\u65F6\u95F4", "CHUT"};
        String CIT[] = new String[] {"\u4e2d\u90e8\u5370\u5ea6\u5c3c\u897f\u4e9a\u65f6\u95f4", "WITA",
                                     "\u4e2d\u90e8\u5370\u5ea6\u5c3c\u897f\u4e9a\u590f\u4ee4\u65f6", "CIST",
                                     "\u4E2D\u90E8\u5370\u5EA6\u5C3C\u897F\u4E9A\u65F6\u95F4", "WITA"};
        String CLT[] = new String[] {"\u667a\u5229\u65f6\u95f4", "CLT",
                                     "\u667a\u5229\u590f\u4ee4\u65f6", "CLST",
                                     "\u667A\u5229\u65F6\u95F4", "CLT"};
        String CST[] = new String[] {"\u4e2d\u592e\u6807\u51c6\u65f6\u95f4", "CST",
                                     "\u4e2d\u592e\u590f\u4ee4\u65f6", "CDT",
                                     "\u4E2D\u90E8\u65F6\u95F4", "CT"};
        String CTT[] = new String[] {"\u4e2d\u56fd\u6807\u51c6\u65f6\u95f4", "CST",
                                     "\u4e2d\u56fd\u590f\u4ee4\u65f6", "CDT",
                                     "\u4E2D\u56FD\u65F6\u95F4", "CT"};
        String CUBA[] = new String[] {"\u53e4\u5df4\u6807\u51c6\u65f6\u95f4", "CST",
                                      "\u53e4\u5df4\u590f\u4ee4\u65f6", "CDT",
                                      "\u53E4\u5DF4\u65F6\u95F4", "CT"};
        String DARWIN[] = new String[] {"\u4E2D\u592E\u6807\u51C6\u65F6\u95F4 (\u5317\u9886\u5730)", "ACST",
                                        "\u4E2D\u592E\u590F\u4EE4\u65F6 (\u5317\u9886\u5730)", "ACDT",
                                        "\u4E2D\u90E8\u65F6\u95F4 (\u5317\u90E8\u5730\u533A)", "ACT"};
        String DUBLIN[] = new String[] {"\u683c\u6797\u5a01\u6cbb\u65f6\u95f4", "GMT",
                                        "\u7231\u5c14\u5170\u590f\u4ee4\u65f6", "IST",
                                        "\u7231\u5C14\u5170\u65F6\u95F4", "IT"};
        String EAT[] = new String[] {"\u4e1c\u975e\u65f6\u95f4", "EAT",
                                     "\u4e1c\u975e\u590f\u4ee4\u65f6", "EAST",
                                     "\u4E1C\u975E\u65F6\u95F4", "EAT"};
        String EASTER[] = new String[] {"\u590d\u6d3b\u5c9b\u65f6\u95f4", "EAST",
                                        "\u590d\u6d3b\u5c9b\u590f\u4ee4\u65f6", "EASST",
                                        "\u590D\u6D3B\u5C9B\u65F6\u95F4", "EAST"};
        String EET[] = new String[] {"\u4e1c\u6b27\u65f6\u95f4", "EET",
                                     "\u4e1c\u6b27\u590f\u4ee4\u65f6", "EEST",
                                     "\u4e1c\u6b27\u65f6\u95f4", "EET"};
        String EGT[] = new String[] {"\u4e1c\u683c\u6797\u5c9b\u65f6\u95f4", "EGT",
                                     "\u4e1c\u683c\u6797\u5c9b\u590f\u4ee4\u65f6", "EGST",
                                     "\u4E1C\u683C\u6797\u5C9B\u65F6\u95F4", "EGT"};
        String EST[] = new String[] {"\u4e1c\u90e8\u6807\u51c6\u65f6\u95f4", "EST",
                                     "\u4e1c\u90e8\u590f\u4ee4\u65f6", "EDT",
                                     "\u4E1C\u90E8\u65F6\u95F4", "ET"};
        String EST_NSW[] = new String[] {"\u4E1C\u90E8\u6807\u51C6\u65F6\u95F4 (\u65B0\u5357\u5A01\u5C14\u65AF)", "AEST",
                                         "\u4E1C\u90E8\u590F\u4EE4\u65F6 (\u65B0\u5357\u5A01\u5C14\u65AF)", "AEDT",
                                         "\u4E1C\u90E8\u65F6\u95F4 (\u65B0\u5357\u5A01\u5C14\u65AF)", "AET"};
        String FET[] = new String[] {"\u8FDC\u4E1C\u6B27\u65F6\u95F4", "FET",
                                     "\u8FDC\u4E1C\u6B27\u590F\u4EE4\u65F6", "FEST",
                                     "\u8FDC\u4E1C\u6B27\u65F6\u95F4", "FET"};
        String GHMT[] = new String[] {"\u52a0\u7eb3\u65f6\u95f4", "GMT",
                                     "\u52a0\u7eb3\u590f\u4ee4\u65f6", "GHST",
                                     "\u52A0\u7EB3\u65F6\u95F4", "GMT"};
        String GAMBIER[] =  new String[] {"\u5188\u6bd4\u4e9a\u65f6\u95f4", "GAMT",
                                          "\u5188\u6bd4\u4e9a\u590f\u4ee4\u65f6", "GAMST",
                                          "\u5188\u6BD4\u4E9A\u65F6\u95F4", "GAMT"};
        String GMT[] = new String[] {"\u683c\u6797\u5a01\u6cbb\u65f6\u95f4", "GMT",
                                     "\u683c\u6797\u5a01\u6cbb\u65f6\u95f4", "GMT",
                                     "\u683C\u6797\u5A01\u6CBB\u65F6\u95F4", "GMT"};
        String GMTBST[] = new String[] {"\u683c\u6797\u5a01\u6cbb\u65f6\u95f4", "GMT",
                                        "\u82f1\u56fd\u590f\u4ee4\u65f6", "BST",
                                        "\u82F1\u56FD\u65F6\u95F4", "BT"};
        String GST[] = new String[] {"\u6ce2\u65af\u6e7e\u6807\u51c6\u65f6\u95f4", "GST",
                                     "\u6ce2\u65af\u6e7e\u590f\u4ee4\u65f6", "GDT",
                                     "\u6D77\u6E7E\u65F6\u95F4", "GT"};
        String HKT[] =  new String[] {"\u9999\u6e2f\u65f6\u95f4", "HKT",
                                      "\u9999\u6e2f\u590f\u4ee4\u65f6", "HKST",
                                      "\u9999\u6E2F\u65F6\u95F4", "HKT"};
        String HST[] = new String[] {"\u590f\u5a01\u5937\u6807\u51c6\u65f6\u95f4", "HST",
                                     "\u590f\u5a01\u5937\u590f\u4ee4\u65f6", "HDT",
                                     "\u590F\u5A01\u5937\u65F6\u95F4", "HT"};
        String ICT[] = new String[] {"\u5370\u5ea6\u652f\u90a3\u65f6\u95f4", "ICT",
                                     "\u5370\u5ea6\u652f\u90a3\u590f\u4ee4\u65f6", "ICST",
                                     "\u5370\u5EA6\u652F\u90A3\u65F6\u95F4", "ICT"};
        String IRKT[] = new String[] {"\u4f0a\u5c14\u5e93\u6b21\u514b\u65f6\u95f4", "IRKT",
                                      "\u4f0a\u5c14\u5e93\u6b21\u514b\u590f\u4ee4\u65f6", "IRKST",
                                      "\u4F0A\u5C14\u5E93\u6B21\u514B\u65F6\u95F4", "IRKT"};
        String IRT[] = new String[] {"\u4f0a\u6717\u6807\u51c6\u65f6\u95f4", "IRST",
                                     "\u4f0a\u6717\u590f\u4ee4\u65f6", "IRDT",
                                     "\u4F0A\u6717\u65F6\u95F4", "IRT"};
        String ISRAEL[] = new String[] {"\u4ee5\u8272\u5217\u6807\u51c6\u65f6\u95f4", "IST",
                                        "\u4ee5\u8272\u5217\u590f\u4ee4\u65f6", "IDT",
                                        "\u4EE5\u8272\u5217\u65F6\u95F4", "IT"};
        String IST[] = new String[] {"\u5370\u5ea6\u6807\u51c6\u65f6\u95f4", "IST",
                                     "\u5370\u5ea6\u590f\u4ee4\u65f6", "IDT",
                                     "\u5370\u5EA6\u65F6\u95F4", "IT"};
        String JST[] = new String[] {"\u65e5\u672c\u6807\u51c6\u65f6\u95f4", "JST",
                                     "\u65e5\u672c\u590f\u4ee4\u65f6", "JDT",
                                     "\u65E5\u672C\u65F6\u95F4", "JT"};
        String KRAT[] = new String[] {"\u514b\u62c9\u65af\u8bfa\u4e9a\u5c14\u65af\u514b\u65f6\u95f4", "KRAT",
                                      "\u514b\u62c9\u65af\u8bfa\u4e9a\u5c14\u65af\u514b\u590f\u4ee4\u65f6", "KRAST",
                                      "\u514B\u62C9\u65AF\u8BFA\u4E9A\u5C14\u65AF\u514B\u65F6\u95F4", "KRAT"};
        String KST[] = new String[] {"\u97e9\u56fd\u6807\u51c6\u65f6\u95f4", "KST",
                                     "\u97e9\u56fd\u590f\u4ee4\u65f6", "KDT",
                                     "\u97E9\u56FD\u65F6\u95F4", "KT"};
        String LORD_HOWE[] = new String[] {"\u8c6a\u516c\u6807\u51c6\u65f6\u95f4", "LHST",
                                           "\u8c6a\u516c\u590f\u4ee4\u65f6", "LHDT",
                                           "\u8C6A\u516C\u65F6\u95F4", "LHT"};
        String MHT[] = new String[] {"\u9a6c\u7ecd\u5c14\u7fa4\u5c9b\u65f6\u95f4", "MHT",
                                     "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b\u590f\u4ee4\u65f6", "MHST",
                                     "\u9A6C\u7ECD\u5C14\u7FA4\u5C9B\u65F6\u95F4", "MHT"};
        String MMT[] = new String[] {"\u7f05\u7538\u65f6\u95f4", "MMT",
                                     "\u7f05\u7538\u590f\u4ee4\u65f6", "MMST",
                                     "\u7F05\u7538\u65F6\u95F4", "MMT"};
        String MSK[] = new String[] {"\u83ab\u65af\u79d1\u6807\u51c6\u65f6\u95f4", "MSK",
                                     "\u83ab\u65af\u79d1\u590f\u4ee4\u65f6", "MSD",
                                     "\u83AB\u65AF\u79D1\u65F6\u95F4", "MT"};
        String MST[] = new String[] {"Mountain \u6807\u51c6\u65f6\u95f4", "MST",
                                     "Mountain \u590f\u4ee4\u65f6", "MDT",
                                     "\u5C71\u5730\u65F6\u95F4", "MT"};
        String MYT[] = new String[] {"\u9a6c\u6765\u897f\u4e9a\u65f6\u95f4", "MYT",
                                     "\u9a6c\u6765\u897f\u4e9a\u590f\u4ee4\u65f6", "MYST",
                                     "\u9A6C\u6765\u897F\u4E9A\u65F6\u95F4", "MYT"};
        String NORONHA[] = new String[] {"\u8d39\u5c14\u5357\u591a\u5fb7\u8bfa\u7f57\u5c3c\u4e9a\u65f6\u95f4", "FNT",
                                         "\u8d39\u5c14\u5357\u591a\u5fb7\u8bfa\u7f57\u5c3c\u4e9a\u590f\u4ee4\u65f6", "FNST",
                                         "\u8D39\u5C14\u5357\u591A\u5FB7\u8BFA\u7F57\u5C3C\u4E9A\u65F6\u95F4", "FNT"};
        String NOVT[] = new String[] {"Novosibirsk \u65f6\u95f4", "NOVT",
                                      "Novosibirsk \u590f\u4ee4\u65f6", "NOVST",
                                      "Novosibirsk \u65F6\u95F4", "NOVT"};
        String NPT[] = new String[] {"\u5c3c\u6cca\u5c14\u65f6\u95f4", "NPT",
                                     "\u5c3c\u6cca\u5c14\u590f\u4ee4\u65f6", "NPST",
                                     "\u5C3C\u6CCA\u5C14\u65F6\u95F4", "NPT"};
        String NST[] = new String[] {"\u7ebd\u82ac\u5170\u6807\u51c6\u65f6\u95f4", "NST",
                                     "\u7ebd\u82ac\u5170\u590f\u4ee4\u65f6", "NDT",
                                     "\u7EBD\u82AC\u5170\u65F6\u95F4", "NT"};
        String NZST[] = new String[] {"\u65b0\u897f\u5170\u6807\u51c6\u65f6\u95f4", "NZST",
                                      "\u65b0\u897f\u5170\u590f\u4ee4\u65f6", "NZDT",
                                      "\u65B0\u897F\u5170\u65F6\u95F4", "NZT"};
        String PITCAIRN[] = new String[] {"\u76ae\u7279\u5eb7\u5c9b\u6807\u51c6\u65f6\u95f4", "PST",
                                          "\u76ae\u7279\u5eb7\u5c9b\u590f\u4ee4\u65f6", "PDT",
                                          "\u76AE\u7279\u51EF\u6069\u65F6\u95F4", "PT"};
        String PKT[] = new String[] {"\u5df4\u57fa\u65af\u5766\u65f6\u95f4", "PKT",
                                     "\u5df4\u57fa\u65af\u5766\u590f\u4ee4\u65f6", "PKST",
                                     "\u5DF4\u57FA\u65AF\u5766\u65F6\u95F4", "PKT"};
        String PONT[] = new String[] {"\u6CE2\u7EB3\u4F69\u65F6\u95F4", "PONT",
                                      "\u6CE2\u7EB3\u4F69\u590F\u4EE4\u65F6", "PONST",
                                      "\u6CE2\u7EB3\u4F69\u65F6\u95F4", "PONT"};
        String PST[] = new String[] {"\u592a\u5e73\u6d0b\u6807\u51c6\u65f6\u95f4", "PST",
                                     "\u592a\u5e73\u6d0b\u590f\u4ee4\u65f6", "PDT",
                                     "\u592A\u5E73\u6D0B\u65F6\u95F4", "PT"};
        String SAST[] = new String[] {"\u5357\u975e\u6807\u51c6\u65f6\u95f4", "SAST",
                                      "\u5357\u975e\u590f\u4ee4\u65f6", "SAST",
                                      "\u5357\u975E\u65F6\u95F4", "SAT"};
        String SBT[] = new String[] {"\u6240\u7f57\u95e8\u7fa4\u5c9b\u65f6\u95f4", "SBT",
                                     "\u6240\u7f57\u95e8\u7fa4\u5c9b\u590f\u4ee4\u65f6", "SBST",
                                     "\u6240\u7F57\u95E8\u7FA4\u5C9B\u65F6\u95F4", "SBT"};
        String SGT[] = new String[] {"\u65b0\u52a0\u5761\u65f6\u95f4", "SGT",
                                     "\u65b0\u52a0\u5761\u590f\u4ee4\u65f6", "SGST",
                                     "\u65B0\u52A0\u5761\u65F6\u95F4", "SGT"};
        String TASMANIA[] = new String[] {"\u4E1C\u90E8\u6807\u51C6\u65F6\u95F4 (\u5854\u65AF\u9A6C\u5C3C\u4E9A)", "AEST",
                                          "\u4E1C\u90E8\u590F\u4EE4\u65F6 (\u5854\u65AF\u9A6C\u5C3C\u4E9A)", "AEDT",
                                          "\u4E1C\u90E8\u65F6\u95F4 (\u5854\u65AF\u9A6C\u5C3C\u4E9A)", "AET"};
        String TMT[] = new String[] {"\u571f\u5e93\u66fc\u65f6\u95f4", "TMT",
                                     "\u571f\u5e93\u66fc\u590f\u4ee4\u65f6", "TMST",
                                     "\u571F\u5E93\u66FC\u65F6\u95F4", "TMT"};
        String ULAT[]= new String[] {"\u5e93\u4f26\u65f6\u95f4", "ULAT",
                                     "\u5e93\u4f26\u590f\u4ee4\u65f6", "ULAST",
                                     "\u5E93\u4F26\u65F6\u95F4", "ULAT"};
        String WAT[] = new String[] {"\u897f\u975e\u65f6\u95f4", "WAT",
                                     "\u897f\u975e\u590f\u4ee4\u65f6", "WAST",
                                     "\u897F\u975E\u65F6\u95F4", "WAT"};
        String WET[] = new String[] {"\u897f\u6b27\u65f6\u95f4", "WET",
                                     "\u897f\u6b27\u590f\u4ee4\u65f6", "WEST",
                                     "\u897F\u6B27\u65F6\u95F4", "WET"};
        String WGT[] = new String[] {"\u897f\u683c\u6797\u5170\u5c9b\u65f6\u95f4", "WGT",
                                     "\u897f\u683c\u6797\u5170\u5c9b\u590f\u4ee4\u65f6", "WGST",
                                     "\u897F\u683C\u6797\u5170\u5C9B\u65F6\u95F4", "WGT"};
        String WIT[] = new String[] {"\u897f\u5370\u5ea6\u5c3c\u897f\u4e9a\u65f6\u95f4", "WIB",
                                     "\u897f\u5370\u5ea6\u5c3c\u897f\u4e9a\u590f\u4ee4\u65f6", "WIST",
                                     "\u897F\u5370\u5EA6\u5C3C\u897F\u4E9A\u65F6\u95F4", "WIB"};
        String WST_AUS[] = new String[] {"\u897F\u90E8\u6807\u51C6\u65F6\u95F4 (\u6FB3\u5927\u5229\u4E9A)", "AWST",
                                         "\u897F\u90E8\u590F\u4EE4\u65F6 (\u6FB3\u5927\u5229\u4E9A)", "AWDT",
                                         "\u897F\u90E8\u65F6\u95F4 (\u6FB3\u5927\u5229\u4E9A)", "AWT"};
        String SAMOA[] = new String[] {"\u8428\u6469\u4e9a\u7fa4\u5c9b\u6807\u51c6\u65f6\u95f4", "SST",
                                       "\u8428\u6469\u4e9a\u7fa4\u5c9b\u590f\u4ee4\u65f6", "SDT",
                                       "\u8428\u6469\u4E9A\u65F6\u95F4", "ST"};
        String WST_SAMOA[] = new String[] {"\u897f\u8428\u6469\u4e9a\u65f6\u95f4", "WSST",
                                           "\u897f\u8428\u6469\u4e9a\u590f\u4ee4\u65f6", "WSDT",
                                           "\u897F\u8428\u6469\u4E9A\u65F6\u95F4", "WST"};
        String ChST[] = new String[] {"Chamorro \u6807\u51c6\u65f6\u95f4", "ChST",
                                      "Chamorro \u590f\u4ee4\u65f6", "ChDT",
                                      "\u67E5\u6469\u6D1B\u65F6\u95F4", "ChT"};
        String VICTORIA[] = new String[] {"\u4E1C\u90E8\u6807\u51C6\u65F6\u95F4 (\u7EF4\u591A\u5229\u4E9A)", "AEST",
                                          "\u4E1C\u90E8\u590F\u4EE4\u65F6 (\u7EF4\u591A\u5229\u4E9A)", "AEDT",
                                          "\u4E1C\u90E8\u65F6\u95F4 (\u7EF4\u591A\u5229\u4E9A)", "AET"};
        String UTC[] = new String[] {"\u534f\u8c03\u4e16\u754c\u65f6\u95f4", "UTC",
                                     "\u534f\u8c03\u4e16\u754c\u65f6\u95f4", "UTC",
                                     "\u534F\u8C03\u4E16\u754C\u65F6\u95F4", "UTC"};
        String UZT[] = new String[] {"\u4e4c\u5179\u522b\u514b\u65af\u5766\u65f6\u95f4", "UZT",
                                     "\u4e4c\u5179\u522b\u514b\u65af\u5766\u590f\u4ee4\u65f6", "UZST",
                                     "\u4E4C\u5179\u522B\u514B\u65AF\u5766\u65F6\u95F4", "UZT"};
        String XJT[] = new String[] {"\u4e2d\u56fd\u6807\u51c6\u65f6\u95f4", "XJT",
                                     "\u4e2d\u56fd\u590f\u4ee4\u65f6", "XJDT",
                                     "\u4E2D\u56FD\u65F6\u95F4", "XJT"};
        String YAKT[] = new String[] {"\u4e9a\u5e93\u6b21\u514b\u65f6\u95f4", "YAKT",
                                      "\u4e9a\u5e93\u6b21\u514b\u590f\u4ee4\u65f6", "YAKST",
                                      "\u4E9A\u5E93\u6B21\u514B\u65F6\u95F4", "YAKT"};

        return new Object[][] {
            {"America/Los_Angeles", PST},
            {"PST", PST},
            {"America/Denver", MST},
            {"MST", MST},
            {"America/Phoenix", MST},
            {"PNT", MST},
            {"America/Chicago", CST},
            {"CST", CST},
            {"America/New_York", EST},
            {"EST", EST},
            {"America/Indianapolis", EST},
            {"IET", EST},
            {"Pacific/Honolulu", HST},
            {"HST", HST},
            {"America/Anchorage", AKST},
            {"AST", AKST},
            {"America/Halifax", AST},
            {"America/Sitka", AKST},
            {"America/St_Johns", NST},
            {"CNT", NST},
            {"Europe/Paris", CET},
            {"ECT", CET},
            {"GMT", GMT},
            {"Africa/Casablanca", WET},
            {"Asia/Jerusalem", ISRAEL},
            {"Asia/Tokyo", JST},
            {"JST", JST},
            {"Europe/Bucharest", EET},
            {"Asia/Shanghai", CTT},
            {"CTT", CTT},
            {"UTC", UTC},
            /* Don't change the order of the above zones
             * to keep compatibility with the previous version.
             */

            {"ACT", DARWIN},
            {"AET", EST_NSW},
            {"AGT", AGT},
            {"ART", EET},
            {"Africa/Abidjan", GMT},
            {"Africa/Accra", GHMT},
            {"Africa/Addis_Ababa", EAT},
            {"Africa/Algiers", CET},
            {"Africa/Asmara", EAT},
            {"Africa/Asmera", EAT},
            {"Africa/Bamako", GMT},
            {"Africa/Bangui", WAT},
            {"Africa/Banjul", GMT},
            {"Africa/Bissau", GMT},
            {"Africa/Blantyre", CAT},
            {"Africa/Brazzaville", WAT},
            {"Africa/Bujumbura", CAT},
            {"Africa/Cairo", EET},
            {"Africa/Ceuta", CET},
            {"Africa/Conakry", GMT},
            {"Africa/Dakar", GMT},
            {"Africa/Dar_es_Salaam", EAT},
            {"Africa/Djibouti", EAT},
            {"Africa/Douala", WAT},
            {"Africa/El_Aaiun", WET},
            {"Africa/Freetown", GMT},
            {"Africa/Gaborone", CAT},
            {"Africa/Harare", CAT},
            {"Africa/Johannesburg", SAST},
            {"Africa/Juba", CAT},
            {"Africa/Kampala", EAT},
            {"Africa/Khartoum", CAT},
            {"Africa/Kigali", CAT},
            {"Africa/Kinshasa", WAT},
            {"Africa/Lagos", WAT},
            {"Africa/Libreville", WAT},
            {"Africa/Lome", GMT},
            {"Africa/Luanda", WAT},
            {"Africa/Lubumbashi", CAT},
            {"Africa/Lusaka", CAT},
            {"Africa/Malabo", WAT},
            {"Africa/Maputo", CAT},
            {"Africa/Maseru", SAST},
            {"Africa/Mbabane", SAST},
            {"Africa/Mogadishu", EAT},
            {"Africa/Monrovia", GMT},
            {"Africa/Nairobi", EAT},
            {"Africa/Ndjamena", WAT},
            {"Africa/Niamey", WAT},
            {"Africa/Nouakchott", GMT},
            {"Africa/Ouagadougou", GMT},
            {"Africa/Porto-Novo", WAT},
            {"Africa/Sao_Tome", GMT},
            {"Africa/Timbuktu", GMT},
            {"Africa/Tripoli", EET},
            {"Africa/Tunis", CET},
            {"Africa/Windhoek", new String[] {"Central African Time", "CAT",
                                              "Western African Time", "WAT",
                                              "Central African Time", "CAT"}},
            {"America/Adak", HST},
            {"America/Anguilla", AST},
            {"America/Antigua", AST},
            {"America/Araguaina", BRT},
            {"America/Argentina/Buenos_Aires", AGT},
            {"America/Argentina/Catamarca", AGT},
            {"America/Argentina/ComodRivadavia", AGT},
            {"America/Argentina/Cordoba", AGT},
            {"America/Argentina/Jujuy", AGT},
            {"America/Argentina/La_Rioja", AGT},
            {"America/Argentina/Mendoza", AGT},
            {"America/Argentina/Rio_Gallegos", AGT},
            {"America/Argentina/Salta", AGT},
            {"America/Argentina/San_Juan", AGT},
            {"America/Argentina/San_Luis", AGT},
            {"America/Argentina/Tucuman", AGT},
            {"America/Argentina/Ushuaia", AGT},
            {"America/Aruba", AST},
            {"America/Asuncion", new String[] {"\u5df4\u62c9\u572d\u65f6\u95f4", "PYT",
                                               "\u5df4\u62c9\u572d\u590f\u4ee4\u65f6", "PYST",
                                               "\u5DF4\u62C9\u572D\u65F6\u95F4", "PYT"}},
            {"America/Atikokan", EST},
            {"America/Atka", HST},
            {"America/Bahia", BRT},
            {"America/Bahia_Banderas", CST},
            {"America/Barbados", AST},
            {"America/Belem", BRT},
            {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
            {"America/Boa_Vista", AMT},
            {"America/Bogota", new String[] {"\u54e5\u4f26\u6bd4\u4e9a\u65f6\u95f4", "COT",
                                             "\u54e5\u4f26\u6bd4\u4e9a\u590f\u4ee4\u65f6", "COST",
                                             "\u54E5\u4F26\u6BD4\u4E9A\u65F6\u95F4", "COT"}},
            {"America/Boise", MST},
            {"America/Buenos_Aires", AGT},
            {"America/Cambridge_Bay", MST},
            {"America/Campo_Grande", AMT},
            {"America/Cancun", EST},
            {"America/Caracas", new String[] {"\u59d4\u5185\u745e\u62c9\u65f6\u95f4", "VET",
                                              "\u59d4\u5185\u745e\u62c9\u590f\u4ee4\u65f6", "VEST",
                                              "\u59D4\u5185\u745E\u62C9\u65F6\u95F4", "VET"}},
            {"America/Catamarca", AGT},
            {"America/Cayenne", new String[] {"\u6cd5\u5c5e\u572d\u4e9a\u90a3\u65f6\u95f4", "GFT",
                                              "\u6cd5\u5c5e\u572d\u4e9a\u90a3\u590f\u4ee4\u65f6", "GFST",
                                              "\u6CD5\u5C5E\u572D\u4E9A\u90A3\u65F6\u95F4", "GFT"}},
            {"America/Cayman", EST},
            {"America/Chihuahua", MST},
            {"America/Creston", MST},
            {"America/Coral_Harbour", EST},
            {"America/Cordoba", AGT},
            {"America/Costa_Rica", CST},
            {"America/Cuiaba", AMT},
            {"America/Curacao", AST},
            {"America/Danmarkshavn", GMT},
            {"America/Dawson", MST},
            {"America/Dawson_Creek", MST},
            {"America/Detroit", EST},
            {"America/Dominica", AST},
            {"America/Edmonton", MST},
            {"America/Eirunepe", ACT},
            {"America/El_Salvador", CST},
            {"America/Ensenada", PST},
            {"America/Fort_Nelson", MST},
            {"America/Fort_Wayne", EST},
            {"America/Fortaleza", BRT},
            {"America/Glace_Bay", AST},
            {"America/Godthab", WGT},
            {"America/Goose_Bay", AST},
            {"America/Grand_Turk", EST},
            {"America/Grenada", AST},
            {"America/Guadeloupe", AST},
            {"America/Guatemala", CST},
            {"America/Guayaquil", new String[] {"\u5384\u74dc\u591a\u5c14\u65f6\u95f4", "ECT",
                                                "\u5384\u74dc\u591a\u5c14\u590f\u4ee4\u65f6", "ECST",
                                                "\u5384\u74DC\u591A\u5C14\u65F6\u95F4", "ECT"}},
            {"America/Guyana", new String[] {"\u572d\u4e9a\u90a3\u65f6\u95f4", "GYT",
                                             "\u572d\u4e9a\u90a3\u590f\u4ee4\u65f6", "GYST",
                                             "\u572D\u4E9A\u90A3\u65F6\u95F4", "GYT"}},
            {"America/Havana", CUBA},
            {"America/Hermosillo", MST},
            {"America/Indiana/Indianapolis", EST},
            {"America/Indiana/Knox", CST},
            {"America/Indiana/Marengo", EST},
            {"America/Indiana/Petersburg", EST},
            {"America/Indiana/Tell_City", CST},
            {"America/Indiana/Vevay", EST},
            {"America/Indiana/Vincennes", EST},
            {"America/Indiana/Winamac", EST},
            {"America/Inuvik", MST},
            {"America/Iqaluit", EST},
            {"America/Jamaica", EST},
            {"America/Jujuy", AGT},
            {"America/Juneau", AKST},
            {"America/Kentucky/Louisville", EST},
            {"America/Kentucky/Monticello", EST},
            {"America/Knox_IN", CST},
            {"America/Kralendijk", AST},
            {"America/La_Paz", new String[] {"\u73bb\u5229\u7ef4\u4e9a\u65f6\u95f4", "BOT",
                                             "\u73bb\u5229\u7ef4\u4e9a\u590f\u4ee4\u65f6", "BOST",
                                             "\u73BB\u5229\u7EF4\u4E9A\u65F6\u95F4", "BOT"}},
            {"America/Lima", new String[] {"\u79d8\u9c81\u65f6\u95f4", "PET",
                                           "\u79d8\u9c81\u590f\u4ee4\u65f6", "PEST",
                                           "\u79D8\u9C81\u65F6\u95F4", "PET"}},
            {"America/Louisville", EST},
            {"America/Lower_Princes", AST},
            {"America/Maceio", BRT},
            {"America/Managua", CST},
            {"America/Manaus", AMT},
            {"America/Marigot", AST},
            {"America/Martinique", AST},
            {"America/Matamoros", CST},
            {"America/Mazatlan", MST},
            {"America/Mendoza", AGT},
            {"America/Menominee", CST},
            {"America/Merida", CST},
            {"America/Metlakatla", AKST},
            {"America/Mexico_City", CST},
            {"America/Miquelon", new String[] {"\u76ae\u57c3\u5c14\u5c9b\u53ca\u5bc6\u514b\u9686\u5c9b\u6807\u51c6\u65f6\u95f4", "PMST",
                                               "\u76ae\u57c3\u5c14\u5c9b\u53ca\u5bc6\u514b\u9686\u5c9b\u590f\u4ee4\u65f6", "PMDT",
                                               "\u76AE\u57C3\u5C14\u548C\u5BC6\u514B\u9686\u5C9B\u65F6\u95F4", "PMT"}},
            {"America/Moncton", AST},
            {"America/Montevideo", new String[] {"\u4e4c\u62c9\u572d\u65f6\u95f4", "UYT",
                                                 "\u4e4c\u62c9\u572d\u590f\u4ee4\u65f6", "UYST",
                                                 "\u4E4C\u62C9\u572D\u65F6\u95F4", "UYT"}},
            {"America/Monterrey", CST},
            {"America/Montreal", EST},
            {"America/Montserrat", AST},
            {"America/Nassau", EST},
            {"America/Nipigon", EST},
            {"America/Nome", AKST},
            {"America/Noronha", NORONHA},
            {"America/North_Dakota/Beulah", CST},
            {"America/North_Dakota/Center", CST},
            {"America/North_Dakota/New_Salem", CST},
            {"America/Nuuk", WGT},
            {"America/Ojinaga", MST},
            {"America/Panama", EST},
            {"America/Pangnirtung", EST},
            {"America/Paramaribo", new String[] {"\u82cf\u5229\u5357\u65f6\u95f4", "SRT",
                                                 "\u82cf\u5229\u5357\u590f\u4ee4\u65f6", "SRST",
                                                 "\u82CF\u5229\u5357\u65F6\u95F4", "SRT"}},
            {"America/Port-au-Prince", EST},
            {"America/Port_of_Spain", AST},
            {"America/Porto_Acre", ACT},
            {"America/Porto_Velho", AMT},
            {"America/Puerto_Rico", AST},
            {"America/Rainy_River", CST},
            {"America/Rankin_Inlet", CST},
            {"America/Recife", BRT},
            {"America/Regina", CST},
            {"America/Resolute", CST},
            {"America/Rio_Branco", ACT},
            {"America/Rosario", AGT},
            {"America/Santa_Isabel", PST},
            {"America/Santarem", BRT},
            {"America/Santiago", CLT},
            {"America/Santo_Domingo", AST},
            {"America/Sao_Paulo", BRT},
            {"America/Scoresbysund", EGT},
            {"America/Shiprock", MST},
            {"America/St_Barthelemy", AST},
            {"America/St_Kitts", AST},
            {"America/St_Lucia", AST},
            {"America/St_Thomas", AST},
            {"America/St_Vincent", AST},
            {"America/Swift_Current", CST},
            {"America/Tegucigalpa", CST},
            {"America/Thule", AST},
            {"America/Thunder_Bay", EST},
            {"America/Tijuana", PST},
            {"America/Toronto", EST},
            {"America/Tortola", AST},
            {"America/Vancouver", PST},
            {"America/Virgin", AST},
            {"America/Whitehorse", MST},
            {"America/Winnipeg", CST},
            {"America/Yakutat", AKST},
            {"America/Yellowknife", MST},
            {"Antarctica/Casey", WST_AUS},
            {"Antarctica/Davis", new String[] {"\u6234\u7ef4\u65af\u65f6\u95f4", "DAVT",
                                               "\u6234\u7ef4\u65af\u590f\u4ee4\u65f6", "DAVST",
                                               "\u6234\u7EF4\u65AF\u65F6\u95F4", "DAVT"}},
            {"Antarctica/DumontDUrville", new String[] {"Dumont-d'Urville \u65f6\u95f4", "DDUT",
                                                        "Dumont-d'Urville \u590f\u4ee4\u65f6", "DDUST",
                                                        "Dumont-d'Urville \u65F6\u95F4", "DDUT"}},
            {"Antarctica/Macquarie", new String[] {"Australian Eastern Standard Time (Macquarie)", "AEST",
                                                   "Australian Eastern Daylight Time (Macquarie)", "AEDT",
                                                   "Australian Eastern Time (Macquarie)", "AET"}},
            {"Antarctica/Mawson", new String[] {"\u83ab\u68ee\u65f6\u95f4", "MAWT",
                                                "\u83ab\u68ee\u590f\u4ee4\u65f6", "MAWST",
                                                "\u83AB\u68EE\u65F6\u95F4", "MAWT"}},
            {"Antarctica/McMurdo", NZST},
            {"Antarctica/Palmer", CLT},
            {"Antarctica/Rothera", new String[] {"\u7f57\u745f\u62c9\u65f6\u95f4", "ROTT",
                                                 "\u7f57\u745f\u62c9\u590f\u4ee4\u65f6", "ROTST",
                                                 "\u7F57\u745F\u62C9\u65F6\u95F4", "ROTT"}},
            {"Antarctica/South_Pole", NZST},
            {"Antarctica/Syowa", new String[] {"Syowa \u65f6\u95f4", "SYOT",
                                               "Syowa \u590f\u4ee4\u65f6", "SYOST",
                                               "Syowa \u65F6\u95F4", "SYOT"}},
            {"Antarctica/Troll", new String[] {"\u534f\u8c03\u4e16\u754c\u65f6\u95f4", "UTC",
                                               "\u4e2d\u6b27\u590f\u4ee4\u65f6", "CEST",
                                               "Troll Time", "ATT"}},
            {"Antarctica/Vostok", new String[] {"\u83ab\u65af\u6258\u514b\u65f6\u95f4", "VOST",
                                                "\u83ab\u65af\u6258\u514b\u590f\u4ee4\u65f6", "VOSST",
                                                "\u83AB\u65AF\u6258\u514B\u65F6\u95F4", "VOST"}},
            {"Arctic/Longyearbyen", CET},
            {"Asia/Aden", ARAST},
            {"Asia/Almaty", new String[] {"Alma-Ata \u65f6\u95f4", "ALMT",
                                          "Alma-Ata \u590f\u4ee4\u65f6", "ALMST",
                                          "Alma-Ata \u65F6\u95F4", "ALMT"}},
            {"Asia/Amman", EET},
            {"Asia/Anadyr", new String[] {"\u963f\u90a3\u5e95\u6cb3\u65f6\u95f4", "ANAT",
                                          "\u963f\u90a3\u5e95\u6cb3\u590f\u4ee4\u65f6", "ANAST",
                                          "\u963F\u90A3\u5E95\u6CB3\u65F6\u95F4", "ANAT"}},
            {"Asia/Aqtau", new String[] {"Aqtau \u65f6\u95f4", "AQTT",
                                         "Aqtau \u590f\u4ee4\u65f6", "AQTST",
                                         "Aqtau \u65F6\u95F4", "AQTT"}},
            {"Asia/Aqtobe", new String[] {"Aqtobe \u65f6\u95f4", "AQTT",
                                          "Aqtobe \u590f\u4ee4\u65f6", "AQTST",
                                          "Aqtobe \u65F6\u95F4", "AQTT"}},
            {"Asia/Ashgabat", TMT},
            {"Asia/Ashkhabad", TMT},
            {"Asia/Baghdad", ARAST},
            {"Asia/Bahrain", ARAST},
            {"Asia/Baku", new String[] {"\u4e9a\u585e\u62dc\u7136\u65f6\u95f4", "AZT",
                                        "\u4e9a\u585e\u62dc\u7136\u590f\u4ee4\u65f6", "AZST",
                                        "\u4E9A\u585E\u62DC\u7136\u65F6\u95F4", "AZT"}},
            {"Asia/Bangkok", ICT},
            {"Asia/Beirut", EET},
            {"Asia/Bishkek", new String[] {"\u5409\u5c14\u5409\u65af\u65af\u5766\u65f6\u95f4", "KGT",
                                           "\u5409\u5c14\u5409\u65af\u65af\u5766\u590f\u4ee4\u65f6", "KGST",
                                           "\u5409\u5C14\u5409\u65AF\u65AF\u5766\u65F6\u95F4", "KGT"}},
            {"Asia/Brunei", new String[] {"\u6587\u83b1\u65f6\u95f4", "BNT",
                                          "\u6587\u83b1\u590f\u4ee4\u65f6", "BNST",
                                          "\u6587\u83B1\u65F6\u95F4", "BNT"}},
            {"Asia/Calcutta", IST},
            {"Asia/Chita", YAKT},
            {"Asia/Choibalsan", new String[] {"Choibalsan \u65f6\u95f4", "CHOT",
                                              "Choibalsan \u590f\u4ee4\u65f6", "CHOST",
                                              "Choibalsan \u65F6\u95F4", "CHOT"}},
            {"Asia/Chongqing", CTT},
            {"Asia/Chungking", CTT},
            {"Asia/Colombo", IST},
            {"Asia/Dacca", BDT},
            {"Asia/Dhaka", BDT},
            {"Asia/Dili", new String[] {"\u4e1c\u5e1d\u6c76\u65f6\u95f4", "TLT",
                                        "\u4e1c\u5e1d\u6c76\u590f\u4ee4\u65f6", "TLST",
                                        "\u4E1C\u5E1D\u6C76\u65F6\u95F4", "TLT"}},
            {"Asia/Damascus", EET},
            {"Asia/Dubai", GST},
            {"Asia/Dushanbe", new String[] {"\u5854\u5409\u514b\u65af\u5766\u65f6\u95f4", "TJT",
                                            "\u5854\u5409\u514b\u65af\u5766\u590f\u4ee4\u65f6", "TJST",
                                            "\u5854\u5409\u514B\u65AF\u5766\u65F6\u95F4", "TJT"}},
            {"Asia/Gaza", EET},
            {"Asia/Harbin", CTT},
            {"Asia/Hebron", EET},
            {"Asia/Ho_Chi_Minh", ICT},
            {"Asia/Hong_Kong", HKT},
            {"Asia/Hovd", new String[] {"\u79d1\u5e03\u591a\u65f6\u95f4", "HOVT",
                                        "\u79d1\u5e03\u591a\u590f\u4ee4\u65f6", "HOVST",
                                        "\u79D1\u5E03\u591A\u65F6\u95F4", "HOVT"}},
            {"Asia/Irkutsk", IRKT},
            {"Asia/Istanbul", EET},
            {"Asia/Jakarta", WIT},
            {"Asia/Jayapura", new String[] {"\u4e1c\u5370\u5ea6\u5c3c\u897f\u4e9a\u65f6\u95f4", "WIT",
                                            "\u4e1c\u5370\u5ea6\u5c3c\u897f\u4e9a\u590f\u4ee4\u65f6", "EIST",
                                            "\u4E1C\u5370\u5EA6\u5C3C\u897F\u4E9A\u65F6\u95F4", "WIT"}},
            {"Asia/Kabul", new String[] {"\u963f\u5bcc\u6c57\u65f6\u95f4", "AFT",
                                         "\u963f\u5bcc\u6c57\u590f\u4ee4\u65f6", "AFST",
                                         "\u963F\u5BCC\u6C57\u65F6\u95F4", "AFT"}},
            {"Asia/Kamchatka", new String[] {"\u5f7c\u5f97\u7f57\u5df4\u752b\u6d1b\u592b\u65af\u514b\u65f6\u95f4", "PETT",
                                             "\u5f7c\u5f97\u7f57\u5df4\u752b\u6d1b\u592b\u65af\u514b\u590f\u4ee4\u65f6", "PETST",
                                             "\u5F7C\u5F97\u7F57\u5DF4\u752B\u6D1B\u592B\u65AF\u514B\u65F6\u95F4", "PETT"}},
            {"Asia/Karachi", PKT},
            {"Asia/Kashgar", XJT},
            {"Asia/Kathmandu", NPT},
            {"Asia/Katmandu", NPT},
            {"Asia/Khandyga", YAKT},
            {"Asia/Kolkata", IST},
            {"Asia/Krasnoyarsk", KRAT},
            {"Asia/Kuala_Lumpur", MYT},
            {"Asia/Kuching", MYT},
            {"Asia/Kuwait", ARAST},
            {"Asia/Macao", CTT},
            {"Asia/Macau", CTT},
            {"Asia/Magadan", new String[] {"Magadan \u65f6\u95f4", "MAGT",
                                           "Magadan \u590f\u4ee4\u65f6", "MAGST",
                                           "Magadan \u65F6\u95F4", "MAGT"}},
            {"Asia/Makassar", CIT},
            {"Asia/Manila", new String[] {"Philippines Standard Time", "PST",
                                          "Philippines Daylight Time", "PDT",
                                          "Philippines Time", "PT"}},
            {"Asia/Muscat", GST},
            {"Asia/Nicosia", EET},
            {"Asia/Novokuznetsk", KRAT},
            {"Asia/Novosibirsk", NOVT},
            {"Asia/Oral", new String[] {"Oral \u65f6\u95f4", "ORAT",
                                        "Oral \u590f\u4ee4\u65f6", "ORAST",
                                        "Oral \u65F6\u95F4", "ORAT"}},
            {"Asia/Omsk", new String[] {"\u9102\u6728\u65af\u514b\u65f6\u95f4", "OMST",
                                        "\u9102\u6728\u65af\u514b\u590f\u4ee4\u65f6", "OMSST",
                                        "\u9102\u6728\u65AF\u514B\u65F6\u95F4", "OMST"}},
            {"Asia/Phnom_Penh", ICT},
            {"Asia/Pontianak", WIT},
            {"Asia/Pyongyang", KST},
            {"Asia/Qatar", ARAST},
            {"Asia/Qyzylorda", new String[] {"Qyzylorda \u65f6\u95f4", "QYZT",
                                             "Qyzylorda \u590f\u4ee4\u65f6", "QYZST",
                                             "Qyzylorda \u65F6\u95F4", "QYZT"}},
            {"Asia/Rangoon", MMT},
            {"Asia/Riyadh", ARAST},
            {"Asia/Saigon", ICT},
            {"Asia/Sakhalin", new String[] {"\u5e93\u9875\u5c9b\u65f6\u95f4", "SAKT",
                                            "\u5e93\u9875\u5c9b\u590f\u4ee4\u65f6", "SAKST",
                                            "\u5E93\u9875\u5C9B\u65F6\u95F4", "SAKT"}},
            {"Asia/Samarkand", UZT},
            {"Asia/Seoul", KST},
            {"Asia/Singapore", SGT},
            {"Asia/Srednekolymsk", new String[] {"Srednekolymsk Time", "SRET",
                                                 "Srednekolymsk Daylight Time", "SREDT",
                                                 "Srednekolymsk Time", "SRET"}},
            {"Asia/Taipei", CTT},
            {"Asia/Tel_Aviv", ISRAEL},
            {"Asia/Tashkent", UZT},
            {"Asia/Tbilisi", new String[] {"\u4e54\u6cbb\u4e9a\u65f6\u95f4", "GET",
                                           "\u4e54\u6cbb\u4e9a\u590f\u4ee4\u65f6", "GEST",
                                           "\u4E54\u6CBB\u4E9A\u65F6\u95F4", "GET"}},
            {"Asia/Tehran", IRT},
            {"Asia/Thimbu", BTT},
            {"Asia/Thimphu", BTT},
            {"Asia/Ujung_Pandang", CIT},
            {"Asia/Ulaanbaatar", ULAT},
            {"Asia/Ulan_Bator", ULAT},
            {"Asia/Urumqi", XJT},
            {"Asia/Ust-Nera", new String[] {"\u4E4C\u65AF\u5B63\u6D85\u62C9\u65F6\u95F4", "VLAT",
                                            "\u4E4C\u65AF\u5B63\u6D85\u62C9\u590F\u4EE4\u65F6", "VLAST",
                                            "\u4E4C\u65AF\u5B63\u6D85\u62C9\u65F6\u95F4", "VLAT"}},
            {"Asia/Vientiane", ICT},
            {"Asia/Vladivostok", new String[] {"\u6d77\u53c2\u5d34\u65f6\u95f4", "VLAT",
                                               "\u6d77\u53c2\u5d34\u590f\u4ee4\u65f6", "VLAST",
                                               "\u6D77\u53C2\u5D34\u65F6\u95F4", "VLAT"}},
            {"Asia/Yakutsk", YAKT},
            {"Asia/Yangon", MMT},
            {"Asia/Yekaterinburg", new String[] {"Yekaterinburg \u65f6\u95f4", "YEKT",
                                                 "Yekaterinburg \u590f\u4ee4\u65f6", "YEKST",
                                                 "Yekaterinburg \u65F6\u95F4", "YEKT"}},
            {"Asia/Yerevan", ARMT},
            {"Atlantic/Azores", new String[] {"\u4e9a\u901f\u5c14\u7fa4\u5c9b\u65f6\u95f4", "AZOT",
                                              "\u4e9a\u901f\u5c14\u7fa4\u5c9b\u590f\u4ee4\u65f6", "AZOST",
                                              "\u4E9A\u901F\u5C14\u7FA4\u5C9B\u65F6\u95F4", "AZOT"}},
            {"Atlantic/Bermuda", AST},
            {"Atlantic/Canary", WET},
            {"Atlantic/Cape_Verde", new String[] {"\u4f5b\u5fb7\u89d2\u65f6\u95f4", "CVT",
                                                  "\u4f5b\u5fb7\u89d2\u590f\u4ee4\u65f6", "CVST",
                                                  "\u4F5B\u5FB7\u89D2\u65F6\u95F4", "CVT"}},
            {"Atlantic/Faeroe", WET},
            {"Atlantic/Faroe", WET},
            {"Atlantic/Jan_Mayen", CET},
            {"Atlantic/Madeira", WET},
            {"Atlantic/Reykjavik", GMT},
            {"Atlantic/South_Georgia", new String[] {"\u5357\u4e54\u6cbb\u4e9a\u6807\u51c6\u65f6\u95f4", "GST",
                                                     "\u5357\u4e54\u6cbb\u4e9a\u590f\u4ee4\u65f6", "GDT",
                                                     "\u5357\u4E54\u6CBB\u4E9A\u5C9B\u65F6\u95F4", "GT"}},
            {"Atlantic/St_Helena", GMT},
            {"Atlantic/Stanley", new String[] {"\u798f\u514b\u5170\u7fa4\u5c9b\u65f6\u95f4", "FKT",
                                               "\u798f\u514b\u5170\u7fa4\u5c9b\u590f\u4ee4\u65f6", "FKST",
                                               "\u798F\u514B\u5170\u7FA4\u5C9B\u65F6\u95F4", "FKT"}},
            {"Australia/ACT", EST_NSW},
            {"Australia/Adelaide", ADELAIDE},
            {"Australia/Brisbane", BRISBANE},
            {"Australia/Broken_Hill", BROKEN_HILL},
            {"Australia/Canberra", EST_NSW},
            {"Australia/Currie", EST_NSW},
            {"Australia/Darwin", DARWIN},
            {"Australia/Eucla", new String[] {"\u4E2D\u897F\u90E8\u6807\u51C6\u65F6\u95F4 (\u6FB3\u5927\u5229\u4E9A)", "ACWST",
                                              "\u4E2D\u897F\u90E8\u590F\u4EE4\u65F6 (\u6FB3\u5927\u5229\u4E9A)", "ACWDT",
                                              "\u4E2D\u897F\u90E8\u65F6\u95F4 (\u6FB3\u5927\u5229\u4E9A)", "ACWT"}},
            {"Australia/Hobart", TASMANIA},
            {"Australia/LHI", LORD_HOWE},
            {"Australia/Lindeman", BRISBANE},
            {"Australia/Lord_Howe", LORD_HOWE},
            {"Australia/Melbourne", VICTORIA},
            {"Australia/North", DARWIN},
            {"Australia/NSW", EST_NSW},
            {"Australia/Perth", WST_AUS},
            {"Australia/Queensland", BRISBANE},
            {"Australia/South", ADELAIDE},
            {"Australia/Sydney", EST_NSW},
            {"Australia/Tasmania", TASMANIA},
            {"Australia/Victoria", VICTORIA},
            {"Australia/West", WST_AUS},
            {"Australia/Yancowinna", BROKEN_HILL},
            {"BET", BRT},
            {"BST", BDT},
            {"Brazil/Acre", ACT},
            {"Brazil/DeNoronha", NORONHA},
            {"Brazil/East", BRT},
            {"Brazil/West", AMT},
            {"Canada/Atlantic", AST},
            {"Canada/Central", CST},
            {"Canada/Eastern", EST},
            {"Canada/Mountain", MST},
            {"Canada/Newfoundland", NST},
            {"Canada/Pacific", PST},
            {"Canada/Yukon", MST},
            {"Canada/Saskatchewan", CST},
            {"CAT", CAT},
            {"CET", CET},
            {"Chile/Continental", CLT},
            {"Chile/EasterIsland", EASTER},
            {"CST6CDT", CST},
            {"Cuba", CUBA},
            {"EAT", EAT},
            {"EET", EET},
            {"Egypt", EET},
            {"Eire", DUBLIN},
            {"EST5EDT", EST},
            {"Etc/Greenwich", GMT},
            {"Etc/UCT", UTC},
            {"Etc/Universal", UTC},
            {"Etc/UTC", UTC},
            {"Etc/Zulu", UTC},
            {"Europe/Amsterdam", CET},
            {"Europe/Andorra", CET},
            {"Europe/Athens", EET},
            {"Europe/Belfast", GMTBST},
            {"Europe/Belgrade", CET},
            {"Europe/Berlin", CET},
            {"Europe/Bratislava", CET},
            {"Europe/Brussels", CET},
            {"Europe/Budapest", CET},
            {"Europe/Busingen", CET},
            {"Europe/Chisinau", EET},
            {"Europe/Copenhagen", CET},
            {"Europe/Dublin", DUBLIN},
            {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
            {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
            {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
            {"Europe/Kaliningrad", EET},
            {"Europe/Kiev", EET},
            {"Europe/Lisbon", WET},
            {"Europe/Ljubljana", CET},
            {"Europe/London", GMTBST},
            {"Europe/Luxembourg", CET},
            {"Europe/Madrid", CET},
            {"Europe/Malta", CET},
            {"Europe/Mariehamn", EET},
            {"Europe/Minsk", MSK},
            {"Europe/Monaco", CET},
            {"Europe/Moscow", MSK},
            {"Europe/Nicosia", EET},
            {"Europe/Oslo", CET},
            {"Europe/Podgorica", CET},
            {"Europe/Prague", CET},
            {"Europe/Riga", EET},
            {"Europe/Rome", CET},
            {"Europe/Samara", new String[] {"\u6c99\u9a6c\u62c9\u65f6\u95f4", "SAMT",
                                            "\u6c99\u9a6c\u62c9\u590f\u4ee4\u65f6", "SAMST",
                                            "\u6C99\u9A6C\u62C9\u65F6\u95F4", "SAMT"}},
            {"Europe/San_Marino", CET},
            {"Europe/Sarajevo", CET},
            {"Europe/Simferopol", MSK},
            {"Europe/Skopje", CET},
            {"Europe/Sofia", EET},
            {"Europe/Stockholm", CET},
            {"Europe/Tallinn", EET},
            {"Europe/Tirane", CET},
            {"Europe/Tiraspol", EET},
            {"Europe/Uzhgorod", EET},
            {"Europe/Vaduz", CET},
            {"Europe/Vatican", CET},
            {"Europe/Vienna", CET},
            {"Europe/Vilnius", EET},
            {"Europe/Volgograd", MSK},
            {"Europe/Warsaw", CET},
            {"Europe/Zagreb", CET},
            {"Europe/Zaporozhye", EET},
            {"Europe/Zurich", CET},
            {"GB", GMTBST},
            {"GB-Eire", GMTBST},
            {"Greenwich", GMT},
            {"Hongkong", HKT},
            {"Iceland", GMT},
            {"Iran", IRT},
            {"IST", IST},
            {"Indian/Antananarivo", EAT},
            {"Indian/Chagos", new String[] {"\u5370\u5ea6\u6d0b\u5730\u5e26\u65f6\u95f4", "IOT",
                                            "\u5370\u5ea6\u6d0b\u5730\u5e26\u590f\u4ee4\u65f6", "IOST",
                                            "\u5370\u5EA6\u6D0B\u5730\u5E26\u65F6\u95F4", "IOT"}},
            {"Indian/Christmas", new String[] {"\u5723\u8bde\u5c9b\u65f6\u95f4", "CXT",
                                               "\u5723\u8bde\u5c9b\u590f\u4ee4\u65f6", "CXST",
                                               "\u5723\u8BDE\u5C9B\u65F6\u95F4", "CIT"}},
            {"Indian/Cocos", new String[] {"\u53ef\u53ef\u65af\u7fa4\u5c9b\u65f6\u95f4", "CCT",
                                           "\u53ef\u53ef\u65af\u7fa4\u5c9b\u590f\u4ee4\u65f6", "CCST",
                                           "\u53EF\u53EF\u65AF\u7FA4\u5C9B\u65F6\u95F4", "CCT"}},
            {"Indian/Comoro", EAT},
            {"Indian/Kerguelen", new String[] {"\u6cd5\u5c5e\u5357\u6781\u65f6\u95f4", "TFT",
                                               "\u6cd5\u5c5e\u5357\u6781\u590f\u4ee4\u65f6", "TFST",
                                               "\u6CD5\u5C5E\u5357\u6781\u65F6\u95F4", "TFT"}},
            {"Indian/Mahe", new String[] {"\u585e\u5e2d\u5c14\u7fa4\u5c9b\u65f6\u95f4", "SCT",
                                          "\u585e\u5e2d\u5c14\u7fa4\u5c9b\u590f\u4ee4\u65f6", "SCST",
                                          "\u585E\u5E2D\u5C14\u7FA4\u5C9B\u65F6\u95F4", "SCT"}},
            {"Indian/Maldives", new String[] {"\u9a6c\u5c14\u4ee3\u592b\u65f6\u95f4", "MVT",
                                              "\u9a6c\u5c14\u4ee3\u592b\u590f\u4ee4\u65f6", "MVST",
                                              "\u9A6C\u5C14\u4EE3\u592B\u65F6\u95F4", "MVT"}},
            {"Indian/Mauritius", new String[] {"\u6469\u91cc\u897f\u65af\u65f6\u95f4", "MUT",
                                               "\u6469\u91cc\u897f\u65af\u590f\u4ee4\u65f6", "MUST",
                                               "\u6469\u91CC\u897F\u65AF\u65F6\u95F4", "MUT"}},
            {"Indian/Mayotte", EAT},
            {"Indian/Reunion", new String[] {"\u7559\u5c3c\u65fa\u5c9b\u65f6\u95f4", "RET",
                                             "\u7559\u5c3c\u65fa\u5c9b\u590f\u4ee4\u65f6", "REST",
                                             "\u7559\u5C3C\u65FA\u5C9B\u65F6\u95F4", "RET"}},
            {"Israel", ISRAEL},
            {"Jamaica", EST},
            {"Japan", JST},
            {"Kwajalein", MHT},
            {"Libya", EET},
            {"MET", new String[] {"\u4e2d\u6b27\u65f6\u95f4", "MET",
                                  "\u4e2d\u6b27\u590f\u4ee4\u65f6", "MEST",
                                  "MET", "MET"}},
            {"Mexico/BajaNorte", PST},
            {"Mexico/BajaSur", MST},
            {"Mexico/General", CST},
            {"MIT", WST_SAMOA},
            {"MST7MDT", MST},
            {"Navajo", MST},
            {"NET", ARMT},
            {"NST", NZST},
            {"NZ", NZST},
            {"NZ-CHAT", CHAST},
            {"PLT", PKT},
            {"Portugal", WET},
            {"PRT", AST},
            {"Pacific/Apia", WST_SAMOA},
            {"Pacific/Auckland", NZST},
            {"Pacific/Bougainville", new String[] {"Bougainville Standard Time", "BST",
                                                   "Bougainville Daylight Time", "BST",
                                                   "Bougainville Time", "BT"}},
            {"Pacific/Chatham", CHAST},
            {"Pacific/Chuuk", CHUT},
            {"Pacific/Easter", EASTER},
            {"Pacific/Efate", new String[] {"\u74e6\u5974\u963f\u56fe\u65f6\u95f4", "VUT",
                                            "\u74e6\u5974\u963f\u56fe\u590f\u4ee4\u65f6", "VUST",
                                            "\u74E6\u5974\u963F\u56FE\u65F6\u95F4", "VUT"}},
            {"Pacific/Enderbury", new String[] {"\u83f2\u5c3c\u514b\u65af\u7fa4\u5c9b\u65f6\u95f4", "PHOT",
                                                "\u83f2\u5c3c\u514b\u65af\u7fa4\u5c9b\u590f\u4ee4\u65f6", "PHOST",
                                                "\u83F2\u5C3C\u514B\u65AF\u7FA4\u5C9B\u65F6\u95F4", "PHOT"}},
            {"Pacific/Fakaofo", new String[] {"\u6258\u514b\u52b3\u7fa4\u5c9b\u65f6\u95f4", "TKT",
                                              "\u6258\u514b\u52b3\u7fa4\u5c9b\u590f\u4ee4\u65f6", "TKST",
                                              "\u6258\u514B\u52B3\u7FA4\u5C9B\u65F6\u95F4", "TKT"}},
            {"Pacific/Fiji", new String[] {"\u6590\u6d4e\u65f6\u95f4", "FJT",
                                           "\u6590\u6d4e\u590f\u4ee4\u65f6", "FJST",
                                           "\u6590\u6D4E\u65F6\u95F4", "FJT"}},
            {"Pacific/Funafuti", new String[] {"\u5410\u9c81\u74e6\u65f6\u95f4", "TVT",
                                               "\u5410\u9c81\u74e6\u590f\u4ee4\u65f6", "TVST",
                                               "\u5410\u9C81\u74E6\u65F6\u95F4", "TVT"}},
            {"Pacific/Galapagos", new String[] {"\u52a0\u62c9\u5df4\u54e5\u65f6\u95f4", "GALT",
                                                "\u52a0\u62c9\u5df4\u54e5\u590f\u4ee4\u65f6", "GALST",
                                                "\u52A0\u62C9\u5DF4\u54E5\u65F6\u95F4", "GALT"}},
            {"Pacific/Gambier", GAMBIER},
            {"Pacific/Guadalcanal", SBT},
            {"Pacific/Guam", ChST},
            {"Pacific/Johnston", HST},
            {"Pacific/Kiritimati", new String[] {"Line \u5c9b\u65f6\u95f4", "LINT",
                                                 "Line \u5c9b\u590f\u4ee4\u65f6", "LINST",
                                                 "Line \u5C9B\u65F6\u95F4", "LINT"}},
            {"Pacific/Kosrae", new String[] {"Kosrae \u65f6\u95f4", "KOST",
                                             "Kosrae \u590f\u4ee4\u65f6", "KOSST",
                                             "Kosrae \u65F6\u95F4", "KOST"}},
            {"Pacific/Kwajalein", MHT},
            {"Pacific/Majuro", MHT},
            {"Pacific/Marquesas", new String[] {"\u9a6c\u514b\u8428\u65af\u65f6\u95f4", "MART",
                                                "\u9a6c\u514b\u8428\u65af\u590f\u4ee4\u65f6", "MARST",
                                                "\u9A6C\u514B\u8428\u65AF\u65F6\u95F4", "MART"}},
            {"Pacific/Midway", SAMOA},
            {"Pacific/Nauru", new String[] {"\u8bfa\u9c81\u65f6\u95f4", "NRT",
                                            "\u8bfa\u9c81\u590f\u4ee4\u65f6", "NRST",
                                            "\u8BFA\u9C81\u65F6\u95F4", "NRT"}},
            {"Pacific/Niue", new String[] {"\u7ebd\u5a01\u5c9b\u65f6\u95f4", "NUT",
                                           "\u7ebd\u5a01\u5c9b\u590f\u4ee4\u65f6", "NUST",
                                           "\u7EBD\u5A01\u5C9B\u65F6\u95F4", "NUT"}},
            {"Pacific/Norfolk", new String[] {"\u8bfa\u798f\u514b\u65f6\u95f4", "NFT",
                                              "\u8bfa\u798f\u514b\u590f\u4ee4\u65f6", "NFST",
                                              "\u8BFA\u798F\u514B\u65F6\u95F4", "NFT"}},
            {"Pacific/Noumea", new String[] {"\u65b0\u52a0\u52d2\u591a\u5c3c\u4e9a\u65f6\u95f4", "NCT",
                                             "\u65b0\u52a0\u52d2\u591a\u5c3c\u4e9a\u590f\u4ee4\u65f6", "NCST",
                                             "\u65B0\u52A0\u52D2\u591A\u5C3C\u4E9A\u65F6\u95F4", "NCT"}},
            {"Pacific/Pago_Pago", SAMOA},
            {"Pacific/Palau", new String[] {"\u5e1b\u7409\u65f6\u95f4", "PWT",
                                            "\u5e1b\u7409\u590f\u4ee4\u65f6", "PWST",
                                            "\u5E1B\u7409\u65F6\u95F4", "PWT"}},
            {"Pacific/Pitcairn", PITCAIRN},
            {"Pacific/Pohnpei", PONT},
            {"Pacific/Ponape", PONT},
            {"Pacific/Port_Moresby", new String[] {"\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a\u65f6\u95f4", "PGT",
                                                   "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a\u590f\u4ee4\u65f6", "PGST",
                                                   "\u5DF4\u5E03\u4E9A\u65B0\u51E0\u5185\u4E9A\u65F6\u95F4", "PGT"}},
            {"Pacific/Rarotonga", new String[] {"\u5e93\u514b\u7fa4\u5c9b\u65f6\u95f4", "CKT",
                                                "\u5e93\u514b\u7fa4\u5c9b\u590f\u4ee4\u65f6", "CKHST",
                                                "\u5E93\u514B\u7FA4\u5C9B\u65F6\u95F4", "CKT"}},
            {"Pacific/Saipan", ChST},
            {"Pacific/Samoa", SAMOA},
            {"Pacific/Tahiti", new String[] {"\u5927\u6eaa\u5730\u5c9b\u65f6\u95f4", "TAHT",
                                             "\u5927\u6eaa\u5730\u5c9b\u590f\u4ee4\u65f6", "TAHST",
                                             "\u5927\u6EAA\u5730\u5C9B\u65F6\u95F4", "TAHT"}},
            {"Pacific/Tarawa", new String[] {"\u5409\u4f2f\u7279\u7fa4\u5c9b\u65f6\u95f4", "GILT",
                                             "\u5409\u4f2f\u7279\u7fa4\u5c9b\u590f\u4ee4\u65f6", "GILST",
                                             "\u5409\u4F2F\u7279\u7FA4\u5C9B\u65F6\u95F4", "GILT"}},
            {"Pacific/Tongatapu", new String[] {"\u4e1c\u52a0\u65f6\u95f4", "TOT",
                                                "\u4e1c\u52a0\u590f\u4ee4\u65f6", "TOST",
                                                "\u4E1C\u52A0\u65F6\u95F4", "TOT"}},
            {"Pacific/Truk", CHUT},
            {"Pacific/Wake", new String[] {"\u5a01\u514b\u65f6\u95f4", "WAKT",
                                           "\u5a01\u514b\u590f\u4ee4\u65f6", "WAKST",
                                           "\u5A01\u514B\u65F6\u95F4", "WAKT"}},
            {"Pacific/Wallis", new String[] {"\u74e6\u5229\u65af\u53ca\u798f\u675c\u7eb3\u7fa4\u5c9b\u65f6\u95f4", "WFT",
                                             "\u74e6\u5229\u65af\u53ca\u798f\u675c\u7eb3\u7fa4\u5c9b\u590f\u4ee4\u65f6", "WFST",
                                             "\u74E6\u5229\u65AF\u53CA\u798F\u675C\u7EB3\u7FA4\u5C9B\u65F6\u95F4", "WFT"}},
            {"Pacific/Yap", CHUT},
            {"Poland", CET},
            {"PRC", CTT},
            {"PST8PDT", PST},
            {"ROK", KST},
            {"Singapore", SGT},
            {"SST", SBT},
            {"SystemV/AST4", AST},
            {"SystemV/AST4ADT", AST},
            {"SystemV/CST6", CST},
            {"SystemV/CST6CDT", CST},
            {"SystemV/EST5", EST},
            {"SystemV/EST5EDT", EST},
            {"SystemV/HST10", HST},
            {"SystemV/MST7", MST},
            {"SystemV/MST7MDT", MST},
            {"SystemV/PST8", PST},
            {"SystemV/PST8PDT", PST},
            {"SystemV/YST9", AKST},
            {"SystemV/YST9YDT", AKST},
            {"Turkey", EET},
            {"UCT", UTC},
            {"Universal", UTC},
            {"US/Alaska", AKST},
            {"US/Aleutian", HST},
            {"US/Arizona", MST},
            {"US/Central", CST},
            {"US/Eastern", EST},
            {"US/Hawaii", HST},
            {"US/Indiana-Starke", CST},
            {"US/East-Indiana", EST},
            {"US/Michigan", EST},
            {"US/Mountain", MST},
            {"US/Pacific", PST},
            {"US/Samoa", SAMOA},
            {"VST", ICT},
            {"W-SU", MSK},
            {"WET", WET},
            {"Zulu", UTC},
        };
    }
}
