/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.Queue;
import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

public class CharsetDeltaJob
extends Job
implements IContentTypeManager.IContentTypeChangeListener {
    private ThreadLocal disabled = new ThreadLocal();
    private final Bundle systemBundle = Platform.getBundle("org.eclipse.osgi");
    private Queue work = new Queue();
    private Workspace workspace;
    private static final int CHARSET_DELTA_DELAY = 500;

    public CharsetDeltaJob(Workspace workspace) {
        super(Policy.bind("resources.charsetBroadcasting"));
        this.workspace = workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(ICharsetListenerFilter filter) {
        Queue queue = this.work;
        synchronized (queue) {
            this.work.add(filter);
        }
        this.schedule(500L);
    }

    public void charsetPreferencesChanged(final IProject project) {
        if (this.isDisabled()) {
            return;
        }
        ICharsetListenerFilter filter = new ICharsetListenerFilter(){

            public IPath getRoot() {
                return project.getFullPath();
            }

            public boolean isAffected(ResourceInfo info, IPathRequestor requestor) {
                return true;
            }
        };
        this.addToQueue(filter);
    }

    public void contentTypeChanged(final IContentTypeManager.ContentTypeChangeEvent event) {
        ICharsetListenerFilter filter = new ICharsetListenerFilter(){

            public IPath getRoot() {
                return Path.ROOT;
            }

            public boolean isAffected(ResourceInfo info, IPathRequestor requestor) {
                if (info.getType() != 1) {
                    return false;
                }
                return event.getContentType().isAssociatedWith(requestor.requestName());
            }
        };
        this.addToQueue(filter);
    }

    private boolean isDisabled() {
        return this.disabled.get() != null;
    }

    private void processNextEvent(final ICharsetListenerFilter filter, IProgressMonitor monitor) throws CoreException {
        IElementContentVisitor visitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree tree, IPathRequestor requestor, Object elementContents) {
                ResourceInfo info = (ResourceInfo)elementContents;
                if (!filter.isAffected(info, requestor)) {
                    return true;
                }
                info = CharsetDeltaJob.this.workspace.getResourceInfo(requestor.requestPath(), false, true);
                if (info == null) {
                    return false;
                }
                info.incrementCharsetGenerationCount();
                return true;
            }
        };
        try {
            new ElementTreeIterator(this.workspace.getElementTree(), filter.getRoot()).iterate(visitor);
        }
        catch (WrappedRuntimeException e) {
            throw (CoreException)e.getTargetException();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICharsetListenerFilter removeFromQueue() {
        Queue queue = this.work;
        synchronized (queue) {
            return (ICharsetListenerFilter)this.work.remove();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            try {
                String message = Policy.bind("resources.charsetBroadcasting");
                monitor.beginTask(message, 100);
                try {
                    try {
                        ICharsetListenerFilter next;
                        this.workspace.prepareOperation(null, monitor);
                        this.workspace.beginOperation(true);
                        while (this.systemBundle.getState() != 16 && (next = this.removeFromQueue()) != null) {
                            this.processNextEvent(next, monitor);
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        this.workspace.getWorkManager().operationCanceled();
                        IStatus iStatus = Status.CANCEL_STATUS;
                        Object var4_6 = null;
                        this.workspace.endOperation(null, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                        Object var7_9 = null;
                        monitor.done();
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    this.workspace.endOperation(null, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                    throw throwable;
                }
                {
                    Object var4_8 = null;
                }
                this.workspace.endOperation(null, true, Policy.subMonitorFor(monitor, Policy.endOpWork));
                monitor.worked(Policy.opWork);
            }
            catch (CoreException sig) {
                IStatus iStatus = sig.getStatus();
                Object var7_10 = null;
                monitor.done();
                return iStatus;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_12 = null;
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    public void setDisabled(boolean disabled) {
        this.disabled.set(disabled ? Boolean.TRUE : null);
    }

    public void shutdown() {
        Platform.getContentTypeManager().removeContentTypeChangeListener(this);
    }

    public void startup() {
        Platform.getContentTypeManager().addContentTypeChangeListener(this);
    }

    interface ICharsetListenerFilter {
        public IPath getRoot();

        public boolean isAffected(ResourceInfo var1, IPathRequestor var2);
    }
}

